﻿Imports System
Imports System.Data
Imports System.Configuration
Imports System.Web
Imports System.Web.Security
Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts
Imports System.Web.UI.HtmlControls

Namespace URLRewriter.Form
    Public Class FormRewriterControlAdapter
        Inherits System.Web.UI.Adapters.ControlAdapter
        Public Sub New()
        End Sub

        Protected Overloads Overrides Sub Render(ByVal writer As HtmlTextWriter)
            MyBase.Render(New RewriteFormHtmlTextWriter(writer))
        End Sub
    End Class

    Public Class RewriteFormHtmlTextWriter
        Inherits HtmlTextWriter
        Public Sub New(ByVal writer As HtmlTextWriter)
            MyBase.New(writer)
            MyBase.InnerWriter = writer.InnerWriter
        End Sub
        Public Sub New(ByVal writer As System.IO.TextWriter)
            MyBase.New(writer)
            MyBase.InnerWriter = writer
        End Sub

        Public Overloads Overrides Sub WriteAttribute(ByVal name As String, ByVal value As String, ByVal fEncode As Boolean)
            If name = "action" Then
                Dim context As HttpContext = HttpContext.Current
                If context.Items("ActionAlreadyWritten") Is Nothing Then
                    
                    value = context.Request.RawUrl
                    context.Items("ActionAlreadyWritten") = True
                End If
            End If

            MyBase.WriteAttribute(name, value, fEncode)
        End Sub
        Private Function GetBaseUrl() As String
            Dim strApp As String = HttpContext.Current.Request.ApplicationPath
            If strApp = "/" Then strApp = ""
            Return HttpContext.Current.Request.Url.Scheme.ToString() & "://" & HttpContext.Current.Request.Url.Authority.ToString() & strApp
        End Function
    End Class

End Namespace