﻿
Imports Microsoft.VisualBasic
Imports System.Data

Public Class clsCacheThread(Of T)
    Dim _CacheName As String
    Dim _CacheLife As XrCache.CacheLifeType
    Dim _CacheDependOf As String
    Dim _QuaryLinq As IQueryable(Of T)
    Dim _ReadCount As Boolean
    Dim _QuaryCount As Integer
    Dim _TakeCount As Integer
    Dim _SkipCount As Integer
    Dim _ctxContext As Data.Linq.DataContext
    Dim _OpenSecondCache As Boolean
    Dim _CacheItem As clsCache
    Public Property CacheItem() As clsCache
        Get
            Return _CacheItem
        End Get
        Set(ByVal value As clsCache)
            _CacheItem = value
        End Set
    End Property
    Public Property ctxContext() As Data.Linq.DataContext
        Get
            Return _ctxContext
        End Get
        Set(ByVal value As Data.Linq.DataContext)
            _ctxContext = value
        End Set
    End Property

    Public Property CacheName() As String
        Get
            Return _CacheName
        End Get
        Set(ByVal value As String)
            _CacheName = value
        End Set
    End Property


    Public Property CacheLife() As XrCache.CacheLifeType
        Get
            Return _CacheLife
        End Get
        Set(ByVal value As XrCache.CacheLifeType)
            _CacheLife = value
        End Set
    End Property

    Public Property CacheDependOf() As String
        Get
            Return _CacheDependOf
        End Get
        Set(ByVal value As String)
            _CacheDependOf = value
        End Set
    End Property

    Public Property QuaryLinq() As IQueryable(Of T)
        Get
            Return _QuaryLinq
        End Get
        Set(ByVal value As IQueryable(Of T))
            _QuaryLinq = value
        End Set
    End Property

    Public Property ReadCount() As Boolean
        Get
            Return _ReadCount
        End Get
        Set(ByVal value As Boolean)
            _ReadCount = value
        End Set
    End Property
    Public Property QuaryCount() As Integer
        Get
            Return _QuaryCount
        End Get
        Set(ByVal value As Integer)
            _QuaryCount = value
        End Set
    End Property

    Public Property TakeCount() As Integer
        Get
            Return _TakeCount
        End Get
        Set(ByVal value As Integer)
            _TakeCount = value
        End Set
    End Property

    Public Property SkipCount() As Integer
        Get
            Return _SkipCount
        End Get
        Set(ByVal value As Integer)
            _SkipCount = value
        End Set
    End Property
    Public Property OpenSecondCache() As Boolean
        Get
            Return _OpenSecondCache
        End Get
        Set(ByVal value As Boolean)
            _OpenSecondCache = value
        End Set
    End Property

    Public Function UpdateMainCache() As List(Of T)
        '更新主缓存
        Dim iQuaryList As List(Of T)
        Using ctxContext
            If ReadCount Then
                QuaryCount = QuaryLinq.Count
            End If
            If TakeCount > 0 Then
                iQuaryList = QuaryLinq.Skip(SkipCount).Take(TakeCount).ToList
            Else
                iQuaryList = QuaryLinq.Skip(SkipCount).ToList
            End If
        End Using
        Select Case CacheLife
            Case 1
                Web.HttpRuntime.Cache.Insert(CacheName, iQuaryList, Nothing, Now.AddMinutes(CType(_CacheDependOf, Integer)), Web.Caching.Cache.NoSlidingExpiration, CacheItem.CachePriority, New Web.Caching.CacheItemRemovedCallback(AddressOf XrCache.OnCacheRemove))
            Case 2
                Web.HttpRuntime.Cache.Insert(CacheName, iQuaryList, Nothing, Web.Caching.Cache.NoAbsoluteExpiration, New System.TimeSpan(0, CType(_CacheDependOf, Integer), 0), CacheItem.CachePriority, New Web.Caching.CacheItemRemovedCallback(AddressOf XrCache.OnCacheRemove))
            Case 3
                Dim mFiles() As String = Split(CacheDependOf, ",")
                Web.HttpRuntime.Cache.Insert(CacheName, iQuaryList, New Web.Caching.CacheDependency(mFiles), Now.AddDays(7), Web.Caching.Cache.NoSlidingExpiration, CacheItem.CachePriority, New Web.Caching.CacheItemRemovedCallback(AddressOf XrCache.OnCacheRemove))
        End Select

        '主缓存更新后，更新二级缓存
        If OpenSecondCache Then
            SyncLock (GetType(XrCache))
                Web.HttpRuntime.Cache.Insert("SecCache_" & CacheName, iQuaryList, Nothing, Web.Caching.Cache.NoAbsoluteExpiration, Web.Caching.Cache.NoSlidingExpiration, CacheItem.CachePriority, Nothing)
            End SyncLock
        End If
        CacheItem.IsUpdate = False
        CacheItem.Count = QuaryCount
        XrCache.SaveCacheItem(CacheItem, CacheName)
        Return iQuaryList
    End Function
End Class
