﻿Imports System.Configuration

Public Class clsDataCacheThread
    Private _CacheName As String
    Private _CountCommandText As String
    Private _MainCommandText As String
    Private _CacheLife As XrCache.CacheLifeType
    Private _DependOf As String
    Private _dbCount As Integer
    Private _OpenSecondCache As Boolean
    Private _CacheItem As clsCache
    Public Property CacheItem() As clsCache
        Get
            Return _CacheItem
        End Get
        Set(ByVal value As clsCache)
            _CacheItem = value
        End Set
    End Property
    Public Property CacheName() As String
        Get
            Return _CacheName
        End Get
        Set(ByVal value As String)
            _CacheName = value
        End Set
    End Property

    Public Property CountCommandText() As String
        Get
            Return _CountCommandText
        End Get
        Set(ByVal value As String)
            _CountCommandText = value
        End Set
    End Property

    Public Property MainCommandText() As String
        Get
            Return _MainCommandText
        End Get
        Set(ByVal value As String)
            _MainCommandText = value
        End Set
    End Property
    Public Property CacheLife() As XrCache.CacheLifeType
        Get
            Return _CacheLife
        End Get
        Set(ByVal value As XrCache.CacheLifeType)
            _CacheLife = value
        End Set
    End Property
    Public Property DependOf() As String
        Get
            Return _DependOf
        End Get
        Set(ByVal value As String)
            _DependOf = value
        End Set
    End Property
    Public Property dbCount() As Integer
        Get
            Return _dbCount
        End Get
        Set(ByVal value As Integer)
            _dbCount = value
        End Set
    End Property
    Public Property OpenSecondCache() As Boolean
        Get
            Return _OpenSecondCache
        End Get
        Set(ByVal value As Boolean)
            _OpenSecondCache = value
        End Set
    End Property

    Public Function UpdateMainCache() As Data.DataTable

        '更新主缓存
        Dim iTable As Data.DataTable
        Using mConn As New Data.SqlClient.SqlConnection(ConfigurationManager.ConnectionStrings("XrenCRMConnString").ConnectionString)
            mConn.Open()
            Dim mCMD As New Data.SqlClient.SqlCommand
            mCMD.Connection = mConn
            If dbCount >= 0 Then
                mCMD.CommandText = CountCommandText
                dbCount = CType(mCMD.ExecuteScalar, Integer)
            End If
            mCMD.CommandText = MainCommandText
            Dim mDA As New Data.SqlClient.SqlDataAdapter(mCMD)
            Dim mDT As New Data.DataSet
            Try
                mDA.Fill(mDT)
            Catch ex As Exception
                mConn.Close()
                Return Nothing
            End Try
            iTable = mDT.Tables(0)
            mConn.Close()
        End Using
        Select Case CacheLife
            Case 0
                Return iTable
            Case 1
                Web.HttpRuntime.Cache.Insert(CacheName, iTable, Nothing, Now.AddMinutes(CType(DependOf, Integer)), Web.Caching.Cache.NoSlidingExpiration, CacheItem.CachePriority, New Web.Caching.CacheItemRemovedCallback(AddressOf XrCache.OnCacheRemove))
            Case 2
                Web.HttpRuntime.Cache.Insert(CacheName, iTable, Nothing, Web.Caching.Cache.NoAbsoluteExpiration, New System.TimeSpan(0, CType(DependOf, Integer), 0), CacheItem.CachePriority, New Web.Caching.CacheItemRemovedCallback(AddressOf XrCache.OnCacheRemove))
            Case 3
                Dim mFiles() As String = Split(DependOf, ",")
                For i As Integer = 0 To mFiles.Count - 1
                    mFiles(i) = Web.HttpContext.Current.Request.PhysicalApplicationPath & "CacheFile\" & mFiles(i)
                Next
                Web.HttpRuntime.Cache.Insert(CacheName, iTable, New Web.Caching.CacheDependency(mFiles), Now.AddDays(7), Web.Caching.Cache.NoSlidingExpiration, CacheItem.CachePriority, New Web.Caching.CacheItemRemovedCallback(AddressOf XrCache.OnCacheRemove))
        End Select

        '主缓存更新后，更新二级缓存
        If OpenSecondCache Then
            SyncLock (GetType(XrCache))
                Web.HttpRuntime.Cache.Insert("SecCache_" & CacheName, iTable, Nothing, Web.Caching.Cache.NoAbsoluteExpiration, Web.Caching.Cache.NoSlidingExpiration, CacheItem.CachePriority, Nothing)
            End SyncLock
        End If

        CacheItem.IsUpdate = False
        CacheItem.Count = dbCount
        XrCache.SaveCacheItem(CacheItem, CacheName)
        Return iTable
    End Function
End Class
