﻿Imports System
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Text
Imports System.Web
Imports System.Web.UI
Imports System.Web.UI.WebControls

<Assembly: WebResource("iCalendar.Calendar.js", "application/x-javascript", PerformSubstitution:=True)> 
<Assembly: WebResource("iCalendar.iconCalendar.gif", "image/gif")> 
<DefaultProperty("SelectDateTime"), ToolboxData("<{0}:ICalendar runat=server></{0}:ICalendar>")> _
Public Class ICalendar
    Inherits CompositeControl
    Private txtDateTime As TextBox
    Private _TextBoxHeight As UI.WebControls.Unit = 20
    <Bindable(True), Category("Appearance"), DefaultValue(""), Localizable(True)> Property SelectDateTime() As Date
        Get
            EnsureChildControls()
            If IsDate(txtDateTime.Text) Then
                Return CDate(String.Format(txtDateTime.Text, "yyyy-MM-dd"))
            Else
                Return CDate(Now.ToString("yyyy-MM-dd"))
            End If
        End Get

        Set(ByVal Value As Date)
            EnsureChildControls()
            txtDateTime.Text = Value.ToString("yyyy-MM-dd")
        End Set
    End Property
    Property TextBoxHeight() As UI.WebControls.Unit
        Get
            Return _TextBoxHeight
        End Get
        Set(ByVal value As UI.WebControls.Unit)
            _TextBoxHeight = value
            txtDateTime.Height = value
        End Set
    End Property

    Protected Overrides Sub RecreateChildControls()
        EnsureChildControls()
    End Sub
    Protected Overrides Sub CreateChildControls()
        Controls.Clear()
        txtDateTime = New TextBox
        txtDateTime.Width = 180
        txtDateTime.Height = _TextBoxHeight
        txtDateTime.Style.Add("vertical-align", "middle")
        txtDateTime.Style.Add("padding", "0px 5px 0px 5px")
        txtDateTime.Style.Add("background-repeat", "no-repeat")
        txtDateTime.Style.Add("background-position", "right center")
        txtDateTime.Style.Add("background-image", "url(" & Page.ClientScript.GetWebResourceUrl(GetType(ICalendar), "iCalendar.iconCalendar.gif") & ")")
        txtDateTime.Text = Now.ToString("yyyy-MM-dd")
        Controls.Add(txtDateTime)
    End Sub

    Protected Overrides Sub RenderContents(ByVal writer As HtmlTextWriter)
        'AddAttributesToRender(writer)
        txtDateTime.RenderControl(writer)
    End Sub
    Protected Overrides Sub OnPreRender(ByVal e As System.EventArgs)
        If Not Page.ClientScript.IsClientScriptIncludeRegistered("ICalendar") Then Page.ClientScript.RegisterClientScriptResource(GetType(ICalendar), "iCalendar.Calendar.js")

        txtDateTime.Attributes("onfocus") = "setday(this);"
        txtDateTime.Attributes("onkeypress") = "event.returnValue=CalendarIsDigit();"
        MyBase.OnPreRender(e)
    End Sub
End Class
