﻿$.fn.simpleTree = function(opt) {
    return this.each(function() {
        var TREE = this;
        var ROOT = $('.root', this);
        var mousePressed = false;
        var mouseMoved = false;
        var dragMoveType = false;
        var dragNode_destination = false;
        var dragNode_source = false;
        var dragDropTimer = false;
        var ajaxCache = Array();

        TREE.option = {
            drag: true,
            animate: false,
            autoclose: false,
            speed: 'fast',
            afterAjax: false,
            afterMove: false,
            afterClick: false,
            afterDblClick: false,
            afterContextMenu: false,
            docToFolderConvert: false
        };
        TREE.option = $.extend(TREE.option, opt);
        $.extend(this, { getSelected: function() {
            return $('span.active', this).parent();
        }
        });
        TREE.closeNearby = function(obj) {
            $(obj).siblings().filter('.folder-open, .folder-open-last').each(function() {
                var childUl = $('>ul', this);
                var className = this.className;
                this.className = className.replace('open', 'close');
                if (TREE.option.animate) {
                    childUl.animate({ height: "toggle" }, TREE.option.speed);
                } else {
                    childUl.hide();
                }
            });
        };
        TREE.nodeToggle = function(obj) {
            var childUl = $('>ul', obj);
            if (childUl.is(':visible')) {
                obj.className = obj.className.replace('open', 'close');

                if (TREE.option.animate) {
                    childUl.animate({ height: "toggle" }, TREE.option.speed);
                } else {
                    childUl.hide();
                }
            } else {
                if (obj.className)
                    obj.className = obj.className.replace('close', 'open');
                if (TREE.option.animate) {
                    childUl.animate({ height: "toggle" }, TREE.option.speed, function() {
                        if (TREE.option.autoclose) TREE.closeNearby(obj);
                        if (childUl.is('.ajax')) TREE.setAjaxNodes(childUl, obj.id);
                    });
                } else {
                    childUl.show();
                    if (TREE.option.autoclose) TREE.closeNearby(obj);
                    if (childUl.is('.ajax')) {
                        TREE.setAjaxNodes(childUl, obj.id)
                    };
                }
            }
        };
        TREE.setAjaxNodes = function(node, parentId, callback) {
            if ($.inArray(parentId, ajaxCache) == -1) {
                ajaxCache[ajaxCache.length] = parentId;
                var url = $.trim($('>li', node).text());
                if (url && url.indexOf('url:')) {
                    url = $.trim(url.replace(/.*\{url:(.*)\}/i, '$1'));
                    $.ajax({
                        type: "GET",
                        url: url,
                        contentType: 'html',
                        cache: false,
                        success: function(responce) {
                            node.removeAttr('class');
                            node.html(responce);
                            $.extend(node, { url: url });
                            TREE.setTreeNodes(node, true);
                            if (typeof TREE.option.afterAjax == 'function') {
                                TREE.option.afterAjax(node);
                            }
                            if (typeof callback == 'function') {
                                callback(node);
                            }
                        }
                    });
                }

            }
        };
        TREE.setTreeNodes = function(obj, useParent) {
            obj = useParent ? obj.parent() : obj;
            $('li>span', obj).addClass('text')
			.bind('selectstart', function() {
			    return false;
			}).click(function() {
			    $('.active', TREE).attr('class', 'text');
			    if (this.className == 'text') {
			        this.className = 'active';
			    }
			    if (typeof TREE.option.afterClick == 'function') {
			        TREE.option.afterClick($(this).parent());
			    }
			    return false;
			}).dblclick(function() {
			    mousePressed = false;
			    TREE.nodeToggle($(this).parent().get(0));
			    if (typeof TREE.option.afterDblClick == 'function') {
			        TREE.option.afterDblClick($(this).parent());
			    }
			    return false;
			    
			}).bind("contextmenu", function() {
			    $('.active', TREE).attr('class', 'text');
			    if (this.className == 'text') {
			        this.className = 'active';
			    }
			    if (typeof TREE.option.afterContextMenu == 'function') {
			        TREE.option.afterContextMenu($(this).parent());
			    }
			    return false;
			}).mousedown(function(event) {
			    mousePressed = true;
			    cloneNode = $(this).parent().clone();
			    var LI = $(this).parent();
			    //				if(TREE.option.drag)
			    //				{
			    //					$('>ul', cloneNode).hide();
			    //					$('body').append('<div id="drag_container"><ul></ul></div>');
			    //					$('#drag_container').hide().css({opacity:'0.8'});
			    //					$('#drag_container >ul').append(cloneNode);
			    //					$("<img>").attr({id	: "tree_plus",src	: "images/plus.gif"}).css({width: "7px",display: "block",position: "absolute",left	: "5px",top: "5px", display:'none'}).appendTo("body");
			    //					$(document).bind("mousemove", {LI:LI}, TREE.dragStart).bind("mouseup",TREE.dragEnd);
			    //				}
			    return false;
			}).mouseup(function() {
			    if (mousePressed && mouseMoved && dragNode_source) {
			        TREE.moveNodeToFolder($(this).parent());
			    }
			    TREE.eventDestroy();
			});
            $('li', obj).each(function(i) {
                var className = this.className;
                var open = false;
                var cloneNode = false;
                var LI = this;
                var childNode = $('>ul', this);
                if (childNode.size() > 0) {
                    var setClassName = 'folder-';
                    if (className && className.indexOf('open') >= 0) {
                        setClassName = setClassName + 'open';
                        open = true;
                    } else {
                        setClassName = setClassName + 'close';
                    }
                    this.className = setClassName + ($(this).is(':last-child') ? '-last' : '');

                    if (!open || className.indexOf('ajax') >= 0) childNode.hide();

                    TREE.setTrigger(this);
                } else {
                    var setClassName = 'doc';
                    this.className = setClassName + ($(this).is(':last-child') ? '-last' : '');
                }
            }).before('<li class="line"></li>')
			.filter(':last-child').after('<li class="line-last"></li>');
            TREE.setEventLine($('.line, .line-last', obj));
        };
        TREE.setTrigger = function(node) {
            $('>span', node).before('<img class="trigger" src="/App_Themes/ManagerTheme/Images/Explorer/spacer.gif" border=0>');
            var trigger = $('>.trigger', node);
            trigger.click(function(event) {
                TREE.nodeToggle(node);
            });
            if (!$.browser.msie) {
                trigger.css('float', 'left');
            }
        };
        TREE.dragStart = function(event) {
            var LI = $(event.data.LI);
            if (mousePressed) {
                mouseMoved = true;
                if (dragDropTimer) clearTimeout(dragDropTimer);
                if ($('#drag_container:not(:visible)')) {
                    $('#drag_container').show();
                    LI.prev('.line').hide();
                    dragNode_source = LI;
                }
                $('#drag_container').css({ position: 'absolute', "left": (event.pageX + 5), "top": (event.pageY + 15) });
                if (LI.is(':visible')) LI.hide();
                var temp_move = false;
                if (event.target.tagName.toLowerCase() == 'span' && $.inArray(event.target.className, Array('text', 'active', 'trigger')) != -1) {
                    var parent = event.target.parentNode;
                    var offs = $(parent).offset({ scroll: false });
                    var screenScroll = { x: (offs.left - 3), y: event.pageY - offs.top };
                    var isrc = $("#tree_plus").attr('src');
                    var ajaxChildSize = $('>ul.ajax', parent).size();
                    var ajaxChild = $('>ul.ajax', parent);
                    screenScroll.x += 19;
                    screenScroll.y = event.pageY - screenScroll.y + 5;

                    if (parent.className.indexOf('folder-close') >= 0 && ajaxChildSize == 0) {
                        if (isrc.indexOf('minus') != -1) $("#tree_plus").attr('src', 'images/plus.gif');
                        $("#tree_plus").css({ "left": screenScroll.x, "top": screenScroll.y }).show();
                        dragDropTimer = setTimeout(function() {
                            parent.className = parent.className.replace('close', 'open');
                            $('>ul', parent).show();
                        }, 700);
                    } else if (parent.className.indexOf('folder') >= 0 && ajaxChildSize == 0) {
                        if (isrc.indexOf('minus') != -1) $("#tree_plus").attr('src', 'images/plus.gif');
                        $("#tree_plus").css({ "left": screenScroll.x, "top": screenScroll.y }).show();
                    } else if (parent.className.indexOf('folder-close') >= 0 && ajaxChildSize > 0) {
                        mouseMoved = false;
                        $("#tree_plus").attr('src', 'images/minus.gif');
                        $("#tree_plus").css({ "left": screenScroll.x, "top": screenScroll.y }).show();

                        $('>ul', parent).show();
                        TREE.setAjaxNodes(ajaxChild, parent.id, function() {
                            parent.className = parent.className.replace('close', 'open');
                            mouseMoved = true;
                            $("#tree_plus").attr('src', 'images/plus.gif');
                            $("#tree_plus").css({ "left": screenScroll.x, "top": screenScroll.y }).show();
                        });

                    } else {
                        if (TREE.option.docToFolderConvert) {
                            $("#tree_plus").css({ "left": screenScroll.x, "top": screenScroll.y }).show();
                        } else {
                            $("#tree_plus").hide();
                        }
                    }
                } else {
                    $("#tree_plus").hide();
                }
                return false;
            }
            return true;
        };
        TREE.dragEnd = function() {
            if (dragDropTimer) clearTimeout(dragDropTimer);
            TREE.eventDestroy();
        };
        TREE.setEventLine = function(obj) {
            obj.mouseover(function() {
                if (this.className.indexOf('over') < 0 && mousePressed && mouseMoved) {
                    this.className = this.className.replace('line', 'line-over');
                }
            }).mouseout(function() {
                if (this.className.indexOf('over') >= 0) {
                    this.className = this.className.replace('-over', '');
                }
            }).mouseup(function() {
                if (mousePressed && dragNode_source && mouseMoved) {
                    dragNode_destination = $(this).parents('li:first');
                    TREE.moveNodeToLine(this);
                    TREE.eventDestroy();
                }
            });
        };
        TREE.checkNodeIsLast = function(node) {
            if (node.className.indexOf('last') >= 0) {
                var prev_source = dragNode_source.prev().prev();
                if (prev_source.size() > 0) {
                    prev_source[0].className += '-last';
                }
                node.className = node.className.replace('-last', '');
            }
        };
        TREE.checkLineIsLast = function(line) {
            if (line.className.indexOf('last') >= 0) {
                var prev = $(line).prev();
                if (prev.size() > 0) {
                    prev[0].className = prev[0].className.replace('-last', '');
                }
                dragNode_source[0].className += '-last';
            }
        };
        TREE.eventDestroy = function() {
            $(document).unbind('mousemove', TREE.dragStart).unbind('mouseup').unbind('mousedown');
            $('#drag_container, #tree_plus').remove();
            if (dragNode_source) {
                $(dragNode_source).show().prev('.line').show();
            }
            dragNode_destination = dragNode_source = mousePressed = mouseMoved = false;
            //ajaxCache = Array();
        };
        TREE.convertToFolder = function(node) {
            node[0].className = node[0].className.replace('doc', 'folder-open');
            node.append('<ul><li class="line-last"></li></ul>');
            TREE.setTrigger(node[0]);
            TREE.setEventLine($('.line, .line-last', node));
        };
        TREE.convertToDoc = function(node) {
            $('>ul', node).remove();
            $('img', node).remove();
            node[0].className = node[0].className.replace(/folder-(open|close)/gi, 'doc');
        };
        TREE.moveNodeToFolder = function(node) {
            if (!TREE.option.docToFolderConvert && node[0].className.indexOf('doc') != -1) {
                return true;
            } else if (TREE.option.docToFolderConvert && node[0].className.indexOf('doc') != -1) {
                TREE.convertToFolder(node);
            }
            TREE.checkNodeIsLast(dragNode_source[0]);
            var lastLine = $('>ul >.line-last', node);
            if (lastLine.size() > 0) {
                TREE.moveNodeToLine(lastLine[0]);
            }
        };
        TREE.moveNodeToLine = function(node) {
            TREE.checkNodeIsLast(dragNode_source[0]);
            TREE.checkLineIsLast(node);
            var parent = $(dragNode_source).parents('li:first');
            var line = $(dragNode_source).prev('.line');
            $(node).before(dragNode_source);
            $(dragNode_source).before(line);
            node.className = node.className.replace('-over', '');
            var nodeSize = $('>ul >li', parent).not('.line, .line-last').filter(':visible').size();
            if (TREE.option.docToFolderConvert && nodeSize == 0) {
                TREE.convertToDoc(parent);
            } else if (nodeSize == 0) {
                parent[0].className = parent[0].className.replace('open', 'close');
                $('>ul', parent).hide();
            }

            if ($('span:first', dragNode_source).attr('class') == 'text') {
                $('.active', TREE).attr('class', 'text');
                $('span:first', dragNode_source).attr('class', 'active');
            }

            if (typeof (TREE.option.afterMove) == 'function') {
                var pos = $(dragNode_source).prevAll(':not(.line)').size();
                TREE.option.afterMove($(node).parents('li:first'), $(dragNode_source), pos);
            }
        };

        TREE.addNode = function(id, text, callback) {
            var temp_node = $('<li><ul><li id="' + id + '"><span>' + text + '</span></li></ul></li>');
            TREE.setTreeNodes(temp_node);
            dragNode_destination = TREE.getSelected();
            dragNode_source = $('.doc-last', temp_node);
            TREE.moveNodeToFolder(dragNode_destination);
            temp_node.remove();
            if (typeof (callback) == 'function') {
                callback(dragNode_destination, dragNode_source);
            }
        };
        TREE.delNode = function(callback) {
            dragNode_source = TREE.getSelected();
            TREE.checkNodeIsLast(dragNode_source[0]);
            dragNode_source.prev().remove();
            dragNode_source.remove();
            if (typeof (callback) == 'function') {
                callback(dragNode_destination);
            }
        };

        TREE.init = function(obj) {
            TREE.setTreeNodes(obj, false);
            TREE.nodeToggle(ROOT);
        };
        TREE.init(ROOT);
    });
}
/*屏幕宽高*/
function pageHeight() {
    var h = $('#main_right', parent.document).css('height');
    if (h != null) {
        return h.replace('px', '');
    } else {
        var w;
        if ($.browser.msie) {
            w = document.compatMode == "CSS1Compat" ? document.documentElement.clientHeight :document.body.clientHeight;
        } else {
            w = self.innerHeight;
        }
        return w;
    }
}
function pageWidth() {
    var w;
    if ($.browser.msie) {
        w = document.compatMode == "CSS1Compat" ? document.documentElement.clientWidth :
        document.body.clientWidth;
    } else {
        w = self.innerWidth;
    }
    return w - 60;
}
/*分割线事件*/
$(function() {
    var bool = false;
    var offsetX = 0;
    var treeWidth;
    $("#split").mousedown(function() {
        bool = true;
        offsetX = event.offsetX;
        $(this).css('cursor', 'e-resize');
        $(this).css('position', 'absolute');
        $(this).css('border-style', 'dashed');
        $(this).css('border-color', '#444');
        $(this).css('border-width', '1');
        $(document).bind("selectstart", function() { return false; });
    })
        .mouseup(function() {
            $(this).css('background-color', '#E3E3E3');
            bool = false;
            $('.simpleTree').css('width', treeWidth);
            $(this).css('position', 'static');
            $(this).css('border', '0');
            $('#FileList').css('width', pageWidth() - treeWidth - 20);
        })
        .mouseout(function() {
            $(this).css('background-color', '#E3E3E3');
        })
        .mouseover(function() {
            $(this).css('background-color', '#CCCCCC');
        })
    $(document).mousemove(function(e) {
        if (!bool) { return; }
        var x = event.clientX - offsetX - 2;
        treeWidth = x - 10;
        $("#split").css("left", x);
    })
})
/*初始化*/
var simpleTreeCollection;
$(document).ready(function() {
    simpleTreeCollection = $('.simpleTree').simpleTree({
        autoclose: true,
        afterClick: function(node) {/*单击事件*/
            nodeClick(node, false);
        },
        afterDblClick: function(node) { /*双击事件*/ },
        afterAjax: function(node) { },
        animate: true
    });
    var mHeight = pageHeight();
    $('#split').css('height', mHeight - 80);
    $('#FileList').css('height', mHeight - 80);
    $('.simpleTree').css('height', mHeight - 80);
    var treewidth = $('.simpleTree').css('width');
    var filelistwidth = pageWidth() - treewidth.replace('px', '') - 10;
    $('#FileList').css('width', filelistwidth + 'px');
    $('#root').bind('click', function() { nodeClick($('.root').attr('id'), true); });
    nodeClick($('.root').attr('id'), true);
    parent.$.dialog.setting.zIndex = 9999;
});

/*节点点击*/
function nodeClick(node, isRoot) {
    var nodeID;
    if (isRoot) {
        nodeID = node;
        $('#root').css('background-color', '#0373F5');
        $('#root').css('color', '#fff');
        $('.active').attr('class', 'text');
    } else {
        nodeID = $('span:first', node).attr("id");
    }
    GetFiles(nodeID, isRoot);
    $('>img', '#explorContext>li').each(function(i) {
        $(this).unbind('click');
        $(this).css('cursor', 'pointer');
    });
    $('#Upload').bind('click', function() { ShowUpload(nodeID); });
    $('#Reflash').bind('click', function() { GetFiles(nodeID, false); });
    $('#AddFolder').bind('click', function() {
        parent.$.dialog.prompt('新建文件夹名称：', function(val) { AddFolder(nodeID, val); }, '新建文件夹', this);
    });
    $('#DelFolder').bind('click', function() {
    parent.$.dialog.confirm('单击确定将删除此文件夹以及子文件夹和文件<br />你确定要删除这个文件夹吗？', function() {
            DelFolder(nodeID);
        }, function() {
            return;
        });
    });
}
/*新建文件夹*/
function AddFolder(nodeID, NewFolderName) {
    $.ajax({
        type: "GET",
        url: "/AddFolder.gdr?ParentFolder=" + encodeURI(nodeID) + "&NewFolderName=" + encodeURI(NewFolderName),
        contentType: 'html',
        cache: false,
        success: function(responce) {
            if (responce == '0') {
                parent.$.dialog.alert('文件夹创建失败！');
            } else {
                location.reload();
            }
        }
    });
}
/*删除文件夹*/
function DelFolder(FolderPath) {
    $.ajax({
        type: "GET",
        url: "/DelFolder.gdr?FolderPath=" + encodeURI(FolderPath),
        contentType: 'html',
        cache: false,
        success: function(responce) {
            if (responce == '0') {
                parent.$.dialog.alert('文件夹删除失败！');
            } else {
            location.reload();
            }
        }
    });
}
/*获取文件列表*/
function GetFiles(folderPath, isRoot) {
    if (!isRoot) { $('#root').css('background-color', ''); $('#root').css('color', '#000'); }
    $.ajax({
        type: "GET",
        url: "/GetFiles.gdr?Path=" + encodeURI(folderPath) + '&ShowM=1',
        contentType: 'html',
        cache: false,
        success: function(responce) {
            $('#FileList').html(responce);
            var PW = GetParentWindow();
            $('#FileList>li').each(function(i) {
                $(this).bind('click', function() { FileClick(this); });
                if (PW != null) { $(this).bind('dblclick', function() { FiledbClick(this); }); }
            });
            if (responce != '') {
                $('#View').unbind('click');
                $('#View').bind('click', function() { ViewClick(); });
                $('#View').css('cursor', 'pointer');
                ViewMode();
            } else {
                $('#View').unbind('click');
                $('#View').css('cursor', 'default');
            }
        }
    });
}
/*获取父窗口对象*/
function GetParentWindow() {
    var api = frameElement.api;
    if (api != null) {
        var W = api.opener;
        return W;
    }
    return null;
}
function FiledbClick(objFile) {
    var api = frameElement.api;
    if (api != null) {
        api.opener.callBack(objFile.id);
        api.close();
    }
}
/*视图点击事件*/
function ViewClick() {
    if ($('#View').attr('alt') == '列表') {
        $('#View').attr('alt', '缩略图');
        $('#View').attr('src', '/App_Themes/ManagerTheme/Images/Explorer/Thumbs.gif');
    } else {
        $('#View').attr('alt', '列表');
        $('#View').attr('src', '/App_Themes/ManagerTheme/Images/Explorer/List.gif');
    }
    ViewMode();
}
/*切换文件列表视图*/
function ViewMode() {
    $('#FileList').css('display','none');
    $('#FileList').before("<div id='FileSpinner' style='float:left;background-color:#fff;width:" + $('#FileList').css('width') + ";height:" + $('#FileList').css('height') + ";background: url(/App_Themes/ManagerTheme/Images/Explorer/spinner.gif) no-repeat center center;'></div>");
    setTimeout(function() { ViewShow(); }, 1000);
}
/*切换文件列表视图的主函数*/
function ViewShow() {
    if ($('#View').attr('alt') != '列表') {
        $('#FileList>li').each(function(i) {
            var filename = $(this).attr('id').replace(/.*(\/|\\)/, "");
            var fileExt = (/[.]/.exec(filename)) ? /[^.]+$/.exec(filename.toLowerCase()) : '';
            var thisLi = $(this);
            thisLi.attr('class', 'Thumbs');
            $('>img', this).each(function(j) {
                if (fileExt == 'jpg' || fileExt == 'gif' || fileExt == 'bmp' || fileExt == 'png' || fileExt == 'jpeg') {
                    var isLoad = false;
                    if ($.browser.msie) {
                        var nImg = new Image();
                        nImg.src = thisLi.attr('id');
                        nImg.onload = function() {
                            if (this.width > 150 || this.height > 170) {
                                isLoad = true;
                                thisLi.attr("style", "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + thisLi.attr('id') + "', sizingMethod='scale')");
                            }
                        }
                    }
                    if (!isLoad) {
                        thisLi.css('background-image', 'url(' + thisLi.attr('id') + ')');
                    }
                    isLoad = false;
                } else {
                    thisLi.css('background-image', 'url(' + $(this).attr('src') + ')');
                }
            });
        });
    } else {
        $('.Thumbs').each(function(i) {
            $(this).removeAttr('class');
            //$(this).attr('style', '');
        });
        $('#FileList>li').each(function(i) {
        //
            $(this).removeAttr('style');
         });
    }
    $('#FileList').css('display', '');
    $('#FileSpinner').remove();
}
/*文件点击事件*/
function FileClick(file) {
    var NewClass;
    var oldClass;
    if ($('#View').attr('alt') == '列表') {
        NewClass = 'FileActive';
    } else {
        NewClass = 'FileActive Thumbs'; 
    }
    $('.FileActive').each(function(i) {
        oldClass = $(this).attr('class').replace('FileActive', '').replace(' ', '');
        $(this).attr('class', oldClass);
    });
    $(file).attr('class', NewClass);
    $('#DownLoad').unbind('click');
    $('#DownLoad').css('cursor', 'pointer');
    $('#DownLoad').bind('click', function() { FileDownLoad(file); });
    $('#DelFile').unbind('click');
    $('#DelFile').css('cursor', 'pointer');
    $('#DelFile').bind('click', function() {
        parent.$.dialog.confirm('单击确定将删除此文件！<br /><br />你确定要删除这个文件吗？', function() {
            DelFile(file.id);
        }, function() {
            return;
        });
    });
    var filename = file.id.replace(/.*(\/|\\)/, "");
    var fileExt = (/[.]/.exec(filename)) ? /[^.]+$/.exec(filename.toLowerCase()) : '';
    if (fileExt == 'zip') {
        $('#ExZip').unbind('click');
        $('#ExZip').css('cursor', 'pointer');
        $('#ExZip').bind('click', function() { ExZip(file); });
    }
}
/*删除文件*/
function DelFile(FilePath) {
    var isRoot = true;
    $('.active').each(function() { isRoot = false; return false; });
    $.ajax({
        type: "GET",
        url: "/DelFile.gdr?FilePath=" + encodeURI(FilePath),
        contentType: 'html',
        cache: false,
        success: function(responce) {
            if (responce == '0') {
                parent.$.dialog.alert('文件删除失败！');
            } else {
                GetFiles(responce, isRoot);
            }
        }
    });
}
/*解压缩*/
function ExZip(objFile) {
    var diaAPI = parent.$.dialog({
                            lock: true,
                            title: '解压中...',
                            icon: 'alert.gif',
                            content: '文件解压中，请不要关闭本窗口！',
                            width: '200',
                            height: '120',
                            max: false,
                            min: false
   });
   setTimeout(function() {
       $.ajax({
           type: "GET",
           url: "/ExZip.gdr?FilePath=" + encodeURI(objFile.id),
           contentType: 'html',
           cache: false,
           success: function(responce) {
               if (responce == '0') {
                   diaAPI.content('文档解压失败！').title('错误');
               } else {
                   GetFiles(responce);
                   diaAPI.close();
               }
           }
       });}, 1000);
}

/*下载*/
function FileDownLoad(objFile) {
    window.location = "/DownLoad.gdr?FileName=" + encodeURI(objFile.id);
}
/*弹出上传窗口*/
function ShowUpload(FolderPath) {
    parent.$.dialog({
        lock: true,
        title: '文件上传',
        content: '<div class="uploadify"><span><input type="file" name="uploadify" id="uploadify" /></span><span>上传文件类型请在网站配置中更改</span></div><div id="fileQueue"></div>',
        init: function() { InitUpload(FolderPath, true, true); },
        width: '440px',
        height: '340px',
        max: false,
        min: false,
        zIndex:'9999',
        close: function() { GetFiles(FolderPath, false); }
    });
}
function InitUpload(UploadPath,Auto,Muti) {
   parent.$('#uploadify').uploadify({
        'uploader': '/App_Themes/ManagerTheme/Images/Explorer/uploadify.swf',
        'script': '/SaveUpload.gdr',
        'cancelImg': '/App_Themes/ManagerTheme/Images/Explorer/cancel.png',
        'folder': UploadPath,
        'queueID': 'fileQueue',
        'buttonImg': '/App_Themes/ManagerTheme/Images/Explorer/SelectFiles.gif',
        'auto': Auto,
        'multi': Muti,
        'width': 80,
        'height': 20,
        'onAllComplete': function(event, data) { alert('成功：' + data.filesUploaded + '\r\n失败：' + data.errors + '\r\n大小：' + data.allBytesLoaded + '\r\n速度：' + data.speed); }
    });
}