﻿Imports BaseFunction.PublicMethod
Partial Class Manager_Adv_Adv
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim mdb As New DB_Adv.clsAdv
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    ReadAdvClass(dplSiteClassID)
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    ReadAdvClass(dplSiteClassID)
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        Dim QuerySingle = mdb.GetSingle(ID)
                        With QuerySingle
                            dplSiteClassID.SelectedValue = .ClassID
                            txtOrderID.Text = .OrderID
                            txtSiteName.Text = .Name
                            txtSiteUrl.Text = .Url
                            txtPicName.Text = .Pic

                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        If mdb.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
                    ReadAdvClass(dplClass)
            End Select
        End If
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        '----------------------------------------
        '
        '     获取数据列表的LINQ语句缓存版本
        '
        '----------------------------------------
        'Dim db As New DB_Adv.DB_AdvDataContext
        'Dim CacheName as String ="Adv"   '待修改
        'Dim mQueryLinq As IQueryable(Of DB_Adv.Adv)=DB_Adv.clsAdv.GetLinq()
        'CacheName = CacheName & (ListPaging.PageNo + 1).ToString
        'Dim mQueryList As List(Of  DB_Adv.Adv) = XrenCache.XrCache.GetList(db, CacheName, mQueryLinq, XrenCache.XrCache.CacheLifeType.Relative, "20", ListPaging.SumCount, ListPaging.PageSize, ListPaging.PageSize * ListPaging.PageNo)
        '----------------------------------------
        '
        '     获取数据列表的LINQ语句
        '
        '----------------------------------------
        Dim db As New DB_Adv.DB_AdvDataContext
        Dim mQueryLinq As IQueryable(Of DB_Adv.Adv) = DB_Adv.clsAdv.GetLinq(CType(GetApplication("SiteID"), Integer))
        Dim selClassID As Integer = 0
        Integer.TryParse(dplClass.SelectedValue, selClassID)
        If selClassID > 0 Then
            mQueryLinq = mQueryLinq.Where(Function(w) w.ClassID = selClassID)
        End If
        Dim mList As List(Of DB_Adv.Adv)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        Dim mdb As New DB_Adv.clsAdv
        If strMsg.Length = 0 Then
            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                If mdb.Insert(dplSiteClassID.SelectedValue, txtOrderID.Text, CType(GetApplication("SiteID"), Integer), txtSiteName.Text, txtSiteUrl.Text, txtPicName.Text) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mdb.Save(ID, dplSiteClassID.SelectedValue, txtOrderID.Text, CType(GetApplication("SiteID"), Integer), txtSiteName.Text, txtSiteUrl.Text, txtPicName.Text) > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If dplSiteClassID.SelectedValue = 0 Then strMsg += "链接分类不能为空！<br />"
        If txtOrderID.Text.Length = 0 Then strMsg += "排序不能为空！<br />"
        If Not IsNumeric(txtOrderID.Text) Then strMsg += "排序只能为数字！<br />"
        If txtSiteName.Text.Length = 0 Then strMsg += "链接名称不能为空！<br />"
        If txtSiteUrl.Text.Length = 0 Then strMsg += "链接地址不能为空！<br />"
        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        Dim mdb As New DB_Adv.clsAdv
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            If mdb.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
    Private Sub ReadAdvClass(ByVal dpl As DropDownList)
        Dim PlugClasses = DB_Adv.clsAdvClass.GetLinq(CType(GetApplication("SiteID"), Integer))
        dpl.Items.Clear()
        For Each mPlug In PlugClasses
            dpl.Items.Add(New ListItem(mPlug.ClassName, mPlug.ID.ToString))
        Next
        Dim DefaultItem As New ListItem("所有分类", "0")
        DefaultItem.Selected = True
        dpl.Items.Add(DefaultItem)
    End Sub

    Protected Sub dplClass_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplClass.SelectedIndexChanged
        ListPaging.PageCount = 0
        GetList()
    End Sub
End Class


