﻿Imports BaseFunction.PublicMethod
Partial Class Manager_Article_ArticleList
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        ArticleContent.SubmitButton = imgSave.ClientID
        ArticleContent.UploadPath = "/Sites/Site" & GetApplication("SiteID") & "/Template" & GetApplication("DefaultGroup") & "/"
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    icAddTiem.SelectDateTime = Now
                    txtAuthor.Text = BaseFunction.SiteUser.GetLoginUserName
                    Dim mClass As New DB_Article.clsArticleClass
                    mClass.FillDplClass(dplEditClass, CType(GetApplication("SiteID"), Integer))
                    FillUserGroup()
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        FillUserGroup()

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        Dim mClass As New DB_Article.clsArticleClass
                        mClass.FillDplClass(dplEditClass, CType(GetApplication("SiteID"), Integer))
                        Dim QuerySingle = DB_Article.clsArticle.GetSingle(ID)
                        With QuerySingle
                            Dim FontStyle As String = .TitleStyle
                            Dim Styles() As String = Nothing
                            Dim Style() As String = Nothing
                            If FontStyle.Length > 0 Then
                                FontStyle = Replace(FontStyle, "<font style=" & Chr(34), "")
                                FontStyle = Replace(FontStyle, ">", "")
                                Styles = Split(FontStyle, ";")
                                For i As Integer = 0 To UBound(Styles)
                                    Style = Split(Styles(i), ":")
                                    Select Case Style(0)
                                        Case "color"
                                            dplColor.SelectedValue = Style(1)
                                            txtTitle.Style.Add("color", Style(1))
                                        Case "font-family"
                                            dplFont.SelectedValue = Style(1)
                                            txtTitle.Style.Add("font-family", Style(1))
                                        Case "font-size"
                                            dplSize.SelectedValue = Style(1)
                                            txtTitle.Style.Add("font-size", Style(1))
                                        Case "font-weight"
                                            chkBold.Checked = True
                                            txtTitle.Style.Add("font-weight", Style(1))
                                        Case "font-style"
                                            chkItalic.Checked = True
                                            txtTitle.Style.Add("font-style", Style(1))
                                        Case "text-decoration"
                                            chkUnderline.Checked = True
                                            txtTitle.Style.Add("text-decoration", Style(1))
                                    End Select
                                Next
                            End If
                            dplEditClass.SelectedValue = .ClassID.ToString
                            txtPoint.Text = .Point
                            dplGroup.SelectedValue = .GroupID.ToString
                            txtHits.Text = .Hits
                            txtGrade.Text = .GradeCount
                            icAddTiem.SelectDateTime = .AddTime
                            Dim strHTML As String = .txtContext.Replace("/&/&", "+")
                            strHTML = "<html><head><title></title></head><body>" & strHTML & "</body></html>"
                            ArticleContent.SetHTML(strHTML)
                            cbChecked.Checked = .IsChecked
                            cbComment.Checked = .OpenComment
                            txtTitle.Text = .Title
                            txtAuthor.Text = .Author
                            txtscTitle.Text = .scTitle
                            txtShortTitle.Text = .ShortTitle
                            txtKeyWord.Text = .KeyWord
                            txtArticleTag.Text = .ArticleTag
                            txtCopyFrom.Text = .CopyFrom
                            txtPicName.Text = .PicName
                            txtArticleAbstract.Text = .ArticleAbstract
                            txtAppendix.Text = .Appendix
                            txtSkipURL.Text = .SkipURL
                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        If DB_Article.clsArticle.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case "Check"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim mArticle As New DB_Article.clsArticle
                        If mArticle.ChangeChecked(ID) Then
                            ShowMessage(Me, "提示", "设置成功！", "")
                        Else
                            ShowMessage(Me, "提示", "设置失败！", "")
                        End If
                    End If
                Case "Comment"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim mArticle As New DB_Article.clsArticle
                        If mArticle.ChangeComment(ID) Then
                            ShowMessage(Me, "提示", "设置成功！", "")
                        Else
                            ShowMessage(Me, "提示", "设置失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
                    Dim mClass As New DB_Article.clsArticleClass
                    mClass.FillDplClass(dplClass, CType(GetApplication("SiteID"), Integer))
            End Select
        End If
    End Sub
    Private Sub FillUserGroup()
        dplGroup.Items.Clear()
        Dim mGroup As New DB_UserModular.clsUserGroup
        Dim mGroups = DB_UserModular.clsUserGroup.GetLinq(CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer))
        For Each g In mGroups
            dplGroup.Items.Add(New ListItem(g.GroupName, g.ID.ToString))
        Next
        dplGroup.Items.Add(New ListItem("游客", "0"))
        dplGroup.SelectedValue = "0"
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        Dim mClassID As Integer = 0
        Integer.TryParse(dplClass.SelectedValue, mClassID)
        Dim db As New DB_Article.DB_ArticleDataContext
        Dim mQueryLinq As IQueryable(Of DB_Article.Article) = DB_Article.clsArticle.GetLinq(CType(GetApplication("SiteID"), Integer))
        If mClassID > 0 Then
            mQueryLinq = From q In mQueryLinq _
                         Where q.ClassID = mClassID _
                         Select q

        End If
        If cbCheck.Checked Then
            mQueryLinq = mQueryLinq.Where(Function(w) w.IsChecked = False)
        End If
        Dim mList As List(Of DB_Article.Article)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim strHTML As String = ArticleContent.GetHTML
            Dim Regbody As New RegularExpressions.Regex("(<body)+[^<>]*>[^0]*(</body>)+", RegexOptions.IgnoreCase)
            If Regbody.IsMatch(strHTML) Then
                strHTML = Regbody.Match(strHTML).Value
                strHTML = strHTML.Replace("<body>", "")
                strHTML = strHTML.Replace("</body>", "")
            End If


            Dim TitleStyle As String = "<font style=" & Chr(34)
            If dplColor.SelectedValue.Length > 0 Then
                TitleStyle += "color:" & dplColor.SelectedValue & ";"
            End If
            If dplFont.SelectedValue.Length > 0 Then
                TitleStyle += "font-family:" & dplFont.SelectedValue & ";"
            End If
            If dplSize.SelectedValue.Length > 0 Then
                TitleStyle += "font-size:" & dplSize.SelectedValue & ";"
            End If
            If chkBold.Checked Then
                TitleStyle += "font-weight:bold;"
            End If
            If chkItalic.Checked Then
                TitleStyle += "font-style: italic;"
            End If
            If chkUnderline.Checked Then
                TitleStyle += "text-decoration: underline;"
            End If
            TitleStyle += Chr(34) & ">"
            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                If DB_Article.clsArticle.Insert(CType(GetApplication("SiteID"), Integer), CType(dplEditClass.SelectedValue, Integer), txtPoint.Text, CType(dplGroup.SelectedValue, Integer), txtHits.Text, icAddTiem.SelectDateTime, strHTML, cbChecked.Checked, cbComment.Checked, txtGrade.Text, txtTitle.Text, TitleStyle, txtAuthor.Text, txtscTitle.Text, txtShortTitle.Text, txtKeyWord.Text, txtArticleTag.Text, txtCopyFrom.Text, txtPicName.Text, txtArticleAbstract.Text, txtAppendix.Text, txtSkipURL.Text) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If DB_Article.clsArticle.Save(ID, CType(dplEditClass.SelectedValue, Integer), txtPoint.Text, CType(dplGroup.SelectedValue, Integer), txtHits.Text, icAddTiem.SelectDateTime, strHTML, cbChecked.Checked, cbComment.Checked, txtGrade.Text, txtTitle.Text, TitleStyle, txtAuthor.Text, txtscTitle.Text, txtShortTitle.Text, txtKeyWord.Text, txtArticleTag.Text, txtCopyFrom.Text, txtPicName.Text, txtArticleAbstract.Text, txtAppendix.Text, txtSkipURL.Text) > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If dplEditClass.SelectedValue = "0" Then strMsg += "分类序号不能为空！<br />"
        If txtHits.Text.Length = 0 Then strMsg += "点击量不能为空！<br />"
        If txtGrade.Text.Length = 0 Then strMsg += "评分不能为空！<br />"
        If ArticleContent.GetHTML.Length = 0 Then strMsg += "文章内容不能为空！<br />"
        If txtTitle.Text.Length = 0 Then strMsg += "标题不能为空！<br />"
        If txtAuthor.Text.Length = 0 Then strMsg += "作者不能为空！<br />"
        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            If DB_Article.clsArticle.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub

    Protected Sub cbCheck_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbCheck.CheckedChanged
        If cbCheck.Checked Then
            cbCheck.Text = "未审核"
        Else
            cbCheck.Text = "审核"
        End If
        GetList()
    End Sub

    Protected Sub dplClass_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplClass.SelectedIndexChanged
        GetList()
    End Sub
End Class
