﻿Imports BaseFunction.PublicMethod
Partial Class Manager_House_HouseInfo
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim mclsHouse As New DB_House.clsHouseInfo
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    FillHouseClass()
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        FillHouseClass()
                        Dim QuerySingle = mclsHouse.GetSingle(ID)
                        With QuerySingle
                            dplHouseClass.SelectedValue = .ClassID.ToString
                            txtArea.Text = .Area
                            txtTitle.Text = .Title
                            txtHousePosition.Text = .HousePosition
                            dplOrientation.SelectedValue = .Orientation
                            hfFileList.Value = .HousePics
                            txtTrafficSigns.Text = .TrafficSigns
                            txtNote.Text = .Note
                            txtPrices.Text = .Prices.ToString
                            cbIsTop.Checked = .IsTop
                            rblHouseType.SelectedValue = .HouseType
                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        If mclsHouse.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub

    Private Sub FillHouseClass()
        Dim mClasses = DB_House.clsHouseClass.GetLinq(CType(GetApplication("SiteID"), Integer))
        dplHouseClass.Items.Clear()
        dplHouseClass.Items.Add(New ListItem("房产分类", "0"))
        For Each c In mClasses
            dplHouseClass.Items.Add(New ListItem(c.ClassName, c.ClassID.ToString))
        Next
        dplHouseClass.SelectedValue = "0"
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        '----------------------------------------
        '
        '     获取数据列表的LINQ语句缓存版本
        '
        '----------------------------------------
        'Dim db As New DB_HouseInfo.DB_HouseInfoDataContext
        'Dim CacheName as String ="HouseInfo"   '待修改
        'Dim mQueryLinq As IQueryable(Of DB_HouseInfo.HouseInfo)=DB_HouseInfo.clsHouseInfo.GetLinq()
        'CacheName = CacheName & (ListPaging.PageNo + 1).ToString
        'Dim mQueryList As List(Of  DB_HouseInfo.HouseInfo) = XrenCache.XrCache.GetList(db, CacheName, mQueryLinq, XrenCache.XrCache.CacheLifeType.Relative, "20", ListPaging.SumCount, ListPaging.PageSize, ListPaging.PageSize * ListPaging.PageNo)
        '----------------------------------------
        '
        '     获取数据列表的LINQ语句
        '
        '----------------------------------------
        Dim mQueryLinq As IQueryable(Of DB_House.HouseInfo) = DB_House.clsHouseInfo.GetLinq()
        Dim mList As List(Of DB_House.HouseInfo)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mclsHouse As New DB_House.clsHouseInfo
            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                If mclsHouse.Insert(CType(dplHouseClass.SelectedValue, Integer), txtArea.Text, txtTitle.Text, txtHousePosition.Text, dplOrientation.SelectedValue, hfFileList.Value, txtTrafficSigns.Text, txtNote.Text, txtPrices.Text, cbIsTop.Checked, rblHouseType.SelectedValue) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mclsHouse.Save(ID, CType(dplHouseClass.SelectedValue, Integer), txtArea.Text, txtTitle.Text, txtHousePosition.Text, dplOrientation.SelectedValue, hfFileList.Value, txtTrafficSigns.Text, txtNote.Text, txtPrices.Text, cbIsTop.Checked, rblHouseType.SelectedValue) > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If dplHouseClass.SelectedValue = "0" Then strMsg += "分类不能为空！<br />"
        If txtTitle.Text.Length = 0 Then strMsg += "标题不能为空！<br />"
        If Not IsNumeric(txtPrices.Text) Then strMsg += "价格只能输入数字！<br />"
        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mclsHouse As New DB_House.clsHouseClass
            If mclsHouse.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
End Class
