﻿Imports BaseFunction.PublicMethod
Partial Class Manager_Plug
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    ReadPlugClass(dplClass)
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    ReadPlugClass(dplClass)
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        Dim mPlug As New DB_PlugModular.clsPlug
                        Dim QuerySingle = mPlug.GetSingle(ID)
                        With QuerySingle
                            dplClass.SelectedValue = .ClassID.ToString
                            dplPageFlag.SelectedValue = .PageFlag.ToString
                            txtOrderID.Text = .OrderID.ToString
                            cbShowMenu.Checked = .ShowMenu
                            cbNewTarget.Checked = .NewTarget
                            txtPlugName.Text = .PlugName
                            txtPlugMemo.Text = .PlugMemo
                            txtAuthor.Text = .Author
                            txtPageSetFile.Text = .PageSetFile
                            txtSendTo.Text = .SendTo
                            txtLookFor.Text = .LookFor
                            txtPlugPic.Text = .PlugPic
                            txtBaseURL.Text = .BaseURL
                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        Dim mPlug As New DB_PlugModular.clsPlug
                        If mPlug.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    ReadPlugClass(dplSelClass)
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        Dim mQueryLinq As IQueryable(Of DB_PlugModular.Plug) = DB_PlugModular.clsPlug.GetLinq()
        Dim selClassID As Integer = 0
        Integer.TryParse(dplSelClass.SelectedValue, selClassID)
        If selClassID > 0 Then
            mQueryLinq = mQueryLinq.Where(Function(w) w.ClassID = selClassID)
        End If
        Dim mList As List(Of DB_PlugModular.Plug)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim BaseUrl As String = "manager"
            Dim mPlug As New DB_PlugModular.clsPlug
            If txtBaseURL.Text.Length > 0 Then BaseUrl = txtBaseURL.Text.ToLower
            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                If mPlug.Insert(CType(dplClass.SelectedValue, Integer), CType(dplPageFlag.SelectedValue, Integer), txtOrderID.Text, Now, cbShowMenu.Checked, cbNewTarget.Checked, txtPlugName.Text, txtPlugMemo.Text, txtAuthor.Text, txtPageSetFile.Text, txtSendTo.Text, txtLookFor.Text, txtPlugPic.Text, BaseUrl) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mPlug.Save(ID, CType(dplClass.SelectedValue, Integer), CType(dplPageFlag.SelectedValue, Integer), txtOrderID.Text, Now, cbShowMenu.Checked, cbNewTarget.Checked, txtPlugName.Text, txtPlugMemo.Text, txtAuthor.Text, txtPageSetFile.Text, txtSendTo.Text, txtLookFor.Text, txtPlugPic.Text, BaseUrl) > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If CType(dplClass.SelectedValue, Integer) = 0 Then strMsg += "未选择分类！"
        If CType(dplPageFlag.SelectedValue, Integer) = 0 Then strMsg += "未选择插件类型！"
        If txtPlugName.Text.Length = 0 Then strMsg += "插件名称不能为空！"
        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mPlug As New DB_PlugModular.clsPlug
            If mPlug.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub

    Private Sub ReadPlugClass(ByVal dpl As DropDownList)
        Dim PlugClasses = DB_PlugModular.clsPlugClass.GetLinq
        dpl.Items.Clear()
        For Each mPlug In PlugClasses
            dpl.Items.Add(New ListItem(mPlug.ClassName, mPlug.ClassID.ToString))
        Next
        Dim DefaultItem As New ListItem("所有分类", "0")
        DefaultItem.Selected = True
        dpl.Items.Add(DefaultItem)
    End Sub

    Protected Sub dplSelClass_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplSelClass.SelectedIndexChanged
        ListPaging.PageCount = 0
        GetList()
    End Sub
End Class
