﻿Imports BaseFunction.PublicMethod
Partial Class Manager_Tags_SQLManager
    Inherits System.Web.UI.Page

    Private Sub GetList()
        Dim mQueryLinq As IQueryable(Of DB_SQL.SQLData) = DB_SQL.clsSQLData.GetLinq(CType(GetApplication("SiteID"), Integer))
        Dim mList As List(Of DB_SQL.SQLData)
        Dim mSQLClassID As Integer = 0
        Integer.TryParse(dplSQLGroup.SelectedValue, mSQLClassID)
        If mSQLClassID > 0 Then
            mQueryLinq = mQueryLinq.Where(Function(w) w.ClassID = mSQLClassID)
        End If
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub
    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mSQLData As New DB_SQL.clsSQLData
            If mSQLData.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            If Request("Action") = "Del" Then
                Dim ID As Integer = 0
                If Integer.TryParse(Request("ID"), ID) Then
                    Dim mclsSQLData As New DB_SQL.clsSQLData
                    If mclsSQLData.Delete(ID) Then
                        ShowMessage(Me, "提示", "删除成功！", "")
                    Else
                        ShowMessage(Me, "提示", "删除失败！", "")
                    End If
                End If
            End If
            dplSQLGroup.Items.Clear()
            dplSQLGroup.Items.Add(New ListItem("所有分组", "0"))
            Dim mSqlClass = DB_SQL.clsSQLClass.GetLinq(CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer))
            For Each c In mSqlClass
                dplSQLGroup.Items.Add(New ListItem(c.ClassName, c.ID.ToString))
            Next
            dplSQLGroup.SelectedIndex = 0
            GetList()
        End If
    End Sub
    Public Function intTypeToStrType(ByVal intType As Integer) As String
        Select Case intType
            Case -1
                Return "查询"
            Case -2
                Return "添加"
            Case -3
                Return "更新"
            Case -4
                Return "删除"
            Case -5
                Return "特殊查询"
            Case Else
                If intType > 0 Then
                    Dim clsSQLTemp As New DB_SQL.clsSQLTemplate
                    Dim mSQLTmp As DB_SQL.SQLTemplate = clsSQLTemp.GetSingle(intType)
                    If mSQLTmp IsNot Nothing Then
                        Return mSQLTmp.SQLName
                    Else
                        Return ""
                    End If
                Else
                    Return ""
                End If
        End Select
    End Function
    Public Function intCacheTostrCache(ByVal CacheType As Integer) As String
        Select Case CacheType
            Case 1
                Return "绝对时间"
            Case 2
                Return "相对时间"
            Case 3
                Return "文件"
            Case Else
                Return "无缓存"
        End Select
    End Function

    Protected Sub dplSQLGroup_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplSQLGroup.SelectedIndexChanged
        ListPaging.PageCount = 0
        GetList()
    End Sub
End Class
