﻿Imports BaseFunction.PublicMethod
Partial Class Manager_SQLUrl
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim mSQLID As Integer
            If Integer.TryParse(Request("SQLID"), mSQLID) Then
                hfSQLID.Value = mSQLID.ToString
                Select Case Request("Action")
                    Case "Add"
                        MultiView1.ActiveViewIndex = 0
                    Case "Edit"
                        imgSave.ToolTip = "保存"
                        imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                        MultiView1.ActiveViewIndex = 0
                        Dim ID As Integer = 0
                        If Integer.TryParse(Request("ID"), ID) Then

                            '----------------------------------------
                            '
                            '           数据库获取单条记录逻辑操作
                            '
                            '----------------------------------------
                            Dim mURL As New DB_SQL.clsSQLUrl
                            Dim QuerySingle = mURL.GetSingle(ID)
                            With QuerySingle
                                txtLookFor.Text = .LookFor.Replace(".html", "")
                                txtSendTo.Text = .SendTo
                            End With
                        End If
                    Case "Del"
                        Dim ID As Integer = 0
                        If Integer.TryParse(Request("ID"), ID) Then
                            '----------------------------------------
                            '
                            '           数据库删除逻辑操作
                            '
                            '----------------------------------------
                            Dim mURL As New DB_SQL.clsSQLUrl
                            If mURL.Delete(ID) Then
                                ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('删除成功！');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & mSQLID.ToString & "'", True)
                            Else
                                ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('删除失败！');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & mSQLID.ToString & "'", True)
                            End If
                        End If
                    Case Else
                        GetList(mSQLID)
                End Select
            End If
           
        End If
    End Sub
    Private Sub GetList(ByVal mSQLID As Integer)
        MultiView1.ActiveViewIndex = 1
        Dim mQueryLinq As IQueryable(Of DB_SQL.SQLUrl) = DB_SQL.clsSQLUrl.GetSQLLinq(mSQLID)
        Dim mList As List(Of DB_SQL.SQLUrl)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        Dim mSQLID As Integer
        If strMsg.Length = 0 AndAlso Integer.TryParse(hfSQLID.Value, mSQLID) Then
            Dim mSQL As New DB_SQL.clsSQLUrl
            Dim strPagingLookFor As String = ""
            Dim strPagingSendTo As String = ""
            If Left(txtLookFor.Text, 2) <> "~/" Then
                txtLookFor.Text = "~/" & txtLookFor.Text
            End If
            If Left(txtSendTo.Text, 2) <> "~/" Then
                txtSendTo.Text = "~/" & txtSendTo.Text
            End If
           
            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
                If mSQL.Insert(mSQLID, txtLookFor.Text & ".html", txtSendTo.Text, mSiteID) > 0 Then
                    ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('添加成功！');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & mSQLID.ToString & "'", True)
                Else
                    ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('添加失败！');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & mSQLID.ToString & "'", True)
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mSQL.Save(ID, txtLookFor.Text & ".html", txtSendTo.Text) > 0 Then
                        ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('修改成功！');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & mSQLID.ToString & "'", True)
                    Else
                        ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('修改失败！');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & mSQLID.ToString & "'", True)
                    End If
                End If
            End If
        Else
            ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('" & strMsg & "');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & hfSQLID.Value & "'", True)
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If txtLookFor.Text.Length = 0 Then strMsg += "虚拟地址不能为空！<br />"
        If txtSendTo.Text.Length = 0 Then strMsg += "真实地址不能为空！<br />"

        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mSQL As New DB_SQL.clsSQLUrl
            If mSQL.Delete(IDs) Then
                ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('删除成功！');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & hfSQLID.Value & "'", True)
            Else
                ClientScript.RegisterStartupScript(Page.GetType, "ShowMessage", "alert('删除失败！');window.location='/Manager/Tags/SQLUrl.aspx?SQLID=" & hfSQLID.Value & "'", True)
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList(CType(hfSQLID.Value, Integer))
    End Sub
End Class
