﻿Imports BaseFunction.PublicMethod
Partial Class Manager_TagData
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    GetClass()
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    GetClass()
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        Dim mTagData As New DB_Tag.clsTagData
                        Dim QuerySingle = mTagData.GetSingle(ID)
                        With QuerySingle
                            dplClassID.SelectedValue = .ClassID.ToString
                            txtTagName.Text = .TagName
                            txtTagContent.Text = Base64DecryptData(.TagContent)
                            hfTagName.Value = .TagName
                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        Dim mTagData As New DB_Tag.clsTagData
                        If mTagData.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    Dim mClass As List(Of DB_Tag.TagClass) = DB_Tag.clsTagClass.GetLinq(CType(BaseFunction.PublicMethod.GetApplication("SiteID"), Integer)).ToList
                    dplTagClass.Items.Clear()
                    dplTagClass.Items.Add(New ListItem("所有分类", "0"))
                    For Each c In mClass
                        dplTagClass.Items.Add(New ListItem(c.ClassName, c.ID.ToString))
                    Next
                    dplTagClass.SelectedValue = "0"
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetClass()
        Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
        Dim mClassIDList = DB_Tag.clsTagClass.GetLinq(mSiteID).ToList
        dplClassID.Items.Clear()
        dplClassID.Items.Add(New ListItem("所有分类", "0"))
        For Each c In mClassIDList
            dplClassID.Items.Add(New ListItem(c.ClassName, c.ID.ToString))
        Next
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        Dim db As New DB_Tag.DB_TagDataContext
        Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
        Dim mTagClassID As Integer = 0
        Integer.TryParse(dplTagClass.SelectedValue, mTagClassID)
        Dim mQueryable As IQueryable(Of DB_Tag.TagData)
        If mTagClassID > 0 Then
            mQueryable = DB_Tag.clsTagData.GetClassLinq(mTagClassID)
        Else
            mQueryable = DB_Tag.clsTagData.GetLinq(mSiteID)
        End If
        Dim mList As List(Of DB_Tag.TagData)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryable.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryable.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim strContent As String = Base64EncryptData(Server.UrlDecode(txtTagContent.Text))
            Dim mTagData As New DB_Tag.clsTagData
            Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)

            If imgSave.ToolTip = "添加" Then
                If mTagData.IsHasTagName(txtTagName.Text, mSiteID) Then
                    ShowMessage(Me, "提示", "添加失败！标签名已存在！", "")
                Else
                    If mTagData.Insert(CType(dplClassID.SelectedValue, Integer), txtTagName.Text, strContent, mSiteID) > 0 Then
                        ShowMessage(Me, "提示", "添加成功！", "")
                    Else
                        ShowMessage(Me, "提示", "添加失败！", "")
                    End If
                End If

            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mTagData.IsHasTagName(ID, txtTagName.Text, mSiteID) Then
                        ShowMessage(Me, "提示", "添加失败！标签名已存在！", "")
                    Else
                        If mTagData.Save(ID, CType(dplClassID.SelectedValue, Integer), txtTagName.Text, strContent) > 0 Then
                            ShowMessage(Me, "提示", "修改成功！", "")
                        Else
                            ShowMessage(Me, "提示", "修改失败！", "")
                        End If
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If dplClassID.SelectedValue = "0" Then strMsg += "请选择分类分类！<br />"
        If txtTagName.Text.Length = 0 Then strMsg += "标签名称不能为空！<br />"
        If txtTagContent.Text.Length = 0 Then strMsg += "标签内容不能为空！<br />"

        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mTagData As New DB_Tag.clsTagData
            If mTagData.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub

    Protected Sub dplTagClass_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplTagClass.SelectedIndexChanged
        GetList()
    End Sub
End Class
