﻿
Imports BaseFunction.PublicMethod
Partial Class Manager_Task_TaskClass
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not Me.IsPostBack Then
            AddNodes()
        End If

    End Sub
    Private Sub AddNodes()
        Dim isFind As Boolean = False
        Dim ClassInfo() As String
        Dim TmpInfo() As String

        Dim ArticleClasses = DB_Task.clsTaskClass.GetLinq(CType(GetApplication("SiteID"), Integer))
        ClassTree.Nodes.Clear()
        Dim Fnode As New TreeNode(GetApplication("WebName"), "0,-1,0,0,-1")
        Dim iNode As TreeNode
        If Fnode.Value = hfParentID.Value Then Fnode.Selected = True
        ClassTree.Nodes.Add(Fnode)
        For Each mClass In ArticleClasses
            iNode = New TreeNode(mClass.ClassName, mClass.ClassID.ToString & "," & mClass.ParentID.ToString & "," & mClass.ClassLev.ToString & "," & mClass.ChildCount.ToString)
            If iNode.Value = hfParentID.Value Then iNode.Selected = True
            ClassInfo = Split(iNode.Value, ",")
            For Each sNode As TreeNode In ClassTree.Nodes
                TmpInfo = Split(sNode.Value, ",")
                If CLng(ClassInfo(1)) = TmpInfo(0) Then
                    sNode.ChildNodes.Add(iNode)
                    Exit For
                Else
                    If InsertNodes(sNode, iNode) Then Exit For
                End If
            Next
        Next
        ClassTree.ExpandAll()
    End Sub
    Private Function InsertNodes(ByVal pNode As TreeNode, ByVal insertNode As TreeNode) As Boolean
        Dim ClassInfo() As String
        Dim InsertInfo() As String = Split(insertNode.Value, ",")
        For Each fNode As TreeNode In pNode.ChildNodes
            ClassInfo = Split(fNode.Value, ",")
            If ClassInfo(0) = InsertInfo(1) Then
                fNode.ChildNodes.Add(insertNode)
                Return True
            End If
        Next
        For Each fNode As TreeNode In pNode.ChildNodes
            If InsertNodes(fNode, insertNode) Then Return True
        Next
    End Function

    Protected Sub ClassTree_SelectedNodeChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ClassTree.SelectedNodeChanged
        Dim ClassInfo() As String
        ClassInfo = Split(ClassTree.SelectedValue, ",")
        If CType(ClassInfo(1), Integer) < 0 Then
            LblParent.Text = "无"
            TxtClassName.Enabled = False
        Else
            TxtClassName.Enabled = True
            LblParent.Text = ClassTree.SelectedNode.Parent.Text
        End If
        Dim mClass As New DB_Task.clsTaskClass
        Dim SelClass = mClass.GetSingle(CType(ClassInfo(0), Integer))
        If Not IsNothing(SelClass) Then
            TxtClassName.Text = SelClass.ClassName
        End If
        hfParentID.Value = ClassTree.SelectedNode.Value
    End Sub
    Protected Sub lnkDeleteClass_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkDeleteClass.Click
        If hfParentID.Value = "" Then
            ShowMessage(Me.Page, "请选择要删除的栏目！")
            Exit Sub
        End If
        Dim ClassInfo() As String
        Dim i As Integer = 0
        If hfParentID.Value = "" Then hfParentID.Value = "0,-1,0,0,-1"
        ClassInfo = Split(hfParentID.Value, ",")
        Dim ChildCount As Integer = (From x In DB_Task.clsTaskClass.GetLinq(CType(GetApplication("SiteID"), Integer)) _
                                     Where x.ParentID = CType(ClassInfo(0), Integer) _
                                     Select New With {x.ClassID}).Count

        If ChildCount > 0 Then
            ShowMessage(Me.Page, "删除失败！栏目中含有子栏目！")
        Else
            Dim mClasses As New DB_Task.clsTaskClass
            If mClasses.Delete(CType(ClassInfo(0), Integer)) Then
                ShowMessage(Me.Page, "删除成功！")
                AddNodes()
            End If
        End If
    End Sub

    Protected Sub LnkClassUpdate_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles LnkClassUpdate.Click
        If TxtClassName.Text.Length = 0 Then
            ShowMessage(Me.Page, "请输入栏目名！")
            Exit Sub
        End If
        Dim ClassInfo() As String
        If hfParentID.Value = "" Then hfParentID.Value = "0,-1,0,0,-1"
        ClassInfo = Split(hfParentID.Value, ",")
        Dim mClass As New DB_Task.clsTaskClass
        If mClass.Save(CType(ClassInfo(0), Integer), TxtClassName.Text) > 0 Then
            ShowMessage(Me.Page, "保存成功！")
            AddNodes()
        End If
    End Sub

    Protected Sub LnkClassAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles LnkClassAdd.Click
        If TxtClassName.Text.Length = 0 Then
            ShowMessage(Me.Page, "请输入栏目名！")
            Exit Sub
        End If
        Dim ClassInfo() As String
        Dim MaxOrder As Integer = 0
        Dim pClassID As Integer = 0
        Dim pClassLevel As Integer = 1
        If hfParentID.Value <> "" Then
            ClassInfo = Split(hfParentID.Value, ",")
        Else
            ClassInfo = Split("0,-1,0,0,-1", ",")
        End If
        Dim maxTaskClass As DB_Task.TaskClass = (From m In DB_Task.clsTaskClass.GetLinq(CType(GetApplication("SiteID"), Integer)) _
                                                 Where m.ParentID = CType(ClassInfo(1), Integer) _
                                                 Order By m.OrderID Descending _
                                                 Select m).FirstOrDefault
        If maxTaskClass IsNot Nothing Then
            MaxOrder = maxTaskClass.OrderID
        End If


        Integer.TryParse(ClassInfo(1), pClassID)
        If pClassID > 0 Then pClassLevel = CType(ClassInfo(2), Integer)

        Dim mClass As New DB_Task.clsTaskClass
        If mClass.Insert(CType(GetApplication("SiteID"), Integer), pClassID, pClassLevel, 0, MaxOrder + 1, TxtClassName.Text) > 0 Then
            ShowMessage(Me.Page, "添加成功！")
            AddNodes()
        Else
            ShowMessage(Me.Page, "添加失败！")
        End If
    End Sub

    Protected Sub LnkAddClass_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles LnkAddClass.Click
        If hfParentID.Value = "" Then
            ShowMessage(Me.Page, "添加失败！请先选择父级栏目才能添加子栏目！")
            Exit Sub
        End If
        If TxtClassName.Text.Length = 0 Then
            ShowMessage(Me.Page, "请输入栏目名！")
            Exit Sub
        End If

        Dim ClassInfo() As String = Split(hfParentID.Value, ",")

        Dim MaxOrder As Integer = 0
        Dim maxTaskClass As DB_Task.TaskClass = (From m In DB_Task.clsTaskClass.GetLinq(CType(GetApplication("SiteID"), Integer)) _
                                                 Where m.ParentID = CType(ClassInfo(1), Integer) _
                                                 Order By m.OrderID Descending _
                                                 Select m).FirstOrDefault
        If maxTaskClass IsNot Nothing Then
            MaxOrder = maxTaskClass.OrderID
        End If

        Dim mClass As New DB_Task.clsTaskClass
        If mClass.Insert(CType(GetApplication("SiteID"), Integer), CType(ClassInfo(0), Integer), CType(ClassInfo(2), Integer) + 1, 0, MaxOrder + 1, TxtClassName.Text) > 0 Then
            ShowMessage(Me.Page, "添加成功！")
            AddNodes()
        Else
            ShowMessage(Me.Page, "添加失败！")
        End If
    End Sub



    Protected Sub LnkClassUp_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles LnkClassUp.Click
        ChangeOrder(True)
        AddNodes()
    End Sub
    Private Sub ChangeOrder(ByVal SetChange As Boolean)
        Dim ClassInfo() As String
        Dim MeOrderID As Integer = 0
        Dim vClassID As Integer = 0
        Dim MaxOrder As Integer = 0
        Dim cOrder As Integer = 0
        ClassInfo = Split(hfParentID.Value, ",")
        Dim mArticleClass As New DB_Task.clsTaskClass
        If mArticleClass.ChangeOrder(CType(GetApplication("SiteID"), Integer), CType(ClassInfo(1), Integer), CType(ClassInfo(0), Integer), SetChange) Then
            ShowMessage(Me.Page, "操作成功！")
            AddNodes()
        Else
            ShowMessage(Me.Page, "操作失败！")
        End If

    End Sub


    Protected Sub LnkClassDown_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles LnkClassDown.Click
        ChangeOrder(False)
        AddNodes()
    End Sub

    Protected Sub dplChannel_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs)
        AddNodes()
    End Sub

    Protected Sub LnkClassReset_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles LnkClassReset.Click
        Dim ClassInfo() As String
        Dim i As Integer = 0
        ClassInfo = Split(hfParentID.Value, ",")
        Dim db As New DB_Task.DB_TaskDataContext
        Dim mClasses = From c In DB_Task.clsTaskClass.GetLinq(CType(GetApplication("SiteID"), Integer)) _
                       Where c.ParentID = CType(ClassInfo(1), Integer) _
                       Select c
        For Each mClass In mClasses
            i += 1
            mClass.OrderID = i
        Next
        db.SubmitChanges()
    End Sub
End Class

