﻿
Imports BaseFunction.PublicMethod
Partial Class Manager_Task_TaskList
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Fail"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim mTask As New DB_Task.clsTaskList
                        If mTask.SetFail(ID) Then
                            ShowMessage(Me, "提示", "执行成功！", "")
                        Else
                            ShowMessage(Me, "提示", "执行失败！", "")
                        End If
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim mTask As New DB_Task.clsTaskList
                        If mTask.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetList()
        Dim mQueryLinq As IQueryable(Of DB_Task.TaskList) = DB_Task.clsTaskList.GetLinq(CType(GetApplication("SiteID"), Integer))
        Dim mList As List(Of DB_Task.TaskList)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub



    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mTask As New DB_Task.clsTaskList
            If mTask.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
    ''' 等待接受：   1
    ''' 执行中：     2
    ''' 待确认完成： 3
    ''' 被拒绝：     4
    ''' 已完成：     0
    ''' 失效：       -1
    Public Function intStateName(ByVal intState As Integer) As String
        Select Case intState
            Case 0
                Return "已完成"
            Case 1
                Return "等待接受"
            Case 2
                Return "执行中"
            Case 3
                Return "待确认完成"
            Case 4
                Return "被拒绝"
            Case -1
                Return "失效"
            Case Else
                Return ""
        End Select

    End Function
    ''' 悬赏任务：   1
    ''' 指派任务：     2
    ''' 竞价： 3
    Public Function intTypeName(ByVal intType As Integer) As String
        Select Case intType
            Case 1
                Return "悬赏"
            Case 2
                Return "指派"
            Case 3
                Return "竞价"
            Case Else
                Return ""
        End Select
    End Function
End Class

