﻿Imports BaseFunction.PublicMethod
Partial Class Manager_TemplateList
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        HtmlContent.UploadPath = "/Sites/Site" & GetApplication("SiteID") & "/Template" & Request("ClassID") & "/"
        HtmlContent.SubmitButton = imgSave.ClientID
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    GetTmpClass()
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    GetTmpClass()
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        Dim mTmpList As New DB_Template.clsTemplateList
                        Dim QuerySingle = mTmpList.GetSingle(ID)
                        With QuerySingle
                            dplClassID.SelectedValue = .ClassID.ToString
                            HtmlContent.SetHTML(Base64DecryptData(.TmpContent))
                            txtTmpName.Text = .TmpName
                            txtFileName.Text = .FileName
                        End With
                        txtFileName.Enabled = False
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        Dim mTmpList As New DB_Template.clsTemplateList
                        If mTmpList.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                        End If
                    End If
                Case "SetDefault"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim mTmpList As New DB_Template.clsTemplateList
                        Dim QuerySingle = mTmpList.GetSingle(ID)
                        Dim mTmp As New DB_Template.FormatTmplate
                        Dim intValue As Integer = mTmp.SaveDefault(ID, QuerySingle.FileName)
                        Select Case intValue
                            Case 0
                                ShowMessage(Me, "提示", "默认模板组设置失败！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                            Case 1
                                Dim mCfg As New DB_SiteInfoModular.clsConfigs
                                If mCfg.ChangeDefaultTMP(CType(GetApplication("SiteID"), Integer), QuerySingle.ClassID) Then
                                    ShowMessage(Me, "提示", "设置成功！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                                Else
                                    ShowMessage(Me, "提示", "默认模板组设置失败！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                                End If
                            Case 2
                                ShowMessage(Me, "提示", "默认模板首页取消成功！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                            Case 3
                                ShowMessage(Me, "提示", "找不到IIS默认页！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                        End Select
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetTmpClass()
        Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
        Dim mClasses = DB_Template.clsTemplateClass.GetLinq(mSiteID).ToList
        dplClassID.Items.Clear()
        dplClassID.Items.Add(New ListItem("选择模板组", "0"))
        For Each c In mClasses
            dplClassID.Items.Add(New ListItem(c.ClassName, c.ID.ToString))
        Next
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        Dim mClassID As Integer
        If Integer.TryParse(Request("ClassID"), mClassID) Then
            Dim db As New DB_Template.DB_TemplateDataContext
            Dim mQueryLinq As IQueryable(Of DB_Template.TemplateList) = DB_Template.clsTemplateList.GetClassLinq(mClassID)
            Dim mList As List(Of DB_Template.TemplateList)
            If ListPaging.SumCount >= 0 Then
                mList = mQueryLinq.ToList
                ListPaging.SumCount = mList.Count
                mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
            Else
                mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
            End If
            rptList.DataSource = mList
            rptList.DataBind()
        End If
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mFmtTmp As New DB_Template.FormatTmplate
            Dim strHTML As String = HtmlContent.GetHTML
            Dim HTML As String = mFmtTmp.FormatSaveHTML(strHTML)
            Dim TmpID As Integer = 0
            Dim mTmpList As New DB_Template.clsTemplateList

            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                Dim mOldTemp As DB_Template.TemplateList = mTmpList.GetSingle(txtFileName.Text)
                If mOldTemp Is Nothing Then
                    If mFmtTmp.FormatSaveFile(HTML, txtFileName.Text, CType(dplClassID.SelectedValue, Integer), txtTmpName.Text) Then
                        ShowMessage(Me, "提示", "添加成功！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                    Else
                        ShowMessage(Me, "提示", "模板生成失败！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                    End If
                Else
                    ShowMessage(Me, "提示", "模板文件名重复！请输入其他文件名重试！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                End If
            Else

                If Integer.TryParse(Request("ID"), TmpID) Then
                    If mFmtTmp.FormatSaveFile(HTML, txtFileName.Text, CType(dplClassID.SelectedValue, Integer), txtTmpName.Text, TmpID) Then
                        ShowMessage(Me, "提示", "修改成功！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                    Else
                        ShowMessage(Me, "提示", "模板生成失败！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If dplClassID.SelectedValue = "0" Then strMsg += "模板组不能为空！<br />"
        If txtTmpName.Text.Length = 0 Then strMsg += "模板名称不能为空！<br />"
        If txtFileName.Text.Length = 0 Then strMsg += "文件名不能为空！<br />"

        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mTmpList As New DB_Template.clsTemplateList
            If mTmpList.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
            Else
                ShowMessage(Me, "提示", "删除失败！", "/Manager/Template/TemplateList.aspx?ClassID=" & Request("ClassID"))
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
    Public Function DefaultPage(ByVal IsDefault As Boolean, ByVal ID As Integer) As String
        If IsDefault Then
            Return "<a href='/Manager/Template/TemplateList.aspx?Action=SetDefault&ClassID=" & Request("ClassID") & "&ID=" & ID.ToString & "'><font color='red'>当前首页</font></a>"
        Else
            Return "<a href='/Manager/Template/TemplateList.aspx?Action=SetDefault&ClassID=" & Request("ClassID") & "&ID=" & ID.ToString & "'>设为首页</a>"
        End If
    End Function
End Class
