﻿Imports BaseFunction.PublicMethod
Partial Class Manager_TemplateURL
    Inherits System.Web.UI.Page
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    GetTemplate()
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    Dim ID As Integer = 0
                    GetTemplate()
                    If Integer.TryParse(Request("ID"), ID) Then

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        Dim mTmpURL As New DB_Template.clsTemplateURL
                        Dim QuerySingle = mTmpURL.GetSingle(ID)
                        With QuerySingle
                            dplTemplate.SelectedValue = .TmpID.ToString
                            txtLookFor.Text = .LookFor.Replace("~/", "")
                            txtSendTo.Text = .SendTo.Replace("~/", "")

                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        Dim mTmpURL As New DB_Template.clsTemplateURL
                        If mTmpURL.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetTemplate()
        dplTmplateClass.Items.Clear()
        dplTemplate.Items.Clear()
        dplTmplateClass.Items.Add(New ListItem("所有模板组", "0"))
        dplTemplate.Items.Add(New ListItem("所有模板", "0"))
        Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
        Dim mTmpClass = DB_Template.clsTemplateClass.GetLinq(mSiteID).ToList
        For Each c In mTmpClass
            dplTmplateClass.Items.Add(New ListItem(c.ClassName, c.ID.ToString))
        Next
        Dim mTmp = DB_Template.clsTemplateList.GetLinq(mSiteID).ToList
        For Each t In mTmp
            dplTemplate.Items.Add(New ListItem(t.TmpName, t.ID.ToString))
        Next
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1

        Dim db As New DB_Template.DB_TemplateDataContext
        Dim mQueryLinq = From u In db.TemplateURL _
                         Join t In db.TemplateList On u.TmpID Equals t.ID _
                         Join c In db.TemplateClass On c.ID Equals t.ClassID _
                         Where c.SiteID = CType(GetApplication("SiteID"), Integer) _
                         Order By c.ID, u.TmpID _
                         Select u.ID, t.TmpName, u.LookFor, u.SendTo

        If ListPaging.SumCount >= 0 Then
            ListPaging.SumCount = mQueryLinq.Count
            rptList.DataSource = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize)
            rptList.DataBind()
        Else
            rptList.DataSource = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize)
            rptList.DataBind()
        End If
        
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mTmpURL As New DB_Template.clsTemplateURL
            Dim mTmpList As New DB_Template.clsTemplateList
            Dim mFileName As String = mTmpList.GetSingle(CType(dplTemplate.SelectedValue, Integer)).FileName
            'Dim FileSize As Integer = FileLen(HttpContext.Current.Server.MapPath("/Sites/Site" & GetApplication("SiteID") & "/Template" & GetApplication("DefaultGroup") & "/" & mFileName & ".aspx"))

            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
                If mTmpURL.Insert(CType(dplTemplate.SelectedValue, Integer), "~/" & txtLookFor.Text, "~/" & txtSendTo.Text, mSiteID, Now) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mTmpURL.Save(ID, CType(dplTemplate.SelectedValue, Integer), "~/" & txtLookFor.Text, "~/" & txtSendTo.Text, Now) > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If dplTemplate.SelectedValue = "0" Then strMsg += "模板序号不能为空！<br />"
        If txtSendTo.Text.Length = 0 Then strMsg += "真实地址不能为空！<br />"

        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mTmpURL As New DB_Template.clsTemplateURL
            If mTmpURL.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub

    Protected Sub dplTmplateClass_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplTmplateClass.SelectedIndexChanged
        Dim mClassID As Integer = 0
        Integer.TryParse(dplTmplateClass.SelectedValue, mClassID)
        dplTemplate.Items.Clear()
        dplTemplate.Items.Add(New ListItem("所有模板", "0"))

        Dim mTmp As List(Of DB_Template.TemplateList)
        If mClassID > 0 Then
            mTmp = DB_Template.clsTemplateList.GetClassLinq(mClassID).ToList()
        Else
            Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
            mTmp = DB_Template.clsTemplateList.GetLinq(mSiteID).ToList()
        End If
        For Each t In mTmp
            dplTemplate.Items.Add(New ListItem(t.TmpName, t.ID.ToString))
        Next
        lblPath.Text = "<span id=""TempPath"" style=""cursor:pointer;"" onclick=""CopyPath();"">~/Sites/Site" & GetApplication("SiteID") & "/Template" & mClassID.ToString & "/</span>"
    End Sub

    Protected Sub dplTemplate_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplTemplate.SelectedIndexChanged
        Dim mClsTmp As New DB_Template.clsTemplateList
        Dim mTmp = mClsTmp.GetSingle(CType(dplTemplate.SelectedValue, Integer))

        lblPath.Text = "<span id=""TempPath"" style=""cursor:pointer;"" onclick=""CopyPath();"">~/Sites/Site" & GetApplication("SiteID") & "/Template" & dplTmplateClass.SelectedValue & "/" & mTmp.FileName & ".aspx</span>"
    End Sub
End Class
