﻿Imports BaseFunction.PublicMethod
Partial Class Manager_UserGroup
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim mUserGroup As New DB_UserModular.clsUserGroup
            Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim QuerySingle = mUserGroup.GetSingle(ID, mSiteID)
                        With QuerySingle
                            txtGroupIntro.Text = .GroupIntro
                            txtGroupName.Text = .GroupName
                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        If mUserGroup.Delete(ID, mSiteID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        If Not Me.ClientScript.IsClientScriptIncludeRegistered("jqueryminScript") Then Me.ClientScript.RegisterClientScriptInclude("jqueryminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/jquery.min.js")
        If Not Me.ClientScript.IsClientScriptIncludeRegistered("lhgdialogminScript") Then Me.ClientScript.RegisterClientScriptInclude("lhgdialogminScript", BaseFunction.PublicMethod.GetBaseUrl & "/App_Themes/ManagerTheme/js/lhgdialog.min.js?self=false")

        Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
        Dim mQueryLinq As IQueryable(Of DB_UserModular.UserGroup) = DB_UserModular.clsUserGroup.GetLinq(mSiteID)
        Dim mList As List(Of DB_UserModular.UserGroup)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mUserGroup As New DB_UserModular.clsUserGroup
            Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
            If imgSave.ToolTip = "添加" Then
                If mUserGroup.Save(txtGroupName.Text, txtGroupIntro.Text, mSiteID) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mUserGroup.Save(ID, txtGroupName.Text, txtGroupIntro.Text, mSiteID) > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If txtGroupIntro.Text.Length = 0 Then strMsg = "用户组简介不能为空/n"
        If txtGroupName.Text.Length = 0 Then strMsg += "用户组名称不能为空"
        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
            Dim mUserGroup As New DB_UserModular.clsUserGroup
            If mUserGroup.Delete(IDs, mSiteID) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
End Class
