﻿Imports BaseFunction.PublicMethod
Imports System.Web.Script.Serialization
Partial Class Manager_Vote_VoteQuestion
    Inherits System.Web.UI.Page
    Private Structure Options
        Dim ID As Integer
        Dim Title As String
        Dim Pic As String
        Dim isRight As Boolean
    End Structure
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        imgSave.Attributes("onclick") = "SaveOption()"
        If Not IsPostBack Then
            Dim mclsOption As New DB_Vote.clsVote_Question
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/SaveOption.gif"
                    MultiView1.ActiveViewIndex = 0
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim QuerySingle = mclsOption.GetSingle(ID)
                        With QuerySingle
                            hfOptionType.Value = .VoteType
                            txtIntegral.Text = .Integral
                            txtQuestionPic.Text = .Pictrue
                            txtQuestionTitle.Text = .Title
                            hfRight.Value = .RightOptionID
                            hfOptionType.Value = .VoteType.ToString
                        End With
                        Dim mOptions = DB_Vote.clsVote_Option.GetLinq(ID)
                        Dim mJson As New JavaScriptSerializer
                        hfOptions.Value = mJson.Serialize(mOptions.ToList)
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        If mclsOption.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        Dim mSubID As Integer = 0
        Integer.TryParse(Request("SubID"), mSubID)
        Dim mQueryLinq As IQueryable(Of DB_Vote.Vote_Question) = DB_Vote.clsVote_Question.GetLinq(mSubID)
        Dim mList As List(Of DB_Vote.Vote_Question)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mclsQuestion As New DB_Vote.clsVote_Question
            Dim mSubID As Integer = 0
            Dim mIntegral As Integer = 0
            Integer.TryParse(txtIntegral.Text, mIntegral)
            Dim mJson As New JavaScriptSerializer
            Dim mQuestionID As Integer
            Dim OptionList As List(Of Options) = mJson.Deserialize(Of List(Of Options))(hfOptions.Value)
            Dim strRightID As String = ""
            If Integer.TryParse(Request("SubID"), mSubID) Then
                If imgSave.ToolTip = "添加" Then
                    mQuestionID = mclsQuestion.Insert(mSubID, hfOptionType.Value, mIntegral, txtQuestionPic.Text, txtQuestionTitle.Text, "")
                    If mQuestionID > 0 Then
                        If OptionList IsNot Nothing AndAlso OptionList.Count > 0 Then
                            Dim mclsOption As New DB_Vote.clsVote_Option
                            For Each o In OptionList
                                If hfOptionType.Value = "radio" Then
                                    If o.isRight Then
                                        strRightID = mclsOption.Insert(mSubID, mQuestionID, o.Title, o.Pic)
                                    Else
                                        mclsOption.Insert(mSubID, mQuestionID, o.Title, o.Pic)
                                    End If
                                Else
                                    If o.isRight Then
                                        If strRightID.Length = 0 Then
                                            strRightID = mclsOption.Insert(mSubID, mQuestionID, o.Title, o.Pic)
                                        Else
                                            strRightID = strRightID & "," & mclsOption.Insert(mSubID, mQuestionID, o.Title, o.Pic)
                                        End If
                                    Else
                                        mclsOption.Insert(mSubID, mQuestionID, o.Title, o.Pic)
                                    End If
                                End If
                            Next
                        End If
                        If mclsQuestion.Save(mQuestionID, strRightID) Then
                            ShowMessage(Me, "提示", "添加成功！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
                        Else
                            ShowMessage(Me, "提示", "选项添加失败！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
                        End If
                    Else
                        ShowMessage(Me, "提示", "试题添加失败！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
                    End If
                Else
                    Dim ID As Integer
                    If Integer.TryParse(Request("ID"), ID) Then
                        If mclsQuestion.Save(ID, hfOptionType.Value, mIntegral, txtQuestionPic.Text, txtQuestionTitle.Text, "") > 0 Then
                            If OptionList IsNot Nothing AndAlso OptionList.Count > 0 Then
                                Dim mclsOption As New DB_Vote.clsVote_Option
                                mclsOption.DeleteByQuestion(ID)
                                For Each o In OptionList
                                    If hfOptionType.Value = "radio" Then
                                        If o.isRight Then
                                            strRightID = mclsOption.Insert(mSubID, ID, o.Title, o.Pic)
                                        Else
                                            mclsOption.Insert(mSubID, ID, o.Title, o.Pic)
                                        End If
                                    Else
                                        If o.isRight Then
                                            If strRightID.Length = 0 Then
                                                strRightID = mclsOption.Insert(mSubID, ID, o.Title, o.Pic)
                                            Else
                                                strRightID = strRightID & "," & mclsOption.Insert(mSubID, ID, o.Title, o.Pic)
                                            End If
                                        Else
                                            mclsOption.Insert(mSubID, ID, o.Title, o.Pic)
                                        End If
                                    End If
                                Next
                            End If
                            If mclsQuestion.Save(ID, strRightID) Then
                                ShowMessage(Me, "提示", "保存成功！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
                            Else
                                ShowMessage(Me, "提示", "选项保存失败！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
                            End If
                        Else
                            ShowMessage(Me, "提示", "试题保存失败！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
                        End If
                    End If
                End If
            Else
                ShowMessage(Me, "提示", "参数错误！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If txtIntegral.Text.Length = 0 Then strMsg += "分数不能为空！<br />"
        If txtQuestionTitle.Text.Length = 0 Then strMsg += "题目不能为空！<br />"

        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mclsOption As New DB_Vote.clsVote_Question
            If mclsOption.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
            Else
                ShowMessage(Me, "提示", "删除失败！", "/Manager/Vote/VoteQuestion.aspx?SubID=" & Request("SubID"))
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
    Public Function NameToString(ByVal OptionType As String) As String
        Select Case OptionType
            Case "radio"
                Return "单选"
            Case "checkbox"
                Return "多选"
        End Select
    End Function
End Class
