﻿Imports BaseFunction.PublicMethod
Partial Class Manager_SiteConfig
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
            Dim mGroups = DB_UserModular.clsUserGroup.GetLinq(mSiteID).ToList
            dplManagerGroup.Items.Clear()
            dplManagerGroup.Items.Add(New ListItem("所有用户组", "0"))
            For Each g In mGroups
                dplManagerGroup.Items.Add(New ListItem(g.GroupName, g.ID.ToString))
            Next
            Dim mTmpClass = DB_Template.clsTemplateClass.GetLinq(mSiteID).ToList
            dplDefaultGroup.Items.Clear()
            dplDefaultGroup.Items.Add(New ListItem("所有模板组", "0"))
            For Each t In mTmpClass
                dplDefaultGroup.Items.Add(New ListItem(t.ClassName, t.ID.ToString))
            Next
            Dim mConfig As New DB_SiteInfoModular.clsConfigs
            Dim QuerySingle = mConfig.GetSingle(mSiteID)
            With QuerySingle
                txtLogTime.Text = .LogTime
                txtWebName.Text = .WebName
                txtWebURL.Text = .WebURL
                txtUpType.Text = .UpType
                txtSiteKey.Text = .SiteKey
                cbCheckFile.Checked = .CheckFile
                cbSecCache.Checked = .SecCache
                rbTrance.SelectedValue = .OpenTrace.ToString
                txtURLRewriteEx.Text = .URLFileEx
                Try
                    dplDefaultGroup.SelectedValue = .DefaultGroup.ToString
                    dplManagerGroup.SelectedValue = .ManagerGroup.ToString
                Catch ex As Exception

                End Try

            End With

        End If
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mGroupID As Integer
            Dim mManagerID As Integer
            Integer.TryParse(dplManagerGroup.SelectedValue, mManagerID)
            Integer.TryParse(dplDefaultGroup.SelectedValue, mGroupID)
            Dim mConfig As New DB_SiteInfoModular.clsConfigs
            If mConfig.Save(CType(GetApplication("SiteID"), Integer), txtWebName.Text, txtWebURL.Text, txtUpType.Text, txtLogTime.Text, txtSiteKey.Text, CType(rbTrance.SelectedValue, Integer), cbCheckFile.Checked, cbSecCache.Checked, mManagerID, mGroupID, txtURLRewriteEx.Text) > 0 Then
                Cache.Remove("ConfigDict")
                ShowMessage(Me, "提示", "修改成功！", "")
            Else
                ShowMessage(Me, "提示", "修改失败！", "")
            End If
        End If
        
    End Sub
    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If txtLogTime.Text.Length = 0 Then strMsg += "日志保存时间不能为空！<br />"
        If txtWebName.Text.Length = 0 Then strMsg += "网站名称不能为空！<br />"
        If txtWebURL.Text.Length = 0 Then strMsg += "网址不能为空！<br />"
        If txtSiteKey.Text.Length = 0 Then strMsg += "不能为空！<br />"
        Return strMsg
    End Function
End Class
