﻿Imports BaseFunction.PublicMethod
Partial Class Manager_SiteManager
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    txtManagerName.Enabled = True
                    txtManagerPWD.Enabled = True
                    txtUpType.Text = GetApplication("UpType")
                    icEndTime.SelectDateTime = Now.AddYears(1)
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        Dim mConfig As New DB_SiteInfoModular.clsConfigs
                        Dim QuerySingle = mConfig.GetSingle(ID)
                        With QuerySingle
                            txtWebName.Text = .WebName
                            txtWebURL.Text = .WebURL
                            icEndTime.SelectDateTime = .EndTime
                            txtUpType.Text = .UpType
                            cbSiteState.Checked = .SiteState
                            txtLogTime.Text = .LogTime
                        End With
                    End If
                    txtManagerName.Enabled = False
                    txtManagerPWD.Enabled = False
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        Dim mConfig As New DB_SiteInfoModular.clsConfigs
                        Dim mSiteName As String = mConfig.GetSingle(ID).WebName
                        Dim mIIS As New SiteManager.clsIIS
                        mIIS.DelVirDir(mSiteName)
                        If mConfig.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1

        Dim mQueryLinq As IQueryable(Of DB_SiteInfoModular.Configs) = DB_SiteInfoModular.clsConfigs.GetLinq()
        Dim mList As List(Of DB_SiteInfoModular.Configs)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mConfig As New DB_SiteInfoModular.clsConfigs
            Dim mUserGroup As New DB_UserModular.clsUserGroup
            Dim mXrenUser As New DB_UserModular.clsXrenUser
            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                Dim mNewSiteID As Integer = mConfig.Insert(txtWebName.Text, txtWebURL.Text, icEndTime.SelectDateTime, txtUpType.Text, cbSiteState.Checked, Now, CType(txtLogTime.Text, Integer), GetApplication("ManagerDirectory"), txtSiteKey.Text, , , GetApplication("URLRewrite"))
                If mNewSiteID > 0 Then
                    Dim mNewGroupID As Integer = mUserGroup.Save(txtGroupName.Text, "系统管理组", mNewSiteID)
                    If mNewGroupID > 0 Then
                        Dim mNewUserID As Integer = mXrenUser.Insert(mNewGroupID, 0, 1, 0, Now, Now, True, True, False, True, txtManagerName.Text, MD5(txtManagerPWD.Text, 16), "admin@admin.com", "", "??????", MD5("!!!!!!", 16), "", "", "", "", mNewSiteID)
                        If mNewUserID > 0 Then
                            Dim mIIS As New SiteManager.clsIIS
                            Dim strReturn As String = mIIS.AddVirDir(txtWebURL.Text, txtWebName.Text, "80")
                            If strReturn.Length = 0 Then
                                mConfig.Save(mNewSiteID, mNewGroupID)
                                ShowMessage(Me, "提示", "添加成功！", "")
                            Else
                                ShowMessage(Me, "提示", strReturn, WindowIcon.Errors)
                            End If
                        Else
                            mConfig.Delete(mNewSiteID)
                            mUserGroup.Delete(mNewGroupID, mNewSiteID)
                            ShowMessage(Me, "提示", "用户添加失败！", WindowIcon.Errors)
                        End If
                    Else
                        mConfig.Delete(mNewSiteID)
                        ShowMessage(Me, "提示", "用户组添加失败！", WindowIcon.Errors)
                    End If
                Else
                    ShowMessage(Me, "提示", "网站添加失败！", WindowIcon.Errors)
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mConfig.Save(ID, txtWebName.Text, txtWebURL.Text, icEndTime.SelectDateTime, txtUpType.Text, cbSiteState.Checked, Now, txtLogTime.Text, GetApplication("ManagerDirectory"), 0) > 0 Then
                        Dim mIIS As New SiteManager.clsIIS
                        If mIIS.ChangeVirDir(txtWebName.Text, cbSiteState.Checked, txtWebURL.Text, txtWebName.Text) Then
                            ShowMessage(Me, "提示", "修改成功！", "")
                        Else
                            ShowMessage(Me, "提示", "信息修改成功！IIS设置失败！", "")
                        End If
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If txtWebName.Text.Length = 0 Then strMsg += "网站名称不能为空！<br />"
        If txtWebURL.Text.Length = 0 Then strMsg += "网址不能为空！<br />"
        If txtLogTime.Text.Length = 0 Then strMsg += "日志保存时间不能为空！<br />"
        If txtSiteKey.Text.Length = 0 Then strMsg += "网站密匙不能为空！<br />"
        If txtGroupName.Text.Length = 0 Then strMsg += "用户组名称不能为空！<br />"
        If txtManagerName.Text.Length = 0 Then strMsg += "用户名不能为空！<br />"
        If txtManagerPWD.Text.Length = 0 Then strMsg += "密码不能为空！<br />"
        Return strMsg
    End Function


   

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
End Class
