﻿Imports BaseFunction.PublicMethod
Imports System.Web.Script.Serialization
Partial Class Manager_WebSite_SiteSEO
    Inherits System.Web.UI.Page
    Private Structure jsFields
        Dim TableID As Integer
        Dim FieldID As Integer
        Dim FieldName As String
        Dim TableName As String
        Dim PrimaryKey As Boolean
    End Structure
    Protected Sub dplBindType_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplBindType.SelectedIndexChanged
        FillBindType()
        txtPageTitle.Text = Server.UrlDecode(txtPageTitle.Text)
        txtKeyWords.Text = Server.UrlDecode(txtKeyWords.Text)
        txtDescription.Text = Server.UrlDecode(txtDescription.Text)
        lblFields.Text = ""
    End Sub
    Protected Sub dplBindID_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles dplBindID.SelectedIndexChanged
        txtPageTitle.Text = Server.UrlDecode(txtPageTitle.Text)
        txtKeyWords.Text = Server.UrlDecode(txtKeyWords.Text)
        txtDescription.Text = Server.UrlDecode(txtDescription.Text)
        If dplBindType.SelectedValue <> "1" Then Exit Sub

        Dim HTML As New StringBuilder
        Dim mSQLID As Integer = 0
        Integer.TryParse(dplBindID.SelectedValue, mSQLID)
        If mSQLID > 0 Then
            Dim mJson As New JavaScriptSerializer
            Dim mclsDesign As New DB_SQL.clsSQLDesign
            Dim mJsonSQL = mclsDesign.GetSingle(mSQLID)
            Dim mJsonField As List(Of jsFields) = mJson.Deserialize(Of List(Of jsFields))(mJsonSQL.hfSelectFields)
            Dim mFielsID() As Integer = (From f In mJsonField _
                                         Select f.FieldID).ToArray

            Dim mFields = DB_SQL.clsTableFields.GetLinq(mFielsID).ToList

            For Each f In mFields
                If f.FieldNote Is Nothing OrElse f.FieldNote.Length = 0 Then
                    HTML.Append("<span id=""" & f.FieldName & """ onclick=""InsertField('" & f.FieldName & "');"">" & f.FieldName & "</span>")
                Else
                    HTML.Append("<span id=""" & f.FieldName & """ onclick=""InsertField('" & f.FieldName & "');"">" & f.FieldNote & "</span>")
                End If
            Next
            lblFields.Text = HTML.ToString
        End If
    End Sub
    Private Sub FillBindType()
        Select Case dplBindType.SelectedValue
            Case "0"
                Dim mTmps = (From t In DB_Template.clsTemplateList.GetLinq(CType(GetApplication("SiteID"), Integer)) _
                            Select t.ID, t.TmpName).ToList
                dplBindID.Items.Clear()
                dplBindID.Items.Add(New ListItem("选择模板", "0"))
                For Each t In mTmps
                    dplBindID.Items.Add(New ListItem(t.TmpName, t.ID.ToString))
                Next
            Case "1"
                Dim mSQLs = (From s In DB_SQL.clsSQLData.GetLinq(CType(GetApplication("SiteID"), Integer)) _
                             Where s.SQLType > -2 _
                             Select s.SQLName, s.ID).ToList
                dplBindID.Items.Clear()
                dplBindID.Items.Add(New ListItem("选择查询", "0"))
                For Each t In mSQLs
                    dplBindID.Items.Add(New ListItem(t.SQLName, t.ID.ToString))
                Next
        End Select
        dplBindID.AutoPostBack = True
    End Sub


    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Select Case Request("Action")
                Case "Add"
                    FillBindType()
                    MultiView1.ActiveViewIndex = 0
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim mclsSEO As New DB_SiteInfoModular.clsSiteSEO
                        Dim QuerySingle = mclsSEO.GetSingle(ID)
                        With QuerySingle
                            dplBindType.SelectedValue = .BindType
                            FillBindType()
                            dplBindID.SelectedValue = .BindID
                            txtSEOName.Text = .SEOName
                            txtPageTitle.Text = Base64DecryptData(.PageTitle)
                            txtKeyWords.Text = Base64DecryptData(.KeyWords)
                            txtDescription.Text = Base64DecryptData(.Description)
                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim mclsSEO As New DB_SiteInfoModular.clsSiteSEO
                        If mclsSEO.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1

        Dim mQueryLinq As IQueryable(Of DB_SiteInfoModular.SiteSEO) = DB_SiteInfoModular.clsSiteSEO.GetLinq(CType(GetApplication("SiteID"), Integer))
        Dim mList As List(Of DB_SiteInfoModular.SiteSEO)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mclsSEO As New DB_SiteInfoModular.clsSiteSEO
            Dim pageTitle As String = Base64EncryptData(Server.UrlDecode(txtPageTitle.Text))
            Dim pageKeyWord As String = Base64EncryptData(Server.UrlDecode(txtKeyWords.Text))
            Dim pageDescription As String = Base64EncryptData(Server.UrlDecode(txtDescription.Text))
            Dim mTmpID As Integer = CType(dplBindID.SelectedValue, Integer)

            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                If mclsSEO.Insert(CType(dplBindType.SelectedValue, Integer), mTmpID, pageTitle, pageKeyWord, pageDescription, txtSEOName.Text, CType(GetApplication("SiteID"), Integer)) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                    Exit Sub
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mclsSEO.Save(ID, CType(dplBindType.SelectedValue, Integer), mTmpID, pageTitle, pageKeyWord, pageDescription, txtSEOName.Text) > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                        Exit Sub
                    End If
                End If
            End If
            If dplBindType.SelectedValue = "0" Then
                Dim mclsTMP As New DB_Template.clsTemplateList
                Dim mTMP As DB_Template.TemplateList = mclsTMP.GetSingle(mTmpID)
                Dim mFmtTmp As New DB_Template.FormatTmplate
                mFmtTmp.FormatSaveFile(Base64DecryptData(mTMP.TmpContent), mTMP.FileName, mTMP.ClassID, mTMP.TmpName, mTmpID)
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If dplBindID.SelectedValue = "0" Then strMsg += "请选择绑定序号！<br />"
        If txtSEOName.Text = "" Then strMsg += "请输入SEO描述！<br />"
        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mclsSEO As New DB_SiteInfoModular.clsSiteSEO
            If mclsSEO.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub

    Public Function intTypeToStr(ByVal intType As Integer) As String
        If intType = 0 Then
            Return "模板"
        Else
            Return "SQL查询"
        End If
    End Function
    Public Function intNameToStr(ByVal intType As Integer, ByVal ID As Integer) As String
        If intType = 0 Then
            Dim mClsTmp As New DB_Template.clsTemplateList
            Dim mTmp = mClsTmp.GetSingle(ID)
            If mTmp IsNot Nothing Then
                Return mTmp.TmpName
            End If
        Else
            Dim mClsSQL As New DB_SQL.clsSQLData
            Dim mSQL = mClsSQL.GetSingle(ID)
            If mSQL IsNot Nothing Then
                Return mSQL.SQLName
            End If
        End If
    End Function
End Class
