﻿Imports BaseFunction.PublicMethod
Partial Class Manager_XrenUser
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim mXrenUser As New DB_UserModular.clsXrenUser
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    ReadGroups()
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    ReadGroups()
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then

                        '----------------------------------------
                        '
                        '           数据库获取单条记录逻辑操作
                        '
                        '----------------------------------------
                        Dim QuerySingle = mXrenUser.GetSingle(ID)
                        With QuerySingle
                            Dim FindValue = (From d As ListItem In dplUserGroup.Items _
                                            Where d.Value = .GroupID.ToString _
                                            Select d).FirstOrDefault
                            If Not IsNothing(FindValue) Then dplUserGroup.SelectedValue = .GroupID.ToString
                            txtPoint.Text = .Point

                            cbIsManager.Checked = .IsManager
                            rbSex.SelectedValue = .Sex.ToString
                            cbIsLocked.Checked = .Locked
                            cbIsVerification.Checked = .IsVerification
                            txtUserName.Text = .UserName
                            txtPassWord.Text = ""
                            txtEmail.Text = .Email
                            txtQuestion.Text = .Question
                            txtAnswer.Text = ""
                            txtUserSignature.Text = .UserSignature
                            txtUserCardID.Text = .UserCardID
                            txtCellPhone.Text = .CellPhone

                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        '----------------------------------------
                        '
                        '           数据库删除逻辑操作
                        '
                        '----------------------------------------
                        If mXrenUser.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub ReadGroups()
        Dim mGroups As List(Of DB_UserModular.UserGroup)
        mGroups = DB_UserModular.clsUserGroup.GetLinq(CType(GetApplication("SiteID"), Integer)).ToList
        dplUserGroup.Items.Clear()
        dplUserGroup.Items.Add(New ListItem("用户分组", "0"))
        For Each g In mGroups
            dplUserGroup.Items.Add(New ListItem(g.GroupName, g.ID.ToString))
        Next
        dplUserGroup.SelectedIndex = 0
    End Sub
    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
        Dim mQueryLinq As IQueryable(Of DB_UserModular.XrenUser) = DB_UserModular.clsXrenUser.GetLinq(mSiteID)
        Dim mList As List(Of DB_UserModular.XrenUser)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mQueryLinq.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then
            Dim mXrenUser As New DB_UserModular.clsXrenUser
            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                Dim mSiteID As Integer = CType(GetApplication("SiteID"), Integer)
                If mXrenUser.Insert(CType(dplUserGroup.SelectedValue, Integer), txtPoint.Text, 1, 0, Now, Now, cbIsManager.Checked, CType(rbSex.SelectedValue, Boolean), cbIsLocked.Checked, cbIsVerification.Checked, txtUserName.Text, BaseFunction.PublicMethod.MD5(txtPassWord.Text, 16), txtEmail.Text, "", txtQuestion.Text, BaseFunction.PublicMethod.MD5(txtAnswer.Text, 16), txtUserSignature.Text, txtUserCardID.Text, txtCellPhone.Text, "0.0.0.0", mSiteID) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mXrenUser.Save(ID, CType(dplUserGroup.SelectedValue, Integer), txtPoint.Text, 1, 0, Now, Now, cbIsManager.Checked, CType(rbSex.SelectedValue, Boolean), cbIsLocked.Checked, cbIsVerification.Checked, txtUserName.Text, BaseFunction.PublicMethod.MD5(txtPassWord.Text, 16), txtEmail.Text, "", txtQuestion.Text, BaseFunction.PublicMethod.MD5(txtAnswer.Text, 16), txtUserSignature.Text, txtUserCardID.Text, txtCellPhone.Text, "0.0.0.0") > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If txtPoint.Text.Length = 0 OrElse Not IsNumeric(txtPoint.Text) Then strMsg += "用户点数只能是数字! <br />"
        If CType(dplUserGroup.SelectedValue, Integer) = 0 Then strMsg += "用户组不能为空！<br />"
        If txtUserName.Text.Length = 0 Then strMsg += "用户名不能为空！<br />"
        If txtEmail.Text.Length = 0 OrElse Not BaseFunction.PublicMethod.CheckEmail(txtEmail.Text) Then strMsg += "邮件地址不正确！<br />"
        If txtQuestion.Text.Length = 0 Then strMsg += "安全问题不能为空！<br />"
        If imgSave.ToolTip = "添加" Then
            If txtPassWord.Text.Length = 0 Then strMsg += "密码不能为空！<br />"
            If txtAnswer.Text.Length = 0 Then strMsg += "安全答案不能为空！<br />"
        End If
        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mXrenUser As New DB_UserModular.clsXrenUser
            If mXrenUser.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
End Class
