﻿Imports BaseFunction.PublicMethod
Partial Class Manager_YCGoods_Yc_Goods
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not IsPostBack Then
            Dim mclsGoods As New DB_YC_Goods.clsYc_Goods
            Select Case Request("Action")
                Case "Add"
                    MultiView1.ActiveViewIndex = 0
                    FillClass()
                Case "Edit"
                    imgSave.ToolTip = "保存"
                    imgSave.ImageUrl = "~/App_Themes/ManagerTheme/Images/bc.jpg"
                    MultiView1.ActiveViewIndex = 0
                    FillClass()
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        Dim QuerySingle = mclsGoods.GetSingle(ID)
                        With QuerySingle
                            dplClass.SelectedValue = .ClassID.ToString
                            txtGoodsPoints.Text = .GoodsPoints
                            txtGoodsName.Text = .GoodsName
                            txtGoodsDetail.Text = .GoodsDetail
                            hfFileList.Value = .GoodsPics

                        End With
                    End If
                Case "Del"
                    Dim ID As Integer = 0
                    If Integer.TryParse(Request("ID"), ID) Then
                        If mclsGoods.Delete(ID) Then
                            ShowMessage(Me, "提示", "删除成功！", "")
                        Else
                            ShowMessage(Me, "提示", "删除失败！", "")
                        End If
                    End If
                Case Else
                    GetList()
            End Select
        End If
    End Sub
    Private Sub FillClass()
        Dim mClass = DB_YC_Goods.clsYc_GoodsClass.GetLinq
        dplClass.Items.Clear()
        dplClass.Items.Add(New ListItem("选择分类", "0"))
        For Each c In mClass
            dplClass.Items.Add(New ListItem(c.ClassName, c.ClassID.ToString))
        Next
    End Sub

    Private Sub GetList()
        MultiView1.ActiveViewIndex = 1
        Dim mQueryLinq As IQueryable(Of DB_YC_Goods.Yc_Goods) = DB_YC_Goods.clsYc_Goods.GetLinq()
        Dim mList As List(Of DB_YC_Goods.Yc_Goods)
        If ListPaging.SumCount >= 0 Then
            mList = mQueryLinq.ToList
            ListPaging.SumCount = mList.Count
            mList = mList.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        Else
            mList = mQueryLinq.Skip(ListPaging.PageSize * ListPaging.PageNo).Take(ListPaging.PageSize).ToList
        End If
        rptList.DataSource = mList
        rptList.DataBind()
    End Sub

    Protected Sub imgSave_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgSave.Click
        Dim strMsg As String = CheckInput()
        If strMsg.Length = 0 Then

            Dim mPics() As String
            Dim mHTMLPics As String = ""
            If hfFileList.Value.Length > 0 Then
                mPics = hfFileList.Value.Split(",")
                For Each p In mPics
                    mHTMLPics = mHTMLPics & "<a href=""" & p & """><img src=""" & p & """ /></a>"
                Next
            End If
            Dim mclsGoods As New DB_YC_Goods.clsYc_Goods
            If imgSave.ToolTip = "添加" Then
                '---------------------------------
                If mclsGoods.Insert(CType(dplClass.SelectedValue, Integer), txtGoodsPoints.Text, txtGoodsName.Text, txtGoodsDetail.Text, hfFileList.Value, mHTMLPics) > 0 Then
                    ShowMessage(Me, "提示", "添加成功！", "")
                Else
                    ShowMessage(Me, "提示", "添加失败！", "")
                End If
            Else
                Dim ID As Integer
                If Integer.TryParse(Request("ID"), ID) Then
                    If mclsGoods.Save(ID, CType(dplClass.SelectedValue, Integer), txtGoodsPoints.Text, txtGoodsName.Text, txtGoodsDetail.Text, hfFileList.Value, mHTMLPics) > 0 Then
                        ShowMessage(Me, "提示", "修改成功！", "")
                    Else
                        ShowMessage(Me, "提示", "修改失败！", "")
                    End If
                End If
            End If
        Else
            ShowMessage(Me, "提示", strMsg, "")
        End If
    End Sub

    Private Function CheckInput() As String
        Dim strMsg As String = ""
        If dplClass.SelectedValue = "0" Then strMsg += "请选择分类！<br />"
        If txtGoodsPoints.Text.Length = 0 Then strMsg += "商品积分不能为空！<br />"
        If txtGoodsName.Text.Length = 0 Then strMsg += "商品名称不能为空！<br />"
        If txtGoodsDetail.Text.Length = 0 Then strMsg += "商品简介不能为空！<br />"

        Return strMsg
    End Function


    Protected Sub cbSelectAll_CheckedChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cbSelectAll.CheckedChanged
        Dim chkBox As System.Web.UI.WebControls.CheckBox

        If cbSelectAll.Checked Then
            cbSelectAll.Text = "取消选择"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = True
            Next
        Else
            cbSelectAll.Text = "选择全部"
            For Each item As RepeaterItem In rptList.Items
                chkBox = CType(item.FindControl("CheckOn"), CheckBox)
                chkBox.Checked = False
            Next
        End If
    End Sub

    Protected Sub lnkBtnDel_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles lnkBtnDel.Click
        Dim chkBox As System.Web.UI.WebControls.CheckBox
        Dim IDs() As Integer = Nothing
        For Each item As RepeaterItem In rptList.Items
            chkBox = CType(item.FindControl("CheckOn"), CheckBox)
            If chkBox.Checked Then
                If Not IsNothing(IDs) Then
                    ReDim Preserve IDs(UBound(IDs) + 1)
                Else
                    ReDim IDs(0)
                End If
                IDs(UBound(IDs)) = CType(chkBox.ToolTip, Integer)
            End If
        Next
        If Not IsNothing(IDs) Then
            Dim mclsGoods As New DB_YC_Goods.clsYc_Goods
            If mclsGoods.Delete(IDs) Then
                ShowMessage(Me, "提示", "删除成功！", "")
            Else
                ShowMessage(Me, "提示", "删除失败！", "")
            End If
        End If
    End Sub

    Protected Sub ListPaging_Submit(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListPaging.Submit
        GetList()
    End Sub
End Class
