﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Install.aspx.cs" Inherits="Amr.SuperSiteGroup.Web.Install" %>

<%@ Register Assembly="System.Web.Extensions, Version=1.0.61025.0, Culture=neutral, PublicKeyToken=31bf3856ad364e35"
    Namespace="System.Web.UI" TagPrefix="asp" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title> <%=siteNameAlias %>安装向导</title>
    <link href="Management/style/install.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="/management/js/jquery.min.js"></script>
    <script type="text/javascript">
        function install(step) {
            switch (step) {
                case 1:;
                    $("#installStatus").append("<table><tr><td width='20' id='operation" + step + "'><img src='management/images/loading.gif'></td><td>初始化数据库</td></tr></table>");
                    break;
                case 2:
                    $("#installStatus").append("<table><tr><td width='20' id='operation" + step + "'><img src='management/images/loading.gif'></td><td>建立表结构</td></tr></table>");
                    break;
                case 3:
                    $("#installStatus").append("<table><tr><td width='20' id='operation" + step + "'><img src='management/images/loading.gif'></td><td>建立存储过程</td></tr></table>");
                    break;
                case 4:
                    $("#installStatus").append("<table><tr><td width='20' id='operation" + step + "'><img src='management/images/loading.gif'></td><td>初始化站点数据</td></tr></table>");
                    break;
                case 5:
                    $("#installStatus").append("<table><tr><td width='20' id='operation" + step + "'><img src='management/images/loading.gif'></td><td>添加其他数据</td></tr></table>");
                    break;
                case 6:
                    $("#installStatus").append("<table><tr><td width='20' id='operation" + step + "'><img src='management/images/loading.gif'></td><td>修改配置文件</td></tr></table>");
                    break;
                case 7:
                    $("#installStatus").append("<table><tr><td width='20' id='operation" + step + "'><img src='management/images/loading.gif'></td><td>清理安装文件</td></tr></table>");
                    break;
            }

            $.ajax({
                type: "GET",
                url: "Install.aspx?installStep=" + step,
                success: function (content) {
                    if (content == "true") {
                        $("#operation" + step).html("<img src='management/images/ico_ok.gif'>");
                        install(step + 1);
                    }
                    else if (content == "over") {
                        $("#operation" + step).html("<img src='management/images/ico_ok.gif'>");
                        $("#stepMenu").html("<ul class=\"step\"><li class=\"succed\">许可协议</li><li class=\"succed\">环境检测</li><li class=\"succed\">参数配置</li><li class=\"succed\">正在安装</li><li class=\"select\">安装完成</li></ul>");
                        $("#success").show();
                        $("#installBack").hide();
                    }
                    else {
                        $("#operation" + step).html("<img src='management/images/ico_del.gif'>");
                        $("#failed").show();
                        $("#errorInfo").html(content);
                    }
                }
            });
        }
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <div id="header">
        <div id="logo">
            <img src="Management/images/logo.png" /></div>
        <div class="link">
            <a href="http://www.amr-lab.net" target="_blank">官方网站</a> | <a href="http://www.amr-lab.net"
                target="_blank">技术论坛</a></div>
        <div class="vision">
             <%=siteNameAlias %>V<%=version %> 版本 20131028</div>
    </div>
    <div id="contain">
        <div id="left">
            <div class="title">
                安装步骤</div>
            <div id="stepMenu"><%=stepMenu %></div>
        </div>
        <div id="right">
            <asp:Panel ID="panelAgreement" Visible="false" runat="server">
                <div class="r_title">
                    阅读许可协议</div>
                <div class="pr-agreement">
                    <p>
                        版权所有 (c) 2009-<%=System.DateTime.Now.Year %>， <%=companyName %> amr-lab.net 保留所有权利。</p>
                    <p>
                    </p>
                    <p>
                        感谢您选择 <%=siteNameAlias %>。希望我们的努力能为您提供一个快速提升流量的解决方案。</p>
                    <p>
                    </p>
                    <p>
                        产品中文全称为<%=siteName %>，以下简称  <%=siteNameAlias %>。</p>
                    <p>
                    </p>
                    <p>
                        本授权协议适用且仅适用于<%=siteNameAlias %>V<%=version %>版本， <%=companyName %>拥有对本授权协议的最终解释权。</p>
                    <p>
                    </p>
                    <p>
                        <b>I 协议许可的权利</b></p>
                    <p>
                        1. 您可以在完全遵守本最终用户授权协议的基础上，将本软件之免费版应用于非商业用途，而不必支付软件版权授权费用。</p>
                    <p>
                        2. 您可以在协议规定的约束和限制范围内修改  <%=siteNameAlias %> 源代码(如果被提供的话)或界面风格以适应您的网站要求。</p>
                    <p style="color: Red">
                        3. 此软件仅限采集没有版权限制的站点，并在法律适用范围内使用，如因版权等问题产生的一切法律问题均由使用者自行承担。</p>
                    <p>
                        4. 获得商业授权之后，您可以将本软件应用于商业用途，同时依据所购买的授权类型中确定的技术支持期限、技术支持方式和技术支持内容，自购买时刻起，在技术支持期限内拥有通过指定的方式获得指定范围内的技术支持服务。商业授权用户享有反映和提出意见的权力，相关意见将被作为首要考虑，但没有一定被采纳的承诺或保证。</p>
                    <p>
                    </p>
                    <p>
                        <b>II 协议规定的约束和限制</b></p>
                    <p>
                        1. 未获商业授权之前，不得将本软件用于商业用途（包括但不限于企业网站、经营性网站、以营利为目或实现盈利的网站）。购买商业授权请登陆http://www.amr-lab.net/
                        参考相关说明。</p>
                    <p>
                        2. 不得对本软件或与之关联的商业授权进行出租、出售、抵押或发放子许可证。</p>
                    <p>
                        3. 无论如何，即无论用途如何、是否经过修改或美化、修改程度如何，只要使用  <%=siteNameAlias %> 的整体或任何部分，未经书面许可，论坛底部的  <%=siteNameAlias %> 名称和链接都必须保留，而不能清除或修改。</p>
                    <p>
                        4. 禁止对<%=siteNameAlias %>程序进行反编译，反汇编，进行授权破解等，禁止在  <%=siteNameAlias %> 的整体或任何部分基础上以发展任何派生版本、修改版本或第三方版本用于重新分发。</p>
                    <p>
                        5. 如果您未能遵守本协议的条款，您的授权将被终止，所被许可的权利将被无偿收回，并承担相应法律责任。</p>
                    <p>
                    </p>
                    <p>
                        <b>III 有限担保和免责声明</b></p>
                    <p>
                        1. 本软件及所附带的文件是作为不提供任何明确的或隐含的赔偿或担保的形式提供的。</p>
                    <p>
                        2. 用户出于自愿而使用本软件，您必须了解使用本软件的风险，在尚未购买产品技术服务之前，我们不承诺提供任何形式的技术支持、使用担保，也不承担任何因使用本软件而产生问题的相关责任。</p>
                    <p>
                        3. <%=companyName %>官方不对使用本软件构建的站点的文章或信息承担任何责任。</p>
                    <p>
                    </p>
                    <p>
                        有关  <%=siteNameAlias %> 最终用户授权协议、商业授权与技术服务的详细内容，均由<%=companyName %>官方网站独家提供。官方拥有在不事先通知的情况下，修改授权协议和服务价目表的权力，修改后的协议或价目表对自改变之日起的新授权用户生效。</p>
                    <p>
                    </p>
                    <p>
                        电子文本形式的授权协议如同双方书面签署的协议一样，具有完全的和等同的法律效力。您一旦开始安装  <%=siteNameAlias %>，即被视为完全理解并接受本协议的各项条款，在享有上述条款授予的权力的同时，受到相关的约束和限制。协议许可范围以外的行为，将直接违反本授权协议并构成侵权，我们有权随时终止授权，责令停止损害，并保留追究相关责任的权力。</p>
                    <p>
                    </p>
                    <p>
                    </p>
                    <p>
                         <%=companyName %> www.amr-lab.net
                    </p>
                    <p>
                        <b>协议发布时间：</b> 2012年12月21日</p>
                    <p>
                        <b>版本最新更新：</b>
                    </p>
                </div>
                <div class="btn-box">
                    <input name="readpact" type="checkbox" id="readpact" value="" /><label for="readpact"><strong
                        class="readpact">我已经阅读并同意此协议</strong></label>
                    <input type="button" class="btn-next" onclick="document.getElementById('readpact').checked ?window.location.href='Install.aspx?step=2' : alert('您必须同意软件许可协议才能安装！');" />
                </div>
            </asp:Panel>
            <asp:Panel ID="panelCheckInstall" Visible="false" runat="server">
                <div class="r_title">
                    服务器信息</div>
                <table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <th width="300" align="center">
                            <strong>参数</strong>
                        </th>
                        <th width="424">
                            <strong>值</strong>
                        </th>
                    </tr>
                    <tr align="center">
                        <td>
                            <strong>服务器名</strong>
                        </td>
                        <td><%=Request.ServerVariables["SERVER_NAME"] %>
                        </td>
                    </tr>
                    <tr align="center">
                        <td>
                            <strong>服务器操作系统</strong>
                        </td>
                        <td>
                        <%=System.Environment.OSVersion.ToString()%>
                        </td>
                    </tr>
                    <tr align="center">
                        <td>
                            <strong>系统安装目录</strong>
                        </td>
                        <td><%=Request.ServerVariables["APPL_PHYSICAL_PATH"]%>
                        </td>
                    </tr>
                </table>
                <div class="r_title">
                    系统环境检测</div>
                <div style="padding: 2px 8px 0px; line-height: 33px; height: 23px; overflow: hidden; float:left;
                    color: #666;">
                    系统环境要求必须满足下列所有条件，否则系统或系统部份功能将无法使用。
                </div>
                <table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <th width="446" align="center">
                            <strong>需开启的变量或函数</strong>
                        </th>
                        <th width="80">
                            <div align="center">
                                <strong>要求</strong></div>
                        </th>
                        <th width="200">
                            <strong>实际状态及建议</strong>
                        </th>
                    </tr>
                    <tr>
                        <td>
                            采集功能
                        </td>
                        <td align="center">
                            <div align="center">
                                <img src="Management/images/ico_ok.gif" width="16" height="16" /></div>
                        </td>
                        <td>
                            <div align="center">
                            <%=CheckInternet() %>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            自定义403.14、404、414错误页为/Unaccessible.aspx</td>
                        <td align="center">
                            <div align="center">
                                <img src="Management/images/ico_ok.gif" width="16" height="16" />
                            </div>
                        </td>
                        <td>
                            <div align="center">
                                IIS7用户无需设置；IIS5，6用户必须设置为指定错误页，否则系统无法使用
                            </div>
                        </td>
                    </tr>
                </table>
                <div class="r_title">
                    目录权限检测</div>
                <div style="padding: 2px 8px 0px; line-height: 33px; height: 23px; overflow: hidden; float:left;
                    color: #666;">
                    系统要求必须满足下列所有的目录权限全部可读写的需求才能使用，如果不满足安装后程序将无法正常使用。
                </div>
                <table width="706" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <th width="446" align="center">
                            <strong>目录名</strong>
                        </th>
                        <th width="130">
                            <div align="center">
                                <strong>读取权限</strong></div>
                        </th>
                        <th width="130">
                            <div align="center">
                                <strong>写入权限</strong></div>
                        </th>
                    </tr>
                    <tr>
                        <td><%=Request.ServerVariables["APPL_PHYSICAL_PATH"]%>
                        </td>
                        <td align="center"> <img src="Management/images/<%=CheckReadPermission() %>" width="16" height="16" />
                        </td>
                        <td align="center"> <img src="Management/images/<%=CheckWritePermission() %>" width="16" height="16" />
                        </td>
                    </tr>
                </table>
                <div class="btn-box">
                    <input type="button" class="btn-pre" onclick="window.location.href='install.aspx?step=1'" />
                    <input type="button" class="btn-next" onclick="window.location.href='install.aspx?step=3'" />
                </div>
            </asp:Panel>
            <asp:Panel ID="panelSetDB" Visible="false" runat="server" HorizontalAlign="Left">
                <div class="r_title">
                    数据库设定</div>
                <table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <td class="onetd" colspan="2" align="center">
                            <asp:Label ID="Label1" runat="server" ForeColor="Green">请注意，请先创建好目标数据库，否则将无法继续，因为大多数数据库用户是没有建库权限的，第一次安装请选择全新安装，否则会出错</asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd" colspan="2" align="center">
                            <asp:Label ID="laDBInfo" runat="server" ForeColor="Red"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>数据库主机：</strong>
                        </td>
                        <td>
                            <asp:TextBox ID="ServerNameBox" runat="server" CssClass="input-txt" 
                                ValidationGroup="DBinfo">(local)</asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" 
                                ControlToValidate="ServerNameBox" ErrorMessage="*" ValidationGroup="DBinfo"></asp:RequiredFieldValidator>
                            <small>本地数据库一般为(local)</small>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>数据库名：</strong>
                        </td>
                        <td>
                            <asp:TextBox ID="dbnameBox" runat="server" CssClass="input-txt" ValidationGroup="DBinfo"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ErrorMessage="*"
                                ControlToValidate="dbnameBox" ValidationGroup="DBinfo"></asp:RequiredFieldValidator><small>
                                    填写您要存放的数据库名称</small>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>数据库用户名：</strong>
                        </td>
                        <td>
                            <asp:TextBox ID="useridBox" runat="server" CssClass="input-txt" ValidationGroup="DBinfo"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server" ErrorMessage="*"
                                ControlToValidate="useridBox" ValidationGroup="DBinfo"></asp:RequiredFieldValidator><small>
                                    您的数据库用户名，不要全数字</small>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>数据库用户密码：</strong>
                        </td>
                        <td>
                            <asp:TextBox ID="pwdBox" runat="server" CssClass="input-txt" ValidationGroup="DBinfo"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server" ErrorMessage="*"
                                ControlToValidate="pwdBox" ValidationGroup="DBinfo"></asp:RequiredFieldValidator>
                            <small>您的数据库登陆密码</small>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                             <strong>数据库类型:</strong></td>
                        <td>   
                            <asp:DropDownList ID="ddlServerType" runat="server">
                                <asp:ListItem>Sql Server 2005及以上版本</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>安装方式：</strong>
                        </td>
                        <td>
                            <div>
                                <asp:RadioButtonList ID="installStyle" runat="server" 
                                    RepeatDirection="Horizontal">
                                    <asp:ListItem Selected="True" Value="0">全新安装（将建立新的数据表和存储过程，同名对象会被删除）</asp:ListItem>
                                    <asp:ListItem Value="1">加入站群（基于原有数据库）</asp:ListItem>
                                </asp:RadioButtonList>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            &nbsp;
                        </td>
                        <td>
                            <asp:Button ID="TestDB" runat="server" OnClick="TestDB_Click" Text="测试连接" ValidationGroup="DBinfo" />
                        </td>
                    </tr>
                </table>
                <div class="r_title">
                    站点基本配置</div>
                <table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <td class="onetd">
                            <asp:RadioButton ID="rbSetupSingle" runat="server" GroupName="SetupType" 
                                Text="安装单个站点" Checked="true" AutoPostBack="True" 
                                oncheckedchanged="rbSetupSingle_CheckedChanged" />
                            &nbsp;<asp:RadioButton ID="rbSetupMultiple" runat="server" GroupName="SetupType" 
                                Text="批量安装站点" AutoPostBack="True" 
                                oncheckedchanged="rbSetupMultiple_CheckedChanged" />
                        </td>
                    </tr>
                </table>
                <asp:Panel runat="server" ID="panSingleSite">
                                <table id="singleSite" width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <td class="onetd">
                            <strong>网站名称：</strong>
                        </td>
                        <td height="36">
                            <asp:TextBox ID="siteNameBox" runat="server" ValidationGroup="siteinfo"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="*"
                                ControlToValidate="siteNameBox" ValidationGroup="siteinfo"></asp:RequiredFieldValidator>
                            &nbsp;<span class="gray">(将会提交至官方最新网站区) </span>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>授权站点（本站）信息：</strong>
                        </td>
                        <td height="36">
                            协议<asp:DropDownList ID="selfProtoco" runat="server">
                                <asp:ListItem Value="0">http</asp:ListItem>
                                <asp:ListItem Value="1">https</asp:ListItem>
                            </asp:DropDownList>
                            子域名<asp:TextBox ID="selfChildDomain" runat="server" ValidationGroup="siteinfo" 
                                Width="60px"></asp:TextBox>
                            根域名<asp:TextBox ID="selfRootDomain" runat="server" ValidationGroup="siteinfo"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator7" runat="server" ErrorMessage="*"
                                ControlToValidate="selfRootDomain" ValidationGroup="siteinfo"></asp:RequiredFieldValidator>
                            端口<asp:TextBox ID="selfSitePort" runat="server" ValidationGroup="siteinfo" 
                                Width="42px">80</asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator10" runat="server" ErrorMessage="*"
                                ControlToValidate="selfSitePort" ValidationGroup="siteinfo"></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidator2" Type="Integer" runat="server" ErrorMessage="必须为数字" ValidationGroup="siteinfo" ControlToValidate="selfSitePort" MaximumValue="65535" MinimumValue="0"></asp:RangeValidator>
                            <br /><span class="gray">例：http://www.example.com:8080,协议为http，子域名为www,根域名为example.com,端口号8080(http协议默认为80，https默认为443，请正确填写，否则网站将无法正常工作。信息将会提交至官方最新网站区) </span>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>采集目标站信息：</strong>
                        </td>
                        <td height="36">
                            协议<asp:DropDownList ID="targetProtoco" runat="server">
                                <asp:ListItem Value="0">http</asp:ListItem>
                                <asp:ListItem Value="1">https</asp:ListItem>
                            </asp:DropDownList>
                            子域名<asp:TextBox ID="targetChildDomain" runat="server" ValidationGroup="siteinfo" 
                                Width="60px"></asp:TextBox>
                            根域名<asp:TextBox ID="targetRootDomain" runat="server" ValidationGroup="siteinfo"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ErrorMessage="*"
                                ControlToValidate="targetRootDomain" ValidationGroup="siteinfo"></asp:RequiredFieldValidator>
                            端口<asp:TextBox ID="targetPort" runat="server" ValidationGroup="siteinfo" 
                                Width="42px">80</asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidator11" runat="server" ErrorMessage="*"
                                ControlToValidate="targetPort" ValidationGroup="siteinfo"></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidator1" Type="Integer" runat="server" ErrorMessage="必须为数字" ValidationGroup="siteinfo" ControlToValidate="targetPort" MaximumValue="65535" MinimumValue="0"></asp:RangeValidator>
                            <br /><span class="gray">与本站信息一样，请正确填写，否则网站将无法正常工作 </span>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>站点编码：</strong>
                        </td>
                        <td height="36">
                            <asp:TextBox ID="siteEncoding" runat="server" Text="utf-8"></asp:TextBox>
                            <span class="red">(站点编码信息，请正确填写以增加采集精确度。)</span>
                        </td>
                    </tr>
                                    <tr>
                                        <td class="onetd">
                                            <strong>站长Email：</strong>
                                        </td>
                                        <td height="36">
                                            <asp:TextBox ID="siteEmailBox" runat="server" ValidationGroup="siteinfo"></asp:TextBox>
                                            <span class="red">(供官方统计用，为了更好的为您服务，建议填写。)</span>
                                        </td>
                                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>站长QQ：</strong>
                        </td>
                        <td height="36">
                            <asp:TextBox ID="siteQQBox" runat="server" ValidationGroup="siteinfo"></asp:TextBox>
                            <span class="red">(供官方统计用，为了更好的为您服务，建议填写。)</span>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong> <%=siteNameAlias %>论坛用户名：</strong>
                        </td>
                        <td height="36">
                            <asp:TextBox ID="userBBSid" runat="server" ValidationGroup="siteinfo"></asp:TextBox>
                            <span class="red">(没有论坛用户名的请到：<a href="http://www.amr-lab.net/">AMR实验室</a>注册)</span>
                        </td>
                    </tr>
                </table>
                </asp:Panel>
                <asp:Panel runat="server" ID="panMultipleSite" Visible="false">
                    <table id="multipleSite" width="726" border="0" align="center" cellpadding="0" cellspacing="0"
                        class="twbox">
                        <tr>
                            <td class="onetd" align="center">
                                <strong>请到网站根目录找到SiteSetup.csv, 在里面填写好将要初始化的多个站点，不合法的数据将被忽略</strong>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>

                <div class="r_title">
                    管理员初始密码</div>
                <div style="padding: 2px 8px 0px; line-height: 33px; height: 23px; overflow: hidden; float:left;
                    color: #666;">
                    请设定管理员初始密码,,如果是站群安装，已经有同名的管理员，将不会做覆盖操作，原有管理员的密码不变。
                </div>
                <table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <td class="onetd">
                            <strong>管理员账号：</strong>
                        </td>
                        <td>
                            <asp:TextBox ID="AdminUser" runat="server" ValidationGroup="siteinfo">admin</asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator8" runat="server" ErrorMessage="*"
                                ControlToValidate="AdminUser" ValidationGroup="siteinfo"></asp:RequiredFieldValidator>
                            &nbsp;<p>
                                <small>只能用'0-9'、'a-z'、'A-Z'、'.'、'@'、'_'、'-'、'!'以内范围的字符</small></p>
                        </td>
                    </tr>
                    <tr>
                        <td class="onetd">
                            <strong>密 码：</strong>
                        </td>
                        <td>
                            <asp:TextBox ID="AdminPass" runat="server" TextMode="Password" 
                                ValidationGroup="siteinfo"></asp:TextBox>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidator9" runat="server" ErrorMessage="*"
                                ControlToValidate="AdminUser" ValidationGroup="siteinfo"></asp:RequiredFieldValidator>
                            &nbsp;<p>
                                <small>请尽量设置一个8位以上复杂密码</small></p>
                        </td>
                    </tr>
                </table>
                <div class="btn-box">
                    <asp:ImageButton ID="ibNext" runat="server" CssClass="btn-next" 
                        ValidationGroup="siteinfo" onclick="ibNext_Click" ImageUrl="~/Management/images/btn_next.jpg"  onmousedown="if(confirm('请再次确认安装模式是否正确，全新安装将删除所有现有数据!')){this.click();}else{return false;}" />
                    <asp:Label ID="laStep3ErrorInfo" runat="server" ForeColor="Red"></asp:Label>
                </div>
            </asp:Panel>
            <asp:UpdatePanel ID="upProcess" Visible="false" runat="server">
                <ContentTemplate>
                    <div class="r_title">
                        正在安装模块</div>
                    <div class="pr-agreement">
                        <p id="installStatus">安装进度<br /></p>
                    </div>
                    <asp:Literal ID="liInstallScript" runat="server"></asp:Literal>
                    <p id="success" style="margin: 35px 0;display:none">
                                <span style="font-size: 14px; line-height: 33px; padding-right: 6px;">
                                恭喜你！安装完成，请检查install文件是否被删除，否则请手动删除此文件。</span><br />
                                <br />
                                <a href="Management/Login.aspx" class="readpact" style="float: none; font-weight: bold; color: #06c">
                                    点击进入管理后台</a></p>
                     <p id="failed" style="margin: 35px 0;display:none">
                     安装失败<br />
                                <span id="errorInfo" style="font-size: 14px; line-height: 33px; padding-right: 6px; color:Red">
                                     </span><br />
                                <br />
                                <a href="javascript:history.go(-1)" class="readpact" style="float: none; font-weight: bold; color: #06c">
                                    点此重试</a></p>
                    <div class="btn-box">
                        <input type="button" id="installBack" onclick="javascript:history.go(-1)" class="btn-pre" onclick="window.location.href='install.aspx?step=3'" />
                    </div>
                </ContentTemplate>
            </asp:UpdatePanel>
            <asp:Panel ID="panelSuccess" Visible="false" runat="server">
                <div class="r_title">
                    安装成功</div>
                <table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <td align="center" height="200">
                            <p style="margin: 35px 0">
                                <span style="font-size: 14px; line-height: 33px; padding-right: 6px;">
                                恭喜你！ <%=siteNameAlias %>已经安装完成，请检查install文件是否被删除，否则请手动删除此文件。</span><br />
                                <br />
                                <a href="Management/" class="readpact" style="float: none; font-weight: bold; color: #06c">
                                    点击进入管理后台</a></p>
                        </td>
                    </tr>
                </table>
            </asp:Panel>
            <asp:Panel ID="panelFailure" Visible="false" runat="server">
                <div class="r_title">
                    安装错误！</div>
                <table width="726" border="0" align="center" cellpadding="0" cellspacing="0" class="twbox">
                    <tr>
                        <td align="center" height="200">
                            <p style="margin: 35px 0">
                                <span style="font-size: 14px; line-height: 33px; padding-right: 6px;">
                                    <%=failureInfo %></span><br />
                                <br />
                                <a href="Install.aspx" class="readpact" style="float: none; font-weight: bold; color: #06c">
                                    点此重试</a></p>
                        </td>
                    </tr>
                </table>
            </asp:Panel>
        </div>
    </div>
    <div id="footer">
        Powered by  <a href="http://www.amr-lab.net" target="_blank">www.amr-lab.net</a>  <%=siteNameAlias %>V<%=version %></div>
    </form>
</body>
</html>
