﻿
------------------------------------
--初始化数据库
------------------------------------

IF not EXISTS (SELECT name FROM sys.databases WHERE name = N'{0}')
CREATE DATABASE [{0}]

!!!!!!

------------------------------------
--建立表
------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserSite]') AND type in (N'U'))
DROP TABLE [dbo].[UserSite]
GO

CREATE TABLE [dbo].[UserSite](
	[UserId] [int] NOT NULL,
	[SiteId] [int] NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_UserSite_CreatedOn]  DEFAULT (getdate()),
 CONSTRAINT [PK_UserSite] PRIMARY KEY CLUSTERED 
(
	[UserId] ASC,
	[SiteId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SiteUser]') AND type in (N'U'))
DROP TABLE [dbo].[SiteUser]
GO

CREATE TABLE [dbo].[SiteUser](
	[UserId] [int] IDENTITY(1,1) NOT NULL,
	[UserName] [nvarchar](50) NOT NULL,
	[Password] [nchar](32) NOT NULL,
	[Name] [nvarchar](20) NULL,
	[Email] [nvarchar](120) NULL,
	[MobilePhone] [nvarchar](20) NULL,
	[UserType] [int] NOT NULL CONSTRAINT [DF_User_UserType]  DEFAULT ((0)),
	[LastLoginIP] [nvarchar](60) NULL,
	[LastLoginOn] [datetime] NULL,
	[IsActive] [bit] NOT NULL CONSTRAINT [DF_User_IsActiv]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_User_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_User] PRIMARY KEY CLUSTERED 
(
	[UserId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]

GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CacheServer]') AND type in (N'U'))
DROP TABLE [dbo].[CacheServer]
GO

CREATE TABLE [dbo].[CacheServer](
	[ServerId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[ServerName] [nvarchar](300) NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_CacheServer_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_CacheServer_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_CacheServer] PRIMARY KEY CLUSTERED 
(
	[ServerId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Proxy]') AND type in (N'U'))
DROP TABLE [dbo].[Proxy]
GO

CREATE TABLE [dbo].[Proxy](
	[ProxyId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Address] [nvarchar](2000) NOT NULL,
	[Domain] [nvarchar](400) NULL,
	[UserName] [nvarchar](100) NULL,
	[Password] [nvarchar](100) NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_Proxy_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Proxy_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Proxy] PRIMARY KEY CLUSTERED 
(
	[ProxyId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ReplaceRule]') AND type in (N'U'))
DROP TABLE [dbo].[ReplaceRule]
GO

CREATE TABLE [dbo].[ReplaceRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NULL,
	[OldValue] [nvarchar](max) NULL,
	[NewValue] [nvarchar](max) NULL,
	[CaseSensitive] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_CaseSensitive]  DEFAULT ((1)),
	[IsRegex] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_IsRegex]  DEFAULT ((0)),
	[RuleType] [int] NOT NULL CONSTRAINT [DF_ReplaceRule_RuleType]  DEFAULT ((0)),
	[Priority] [int] NULL CONSTRAINT [DF_ReplaceRule_Priority]  DEFAULT ((1)),
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](1000) NULL,
	[ExactMatch] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_ExactMatch]  DEFAULT ((0)),
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_IsDefault]  DEFAULT ((0)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_ReplaceRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_ReplaceRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ReplaceRole] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitlePrefix]') AND type in (N'U'))
DROP TABLE [dbo].[TitlePrefix]
GO

CREATE TABLE [dbo].[TitlePrefix](
	[TitleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Value] [nvarchar](60) NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitlePrefix_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitlePrefix] PRIMARY KEY CLUSTERED 
(
	[TitleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeleteRule]') AND type in (N'U'))
DROP TABLE [dbo].[DeleteRule]
GO

CREATE TABLE [dbo].[DeleteRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[StartWord] [nvarchar](200) NOT NULL,
	[EndWord] [nvarchar](200) NOT NULL,
	[IncludeStartWord] [bit] NOT NULL CONSTRAINT [DF_DeleteRule_IncludeStartWord]  DEFAULT ((0)),
	[IncludeEndWord] [bit] NOT NULL,
	[CaseSensitive] [bit] NOT NULL CONSTRAINT [DF_DeleteRule_CaseSensitive]  DEFAULT ((0)),
	[DeleteType] [int] NOT NULL,
	[RuleType] [int] NOT NULL CONSTRAINT [DF_DeleteRule_RuleType]  DEFAULT ((0)),
	[Priority] [int] NULL CONSTRAINT [DF_DeleteRule_Priority]  DEFAULT ((1)),
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](1000) NULL,
	[ExactMatch] [bit] NOT NULL CONSTRAINT [DF_DeleteRule_ExactMatch]  DEFAULT ((0)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_DeleteRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_DeleteRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_DeleteRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NodeRule]') AND type in (N'U'))
DROP TABLE [dbo].[NodeRule]
GO

CREATE TABLE [dbo].[NodeRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[Expression] [nvarchar](2000) NOT NULL,
	[AttributeName] [nvarchar](200) NULL,
	[OperationValue] [nvarchar](max) NULL,
	[OperationIndex] [int] NOT NULL CONSTRAINT [DF_NodeRule_OperationIndex]  DEFAULT ((0)),
	[OperationType] [int] NOT NULL,
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](2000) NULL,
	[ExactMatch] [bit] NOT NULL CONSTRAINT [DF_NodeRule_ExactMatch]  DEFAULT ((0)),
	[Priority] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_NodeRule_IsEnable]  DEFAULT ((1)),
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_NodeRule_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_NodeRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_NodeRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OriginalVocabulary]') AND type in (N'U'))
DROP TABLE [dbo].[OriginalVocabulary]
GO

CREATE TABLE [dbo].[OriginalVocabulary](
	[VocabularyId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Vocabulary] [nvarchar](100) NOT NULL,
	[Synonyms] [nvarchar](100) NOT NULL,
	[CaseSensitive] [bit] NOT NULL CONSTRAINT [DF_OriginalVocabulary_CaseSensitive]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_OriginalVocabulary_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_OriginalVocabulary] PRIMARY KEY CLUSTERED 
(
	[VocabularyId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleExpression]') AND type in (N'U'))
DROP TABLE [dbo].[TitleExpression]
GO

CREATE TABLE [dbo].[TitleExpression](
	[ExpressionId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Value] [nvarchar](60) NOT NULL,
	[Priority] [int] NULL CONSTRAINT [DF_TitleExpression_Priority]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_TitleExpression_IsEnable]  DEFAULT ((1)),
 CONSTRAINT [PK_TitleExpression] PRIMARY KEY CLUSTERED 
(
	[ExpressionId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SiteSetting]') AND type in (N'U'))
DROP TABLE [dbo].[SiteSetting]
GO

CREATE TABLE [dbo].[SiteSetting](
	[SettingId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[IsActive] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_IsActive]  DEFAULT ((0)),
	[HeadCode] [nvarchar](max) NULL,
	[BodyCode] [nvarchar](max) NULL,
	[CacheExpireTime] [int] NULL,
	[Charset] [nvarchar](20) NULL,
	[ForbiddenFileType] [nvarchar](255) NULL,
	[CollectImage] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_CollectImage]  DEFAULT ((1)),
	[FakeOriginalTitle] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_FakeOriginal]  DEFAULT ((0)),
	[FakeOriginalContent] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_FakeOriginalContent]  DEFAULT ((0)),
	[StaticExtension] [nvarchar](20) NOT NULL CONSTRAINT [DF_SiteSetting_StaticExtension]  DEFAULT (N'html'),
	[EnableBillboard] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_EnableBillboard]  DEFAULT ((0)),
	[CustomInternalLinkKeyword] [nvarchar](255) NULL,
	[InternalSearchTemplate] [nvarchar](50) NOT NULL CONSTRAINT [DF_SiteSetting_InternalSearchTemplate]  DEFAULT (N'Search.htm'),
	[SupportPandomain] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_SupportPandomain]  DEFAULT ((0)),
	[UseProxy] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_UseProxy]  DEFAULT ((0)),
	[SynchronizeIECookie] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_SynchronizeIECookie]  DEFAULT ((0)),
	[CookieString] [nvarchar](4000) NULL,
	[EnableErrorLog] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_EnableErrorLog]  DEFAULT ((0)),
	[EnableStatisticalCode] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_EnableStatisticalCode]  DEFAULT ((1)),
	[ConvertToRedirectLink] [bit] NOT NULL CONSTRAINT [DF_SiteSetting_ConvertToRedirectLink]  DEFAULT ((0)),
	[WorkMode] [int] NOT NULL CONSTRAINT [DF_SiteSetting_WorkMode]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_SiteSetting_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_SiteSetting] PRIMARY KEY CLUSTERED 
(
	[SettingId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Billboard]') AND type in (N'U'))
DROP TABLE [dbo].[Billboard]
GO

CREATE TABLE [dbo].[Billboard](
	[BillboardId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL CONSTRAINT [DF_Billboard_SiteId]  DEFAULT ((1)),
	[Name] [nvarchar](60) NOT NULL,
	[Url] [nvarchar](1000) NOT NULL,
	[DataType] [int] NOT NULL CONSTRAINT [DF_Billboard_DataType]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_Billboard_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Billboard_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Billboard] PRIMARY KEY CLUSTERED 
(
	[BillboardId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Site]') AND type in (N'U'))
DROP TABLE [dbo].[Site]
GO

CREATE TABLE [dbo].[Site](
	[SiteId] [int] IDENTITY(1,1) NOT NULL,
	[SiteName] [nvarchar](120) NOT NULL,
	[SiteProtoco] [nvarchar](50) NOT NULL,
	[SitePort] [int] NOT NULL,
	[SiteChildDomain] [nvarchar](60) NOT NULL,
	[SiteRootDomain] [nvarchar](60) NOT NULL,
	[Keyword] [nvarchar](120) NULL,
	[Description] [nvarchar](255) NULL,
	[ICPNumber] [nvarchar](60) NULL,
	[TargetSiteProtoco] [nvarchar](50) NOT NULL,
	[TargetSitePort] [int] NOT NULL,
	[TargetSiteChildDomain] [nvarchar](60) NOT NULL,
	[TargetSiteRootDomain] [nvarchar](60) NOT NULL,
	[Email] [nvarchar](120) NULL,
	[QQ] [nvarchar](60) NULL,
	[ForumUserName] [nvarchar](60) NULL,
	[CNZZCredentials] [nvarchar](200) NULL,
	[SiteStatus] [bit] NOT NULL CONSTRAINT [DF_Site_SiteStatus]  DEFAULT ((1)),
	[AuthorizedCode] [nvarchar](4000) NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Site_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Site] PRIMARY KEY CLUSTERED 
(
	[SiteId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BillboardExtractionRule]') AND type in (N'U'))
DROP TABLE [dbo].[BillboardExtractionRule]
GO

CREATE TABLE [dbo].[BillboardExtractionRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[BillboardId] [int] NOT NULL,
	[RuleName] [nvarchar](60) NOT NULL,
	[ExtractionRule] [nvarchar](255) NOT NULL,
	[KeywordCount] [int] NOT NULL CONSTRAINT [DF_BillboardExtractionRule_KeywordCount]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_BillboardExtractionRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_BillboardExtractionRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NotUpdatePage]') AND type in (N'U'))
DROP TABLE [dbo].[NotUpdatePage]
GO

CREATE TABLE [dbo].[NotUpdatePage](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[FilePath] [nvarchar](200) NOT NULL,
	[IsActive] [bit] NOT NULL CONSTRAINT [DF_NotUpdatePage_IsActive]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_NotUpdatePage_CreatedOn]  DEFAULT (getdate()),
 CONSTRAINT [PK_NotUpdatePage] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[InternalSiteSearch]') AND type in (N'U'))
DROP TABLE [dbo].[InternalSiteSearch]
GO

CREATE TABLE [dbo].[InternalSiteSearch](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[Url] [nvarchar](1000) NOT NULL,
	[ContentExpression] [nvarchar](2000) NOT NULL,
	[ChildExpression] [nvarchar](2000) NOT NULL,
	[Encoding] [nvarchar](50) NULL,
	[NoResultText] [nvarchar](60) NULL,
	[ContentTemplate] [nvarchar](2000) NULL,
	[ContentOutTemplate] [nvarchar](2000) NULL,
	[RelatedKeywordExpression] [nvarchar](2000) NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_InternalSiteSearch_IsActive]  DEFAULT ((1)),
	[IsDefault] [bit] NOT NULL,
	[Priority] [int] NOT NULL CONSTRAINT [DF_InternalSiteSearch_Priority]  DEFAULT ((10)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_InternalSiteSearch_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_InternalSiteSearch] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, IGNORE_DUP_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UrlEncodingRule]') AND type in (N'U'))
DROP TABLE [dbo].[UrlEncodingRule]
GO

CREATE TABLE [dbo].[UrlEncodingRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[TagName] [nvarchar](40) NOT NULL,
	[AttributeName] [nvarchar](200) NULL,
	[DefaultFileType] [nvarchar](40) NULL,
	[Priority] [int] NULL CONSTRAINT [DF_UrlEncodingRule_Priority]  DEFAULT ((1)),
	[KeepOriginalFileType] [bit] NOT NULL CONSTRAINT [DF_UrlEncodingRule_KeepOriginalFileType]  DEFAULT ((0)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_UrlEncodingRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_UrlEncodingRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_UrlEncodingRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NonStaticUrl]') AND type in (N'U'))
DROP TABLE [dbo].[NonStaticUrl]
GO

CREATE TABLE [dbo].[NonStaticUrl](
	[UrlId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](200) NOT NULL,
	[Url] [nvarchar](4000) NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_NonStaticUrl_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_NonStaticUrl_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_NonStaticUrl] PRIMARY KEY CLUSTERED 
(
	[UrlId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MultiSite]') AND type in (N'U'))
DROP TABLE [dbo].[MultiSite]
GO

CREATE TABLE [dbo].[MultiSite](
	[MultiSiteId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[SiteName] [nvarchar](200) NOT NULL,
	[RootDomain] [nvarchar](200) NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_MultiSite_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_MultiSite_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_MultiSite] PRIMARY KEY CLUSTERED 
(
	[MultiSiteId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DomainSetting]') AND type in (N'U'))
DROP TABLE [dbo].[DomainSetting]
GO

CREATE TABLE [dbo].[DomainSetting](
	[DomainId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[DomainName] [nvarchar](200) NULL,
	[Domain] [nvarchar](200) NOT NULL,
	[Charset] [nvarchar](20) NULL CONSTRAINT [DF_Table_1_Priority]  DEFAULT ((1)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_Domain_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_Domain_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Domain] PRIMARY KEY CLUSTERED 
(
	[DomainId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ContentExtractionRule]') AND type in (N'U'))
DROP TABLE [dbo].[ContentExtractionRule]
GO

CREATE TABLE [dbo].[ContentExtractionRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](20) NOT NULL,
	[Url] [nvarchar](1000) NOT NULL,
	[ContentExpression] [nvarchar](2000) NOT NULL,
	[ChildExpression] [nvarchar](2000) NOT NULL,
	[Encoding] [nvarchar](50) NULL,
	[NoResultText] [nvarchar](60) NULL,
	[ContentTemplate] [nvarchar](2000) NULL,
	[ContentOutTemplate] [nvarchar](2000) NULL,
	[IsConvertToLocalUrl] [bit] NOT NULL,
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_ContentExtractionRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_ContentExtractionRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ContentExtractionRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleOriginalRule]') AND type in (N'U'))
DROP TABLE [dbo].[TitleOriginalRule]
GO

CREATE TABLE [dbo].[TitleOriginalRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](60) NOT NULL,
	[RuleType] [int] NOT NULL,
	[Delimiter] [nvarchar](60) NULL,
	[Count] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](2000) NULL,
	[ExactMatch] [bit] NOT NULL,
	[Priority] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[IsDefault] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleOriginalRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleOriginal]') AND type in (N'U'))
DROP TABLE [dbo].[TitleOriginal]
GO

CREATE TABLE [dbo].[TitleOriginal](
	[OriginalId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[Vocabulary] [nvarchar](1000) NOT NULL,
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_TitleOriginal_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitleOriginal_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleOriginal] PRIMARY KEY CLUSTERED 
(
	[OriginalId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TitleCategory]') AND type in (N'U'))
DROP TABLE [dbo].[TitleCategory]
GO

CREATE TABLE [dbo].[TitleCategory](
	[CategoryId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryName] [nvarchar](100) NOT NULL,
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_TitleCategory_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitleCategory_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleCategory] PRIMARY KEY CLUSTERED 
(
	[CategoryId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PageTitle]') AND type in (N'U'))
DROP TABLE [dbo].[PageTitle]
GO

CREATE TABLE [dbo].[PageTitle](
	[PageId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[PageIdentity] [nvarchar](36) NOT NULL,
	[Title] [nvarchar](2000) NOT NULL,
	[OldTitle] [nvarchar](2000) NOT NULL,
	[TitleMainPart] [nvarchar](2000) NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_PageTitle_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_PageTitle] PRIMARY KEY CLUSTERED 
(
	[PageId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TranslateRule]') AND type in (N'U'))
DROP TABLE [dbo].[TranslateRule]
GO

CREATE TABLE [dbo].[TranslateRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[TranslateUrl] [nvarchar](4000) NOT NULL,
	[RawUrlExtractExpression] [nvarchar](4000) NULL,
	[RedirectExpression] [nvarchar](4000) NULL,
	[OperationExpression] [nvarchar](4000) NULL,
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](2000) NULL,
	[ExactMatch] [bit] NOT NULL,
	[Priority] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[IsDefault] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TranslateRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RedirectRule]') AND type in (N'U'))
DROP TABLE [dbo].[RedirectRule]
GO

CREATE TABLE [dbo].[RedirectRule](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[RuleName] [nvarchar](60) NOT NULL,
	[RuleExpression] [nvarchar](1000) NOT NULL,
	[RedirectUrl] [nvarchar](2000) NOT NULL,
	[Priority] [int] NOT NULL,
	[ExactMatch] [bit] NOT NULL CONSTRAINT [DF_RedirectRule_ExactMatch]  DEFAULT ((0)),
	[IsRegex] [bit] NOT NULL CONSTRAINT [DF_RedirectRule_IsRegex]  DEFAULT ((0)),
	[IsEnable] [bit] NOT NULL CONSTRAINT [DF_RedirectRule_IsEnable]  DEFAULT ((1)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_RedirectRule_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_RedirectRule] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ArticleTemplate]') AND type in (N'U'))
DROP TABLE [dbo].[ArticleTemplate]
GO

CREATE TABLE [dbo].[ArticleTemplate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[TemplateType] [int] NOT NULL,
	[Template] [text] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ArticleTemplate] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ArticleContent]') AND type in (N'U'))
DROP TABLE [dbo].[ArticleContent]
GO

CREATE TABLE [dbo].[ArticleContent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ArticleId] [int] NOT NULL,
	[SubTitle] [nvarchar](1000) NULL,
	[Page] [int] NULL,
	[OrderValue] [int] NOT NULL,
	[ContentValue] [text] NOT NULL,
	[UserId] [int] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ArticleContent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ArticleCategory]') AND type in (N'U'))
DROP TABLE [dbo].[ArticleCategory]
GO

CREATE TABLE [dbo].[ArticleCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[ParentId] [int] NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ArticleCategory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Article]') AND type in (N'U'))
DROP TABLE [dbo].[Article]
GO

CREATE TABLE [dbo].[Article](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[CategoryName] [nvarchar](100) NOT NULL,
	[Model] [int] NOT NULL,
	[Author] [nvarchar](100) NULL,
	[Source] [nvarchar](200) NULL,
	[SourceUrl] [nvarchar](2000) NULL,
	[Title] [nvarchar](1000) NOT NULL,
	[ShortTitle] [nvarchar](100) NULL,
	[Tag] [nvarchar](200) NULL,
	[Thumbnails] [nvarchar](2000) NULL,
	[HasThumbnails] [bit] NOT NULL,
	[Hits] [int] NULL,
	[OrderValue] [bigint] NOT NULL,
	[Comments] [int] NULL,
	[Description] [nvarchar](1000) NULL,
	[UserName] [nvarchar](100) NOT NULL,
	[UserId] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Article] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StaticType]') AND type in (N'U'))
DROP TABLE [dbo].[StaticType]
GO

CREATE TABLE [dbo].[StaticType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](60) NOT NULL,
	[TypeIdentity] [nvarchar](200) NOT NULL,
	[IdentityType] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_StaticType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (0,N'960*90',N'//script[text()[contains(.,''width = 960'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''960*90'')]]|//script[text()[contains(.,''width=960'') and contains(.,''height=90'')]]|//iframe[@width="960" and @height="90"]|//script[text()[contains(.,''960*90'')]]|//script[text()[contains(.,''960×90'')]]',N'<!-- 广告位：960×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636906";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 12:59:30',N'2013/4/11 13:25:38')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (0,N'960*60',N'//script[text()[contains(.,''width = 960'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''960*60'')]]|//script[text()[contains(.,''width=960'') and contains(.,''height=60'')]]|//iframe[@width="960" and @height="60"]|//script[text()[contains(.,''960*60'')]]|//script[text()[contains(.,''960×60'')]]',N'<!-- 广告位：960×60 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636907";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:23:42',N'2013/4/11 13:27:42')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'950*90',N'//script[text()[contains(.,''width = 950'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''950*90'')]]|//script[text()[contains(.,''width=950'') and contains(.,''height=90'')]]|//iframe[@width="950" and @height="90"]|//script[text()[contains(.,''950*90'')]]|//script[text()[contains(.,''950×90'')]]',N'<!-- 广告位：950×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636908";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:29:09')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'760*90',N'//script[text()[contains(.,''width = 760'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''760*90'')]]|//script[text()[contains(.,''width=760'') and contains(.,''height=90'')]]|//iframe[@width="760" and @height="90"]|//script[text()[contains(.,''760*90'')]]|//script[text()[contains(.,''760×90'')]]',N'<!-- 广告位：760×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636909";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:29:58')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'728*90',N'//script[text()[contains(.,''width = 728'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''728*90'')]]|//script[text()[contains(.,''width=728'') and contains(.,''height=90'')]]|//iframe[@width="728" and @height="90"]|//script[text()[contains(.,''728*90'')]]|//script[text()[contains(.,''728×90'')]]',N'<!-- 广告位：728×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636910";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:30:35')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'728*15',N'//script[text()[contains(.,''width = 728'') and contains(.,''height = 15'')]]|//script[text()[contains(.,''728*15'')]]|//script[text()[contains(.,''width=728'') and contains(.,''height=15'')]]|//iframe[@width="728" and @height="15"]|//script[text()[contains(.,''728*15'')]]|//script[text()[contains(.,''728×15'')]]',N'<!-- 广告位：728×15 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636911";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:31:10')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'640*60',N'//script[text()[contains(.,''width = 640'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''640*60'')]]|//script[text()[contains(.,''width=640'') and contains(.,''height=60'')]]|//iframe[@width="640" and @height="60"]|//script[text()[contains(.,''640*60'')]]|//script[text()[contains(.,''640×60'')]]',N'<!-- 广告位：640×60 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636912";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:31:54')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'580*90',N'//script[text()[contains(.,''width = 580'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''580*90'')]]|//script[text()[contains(.,''width=580'') and contains(.,''height=90'')]]|//iframe[@width="580" and @height="90"]|//script[text()[contains(.,''580*90'')]]|//script[text()[contains(.,''580×90'')]]',N'<!-- 广告位：580×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636913";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:33:20')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'500*200',N'//script[text()[contains(.,''width = 500'') and contains(.,''height = 200'')]]|//script[text()[contains(.,''500*200'')]]|//script[text()[contains(.,''width=500'') and contains(.,''height=200'')]]|//iframe[@width="500" and @height="200"]|//script[text()[contains(.,''500*200'')]]|//script[text()[contains(.,''500×200'')]]',N'<!-- 广告位：500×200 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636914";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:33:55')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'480*160',N'//script[text()[contains(.,''width = 480'') and contains(.,''height = 160'')]]|//script[text()[contains(.,''480*160'')]]|//script[text()[contains(.,''width=480'') and contains(.,''height=160'')]]|//iframe[@width="480" and @height="160"]|//script[text()[contains(.,''480*160'')]]|//script[text()[contains(.,''480×160'')]]',N'<!-- 广告位：480×160 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636915";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:34:34')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'468*60',N'//script[text()[contains(.,''width = 468'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''468*60'')]]|//script[text()[contains(.,''width=468'') and contains(.,''height=60'')]]|//iframe[@width="468" and @height="60"]|//script[text()[contains(.,''468*60'')]]|//script[text()[contains(.,''468×60'')]]',N'<!-- 广告位：468×60 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636916";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:35:12')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'468*15',N'//script[text()[contains(.,''width = 468'') and contains(.,''height = 15'')]]|//script[text()[contains(.,''468*15'')]]|//script[text()[contains(.,''width=468'') and contains(.,''height=15'')]]|//iframe[@width="468" and @height="15"]|//script[text()[contains(.,''468*15'')]]|//script[text()[contains(.,''468×15'')]]',N'<!-- 广告位：468×15 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636917";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:35:51')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'460*60',N'//script[text()[contains(.,''width = 460'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''460*60'')]]|//script[text()[contains(.,''width=460'') and contains(.,''height=60'')]]|//iframe[@width="460" and @height="60"]|//script[text()[contains(.,''460*60'')]]|//script[text()[contains(.,''460×60'')]]',N'<!-- 广告位：460×60 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636918";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:36:30')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'360*300',N'//script[text()[contains(.,''width = 360'') and contains(.,''height = 300'')]]|//script[text()[contains(.,''360*300'')]]|//script[text()[contains(.,''width=360'') and contains(.,''height=300'')]]|//iframe[@width="360" and @height="300"]|//script[text()[contains(.,''360*300'')]]|//script[text()[contains(.,''360×300'')]]',N'<!-- 广告位：360×300 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636919";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:37:31')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'336*280',N'//script[text()[contains(.,''width = 336'') and contains(.,''height = 280'')]]|//script[text()[contains(.,''336*280'')]]|//script[text()[contains(.,''width=336'') and contains(.,''height=280'')]]|//iframe[@width="336" and @height="280"]|//script[text()[contains(.,''336*280'')]]|//script[text()[contains(.,''336×280'')]]',N'<!-- 广告位：336×280 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636920";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:38:07')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'320*50',N'//script[text()[contains(.,''width = 320'') and contains(.,''height = 50'')]]|//script[text()[contains(.,''320*50'')]]|//script[text()[contains(.,''width=320'') and contains(.,''height=50'')]]|//iframe[@width="320" and @height="50"]|//script[text()[contains(.,''320*50'')]]|//script[text()[contains(.,''320×50'')]]',N'<!-- 广告位：320×50 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636921";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:38:37')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'300*600',N'//script[text()[contains(.,''width = 300'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''300*600'')]]|//script[text()[contains(.,''width=300'') and contains(.,''height=600'')]]|//iframe[@width="300" and @height="600"]|//script[text()[contains(.,''300*600'')]]|//script[text()[contains(.,''300×600'')]]',N'<!-- 广告位：300×600 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636922";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:39:26')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'300*250',N'//script[text()[contains(.,''width = 300'') and contains(.,''height = 250'')]]|//script[text()[contains(.,''300*250'')]]|//script[text()[contains(.,''width=300'') and contains(.,''height=250'')]]|//iframe[@width="300" and @height="250"]|//script[text()[contains(.,''300*250'')]]|//script[text()[contains(.,''300×250'')]]',N'<!-- 广告位：300×250 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636923";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:40:01')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'250*250',N'//script[text()[contains(.,''width = 250'') and contains(.,''height = 250'')]]|//script[text()[contains(.,''250*250'')]]|//script[text()[contains(.,''width=250'') and contains(.,''height=250'')]]|//iframe[@width="250" and @height="250"]|//script[text()[contains(.,''250*250'')]]|//script[text()[contains(.,''250×250'')]]',N'<!-- 广告位：250×250 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636924";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:40:26')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'234*60',N'//script[text()[contains(.,''width = 234'') and contains(.,''height = 60'')]]|//script[text()[contains(.,''234*60'')]]|//script[text()[contains(.,''width=234'') and contains(.,''height=60'')]]|//iframe[@width="234" and @height="60"]|//script[text()[contains(.,''234*60'')]]|//script[text()[contains(.,''234×60'')]]',N'<!-- 广告位：234×60 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636925";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:40:57')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'200*200',N'//script[text()[contains(.,''width = 200'') and contains(.,''height = 200'')]]|//script[text()[contains(.,''200*200'')]]|//script[text()[contains(.,''width=200'') and contains(.,''height=200'')]]|//iframe[@width="200" and @height="200"]|//script[text()[contains(.,''200*200'')]]|//script[text()[contains(.,''200×200'')]]',N'<!-- 广告位：200×200 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636926";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:41:27')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'200*90',N'//script[text()[contains(.,''width = 200'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''200*90'')]]|//script[text()[contains(.,''width=200'') and contains(.,''height=90'')]]|//iframe[@width="200" and @height="90"]|//script[text()[contains(.,''200*90'')]]|//script[text()[contains(.,''200×90'')]]',N'<!-- 广告位：200×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636927";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:41:55')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'180*150',N'//script[text()[contains(.,''width = 180'') and contains(.,''height = 150'')]]|//script[text()[contains(.,''180*150'')]]|//script[text()[contains(.,''width=180'') and contains(.,''height=150'')]]|//iframe[@width="180" and @height="150"]|//script[text()[contains(.,''180*150'')]]|//script[text()[contains(.,''180×150'')]]',N'<!-- 广告位：180×150 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636928";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:42:28')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'180*90',N'//script[text()[contains(.,''width = 180'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''180*90'')]]|//script[text()[contains(.,''width=180'') and contains(.,''height=90'')]]|//iframe[@width="180" and @height="90"]|//script[text()[contains(.,''180*90'')]]|//script[text()[contains(.,''180×90'')]]',N'<!-- 广告位：180×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636929";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:42:55')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'160*600',N'//script[text()[contains(.,''width = 160'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''160*600'')]]|//script[text()[contains(.,''width=160'') and contains(.,''height=600'')]]|//iframe[@width="160" and @height="600"]|//script[text()[contains(.,''160*600'')]]|//script[text()[contains(.,''160×600'')]]',N'<!-- 广告位：160×600 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636930";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:43:34')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'160*90',N'//script[text()[contains(.,''width = 160'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''160*90'')]]|//script[text()[contains(.,''width=160'') and contains(.,''height=90'')]]|//iframe[@width="160" and @height="90"]|//script[text()[contains(.,''160*90'')]]|//script[text()[contains(.,''160×90'')]]',N'<!-- 广告位：160×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636931";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:44:03')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'125*125',N'//script[text()[contains(.,''width = 125'') and contains(.,''height = 125'')]]|//script[text()[contains(.,''125*125'')]]|//script[text()[contains(.,''width=125'') and contains(.,''height=125'')]]|//iframe[@width="125" and @height="125"]|//script[text()[contains(.,''125*125'')]]|//script[text()[contains(.,''125×125'')]]',N'<!-- 广告位：125×125 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636932";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:44:37')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'120*600',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 600'')]]|//script[text()[contains(.,''120*600'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=600'')]]|//iframe[@width="120" and @height="600"]|//script[text()[contains(.,''120*600'')]]|//script[text()[contains(.,''120×600'')]]',N'<!-- 广告位：120×600 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636933";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:45:03')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'120*240',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 240'')]]|//script[text()[contains(.,''120*240'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=240'')]]|//iframe[@width="120" and @height="240"]|//script[text()[contains(.,''120*240'')]]|//script[text()[contains(.,''120×240'')]]',N'<!-- 广告位：120×240 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636934";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:45:29')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn]) VALUES (0,N'120*90',N'//script[text()[contains(.,''width = 120'') and contains(.,''height = 90'')]]|//script[text()[contains(.,''120*90'')]]|//script[text()[contains(.,''width=120'') and contains(.,''height=90'')]]|//iframe[@width="120" and @height="90"]|//script[text()[contains(.,''120*90'')]]|//script[text()[contains(.,''120×90'')]]',N'<!-- 广告位：120×90 -->
<script type="text/javascript" >BAIDU_CLB_SLOT_ID = "636935";</script>
<script type="text/javascript" src="http://cbjs.baidu.com/js/o.js"></script>',0,9,0,0,10,1,1,N'2013/4/11 13:45:59')
INSERT [NodeRule] ([SiteId],[Name],[Expression],[OperationIndex],[OperationType],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (0,N'统计代码',N'//script[text()[contains(.,''hm.baidu.com'')]]|//script[text()[contains(.,''cnzz.com'')]]|//script[contains(@src,''cnzz.com'')]|//script[text()[contains(.,''51.la'')]]|//script[contains(@src,''51.la'')]|//a[contains(@href,''51.la'')]|//img[contains(@src,''51.la'')]|//script[text()[contains(.,''google-analytics.com'')]]|//script[contains(@src,''google-analytics.com'')]|//script[text()[contains(.,''jiathis'')]]|//script[contains(@src,''jiathis'')]|//script[contains(@src,''ujian'')]',0,0,0,0,10,1,1,N'2013/6/26 12:16:01',N'2013/7/11 16:57:25')
GO

!!!!!!

------------------------------------
--建立存储过程
------------------------------------

/******************************************************************
* 表名：Billboard
* 时间：2012/12/20 20:56:46
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([BillboardId])+1 FROM [Billboard]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_Exists
@BillboardId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [Billboard] WHERE BillboardId=@BillboardId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_ADD
@BillboardId int output,
@SiteId int,
@Name nvarchar(60),
@Url nvarchar(1000),
@DataType int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [Billboard](
	[SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@DataType,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @BillboardId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_Update
@BillboardId int,
@SiteId int,
@Name nvarchar(60),
@Url nvarchar(1000),
@DataType int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [Billboard] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[DataType] = @DataType,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE BillboardId=@BillboardId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_Delete
@BillboardId int
 AS 
	DELETE [Billboard]
	 WHERE BillboardId=@BillboardId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_GetModel
@BillboardId int
 AS 
	SELECT 
	BillboardId,SiteId,Name,Url,DataType,IsEnable,CreatedOn,UpdatedOn
	 FROM [Billboard]
	 WHERE BillboardId=@BillboardId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Billboard_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Billboard_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:46
------------------------------------
CREATE PROCEDURE Billboard_GetList
 AS 
	SELECT 
	BillboardId,SiteId,Name,Url,DataType,IsEnable,CreatedOn,UpdatedOn
	 FROM [Billboard]

GO


/******************************************************************
* 表名：BillboardExtractionRule
* 时间：2012/12/20 20:56:48
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [BillboardExtractionRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [BillboardExtractionRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_ADD
@RuleId int output,
@BillboardId int,
@RuleName nvarchar(60),
@ExtractionRule nvarchar(255),
@KeywordCount int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [BillboardExtractionRule](
	[BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@BillboardId,@RuleName,@ExtractionRule,@KeywordCount,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_Update
@RuleId int,
@BillboardId int,
@RuleName nvarchar(60),
@ExtractionRule nvarchar(255),
@KeywordCount int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [BillboardExtractionRule] SET 
	[BillboardId] = @BillboardId,[RuleName] = @RuleName,[ExtractionRule] = @ExtractionRule,[KeywordCount] = @KeywordCount,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_Delete
@RuleId int
 AS 
	DELETE [BillboardExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,BillboardId,RuleName,ExtractionRule,KeywordCount,IsEnable,CreatedOn,UpdatedOn
	 FROM [BillboardExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[BillboardExtractionRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[BillboardExtractionRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:48
------------------------------------
CREATE PROCEDURE BillboardExtractionRule_GetList
 AS 
	SELECT 
	RuleId,BillboardId,RuleName,ExtractionRule,KeywordCount,IsEnable,CreatedOn,UpdatedOn
	 FROM [BillboardExtractionRule]

GO


/******************************************************************
* 表名：CacheServer
* 时间：2012/12/20 20:56:49
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([ServerId])+1 FROM [CacheServer]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_Exists
@ServerId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [CacheServer] WHERE ServerId=@ServerId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_ADD
@ServerId int output,
@SiteId int,
@ServerName nvarchar(300),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [CacheServer](
	[SiteId],[ServerName],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@ServerName,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @ServerId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_Update
@ServerId int,
@SiteId int,
@ServerName nvarchar(300),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [CacheServer] SET 
	[SiteId] = @SiteId,[ServerName] = @ServerName,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE ServerId=@ServerId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_Delete
@ServerId int
 AS 
	DELETE [CacheServer]
	 WHERE ServerId=@ServerId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_GetModel
@ServerId int
 AS 
	SELECT 
	ServerId,SiteId,ServerName,IsEnable,CreatedOn,UpdatedOn
	 FROM [CacheServer]
	 WHERE ServerId=@ServerId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[CacheServer_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[CacheServer_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:49
------------------------------------
CREATE PROCEDURE CacheServer_GetList
 AS 
	SELECT 
	ServerId,SiteId,ServerName,IsEnable,CreatedOn,UpdatedOn
	 FROM [CacheServer]

GO


/******************************************************************
* 表名：DeleteRule
* 时间：2012/12/20 20:56:50
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [DeleteRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [DeleteRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(20),
@StartWord nvarchar(200),
@EndWord nvarchar(200),
@IncludeStartWord bit,
@IncludeEndWord bit,
@CaseSensitive bit,
@DeleteType int,
@RuleType int,
@Priority int,
@MatchUrl bit,
@Url nvarchar(1000),
@ExactMatch bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [DeleteRule](
	[SiteId],[Name],[StartWord],[EndWord],[IncludeStartWord],[IncludeEndWord],[CaseSensitive],[DeleteType],[RuleType],[Priority],[MatchUrl],[Url],[ExactMatch],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@StartWord,@EndWord,@IncludeStartWord,@IncludeEndWord,@CaseSensitive,@DeleteType,@RuleType,@Priority,@MatchUrl,@Url,@ExactMatch,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(20),
@StartWord nvarchar(200),
@EndWord nvarchar(200),
@IncludeStartWord bit,
@IncludeEndWord bit,
@CaseSensitive bit,
@DeleteType int,
@RuleType int,
@Priority int,
@MatchUrl bit,
@Url nvarchar(1000),
@ExactMatch bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [DeleteRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[StartWord] = @StartWord,[EndWord] = @EndWord,[IncludeStartWord] = @IncludeStartWord,[IncludeEndWord] = @IncludeEndWord,[CaseSensitive] = @CaseSensitive,[DeleteType] = @DeleteType,[RuleType] = @RuleType,[Priority] = @Priority,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_Delete
@RuleId int
 AS 
	DELETE [DeleteRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,StartWord,EndWord,IncludeStartWord,IncludeEndWord,CaseSensitive,DeleteType,RuleType,Priority,MatchUrl,Url,ExactMatch,IsEnable,CreatedOn,UpdatedOn
	 FROM [DeleteRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[DeleteRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[DeleteRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:50
------------------------------------
CREATE PROCEDURE DeleteRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,StartWord,EndWord,IncludeStartWord,IncludeEndWord,CaseSensitive,DeleteType,RuleType,Priority,MatchUrl,Url,ExactMatch,IsEnable,CreatedOn,UpdatedOn
	 FROM [DeleteRule]

GO


/******************************************************************
* 表名：InternalSiteSearch
* 时间：2012/12/30 19:24:03
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [InternalSiteSearch]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [InternalSiteSearch] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_ADD
@Id int output,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@RelatedKeywordExpression nvarchar(2000),
@IsEnable bit,
@IsDefault bit,
@Priority int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [InternalSiteSearch](
	[SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[NoResultText],[ContentTemplate],[ContentOutTemplate],[RelatedKeywordExpression],[IsEnable],[IsDefault],[Priority],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@ContentExpression,@ChildExpression,@Encoding,@NoResultText,@ContentTemplate,@ContentOutTemplate,@RelatedKeywordExpression,@IsEnable,@IsDefault,@Priority,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_Update
@Id int,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@RelatedKeywordExpression nvarchar(2000),
@IsEnable bit,
@IsDefault bit,
@Priority int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [InternalSiteSearch] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[ContentExpression] = @ContentExpression,[ChildExpression] = @ChildExpression,[Encoding] = @Encoding,[NoResultText] = @NoResultText,[ContentTemplate] = @ContentTemplate,[ContentOutTemplate] = @ContentOutTemplate,[RelatedKeywordExpression] = @RelatedKeywordExpression,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[Priority] = @Priority,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_Delete
@Id int
 AS 
	DELETE [InternalSiteSearch]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,RelatedKeywordExpression,IsEnable,IsDefault,Priority,CreatedOn,UpdatedOn
	 FROM [InternalSiteSearch]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[InternalSiteSearch_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [InternalSiteSearch_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/30 19:24:03
------------------------------------
CREATE PROCEDURE InternalSiteSearch_GetList
 AS 
	SELECT 
	Id,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,RelatedKeywordExpression,IsEnable,IsDefault,Priority,CreatedOn,UpdatedOn
	 FROM [InternalSiteSearch]

GO


/******************************************************************
* 表名：NodeRule
* 时间：2012/12/20 20:56:53
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [NodeRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [NodeRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(100),
@Expression nvarchar(2000),
@AttributeName nvarchar(200),
@OperationValue nvarchar(MAX),
@OperationIndex int,
@OperationType int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [NodeRule](
	[SiteId],[Name],[Expression],[AttributeName],[OperationValue],[OperationIndex],[OperationType],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Expression,@AttributeName,@OperationValue,@OperationIndex,@OperationType,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(100),
@Expression nvarchar(2000),
@AttributeName nvarchar(200),
@OperationValue nvarchar(MAX),
@OperationIndex int,
@OperationType int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [NodeRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Expression] = @Expression,[AttributeName] = @AttributeName,[OperationValue] = @OperationValue,[OperationIndex] = @OperationIndex,[OperationType] = @OperationType,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_Delete
@RuleId int
 AS 
	DELETE [NodeRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,Expression,AttributeName,OperationValue,OperationIndex,OperationType,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [NodeRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NodeRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NodeRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/11 21:34:44
------------------------------------
CREATE PROCEDURE NodeRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,Expression,AttributeName,OperationValue,OperationIndex,OperationType,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [NodeRule]

GO

/******************************************************************
* 表名：NotUpdatePage
* 时间：2012/12/20 20:56:54
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [NotUpdatePage]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [NotUpdatePage] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_ADD
@Id int output,
@SiteId int,
@FilePath nvarchar(200),
@IsActive bit,
@CreatedOn datetime

 AS 
	INSERT INTO [NotUpdatePage](
	[SiteId],[FilePath],[IsActive],[CreatedOn]
	)VALUES(
	@SiteId,@FilePath,@IsActive,@CreatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_Update
@Id int,
@SiteId int,
@FilePath nvarchar(200),
@IsActive bit,
@CreatedOn datetime
 AS 
	UPDATE [NotUpdatePage] SET 
	[SiteId] = @SiteId,[FilePath] = @FilePath,[IsActive] = @IsActive,[CreatedOn] = @CreatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_Delete
@Id int
 AS 
	DELETE [NotUpdatePage]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,FilePath,IsActive,CreatedOn
	 FROM [NotUpdatePage]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[NotUpdatePage_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[NotUpdatePage_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:54
------------------------------------
CREATE PROCEDURE NotUpdatePage_GetList
 AS 
	SELECT 
	Id,SiteId,FilePath,IsActive,CreatedOn
	 FROM [NotUpdatePage]

GO


/******************************************************************
* 表名：OriginalVocabulary
* 时间：2012/12/20 20:56:56
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([VocabularyId])+1 FROM [OriginalVocabulary]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_Exists
@VocabularyId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [OriginalVocabulary] WHERE VocabularyId=@VocabularyId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_ADD
@VocabularyId int output,
@SiteId int,
@Vocabulary nvarchar(1000),
@Synonyms nvarchar(100),
@CaseSensitive bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [OriginalVocabulary](
	[SiteId],[Vocabulary],[Synonyms],[CaseSensitive],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Vocabulary,@Synonyms,@CaseSensitive,@CreatedOn,@UpdatedOn
	)
	SET @VocabularyId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_Update
@VocabularyId int,
@SiteId int,
@Vocabulary nvarchar(1000),
@Synonyms nvarchar(100),
@CaseSensitive bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [OriginalVocabulary] SET 
	[SiteId] = @SiteId,[Vocabulary] = @Vocabulary,[Synonyms] = @Synonyms,[CaseSensitive] = @CaseSensitive,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE VocabularyId=@VocabularyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_Delete
@VocabularyId int
 AS 
	DELETE [OriginalVocabulary]
	 WHERE VocabularyId=@VocabularyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_GetModel
@VocabularyId int
 AS 
	SELECT 
	VocabularyId,SiteId,Vocabulary,Synonyms,CaseSensitive,CreatedOn,UpdatedOn
	 FROM [OriginalVocabulary]
	 WHERE VocabularyId=@VocabularyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_GetList
 AS 
	SELECT 
	VocabularyId,SiteId,Vocabulary,Synonyms,CaseSensitive,CreatedOn,UpdatedOn
	 FROM [OriginalVocabulary]

GO


/******************************************************************
* 表名：Proxy
* 时间：2012/12/20 20:56:57
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([ProxyId])+1 FROM [Proxy]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_Exists
@ProxyId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [Proxy] WHERE ProxyId=@ProxyId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_ADD
@ProxyId int output,
@SiteId int,
@Address nvarchar(2000),
@Domain nvarchar(400),
@UserName nvarchar(100),
@Password nvarchar(100),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [Proxy](
	[SiteId],[Address],[Domain],[UserName],[Password],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Address,@Domain,@UserName,@Password,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @ProxyId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_Update
@ProxyId int,
@SiteId int,
@Address nvarchar(2000),
@Domain nvarchar(400),
@UserName nvarchar(100),
@Password nvarchar(100),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [Proxy] SET 
	[SiteId] = @SiteId,[Address] = @Address,[Domain] = @Domain,[UserName] = @UserName,[Password] = @Password,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE ProxyId=@ProxyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_Delete
@ProxyId int
 AS 
	DELETE [Proxy]
	 WHERE ProxyId=@ProxyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_GetModel
@ProxyId int
 AS 
	SELECT 
	ProxyId,SiteId,Address,Domain,UserName,Password,IsEnable,CreatedOn,UpdatedOn
	 FROM [Proxy]
	 WHERE ProxyId=@ProxyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[Proxy_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[Proxy_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:57
------------------------------------
CREATE PROCEDURE Proxy_GetList
 AS 
	SELECT 
	ProxyId,SiteId,Address,Domain,UserName,Password,IsEnable,CreatedOn,UpdatedOn
	 FROM [Proxy]

GO


/******************************************************************
* 表名：ReplaceRule
* 时间：2012/12/20 20:56:59
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [ReplaceRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ReplaceRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(20),
@OldValue nvarchar(MAX),
@NewValue nvarchar(MAX),
@CaseSensitive bit,
@IsRegex bit,
@RuleType int,
@Priority int,
@MatchUrl bit,
@Url nvarchar(1000),
@ExactMatch bit,
@IsDefault bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ReplaceRule](
	[SiteId],[Name],[OldValue],[NewValue],[CaseSensitive],[IsRegex],[RuleType],[Priority],[MatchUrl],[Url],[ExactMatch],[IsDefault],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@OldValue,@NewValue,@CaseSensitive,@IsRegex,@RuleType,@Priority,@MatchUrl,@Url,@ExactMatch,@IsDefault,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(20),
@OldValue nvarchar(MAX),
@NewValue nvarchar(MAX),
@CaseSensitive bit,
@IsRegex bit,
@RuleType int,
@Priority int,
@MatchUrl bit,
@Url nvarchar(1000),
@ExactMatch bit,
@IsDefault bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ReplaceRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[OldValue] = @OldValue,[NewValue] = @NewValue,[CaseSensitive] = @CaseSensitive,[IsRegex] = @IsRegex,[RuleType] = @RuleType,[Priority] = @Priority,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[IsDefault] = @IsDefault,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_Delete
@RuleId int
 AS 
	DELETE [ReplaceRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,OldValue,NewValue,CaseSensitive,IsRegex,RuleType,Priority,MatchUrl,Url,ExactMatch,IsDefault,IsEnable,CreatedOn,UpdatedOn
	 FROM [ReplaceRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[ReplaceRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[ReplaceRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:56:59
------------------------------------
CREATE PROCEDURE ReplaceRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,OldValue,NewValue,CaseSensitive,IsRegex,RuleType,Priority,MatchUrl,Url,ExactMatch,IsDefault,IsEnable,CreatedOn,UpdatedOn
	 FROM [ReplaceRule]

GO


/******************************************************************
* 表名：Site
* 时间：2012/12/30 19:20:12
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([SiteId])+1 FROM [Site]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_Exists
@SiteId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [Site] WHERE SiteId=@SiteId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_ADD
@SiteId int output,
@SiteName nvarchar(120),
@SiteProtoco nvarchar(50),
@SitePort int,
@SiteChildDomain nvarchar(60),
@SiteRootDomain nvarchar(60),
@Keyword nvarchar(120),
@Description nvarchar(255),
@ICPNumber nvarchar(60),
@TargetSiteProtoco nvarchar(50),
@TargetSitePort int,
@TargetSiteChildDomain nvarchar(60),
@TargetSiteRootDomain nvarchar(60),
@Email nvarchar(120),
@QQ nvarchar(60),
@ForumUserName nvarchar(60),
@CNZZCredentials nvarchar(200),
@SiteStatus bit,
@AuthorizedCode nvarchar(4000),
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [Site](
	[SiteName],[SiteProtoco],[SitePort],[SiteChildDomain],[SiteRootDomain],[Keyword],[Description],[ICPNumber],[TargetSiteProtoco],[TargetSitePort],[TargetSiteChildDomain],[TargetSiteRootDomain],[Email],[QQ],[ForumUserName],[CNZZCredentials],[SiteStatus],[AuthorizedCode],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteName,@SiteProtoco,@SitePort,@SiteChildDomain,@SiteRootDomain,@Keyword,@Description,@ICPNumber,@TargetSiteProtoco,@TargetSitePort,@TargetSiteChildDomain,@TargetSiteRootDomain,@Email,@QQ,@ForumUserName,@CNZZCredentials,@SiteStatus,@AuthorizedCode,@CreatedOn,@UpdatedOn
	)
	SET @SiteId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_Update
@SiteId int,
@SiteName nvarchar(120),
@SiteProtoco nvarchar(50),
@SitePort int,
@SiteChildDomain nvarchar(60),
@SiteRootDomain nvarchar(60),
@Keyword nvarchar(120),
@Description nvarchar(255),
@ICPNumber nvarchar(60),
@TargetSiteProtoco nvarchar(50),
@TargetSitePort int,
@TargetSiteChildDomain nvarchar(60),
@TargetSiteRootDomain nvarchar(60),
@Email nvarchar(120),
@QQ nvarchar(60),
@ForumUserName nvarchar(60),
@CNZZCredentials nvarchar(200),
@SiteStatus bit,
@AuthorizedCode nvarchar(4000),
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [Site] SET 
	[SiteName] = @SiteName,[SiteProtoco] = @SiteProtoco,[SitePort] = @SitePort,[SiteChildDomain] = @SiteChildDomain,[SiteRootDomain] = @SiteRootDomain,[Keyword] = @Keyword,[Description] = @Description,[ICPNumber] = @ICPNumber,[TargetSiteProtoco] = @TargetSiteProtoco,[TargetSitePort] = @TargetSitePort,[TargetSiteChildDomain] = @TargetSiteChildDomain,[TargetSiteRootDomain] = @TargetSiteRootDomain,[Email] = @Email,[QQ] = @QQ,[ForumUserName] = @ForumUserName,[CNZZCredentials] = @CNZZCredentials,[SiteStatus] = @SiteStatus,[AuthorizedCode] = @AuthorizedCode,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_Delete
@SiteId int
 AS 
	DELETE [Site]
	 WHERE SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_GetModel
@SiteId int
 AS 
	SELECT 
	SiteId,SiteName,SiteProtoco,SitePort,SiteChildDomain,SiteRootDomain,Keyword,Description,ICPNumber,TargetSiteProtoco,TargetSitePort,TargetSiteChildDomain,TargetSiteRootDomain,Email,QQ,ForumUserName,CNZZCredentials,SiteStatus,AuthorizedCode,CreatedOn,UpdatedOn
	 FROM [Site]
	 WHERE SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Site_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Site_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/30 19:20:12
------------------------------------
CREATE PROCEDURE Site_GetList
 AS 
	SELECT 
	SiteId,SiteName,SiteProtoco,SitePort,SiteChildDomain,SiteRootDomain,Keyword,Description,ICPNumber,TargetSiteProtoco,TargetSitePort,TargetSiteChildDomain,TargetSiteRootDomain,Email,QQ,ForumUserName,CNZZCredentials,SiteStatus,AuthorizedCode,CreatedOn,UpdatedOn
	 FROM [Site]

GO


/******************************************************************
* 表名：SiteSetting
* 时间：2012/12/30 19:22:31
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([SettingId])+1 FROM [SiteSetting]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Exists
@SettingId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [SiteSetting] WHERE SettingId=@SettingId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_ADD
@SettingId int output,
@SiteId int,
@Name nvarchar(20),
@IsActive bit,
@HeadCode nvarchar(MAX),
@BodyCode nvarchar(MAX),
@CacheExpireTime int,
@Charset nvarchar(20),
@ForbiddenFileType nvarchar(255),
@CollectImage bit,
@FakeOriginalTitle bit,
@FakeOriginalContent bit,
@StaticExtension nvarchar(20),
@EnableBillboard bit,
@CustomInternalLinkKeyword nvarchar(255),
@InternalSearchTemplate nvarchar(50),
@SupportPandomain bit,
@UseProxy bit,
@SynchronizeIECookie bit,
@CookieString nvarchar(4000),
@EnableErrorLog bit,
@EnableStatisticalCode bit,
@ConvertToRedirectLink bit,
@WorkMode int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [SiteSetting](
	[SiteId],[Name],[IsActive],[HeadCode],[BodyCode],[CacheExpireTime],[Charset],[ForbiddenFileType],[CollectImage],[FakeOriginalTitle],[FakeOriginalContent],[StaticExtension],[EnableBillboard],[CustomInternalLinkKeyword],[InternalSearchTemplate],[SupportPandomain],[UseProxy],[SynchronizeIECookie],[CookieString],[EnableErrorLog],[EnableStatisticalCode],[ConvertToRedirectLink],[WorkMode],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@IsActive,@HeadCode,@BodyCode,@CacheExpireTime,@Charset,@ForbiddenFileType,@CollectImage,@FakeOriginalTitle,@FakeOriginalContent,@StaticExtension,@EnableBillboard,@CustomInternalLinkKeyword,@InternalSearchTemplate,@SupportPandomain,@UseProxy,@SynchronizeIECookie,@CookieString,@EnableErrorLog,@EnableStatisticalCode,@ConvertToRedirectLink,@WorkMode,@CreatedOn,@UpdatedOn
	)
	SET @SettingId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Update
@SettingId int,
@SiteId int,
@Name nvarchar(20),
@IsActive bit,
@HeadCode nvarchar(MAX),
@BodyCode nvarchar(MAX),
@CacheExpireTime int,
@Charset nvarchar(20),
@ForbiddenFileType nvarchar(255),
@CollectImage bit,
@FakeOriginalTitle bit,
@FakeOriginalContent bit,
@StaticExtension nvarchar(20),
@EnableBillboard bit,
@CustomInternalLinkKeyword nvarchar(255),
@InternalSearchTemplate nvarchar(50),
@SupportPandomain bit,
@UseProxy bit,
@SynchronizeIECookie bit,
@CookieString nvarchar(4000),
@EnableErrorLog bit,
@EnableStatisticalCode bit,
@ConvertToRedirectLink bit,
@WorkMode int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [SiteSetting] SET 
	[SiteId] = @SiteId,[Name] = @Name,[IsActive] = @IsActive,[HeadCode] = @HeadCode,[BodyCode] = @BodyCode,[CacheExpireTime] = @CacheExpireTime,[Charset] = @Charset,[ForbiddenFileType] = @ForbiddenFileType,[CollectImage] = @CollectImage,[FakeOriginalTitle] = @FakeOriginalTitle,[FakeOriginalContent] = @FakeOriginalContent,[StaticExtension] = @StaticExtension,[EnableBillboard] = @EnableBillboard,[CustomInternalLinkKeyword] = @CustomInternalLinkKeyword,[InternalSearchTemplate] = @InternalSearchTemplate,[SupportPandomain] = @SupportPandomain,[UseProxy] = @UseProxy,[SynchronizeIECookie] = @SynchronizeIECookie,[CookieString] = @CookieString,[EnableErrorLog] = @EnableErrorLog,[EnableStatisticalCode] = @EnableStatisticalCode,[ConvertToRedirectLink] = @ConvertToRedirectLink,[WorkMode] = @WorkMode,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_Delete
@SettingId int
 AS 
	DELETE [SiteSetting]
	 WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetModel
@SettingId int
 AS 
	SELECT 
	SettingId,SiteId,Name,IsActive,HeadCode,BodyCode,CacheExpireTime,Charset,ForbiddenFileType,CollectImage,FakeOriginalTitle,FakeOriginalContent,StaticExtension,EnableBillboard,CustomInternalLinkKeyword,InternalSearchTemplate,SupportPandomain,UseProxy,SynchronizeIECookie,CookieString,EnableErrorLog,EnableStatisticalCode,ConvertToRedirectLink,WorkMode,CreatedOn,UpdatedOn
	 FROM [SiteSetting]
	 WHERE SettingId=@SettingId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[SiteSetting_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [SiteSetting_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/11 21:36:28
------------------------------------
CREATE PROCEDURE SiteSetting_GetList
 AS 
	SELECT 
	SettingId,SiteId,Name,IsActive,HeadCode,BodyCode,CacheExpireTime,Charset,ForbiddenFileType,CollectImage,FakeOriginalTitle,FakeOriginalContent,StaticExtension,EnableBillboard,CustomInternalLinkKeyword,InternalSearchTemplate,SupportPandomain,UseProxy,SynchronizeIECookie,CookieString,EnableErrorLog,EnableStatisticalCode,ConvertToRedirectLink,WorkMode,CreatedOn,UpdatedOn
	 FROM [SiteSetting]

GO

/******************************************************************
* 表名：SiteUser
* 时间：2012/12/20 20:57:03
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([UserId])+1 FROM [SiteUser]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_Exists
@UserId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [SiteUser] WHERE UserId=@UserId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_ADD
@UserId int output,
@UserName nvarchar(50),
@Password nchar(32),
@Name nvarchar(20),
@Email nvarchar(120),
@MobilePhone nvarchar(20),
@UserType int,
@LastLoginIP nvarchar(60),
@LastLoginOn datetime,
@IsActive bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [SiteUser](
	[UserName],[Password],[Name],[Email],[MobilePhone],[UserType],[LastLoginIP],[LastLoginOn],[IsActive],[CreatedOn],[UpdatedOn]
	)VALUES(
	@UserName,@Password,@Name,@Email,@MobilePhone,@UserType,@LastLoginIP,@LastLoginOn,@IsActive,@CreatedOn,@UpdatedOn
	)
	SET @UserId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_Update
@UserId int,
@UserName nvarchar(50),
@Password nchar(32),
@Name nvarchar(20),
@Email nvarchar(120),
@MobilePhone nvarchar(20),
@UserType int,
@LastLoginIP nvarchar(60),
@LastLoginOn datetime,
@IsActive bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [SiteUser] SET 
	[UserName] = @UserName,[Password] = @Password,[Name] = @Name,[Email] = @Email,[MobilePhone] = @MobilePhone,[UserType] = @UserType,[LastLoginIP] = @LastLoginIP,[LastLoginOn] = @LastLoginOn,[IsActive] = @IsActive,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE UserId=@UserId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_Delete
@UserId int
 AS 
	DELETE [SiteUser]
	 WHERE UserId=@UserId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_GetModel
@UserId int
 AS 
	SELECT 
	UserId,UserName,Password,Name,Email,MobilePhone,UserType,LastLoginIP,LastLoginOn,IsActive,CreatedOn,UpdatedOn
	 FROM [SiteUser]
	 WHERE UserId=@UserId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SiteUser_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SiteUser_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:03
------------------------------------
CREATE PROCEDURE SiteUser_GetList
 AS 
	SELECT 
	UserId,UserName,Password,Name,Email,MobilePhone,UserType,LastLoginIP,LastLoginOn,IsActive,CreatedOn,UpdatedOn
	 FROM [SiteUser]

GO


/******************************************************************
* 表名：sysdiagrams
* 时间：2012/12/20 20:57:04
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([diagram_id])+1 FROM [sysdiagrams]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_Exists
@diagram_id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [sysdiagrams] WHERE diagram_id=@diagram_id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_ADD
@name sysname,
@principal_id int,
@diagram_id int output,
@version int,
@definition varbinary(MAX)

 AS 
	INSERT INTO [sysdiagrams](
	[name],[principal_id],[version],[definition]
	)VALUES(
	@name,@principal_id,@version,@definition
	)
	SET @diagram_id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_Update
@name sysname,
@principal_id int,
@diagram_id int,
@version int,
@definition varbinary(MAX)
 AS 
	UPDATE [sysdiagrams] SET 
	[name] = @name,[principal_id] = @principal_id,[version] = @version,[definition] = @definition
	WHERE diagram_id=@diagram_id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_Delete
@diagram_id int
 AS 
	DELETE [sysdiagrams]
	 WHERE diagram_id=@diagram_id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_GetModel
@diagram_id int
 AS 
	SELECT 
	name,principal_id,diagram_id,version,definition
	 FROM [sysdiagrams]
	 WHERE diagram_id=@diagram_id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[sysdiagrams_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[sysdiagrams_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:04
------------------------------------
CREATE PROCEDURE sysdiagrams_GetList
 AS 
	SELECT 
	name,principal_id,diagram_id,version,definition
	 FROM [sysdiagrams]

GO


/******************************************************************
* 表名：TitleExpression
* 时间：2012/12/20 20:57:06
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([ExpressionId])+1 FROM [TitleExpression]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_Exists
@ExpressionId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleExpression] WHERE ExpressionId=@ExpressionId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_ADD
@ExpressionId int output,
@SiteId int,
@Value nvarchar(60),
@Priority int,
@IsEnable bit

 AS 
	INSERT INTO [TitleExpression](
	[SiteId],[Value],[Priority],[IsEnable]
	)VALUES(
	@SiteId,@Value,@Priority,@IsEnable
	)
	SET @ExpressionId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_Update
@ExpressionId int,
@SiteId int,
@Value nvarchar(60),
@Priority int,
@IsEnable bit
 AS 
	UPDATE [TitleExpression] SET 
	[SiteId] = @SiteId,[Value] = @Value,[Priority] = @Priority,[IsEnable] = @IsEnable
	WHERE ExpressionId=@ExpressionId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_Delete
@ExpressionId int
 AS 
	DELETE [TitleExpression]
	 WHERE ExpressionId=@ExpressionId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_GetModel
@ExpressionId int
 AS 
	SELECT 
	ExpressionId,SiteId,Value,Priority,IsEnable
	 FROM [TitleExpression]
	 WHERE ExpressionId=@ExpressionId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitleExpression_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitleExpression_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:06
------------------------------------
CREATE PROCEDURE TitleExpression_GetList
 AS 
	SELECT 
	ExpressionId,SiteId,Value,Priority,IsEnable
	 FROM [TitleExpression]

GO


/******************************************************************
* 表名：TitlePrefix
* 时间：2012/12/20 20:57:07
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([TitleId])+1 FROM [TitlePrefix]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_Exists
@TitleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitlePrefix] WHERE TitleId=@TitleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_ADD
@TitleId int output,
@SiteId int,
@Value nvarchar(60),
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitlePrefix](
	[SiteId],[Value],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Value,@CreatedOn,@UpdatedOn
	)
	SET @TitleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_Update
@TitleId int,
@SiteId int,
@Value nvarchar(60),
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitlePrefix] SET 
	[SiteId] = @SiteId,[Value] = @Value,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE TitleId=@TitleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_Delete
@TitleId int
 AS 
	DELETE [TitlePrefix]
	 WHERE TitleId=@TitleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_GetModel
@TitleId int
 AS 
	SELECT 
	TitleId,SiteId,Value,CreatedOn,UpdatedOn
	 FROM [TitlePrefix]
	 WHERE TitleId=@TitleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[TitlePrefix_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[TitlePrefix_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:07
------------------------------------
CREATE PROCEDURE TitlePrefix_GetList
 AS 
	SELECT 
	TitleId,SiteId,Value,CreatedOn,UpdatedOn
	 FROM [TitlePrefix]

GO


/******************************************************************
* 表名：UserSite
* 时间：2012/12/20 20:57:08
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([UserId])+1 FROM [UserSite]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_Exists
@UserId int,
@SiteId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [UserSite] WHERE UserId=@UserId and SiteId=@SiteId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_ADD
@UserId int,
@SiteId int,
@CreatedOn datetime

 AS 
	INSERT INTO [UserSite](
	[UserId],[SiteId],[CreatedOn]
	)VALUES(
	@UserId,@SiteId,@CreatedOn
	)

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_Update
@UserId int,
@SiteId int,
@CreatedOn datetime
 AS 
	UPDATE [UserSite] SET 
	[CreatedOn] = @CreatedOn
	WHERE UserId=@UserId and SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_Delete
@UserId int,
@SiteId int
 AS 
	DELETE [UserSite]
	 WHERE UserId=@UserId and SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_GetModel
@UserId int,
@SiteId int
 AS 
	SELECT 
	UserId,SiteId,CreatedOn
	 FROM [UserSite]
	 WHERE UserId=@UserId and SiteId=@SiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[UserSite_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[UserSite_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2012/12/20 20:57:08
------------------------------------
CREATE PROCEDURE UserSite_GetList
 AS 
	SELECT 
	UserId,SiteId,CreatedOn
	 FROM [UserSite]

GO

/******************************************************************
* 表名：ContentExtractionRule
* 时间：2013/4/5 0:05:53
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [ContentExtractionRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ContentExtractionRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@IsConvertToLocalUrl bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ContentExtractionRule](
	[SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[NoResultText],[ContentTemplate],[ContentOutTemplate],[IsConvertToLocalUrl],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@ContentExpression,@ChildExpression,@Encoding,@NoResultText,@ContentTemplate,@ContentOutTemplate,@IsConvertToLocalUrl,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(20),
@Url nvarchar(1000),
@ContentExpression nvarchar(2000),
@ChildExpression nvarchar(2000),
@Encoding nvarchar(50),
@NoResultText nvarchar(60),
@ContentTemplate nvarchar(2000),
@ContentOutTemplate nvarchar(2000),
@IsConvertToLocalUrl bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ContentExtractionRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[ContentExpression] = @ContentExpression,[ChildExpression] = @ChildExpression,[Encoding] = @Encoding,[NoResultText] = @NoResultText,[ContentTemplate] = @ContentTemplate,[ContentOutTemplate] = @ContentOutTemplate,[IsConvertToLocalUrl] = @IsConvertToLocalUrl,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_Delete
@RuleId int
 AS 
	DELETE [ContentExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,IsConvertToLocalUrl,IsEnable,CreatedOn,UpdatedOn
	 FROM [ContentExtractionRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ContentExtractionRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ContentExtractionRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/5 0:05:53
------------------------------------
CREATE PROCEDURE ContentExtractionRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,Url,ContentExpression,ChildExpression,Encoding,NoResultText,ContentTemplate,ContentOutTemplate,IsConvertToLocalUrl,IsEnable,CreatedOn,UpdatedOn
	 FROM [ContentExtractionRule]

GO

/******************************************************************
* 表名：DomainSetting
* 时间：2013/4/5 0:08:17
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([DomainId])+1 FROM [DomainSetting]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Exists
@DomainId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [DomainSetting] WHERE DomainId=@DomainId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_ADD
@DomainId int output,
@SiteId int,
@DomainName nvarchar(200),
@Domain nvarchar(200),
@Charset nvarchar(20),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [DomainSetting](
	[SiteId],[DomainName],[Domain],[Charset],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@DomainName,@Domain,@Charset,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @DomainId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Update
@DomainId int,
@SiteId int,
@DomainName nvarchar(200),
@Domain nvarchar(200),
@Charset nvarchar(20),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [DomainSetting] SET 
	[SiteId] = @SiteId,[DomainName] = @DomainName,[Domain] = @Domain,[Charset] = @Charset,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_Delete
@DomainId int
 AS 
	DELETE [DomainSetting]
	 WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetModel
@DomainId int
 AS 
	SELECT 
	DomainId,SiteId,DomainName,Domain,Charset,IsEnable,CreatedOn,UpdatedOn
	 FROM [DomainSetting]
	 WHERE DomainId=@DomainId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[DomainSetting_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [DomainSetting_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/5 0:08:17
------------------------------------
CREATE PROCEDURE DomainSetting_GetList
 AS 
	SELECT 
	DomainId,SiteId,DomainName,Domain,Charset,IsEnable,CreatedOn,UpdatedOn
	 FROM [DomainSetting]

GO

/******************************************************************
* 表名：MultiSite
* 时间：2013/4/5 0:08:46
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([MultiSiteId])+1 FROM [MultiSite]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Exists
@MultiSiteId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [MultiSite] WHERE MultiSiteId=@MultiSiteId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_ADD
@MultiSiteId int output,
@SiteId int,
@SiteName nvarchar(200),
@RootDomain nvarchar(200),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [MultiSite](
	[SiteId],[SiteName],[RootDomain],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@SiteName,@RootDomain,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @MultiSiteId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Update
@MultiSiteId int,
@SiteId int,
@SiteName nvarchar(200),
@RootDomain nvarchar(200),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [MultiSite] SET 
	[SiteId] = @SiteId,[SiteName] = @SiteName,[RootDomain] = @RootDomain,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_Delete
@MultiSiteId int
 AS 
	DELETE [MultiSite]
	 WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetModel
@MultiSiteId int
 AS 
	SELECT 
	MultiSiteId,SiteId,SiteName,RootDomain,IsEnable,CreatedOn,UpdatedOn
	 FROM [MultiSite]
	 WHERE MultiSiteId=@MultiSiteId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[MultiSite_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [MultiSite_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/5 0:08:46
------------------------------------
CREATE PROCEDURE MultiSite_GetList
 AS 
	SELECT 
	MultiSiteId,SiteId,SiteName,RootDomain,IsEnable,CreatedOn,UpdatedOn
	 FROM [MultiSite]

GO

/******************************************************************
* 表名：NonStaticUrl
* 时间：2013/4/6 11:01:57
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([UrlId])+1 FROM [NonStaticUrl]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Exists
@UrlId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [NonStaticUrl] WHERE UrlId=@UrlId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_ADD
@UrlId int output,
@SiteId int,
@Name nvarchar(200),
@Url nvarchar(4000),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [NonStaticUrl](
	[SiteId],[Name],[Url],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@Url,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @UrlId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Update
@UrlId int,
@SiteId int,
@Name nvarchar(200),
@Url nvarchar(4000),
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [NonStaticUrl] SET 
	[SiteId] = @SiteId,[Name] = @Name,[Url] = @Url,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_Delete
@UrlId int
 AS 
	DELETE [NonStaticUrl]
	 WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetModel
@UrlId int
 AS 
	SELECT 
	UrlId,SiteId,Name,Url,IsEnable,CreatedOn,UpdatedOn
	 FROM [NonStaticUrl]
	 WHERE UrlId=@UrlId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[NonStaticUrl_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [NonStaticUrl_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/6 11:01:57
------------------------------------
CREATE PROCEDURE NonStaticUrl_GetList
 AS 
	SELECT 
	UrlId,SiteId,Name,Url,IsEnable,CreatedOn,UpdatedOn
	 FROM [NonStaticUrl]

GO

/******************************************************************
* 表名：UrlEncodingRule
* 时间：2013/4/6 10:59:31
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [UrlEncodingRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [UrlEncodingRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_ADD
@RuleId int output,
@SiteId int,
@TagName nvarchar(40),
@AttributeName nvarchar(200),
@DefaultFileType nvarchar(20),
@Priority int,
@KeepOriginalFileType bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [UrlEncodingRule](
	[SiteId],[TagName],[AttributeName],[DefaultFileType],[Priority],[KeepOriginalFileType],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@TagName,@AttributeName,@DefaultFileType,@Priority,@KeepOriginalFileType,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Update
@RuleId int,
@SiteId int,
@TagName nvarchar(40),
@AttributeName nvarchar(200),
@DefaultFileType nvarchar(20),
@Priority int,
@KeepOriginalFileType bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [UrlEncodingRule] SET 
	[SiteId] = @SiteId,[TagName] = @TagName,[AttributeName] = @AttributeName,[DefaultFileType] = @DefaultFileType,[Priority] = @Priority,[KeepOriginalFileType] = @KeepOriginalFileType,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_Delete
@RuleId int
 AS 
	DELETE [UrlEncodingRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,TagName,AttributeName,DefaultFileType,Priority,KeepOriginalFileType,IsEnable,CreatedOn,UpdatedOn
	 FROM [UrlEncodingRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[UrlEncodingRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [UrlEncodingRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/6 10:59:31
------------------------------------
CREATE PROCEDURE UrlEncodingRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,TagName,AttributeName,DefaultFileType,Priority,KeepOriginalFileType,IsEnable,CreatedOn,UpdatedOn
	 FROM [UrlEncodingRule]

GO

/******************************************************************
* 表名：TitleCategory
* 时间：2013/4/27 21:47:28
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([CategoryId])+1 FROM [TitleCategory]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Exists
@CategoryId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleCategory] WHERE CategoryId=@CategoryId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_ADD
@CategoryId int output,
@SiteId int,
@CategoryName nvarchar(100),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleCategory](
	[SiteId],[CategoryName],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryName,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @CategoryId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Update
@CategoryId int,
@SiteId int,
@CategoryName nvarchar(100),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleCategory] SET 
	[SiteId] = @SiteId,[CategoryName] = @CategoryName,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Delete
@CategoryId int
 AS 
	DELETE [TitleCategory]
	 WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetModel
@CategoryId int
 AS 
	SELECT 
	CategoryId,SiteId,CategoryName,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleCategory]
	 WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetList
 AS 
	SELECT 
	CategoryId,SiteId,CategoryName,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleCategory]

GO

/******************************************************************
* 表名：TitleOriginal
* 时间：2013/4/27 21:47:38
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([OriginalId])+1 FROM [TitleOriginal]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Exists
@OriginalId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleOriginal] WHERE OriginalId=@OriginalId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_ADD
@OriginalId int output,
@SiteId int,
@CategoryId int,
@Vocabulary nvarchar(1000),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleOriginal](
	[SiteId],[CategoryId],[Vocabulary],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryId,@Vocabulary,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @OriginalId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Update
@OriginalId int,
@SiteId int,
@CategoryId int,
@Vocabulary nvarchar(1000),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleOriginal] SET 
	[SiteId] = @SiteId,[CategoryId] = @CategoryId,[Vocabulary] = @Vocabulary,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Delete
@OriginalId int
 AS 
	DELETE [TitleOriginal]
	 WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetModel
@OriginalId int
 AS 
	SELECT 
	OriginalId,SiteId,CategoryId,Vocabulary,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginal]
	 WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetList
 AS 
	SELECT 
	OriginalId,SiteId,CategoryId,Vocabulary,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginal]

GO

/******************************************************************
* 表名：TitleOriginalRule
* 时间：2013/4/28 19:55:02
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [TitleOriginalRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleOriginalRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(60),
@RuleType int,
@Delimiter nvarchar(60),
@Count int,
@CategoryId int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleOriginalRule](
	[SiteId],[Name],[RuleType],[Delimiter],[Count],[CategoryId],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@RuleType,@Delimiter,@Count,@CategoryId,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(60),
@RuleType int,
@Delimiter nvarchar(60),
@Count int,
@CategoryId int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleOriginalRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[RuleType] = @RuleType,[Delimiter] = @Delimiter,[Count] = @Count,[CategoryId] = @CategoryId,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Delete
@RuleId int
 AS 
	DELETE [TitleOriginalRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,RuleType,Delimiter,Count,CategoryId,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginalRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,RuleType,Delimiter,Count,CategoryId,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginalRule]

GO

/******************************************************************
* 表名：PageTitle
* 时间：2013/4/28 19:54:48
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([PageId])+1 FROM [PageTitle]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Exists
@PageId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [PageTitle] WHERE PageId=@PageId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_ADD
@PageId int output,
@SiteId int,
@PageIdentity nvarchar(36),
@Title nvarchar(2000),
@OldTitle nvarchar(2000),
@TitleMainPart nvarchar(2000),
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [PageTitle](
	[SiteId],[PageIdentity],[Title],[OldTitle],[TitleMainPart],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@PageIdentity,@Title,@OldTitle,@TitleMainPart,@CreatedOn,@UpdatedOn
	)
	SET @PageId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Update
@PageId int,
@SiteId int,
@PageIdentity nvarchar(36),
@Title nvarchar(2000),
@OldTitle nvarchar(2000),
@TitleMainPart nvarchar(2000),
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [PageTitle] SET 
	[SiteId] = @SiteId,[PageIdentity] = @PageIdentity,[Title] = @Title,[OldTitle] = @OldTitle,[TitleMainPart] = @TitleMainPart,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Delete
@PageId int
 AS 
	DELETE [PageTitle]
	 WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetModel
@PageId int
 AS 
	SELECT 
	PageId,SiteId,PageIdentity,Title,OldTitle,TitleMainPart,CreatedOn,UpdatedOn
	 FROM [PageTitle]
	 WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetList
 AS 
	SELECT 
	PageId,SiteId,PageIdentity,Title,OldTitle,TitleMainPart,CreatedOn,UpdatedOn
	 FROM [PageTitle]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [TranslateRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TranslateRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(100),
@TranslateUrl nvarchar(4000),
@RawUrlExtractExpression nvarchar(4000),
@RedirectExpression nvarchar(4000),
@OperationExpression nvarchar(4000),
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TranslateRule](
	[SiteId],[Name],[TranslateUrl],[RawUrlExtractExpression],[RedirectExpression],[OperationExpression],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@TranslateUrl,@RawUrlExtractExpression,@RedirectExpression,@OperationExpression,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(100),
@TranslateUrl nvarchar(4000),
@RawUrlExtractExpression nvarchar(4000),
@RedirectExpression nvarchar(4000),
@OperationExpression nvarchar(4000),
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TranslateRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[TranslateUrl] = @TranslateUrl,[RawUrlExtractExpression] = @RawUrlExtractExpression,[RedirectExpression] = @RedirectExpression,[OperationExpression] = @OperationExpression,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_Delete
@RuleId int
 AS 
	DELETE [TranslateRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,TranslateUrl,RawUrlExtractExpression,RedirectExpression,OperationExpression,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TranslateRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,TranslateUrl,RawUrlExtractExpression,RedirectExpression,OperationExpression,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TranslateRule]

GO

/******************************************************************
* 表名：RedirectRule
* 时间：2013/8/31 15:23:29
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[RedirectRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [RedirectRule_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/8/31 15:48:28
------------------------------------
CREATE PROCEDURE RedirectRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [RedirectRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[RedirectRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [RedirectRule_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/8/31 15:48:28
------------------------------------
CREATE PROCEDURE RedirectRule_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [RedirectRule] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[RedirectRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [RedirectRule_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/8/31 15:48:28
------------------------------------
CREATE PROCEDURE RedirectRule_ADD
@Id int output,
@RuleName nvarchar(60),
@RuleExpression nvarchar(1000),
@RedirectUrl nvarchar(2000),
@Priority int,
@ExactMatch bit,
@IsRegex bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [RedirectRule](
	[RuleName],[RuleExpression],[RedirectUrl],[Priority],[ExactMatch],[IsRegex],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@RuleName,@RuleExpression,@RedirectUrl,@Priority,@ExactMatch,@IsRegex,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[RedirectRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [RedirectRule_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/8/31 15:48:28
------------------------------------
CREATE PROCEDURE RedirectRule_Update
@Id int,
@RuleName nvarchar(60),
@RuleExpression nvarchar(1000),
@RedirectUrl nvarchar(2000),
@Priority int,
@ExactMatch bit,
@IsRegex bit,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [RedirectRule] SET 
	[RuleName] = @RuleName,[RuleExpression] = @RuleExpression,[RedirectUrl] = @RedirectUrl,[Priority] = @Priority,[ExactMatch] = @ExactMatch,[IsRegex] = @IsRegex,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[RedirectRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [RedirectRule_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/8/31 15:48:28
------------------------------------
CREATE PROCEDURE RedirectRule_Delete
@Id int
 AS 
	DELETE [RedirectRule]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[RedirectRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [RedirectRule_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/8/31 15:48:28
------------------------------------
CREATE PROCEDURE RedirectRule_GetModel
@Id int
 AS 
	SELECT 
	Id,RuleName,RuleExpression,RedirectUrl,Priority,ExactMatch,IsRegex,IsEnable,CreatedOn,UpdatedOn
	 FROM [RedirectRule]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[RedirectRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [RedirectRule_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/8/31 15:48:28
------------------------------------
CREATE PROCEDURE RedirectRule_GetList
 AS 
	SELECT 
	Id,RuleName,RuleExpression,RedirectUrl,Priority,ExactMatch,IsRegex,IsEnable,CreatedOn,UpdatedOn
	 FROM [RedirectRule]

GO

/******************************************************************
* 表名：Article
* 时间：2013/10/16 23:44:24
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [Article]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [Article] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_ADD
@Id int output,
@SiteId int,
@CategoryId int,
@CategoryName nvarchar(100),
@Model int,
@Author nvarchar(100),
@Source nvarchar(200),
@SourceUrl nvarchar(2000),
@Title nvarchar(1000),
@ShortTitle nvarchar(100),
@Tag nvarchar(200),
@Thumbnails nvarchar(2000),
@HasThumbnails bit,
@Hits int,
@OrderValue bigint,
@Comments int,
@Description nvarchar(1000),
@UserName nvarchar(100),
@UserId int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [Article](
	[SiteId],[CategoryId],[CategoryName],[Model],[Author],[Source],[SourceUrl],[Title],[ShortTitle],[Tag],[Thumbnails],[HasThumbnails],[Hits],[OrderValue],[Comments],[Description],[UserName],[UserId],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryId,@CategoryName,@Model,@Author,@Source,@SourceUrl,@Title,@ShortTitle,@Tag,@Thumbnails,@HasThumbnails,@Hits,@OrderValue,@Comments,@Description,@UserName,@UserId,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_Update
@Id int,
@SiteId int,
@CategoryId int,
@CategoryName nvarchar(100),
@Model int,
@Author nvarchar(100),
@Source nvarchar(200),
@SourceUrl nvarchar(2000),
@Title nvarchar(1000),
@ShortTitle nvarchar(100),
@Tag nvarchar(200),
@Thumbnails nvarchar(2000),
@HasThumbnails bit,
@Hits int,
@OrderValue bigint,
@Comments int,
@Description nvarchar(1000),
@UserName nvarchar(100),
@UserId int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [Article] SET 
	[SiteId] = @SiteId,[CategoryId] = @CategoryId,[CategoryName] = @CategoryName,[Model] = @Model,[Author] = @Author,[Source] = @Source,[SourceUrl] = @SourceUrl,[Title] = @Title,[ShortTitle] = @ShortTitle,[Tag] = @Tag,[Thumbnails] = @Thumbnails,[HasThumbnails] = @HasThumbnails,[Hits] = @Hits,[OrderValue] = @OrderValue,[Comments] = @Comments,[Description] = @Description,[UserName] = @UserName,[UserId] = @UserId,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_Delete
@Id int
 AS 
	DELETE [Article]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,CategoryId,CategoryName,Model,Author,Source,SourceUrl,Title,ShortTitle,Tag,Thumbnails,HasThumbnails,Hits,OrderValue,Comments,Description,UserName,UserId,IsEnable,CreatedOn,UpdatedOn
	 FROM [Article]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_GetList
 AS 
	SELECT 
	Id,SiteId,CategoryId,CategoryName,Model,Author,Source,SourceUrl,Title,ShortTitle,Tag,Thumbnails,HasThumbnails,Hits,OrderValue,Comments,Description,UserName,UserId,IsEnable,CreatedOn,UpdatedOn
	 FROM [Article]

GO

/******************************************************************
* 表名：ArticleCategory
* 时间：2013/10/16 23:44:42
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [ArticleCategory]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ArticleCategory] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_ADD
@Id int output,
@SiteId int,
@Name nvarchar(100),
@IsEnable bit,
@ParentId int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ArticleCategory](
	[SiteId],[Name],[IsEnable],[ParentId],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@IsEnable,@ParentId,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_Update
@Id int,
@SiteId int,
@Name nvarchar(100),
@IsEnable bit,
@ParentId int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ArticleCategory] SET 
	[SiteId] = @SiteId,[Name] = @Name,[IsEnable] = @IsEnable,[ParentId] = @ParentId,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_Delete
@Id int
 AS 
	DELETE [ArticleCategory]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,Name,IsEnable,ParentId,CreatedOn,UpdatedOn
	 FROM [ArticleCategory]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_GetList
 AS 
	SELECT 
	Id,SiteId,Name,IsEnable,ParentId,CreatedOn,UpdatedOn
	 FROM [ArticleCategory]

GO

/******************************************************************
* 表名：ArticleContent
* 时间：2013/10/16 23:44:59
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [ArticleContent]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ArticleContent] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_ADD
@Id int output,
@ArticleId int,
@SubTitle nvarchar(1000),
@Page int,
@OrderValue int,
@ContentValue text,
@UserId int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ArticleContent](
	[ArticleId],[SubTitle],[Page],[OrderValue],[ContentValue],[UserId],[CreatedOn],[UpdatedOn]
	)VALUES(
	@ArticleId,@SubTitle,@Page,@OrderValue,@ContentValue,@UserId,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_Update
@Id int,
@ArticleId int,
@SubTitle nvarchar(1000),
@Page int,
@OrderValue int,
@ContentValue text,
@UserId int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ArticleContent] SET 
	[ArticleId] = @ArticleId,[SubTitle] = @SubTitle,[Page] = @Page,[OrderValue] = @OrderValue,[ContentValue] = @ContentValue,[UserId] = @UserId,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_Delete
@Id int
 AS 
	DELETE [ArticleContent]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_GetModel
@Id int
 AS 
	SELECT 
	Id,ArticleId,SubTitle,Page,OrderValue,ContentValue,UserId,CreatedOn,UpdatedOn
	 FROM [ArticleContent]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_GetList
 AS 
	SELECT 
	Id,ArticleId,SubTitle,Page,OrderValue,ContentValue,UserId,CreatedOn,UpdatedOn
	 FROM [ArticleContent]

GO

/******************************************************************
* 表名：ArticleTemplate
* 时间：2013/10/22 22:52:17
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [ArticleTemplate]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ArticleTemplate] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_ADD
@Id int output,
@SiteId int,
@Name nvarchar(100),
@TemplateType int,
@Template text,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ArticleTemplate](
	[SiteId],[Name],[TemplateType],[Template],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@TemplateType,@Template,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_Update
@Id int,
@SiteId int,
@Name nvarchar(100),
@TemplateType int,
@Template text,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ArticleTemplate] SET 
	[SiteId] = @SiteId,[Name] = @Name,[TemplateType] = @TemplateType,[Template] = @Template,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_Delete
@Id int
 AS 
	DELETE [ArticleTemplate]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,Name,TemplateType,Template,IsEnable,CreatedOn,UpdatedOn
	 FROM [ArticleTemplate]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_GetList
 AS 
	SELECT 
	Id,SiteId,Name,TemplateType,Template,IsEnable,CreatedOn,UpdatedOn
	 FROM [ArticleTemplate]

GO

/******************************************************************
* 表名：StaticType
* 时间：2013/10/26 17:40:16
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_GetMaxId]
GO
------------------------------------
--用途：得到主键字段最大值 
--项目名称：
--说明：
--时间：2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [StaticType]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_Exists]
GO
------------------------------------
--用途：是否已经存在 
--项目名称：
--说明：
--时间：2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [StaticType] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_ADD]
GO
------------------------------------
--用途：增加一条记录 
--项目名称：
--说明：
--时间：2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_ADD
@Id int output,
@SiteId int,
@Name nvarchar(60),
@TypeIdentity nvarchar(200),
@IdentityType int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [StaticType](
	[SiteId],[Name],[TypeIdentity],[IdentityType],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@TypeIdentity,@IdentityType,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_Update]
GO
------------------------------------
--用途：修改一条记录 
--项目名称：
--说明：
--时间：2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_Update
@Id int,
@SiteId int,
@Name nvarchar(60),
@TypeIdentity nvarchar(200),
@IdentityType int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [StaticType] SET 
	[SiteId] = @SiteId,[Name] = @Name,[TypeIdentity] = @TypeIdentity,[IdentityType] = @IdentityType,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_Delete]
GO
------------------------------------
--用途：删除一条记录 
--项目名称：
--说明：
--时间：2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_Delete
@Id int
 AS 
	DELETE [StaticType]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_GetModel]
GO
------------------------------------
--用途：得到实体对象的详细信息 
--项目名称：
--说明：
--时间：2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,Name,TypeIdentity,IdentityType,IsEnable,CreatedOn,UpdatedOn
	 FROM [StaticType]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_GetList]
GO
------------------------------------
--用途：查询记录信息 
--项目名称：
--说明：
--时间：2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_GetList
 AS 
	SELECT 
	Id,SiteId,Name,TypeIdentity,IdentityType,IsEnable,CreatedOn,UpdatedOn
	 FROM [StaticType]

GO


!!!!!!

------------------------------------
--插入站点数据
------------------------------------

INSERT [Site] ([SiteName],[SiteProtoco],[SitePort],[SiteChildDomain],[SiteRootDomain],[Keyword],[Description],[ICPNumber],[TargetSiteProtoco],[TargetSitePort],[TargetSiteChildDomain],[TargetSiteRootDomain],[Email],[QQ],[ForumUserName],[SiteStatus],[AuthorizedCode],[CreatedOn],[UpdatedOn]) 
VALUES (N'{0}',N'{1}',{2},N'{3}',N'{4}',N'',N'',N'',N'{5}',{6},N'{7}',N'{8}',N'{9}',N'{10}',N'{11}',1,N'',getdate(),null)

SELECT @@IDENTITY

!!!!!!

------------------------------------
--插入其他数据
------------------------------------

DECLARE @SiteId int

SELECT @SiteId = [*SiteId*]

if not exists (select * from [SiteUser] where [UserName] = '[*UserName*]')
BEGIN 
INSERT [SiteUser] ([UserName],[Password],[Name],[UserType],[IsActive],[CreatedOn]) VALUES (N'[*UserName*]',N'[*Password*]',N'',0,1,getdate())
END

INSERT [SiteSetting] ([SiteId],[Name],[IsActive],[CacheExpireTime],[Charset],[ForbiddenFileType],[CollectImage],[FakeOriginalTitle],[FakeOriginalContent],[StaticExtension],[EnableBillboard],[InternalSearchTemplate],[SupportPandomain],[UseProxy],[SynchronizeIECookie],[EnableErrorLog], [WorkMode],[CreatedOn],[UpdatedOn]) 
VALUES (@SiteId ,N'默认站点设置',1,3600,N'[*Charset*]',N'zip|mp3|rm',1,1,0,N'htm',1,N'default/search.html',1,0,0,0,2,getdate(),null)

INSERT [InternalSiteSearch] ([SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[ContentTemplate],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (@SiteId,N'soso',N'http://www.soso.com/q?w={0}&site={1}&ch=website',N'//*[@id="result"]',N'url;/ol',N'gbk',N'<ol>[*ContentValue(url)*]</ol>',1,1,getdate(),null)
INSERT [InternalSiteSearch] ([SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[ContentTemplate],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (@SiteId,N'视频',N'http://video.soso.com/search/?ch=v.res.search&pid=v.search&ac=1&w={0}',N'//*[@id="result_wrap"]',N'result;/div[@id="result"]',N'gbk',N'[*ContentValue(result)*]',1,0,getdate(),null)
INSERT [InternalSiteSearch] ([SiteId],[Name],[Url],[ContentExpression],[ChildExpression],[Encoding],[ContentTemplate],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn],[ContentOutTemplate],[RelatedKeywordExpression],[Priority]) VALUES (@SiteId,N'淘宝',N'http://s8.taobao.com/search?q={0}&cat=0&pid=mm_12689842_0_0&mode=23&commend=1%2C2',N'//ul[@data-item-count]/li',N'summary;/h3||url;/h3/a;href||title;/h3/a;title||price;/ul/li[@class=''price'']/em||photo;/div[@class=''photo '']/a/span/img;data-ks-lazyload||sell;/ul/li[@class=''price'']/span||shipment;/ul/li[@class=''shipment'']||carryFee;/li/span[@class=''fee'']||seller;ul/li[@class=''seller'']',N'gbk',N'<li>
        <div class="figure">
            <div class="pic">
                <a href="[*ContentValue(url)*]" target="_blank" class="s_history_e_product_pic">
                    <img alt="[*ContentValue(title)*]" src="[*ContentValue(photo)*]">
                </a><i class=""></i>
            </div>
            <div class="cont">
                <h2 class="title">
                    <i class=""></i>[*ContentValue(summary)*]</h2>
                <p class="price">
                    <span class="present-price">￥<strong>[*ContentValue(price)*]</strong></span><!--<span title="原价：899" class="rebate">3.3折</span>-->
                </p>
                <p class="info">
                    <span class="total">[*ContentValue(sell)*]</span><span class="devide">|</span>[*ContentValue(carryFee)*]
                </p>
                <p class="mall-name">
                    [*ContentValue(seller)*]<!-- <a target="_blank" class="icon-card" title="一站通：支持360帐号登录"
                                            bk="e-logo" href="/yizhantong.html">一站通</a>-->
                </p>
            </div>
        </div>
    </li>',1,0,GETDATE(),null,N'<ul class="product-list clearfix">[*AllContent*]</ul>',N'//*[@id="J_RelatedSearch"]/dd/a',10)

DECLARE @BillboardId int

INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'实时热点',N'http://top.baidu.com/rss_xml.php?b=1',0,1,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'七日关注',N'http://top.baidu.com/rss_xml.php?b=42',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'热门搜索',N'http://top.baidu.com/rss_xml.php?b=2',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'世说新词',N'http://top.baidu.com/rss_xml.php?b=396',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES(@SiteId,N'今日电影排行榜',N'http://top.baidu.com/rss_xml.php?b=26',0,0,N'2013/4/21 19:38:29',N'2013/4/26 7:04:28')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'爱情',N'http://top.baidu.com/rss_xml.php?b=338',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'喜剧',N'http://top.baidu.com/rss_xml.php?b=340',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'惊悚',N'http://top.baidu.com/rss_xml.php?b=339',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'科幻',N'http://top.baidu.com/rss_xml.php?b=437',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'剧情',N'http://top.baidu.com/rss_xml.php?b=337',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES(@SiteId,N'今日电视剧排行榜',N'http://top.baidu.com/rss_xml.php?b=4',0,0,N'2013/4/21 19:38:29',N'2013/4/26 7:05:27')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'偶像',N'http://top.baidu.com/rss_xml.php?b=349',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'言情',N'http://top.baidu.com/rss_xml.php?b=350',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'古装',N'http://top.baidu.com/rss_xml.php?b=351',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'家庭伦理',N'http://top.baidu.com/rss_xml.php?b=448',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'美剧',N'http://top.baidu.com/rss_xml.php?b=452',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'韩剧',N'http://top.baidu.com/rss_xml.php?b=453',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'全部',N'http://top.baidu.com/rss_xml.php?b=19',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'访谈',N'http://top.baidu.com/rss_xml.php?b=439',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'情感',N'http://top.baidu.com/rss_xml.php?b=440',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'选秀',N'http://top.baidu.com/rss_xml.php?b=441',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'内地',N'http://top.baidu.com/rss_xml.php?b=368',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'港台',N'http://top.baidu.com/rss_xml.php?b=369',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'全部',N'http://top.baidu.com/rss_xml.php?b=23',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'搞笑',N'http://top.baidu.com/rss_xml.php?b=442',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'益智',N'http://top.baidu.com/rss_xml.php?b=443',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'冒险',N'http://top.baidu.com/rss_xml.php?b=444',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'国产',N'http://top.baidu.com/rss_xml.php?b=445',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'日本',N'http://top.baidu.com/rss_xml.php?b=446',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'欧美',N'http://top.baidu.com/rss_xml.php?b=447',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'热点人物',N'http://top.baidu.com/rss_xml.php?b=258',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'美女',N'http://top.baidu.com/rss_xml.php?b=3',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'帅哥',N'http://top.baidu.com/rss_xml.php?b=22',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'女演员',N'http://top.baidu.com/rss_xml.php?b=18',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'男演员',N'http://top.baidu.com/rss_xml.php?b=17',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'女歌手',N'http://top.baidu.com/rss_xml.php?b=16',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'男歌手',N'http://top.baidu.com/rss_xml.php?b=15',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'主持人',N'http://top.baidu.com/rss_xml.php?b=454',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'体坛人物',N'http://top.baidu.com/rss_xml.php?b=255',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'财经人物',N'http://top.baidu.com/rss_xml.php?b=261',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'互联网人物',N'http://top.baidu.com/rss_xml.php?b=257',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'历史人物',N'http://top.baidu.com/rss_xml.php?b=259',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'名家人物',N'http://top.baidu.com/rss_xml.php?b=260',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'全部小说',N'http://top.baidu.com/rss_xml.php?b=7',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'玄幻',N'http://top.baidu.com/rss_xml.php?b=353',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'武侠仙侠',N'http://top.baidu.com/rss_xml.php?b=354',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'言情',N'http://top.baidu.com/rss_xml.php?b=355',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'悬疑',N'http://top.baidu.com/rss_xml.php?b=356',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES(@SiteId,N'最近事件排行榜',N'http://top.baidu.com/rss_xml.php?b=341',0,0,N'2013/4/21 19:38:29',N'2013/4/26 7:06:38')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'社会民生',N'http://top.baidu.com/rss_xml.php?b=342',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'娱乐八卦',N'http://top.baidu.com/rss_xml.php?b=344',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'体育热点',N'http://top.baidu.com/rss_xml.php?b=11',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'网页游戏',N'http://top.baidu.com/rss_xml.php?b=173',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'网游',N'http://top.baidu.com/rss_xml.php?b=62',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'小游戏',N'http://top.baidu.com/rss_xml.php?b=451',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'网游运营商',N'http://top.baidu.com/rss_xml.php?b=61',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'页游平台',N'http://top.baidu.com/rss_xml.php?b=244',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'热搜汽车',N'http://top.baidu.com/rss_xml.php?b=176',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'紧凑型车',N'http://top.baidu.com/rss_xml.php?b=179',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'SUV',N'http://top.baidu.com/rss_xml.php?b=285',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'微型车',N'http://top.baidu.com/rss_xml.php?b=177',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'小型车',N'http://top.baidu.com/rss_xml.php?b=178',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'中级车',N'http://top.baidu.com/rss_xml.php?b=180',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'中高级车',N'http://top.baidu.com/rss_xml.php?b=281',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'跑车',N'http://top.baidu.com/rss_xml.php?b=283',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'豪华车',N'http://top.baidu.com/rss_xml.php?b=282',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'MPV',N'http://top.baidu.com/rss_xml.php?b=284',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'汽车品牌',N'http://top.baidu.com/rss_xml.php?b=420',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'旅游',N'http://top.baidu.com/rss_xml.php?b=302',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'团购',N'http://top.baidu.com/rss_xml.php?b=280',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'奢侈品',N'http://top.baidu.com/rss_xml.php?b=270',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'美食',N'http://top.baidu.com/rss_xml.php?b=291',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'化妆品',N'http://top.baidu.com/rss_xml.php?b=44',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'宠物',N'http://top.baidu.com/rss_xml.php?b=24',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'奶粉',N'http://top.baidu.com/rss_xml.php?b=414',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'家电',N'http://top.baidu.com/rss_xml.php?b=415',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'畅销书',N'http://top.baidu.com/rss_xml.php?b=450',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'高校',N'http://top.baidu.com/rss_xml.php?b=12',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'慈善组织',N'http://top.baidu.com/rss_xml.php?b=367',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'手机产品',N'http://top.baidu.com/rss_xml.php?b=238',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'手机品牌',N'http://top.baidu.com/rss_xml.php?b=237',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'PC产品',N'http://top.baidu.com/rss_xml.php?b=402',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'PC品牌',N'http://top.baidu.com/rss_xml.php?b=51',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'软件',N'http://top.baidu.com/rss_xml.php?b=20',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'热搜股票',N'http://top.baidu.com/rss_xml.php?b=274',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'创业板',N'http://top.baidu.com/rss_xml.php?b=277',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'中小板股票',N'http://top.baidu.com/rss_xml.php?b=276',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'基金产品',N'http://top.baidu.com/rss_xml.php?b=412',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)
INSERT [Billboard] ([SiteId],[Name],[Url],[DataType],[IsEnable],[CreatedOn]) VALUES(@SiteId,N'基金品牌',N'http://top.baidu.com/rss_xml.php?b=411',0,0,N'2013/4/21 19:38:29')
SELECT @BillboardId = @@identity
INSERT [BillboardExtractionRule] ([BillboardId],[RuleName],[ExtractionRule],[KeywordCount],[IsEnable],[CreatedOn],[UpdatedOn]) VALUES ( @BillboardId,N'默认提取规则',N'//table/tbody/tr[position()>1]/td[1]/a',1,1,getdate(),null)


INSERT [TranslateRule] ([SiteId],[Name],[TranslateUrl],[RawUrlExtractExpression],[OperationExpression],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (@SiteId,N'国内通道-英->中',N'http://translate.baiducontent.com/transpage?cb=translateCallback&ie=utf8&source=url&query={0}&from=en&to=zh',N'http://translate.baiducontent.com/transpage\?.*?&query=(?<url>.*?)&from=en&to=zh',N'\<trans data-src=".*?"\>(?<rawvalue>.*?)\<\/trans\>;$1||\<link.*?fanyi.baidu.com.*?\>||\<script.*?  fanyi.baidu.com.*?\<\/script\>||\<script.*? var _trace_page_logid.*?\<\/script\>',0,0,10,0,0,N'2013/7/28 20:43:47',N'2013/8/11 15:13:24')
INSERT [TranslateRule] ([SiteId],[Name],[TranslateUrl],[RawUrlExtractExpression],[RedirectExpression],[OperationExpression],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (@SiteId,N'国外通道-英->中',N'http://translate.google.com.hk/translate?depth=1&hl=zh-CN&ie=UTF8&prev=_t&sl=en&tl=zh-CN&u={0}',N'http://translate.googleusercontent.com/translate_c\?.*?&amp;u=(?<url>.*?)&amp;usg=',N'//iframe[@sandbox];src',N'class="notranslate" onmouseover="_tipon\(this\)" onmouseout="_tipoff\(\)"||class="google-src-text" style="direction.*?left";style="display:none"||\<script\>_addload\(function\(\){_setupIW.*?<\/script\>||lang=.*?x-mtfrom-.*?||  \<script src.*?translate.googleusercontent.com.*?js.*?\<\/script\>||\<script\>_intlStrings._originalText.*?\<\/script\>||  \<style.*?google-src-text.*?\<\/style\>||\<meta http-equiv="X-Translated-By" content="Google"\>.*?\<base.*?\/\>||  \(function\(\).*?pageT\),||c&&0<b&&\(c.tick.*?window.jstiming.pt=a.*?}\)\(\)',0,0,10,0,0,N'2013/7/28 23:24:14',N'2013/8/11 15:12:51')
INSERT [TranslateRule] ([SiteId],[Name],[TranslateUrl],[RawUrlExtractExpression],[OperationExpression],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (@SiteId,N'国内通道-中->英',N'http://translate.baiducontent.com/transpage?cb=translateCallback&ie=utf8&source=url&query={0}&from=zh&to=en',N'http://translate.baiducontent.com/transpage\?.*?&query=(?<url>.*?)&from=zh&to=en',N'\<trans data-src=".*?"\>(?<rawvalue>.*?)\<\/trans\>;$1||\<link.*?fanyi.baidu.com.*?\>||\<script.*?  fanyi.baidu.com.*?\<\/script\>||\<script.*? var _trace_page_logid.*?\<\/script\>',0,0,10,0,0,N'2013/7/28 20:43:47',N'2013/8/11 15:05:34')
INSERT [TranslateRule] ([SiteId],[Name],[TranslateUrl],[RawUrlExtractExpression],[RedirectExpression],[OperationExpression],[MatchUrl],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]) VALUES (@SiteId,N'国外通道-中->英',N'http://translate.google.com.hk/translate?depth=1&hl=en&ie=UTF8&prev=_t&sl=zh-CN&tl=en&u={0}',N'http://translate.googleusercontent.com/translate_c\?.*?&amp;u=(?<url>.*?)&amp;usg=.*?"',N'//iframe[@sandbox];src',N'class="notranslate" onmouseover="_tipon\(this\)" onmouseout="_tipoff\(\)"||class="google-src-text" style="direction.*?left";style="display:none"||\<script\>_addload\(function\(\){_setupIW.*?<\/script\>||lang=.*?x-mtfrom-.*?||  \<script src.*?translate.googleusercontent.com.*?js.*?\<\/script\>||\<script\>_intlStrings._originalText.*?\<\/script\>||  \<style.*?google-src-text.*?\<\/style\>||\<meta http-equiv="X-Translated-By" content="Google"\>.*?\<base.*?\/\>||  \(function\(\).*?pageT\),||c&&0<b&&\(c.tick.*?window.jstiming.pt=a.*?}\)\(\)',0,0,10,0,0,N'2013/7/28 23:24:14',N'2013/8/11 15:02:09')
