IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ArticleTemplate]') AND type in (N'U'))
DROP TABLE [dbo].[ArticleTemplate]
GO

CREATE TABLE [dbo].[ArticleTemplate](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[TemplateType] [int] NOT NULL,
	[Template] [text] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ArticleTemplate] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ArticleContent]') AND type in (N'U'))
DROP TABLE [dbo].[ArticleContent]
GO

CREATE TABLE [dbo].[ArticleContent](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[ArticleId] [int] NOT NULL,
	[SubTitle] [nvarchar](1000) NULL,
	[Page] [int] NULL,
	[OrderValue] [int] NOT NULL,
	[ContentValue] [text] NOT NULL,
	[UserId] [int] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ArticleContent] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ArticleCategory]') AND type in (N'U'))
DROP TABLE [dbo].[ArticleCategory]
GO

CREATE TABLE [dbo].[ArticleCategory](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[ParentId] [int] NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_ArticleCategory] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Article]') AND type in (N'U'))
DROP TABLE [dbo].[Article]
GO

CREATE TABLE [dbo].[Article](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[CategoryName] [nvarchar](100) NOT NULL,
	[Model] [int] NOT NULL,
	[Author] [nvarchar](100) NULL,
	[Source] [nvarchar](200) NULL,
	[SourceUrl] [nvarchar](2000) NULL,
	[Title] [nvarchar](1000) NOT NULL,
	[ShortTitle] [nvarchar](100) NULL,
	[Tag] [nvarchar](200) NULL,
	[Thumbnails] [nvarchar](2000) NULL,
	[HasThumbnails] [bit] NOT NULL,
	[Hits] [int] NULL,
	[OrderValue] [bigint] NOT NULL,
	[Comments] [int] NULL,
	[Description] [nvarchar](1000) NULL,
	[UserName] [nvarchar](100) NOT NULL,
	[UserId] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_Article] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StaticType]') AND type in (N'U'))
DROP TABLE [dbo].[StaticType]
GO

CREATE TABLE [dbo].[StaticType](
	[Id] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](60) NOT NULL,
	[TypeIdentity] [nvarchar](200) NOT NULL,
	[IdentityType] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_StaticType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

/******************************************************************
* Article
* ʱ䣺2013/10/16 23:44:24
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [Article]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [Article] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_ADD
@Id int output,
@SiteId int,
@CategoryId int,
@CategoryName nvarchar(100),
@Model int,
@Author nvarchar(100),
@Source nvarchar(200),
@SourceUrl nvarchar(2000),
@Title nvarchar(1000),
@ShortTitle nvarchar(100),
@Tag nvarchar(200),
@Thumbnails nvarchar(2000),
@HasThumbnails bit,
@Hits int,
@OrderValue bigint,
@Comments int,
@Description nvarchar(1000),
@UserName nvarchar(100),
@UserId int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [Article](
	[SiteId],[CategoryId],[CategoryName],[Model],[Author],[Source],[SourceUrl],[Title],[ShortTitle],[Tag],[Thumbnails],[HasThumbnails],[Hits],[OrderValue],[Comments],[Description],[UserName],[UserId],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryId,@CategoryName,@Model,@Author,@Source,@SourceUrl,@Title,@ShortTitle,@Tag,@Thumbnails,@HasThumbnails,@Hits,@OrderValue,@Comments,@Description,@UserName,@UserId,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_Update
@Id int,
@SiteId int,
@CategoryId int,
@CategoryName nvarchar(100),
@Model int,
@Author nvarchar(100),
@Source nvarchar(200),
@SourceUrl nvarchar(2000),
@Title nvarchar(1000),
@ShortTitle nvarchar(100),
@Tag nvarchar(200),
@Thumbnails nvarchar(2000),
@HasThumbnails bit,
@Hits int,
@OrderValue bigint,
@Comments int,
@Description nvarchar(1000),
@UserName nvarchar(100),
@UserId int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [Article] SET 
	[SiteId] = @SiteId,[CategoryId] = @CategoryId,[CategoryName] = @CategoryName,[Model] = @Model,[Author] = @Author,[Source] = @Source,[SourceUrl] = @SourceUrl,[Title] = @Title,[ShortTitle] = @ShortTitle,[Tag] = @Tag,[Thumbnails] = @Thumbnails,[HasThumbnails] = @HasThumbnails,[Hits] = @Hits,[OrderValue] = @OrderValue,[Comments] = @Comments,[Description] = @Description,[UserName] = @UserName,[UserId] = @UserId,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_Delete
@Id int
 AS 
	DELETE [Article]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,CategoryId,CategoryName,Model,Author,Source,SourceUrl,Title,ShortTitle,Tag,Thumbnails,HasThumbnails,Hits,OrderValue,Comments,Description,UserName,UserId,IsEnable,CreatedOn,UpdatedOn
	 FROM [Article]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[Article_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [Article_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:24
------------------------------------
CREATE PROCEDURE Article_GetList
 AS 
	SELECT 
	Id,SiteId,CategoryId,CategoryName,Model,Author,Source,SourceUrl,Title,ShortTitle,Tag,Thumbnails,HasThumbnails,Hits,OrderValue,Comments,Description,UserName,UserId,IsEnable,CreatedOn,UpdatedOn
	 FROM [Article]

GO

/******************************************************************
* ArticleCategory
* ʱ䣺2013/10/16 23:44:42
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [ArticleCategory]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ArticleCategory] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_ADD
@Id int output,
@SiteId int,
@Name nvarchar(100),
@IsEnable bit,
@ParentId int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ArticleCategory](
	[SiteId],[Name],[IsEnable],[ParentId],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@IsEnable,@ParentId,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_Update
@Id int,
@SiteId int,
@Name nvarchar(100),
@IsEnable bit,
@ParentId int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ArticleCategory] SET 
	[SiteId] = @SiteId,[Name] = @Name,[IsEnable] = @IsEnable,[ParentId] = @ParentId,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_Delete
@Id int
 AS 
	DELETE [ArticleCategory]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,Name,IsEnable,ParentId,CreatedOn,UpdatedOn
	 FROM [ArticleCategory]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleCategory_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleCategory_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:42
------------------------------------
CREATE PROCEDURE ArticleCategory_GetList
 AS 
	SELECT 
	Id,SiteId,Name,IsEnable,ParentId,CreatedOn,UpdatedOn
	 FROM [ArticleCategory]

GO

/******************************************************************
* ArticleContent
* ʱ䣺2013/10/16 23:44:59
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [ArticleContent]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ArticleContent] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_ADD
@Id int output,
@ArticleId int,
@SubTitle nvarchar(1000),
@Page int,
@OrderValue int,
@ContentValue text,
@UserId int,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ArticleContent](
	[ArticleId],[SubTitle],[Page],[OrderValue],[ContentValue],[UserId],[CreatedOn],[UpdatedOn]
	)VALUES(
	@ArticleId,@SubTitle,@Page,@OrderValue,@ContentValue,@UserId,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_Update
@Id int,
@ArticleId int,
@SubTitle nvarchar(1000),
@Page int,
@OrderValue int,
@ContentValue text,
@UserId int,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ArticleContent] SET 
	[ArticleId] = @ArticleId,[SubTitle] = @SubTitle,[Page] = @Page,[OrderValue] = @OrderValue,[ContentValue] = @ContentValue,[UserId] = @UserId,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_Delete
@Id int
 AS 
	DELETE [ArticleContent]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_GetModel
@Id int
 AS 
	SELECT 
	Id,ArticleId,SubTitle,Page,OrderValue,ContentValue,UserId,CreatedOn,UpdatedOn
	 FROM [ArticleContent]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleContent_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleContent_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/10/16 23:44:59
------------------------------------
CREATE PROCEDURE ArticleContent_GetList
 AS 
	SELECT 
	Id,ArticleId,SubTitle,Page,OrderValue,ContentValue,UserId,CreatedOn,UpdatedOn
	 FROM [ArticleContent]

GO

/******************************************************************
* ArticleTemplate
* ʱ䣺2013/10/22 22:52:17
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [ArticleTemplate]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [ArticleTemplate] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_ADD
@Id int output,
@SiteId int,
@Name nvarchar(100),
@TemplateType int,
@Template text,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [ArticleTemplate](
	[SiteId],[Name],[TemplateType],[Template],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@TemplateType,@Template,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_Update
@Id int,
@SiteId int,
@Name nvarchar(100),
@TemplateType int,
@Template text,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [ArticleTemplate] SET 
	[SiteId] = @SiteId,[Name] = @Name,[TemplateType] = @TemplateType,[Template] = @Template,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_Delete
@Id int
 AS 
	DELETE [ArticleTemplate]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,Name,TemplateType,Template,IsEnable,CreatedOn,UpdatedOn
	 FROM [ArticleTemplate]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[ArticleTemplate_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [ArticleTemplate_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/10/22 22:52:17
------------------------------------
CREATE PROCEDURE ArticleTemplate_GetList
 AS 
	SELECT 
	Id,SiteId,Name,TemplateType,Template,IsEnable,CreatedOn,UpdatedOn
	 FROM [ArticleTemplate]

GO

/******************************************************************
* StaticType
* ʱ䣺2013/10/26 17:40:16
* Made by Codematic
******************************************************************/

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([Id])+1 FROM [StaticType]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_Exists
@Id int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [StaticType] WHERE Id=@Id 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_ADD
@Id int output,
@SiteId int,
@Name nvarchar(60),
@TypeIdentity nvarchar(200),
@IdentityType int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [StaticType](
	[SiteId],[Name],[TypeIdentity],[IdentityType],[IsEnable],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@TypeIdentity,@IdentityType,@IsEnable,@CreatedOn,@UpdatedOn
	)
	SET @Id = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_Update
@Id int,
@SiteId int,
@Name nvarchar(60),
@TypeIdentity nvarchar(200),
@IdentityType int,
@IsEnable bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [StaticType] SET 
	[SiteId] = @SiteId,[Name] = @Name,[TypeIdentity] = @TypeIdentity,[IdentityType] = @IdentityType,[IsEnable] = @IsEnable,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_Delete
@Id int
 AS 
	DELETE [StaticType]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_GetModel
@Id int
 AS 
	SELECT 
	Id,SiteId,Name,TypeIdentity,IdentityType,IsEnable,CreatedOn,UpdatedOn
	 FROM [StaticType]
	 WHERE Id=@Id 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[StaticType_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [StaticType_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/10/26 17:40:16
------------------------------------
CREATE PROCEDURE StaticType_GetList
 AS 
	SELECT 
	Id,SiteId,Name,TypeIdentity,IdentityType,IsEnable,CreatedOn,UpdatedOn
	 FROM [StaticType]

GO

