﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Models;
using System.Data.SqlClient;
using System.Configuration;


namespace LoveDAL
{
    public static class ArticleCoteService
    {
        private static string connectionString = ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
        //删除文章类别
        public static void DeleteAriCategory(ArticleCote articlecote)
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "delete from articlecote where arti_coteid=@Id";
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@Id", articlecote.Arti_coteid);
                cm.ExecuteNonQuery();
            }
        }
        //修改文章类别
        public static void ModifyNewsCategory(ArticleCote articlecote)
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "update articlecote set arti_cotename=@Name where arti_coteid=@id";
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@Id", articlecote.Arti_coteid);
                cm.Parameters.AddWithValue("@Name", articlecote.Arti_cotename);
                cm.ExecuteNonQuery();
            }

        }
        //将所有的文章类别查出
        public static IList<ArticleCote> GetAriCoteAll()
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "select * from articlecote";
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<ArticleCote> list = new List<ArticleCote>();
                while (dr.Read())
                {
                    ArticleCote arti_cote = new ArticleCote();
                    arti_cote.Arti_coteid = (int)dr["arti_coteid"];
                    arti_cote.Arti_cotename = (string)dr["arti_cotename"];
                    list.Add(arti_cote);
                }
                dr.Close();
                return list;
            }
        }
        //通过文章类别ID查文章类别
        public static ArticleCote GetAriCoteById(int id)
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "select * from articlecote where arti_coteid=@Id";
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@Id", id);
                SqlDataReader dr = cm.ExecuteReader();
                if (dr.Read())
                {
                    ArticleCote arti_cote = new ArticleCote();
                    arti_cote.Arti_coteid = (int)dr["arti_coteid"];
                    arti_cote.Arti_cotename = (string)dr["arti_cotename"];
                    dr.Close();
                    return arti_cote;
                }
                else
                {
                    dr.Close();
                    return null;
                }
            }
        }
        //添加文章类别
        public static bool AddArtiCote(ArticleCote articlecote)
        {
            bool checkAdd = false;
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                string sql = "insert into articlecote(arti_cotename) values(@newscotename)";
                SqlCommand cm = new SqlCommand(sql, cn);
                cm.Parameters.AddWithValue("@newscotename", articlecote.Arti_cotename);
                int check = cm.ExecuteNonQuery();
                if (check == 1)
                {
                    checkAdd = true;
                }
            }
            return checkAdd;
        }
        //修改文章类别
        public static void UpArtiCote(ArticleCote articlecote)
        {
            using (SqlConnection cn = new SqlConnection(connectionString))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "update articlecote set arti_cotename=@Name where arti_coteid=@id";
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@Id", articlecote.Arti_coteid);
                cm.Parameters.AddWithValue("@Name", articlecote.Arti_cotename);
                cm.ExecuteNonQuery();
            }

        }
        //统计条数
        public static int GetArticleNum()
        {
            string sql = "select count(*) from article ";
            using (SqlConnection con = new SqlConnection(connectionString))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                int article_num = Convert.ToInt32(cm.ExecuteScalar());
                return article_num;
            }
        }
    }
}
