﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Configuration;
using Models;


namespace LoveDAL
{
   public static  class InvitationService
    {
       private static string strcon = System.Configuration.ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
       //删除论坛帖子
       public static void DelInvi(Invitation invi)
       {
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               string sql = "delete from invitation where invitation.invitationid=@invi_id";
               SqlCommand cm = new SqlCommand(sql,con);
               cm.Parameters.AddWithValue("@invi_id", invi.Invitationid);
               cm.ExecuteNonQuery();
           }
       }
       //添加论坛帖子
       public static Boolean AddInvi(Invitation invi)
       {
           bool check = false;
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               string sql = "insert into invitation(invi_title,invi_contents,invi_time,userid,invi_click) values(@title,@contents,@invi_time,@userid,@invi_click)";

               SqlCommand cm = new SqlCommand(sql,con);
               cm.Parameters.AddWithValue("@title", invi.Invi_title);
               cm.Parameters.AddWithValue("@contents", invi.Invi_contents);
               cm.Parameters.AddWithValue("@invi_time", System.DateTime.Now);
               cm.Parameters.AddWithValue("@userid", invi.Userid);
               cm.Parameters.AddWithValue("@invi_click", invi.Invi_click);
               int checkAdd=cm.ExecuteNonQuery();
               if (checkAdd == 1)
               {
                   check = true;
               }
           }
           return check;
       }
       //修改论坛帖子
       public static void UpdateInvi(Invitation invi)
       {
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               string sql = "Update invitation set invi_title=@title,invi_contents=@contents,invi_time=@invi_time where invitationid=@id";
               SqlCommand cm = new SqlCommand(sql, con);
               cm.Parameters.AddWithValue("@title", invi.Invi_title);
               cm.Parameters.AddWithValue("@contents", invi.Invi_contents);
               cm.Parameters.AddWithValue("@invi_time", System.DateTime.Now);
               cm.Parameters.AddWithValue("@id", invi.Invitationid);
               cm.ExecuteNonQuery();
           }
       }
       //查询所有的帖子
       public static IList<Invitation> GetInviAll()
       {
           string sql = "select * from invitation order by invi_time desc";
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand();
               cm.Connection = con;
               cm.CommandText = sql;
               SqlDataReader dr = cm.ExecuteReader();
               List<Invitation> list = new List<Invitation>();
               while (dr.Read())
               {
                   Invitation invi = new Invitation();
                   for (int i = 0; i < dr.FieldCount; i++)
                   {
                       string fieldName = dr.GetName(i);
                       if (fieldName == "invitationid")
                       {
                           invi.Invitationid = (int)dr["invitationid"];
                           invi.ReviNum = ReviewService.GetReviewNumber((int)dr["invitationid"]);
                       }
                       if (fieldName == "invi_title")
                       {
                           invi.Invi_title = (string)dr["invi_title"];
                       }
                       if (fieldName == "invi_contents")
                       {
                           invi.Invi_contents = (string)dr["invi_contents"];
                       }
                       if (fieldName == "invi_time")
                       {
                           invi.Invi_time = (DateTime)dr["invi_time"];
                       }
                       if (fieldName == "userid")
                       {
                           invi.Userid = (int)dr["userid"];
                           invi.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                           invi.Userimage = UserService.GetUserByUserId((int)dr["userid"]).Userimage;
                       }
                       if (fieldName == "invi_click")
                       {
                           invi.Invi_click = (int)dr["invi_click"];
                       }

                   }
                   list.Add(invi);
               }
               dr.Close();
               return list;
           }
       }

       //搜索帖子条数
       public static int GetSouInviNum(string str)
       {
           string sql = "select count(*) from invitation where invi_title like '%"+str+"%'";
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand(sql, con);
               int Sou_num = Convert.ToInt32(cm.ExecuteScalar());
               return Sou_num;
           }
       }
       //搜索帖子
       public static IList<Invitation> GetSouInvi(string str)
       {
           string sql = "select * from invitation where invi_title like '%"+str+"%'";
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand();
               cm.Connection = con;
               cm.CommandText = sql;
               SqlDataReader dr = cm.ExecuteReader();
               List<Invitation> list = new List<Invitation>();
               while (dr.Read())
               {
                   Invitation invi = new Invitation();
                   for (int i = 0; i < dr.FieldCount; i++)
                   {
                       string fieldName = dr.GetName(i);
                       if (fieldName == "invitationid")
                       {
                           invi.Invitationid = (int)dr["invitationid"];
                           invi.ReviNum = ReviewService.GetReviewNumber((int)dr["invitationid"]);
                       }
                       if (fieldName == "invi_title")
                       {
                           invi.Invi_title = (string)dr["invi_title"];
                       }
                       if (fieldName == "invi_contents")
                       {
                           invi.Invi_contents = (string)dr["invi_contents"];
                       }
                       if (fieldName == "invi_time")
                       {
                           invi.Invi_time = (DateTime)dr["invi_time"];
                       }
                       if (fieldName == "userid")
                       {
                           invi.Userid = (int)dr["userid"];
                           invi.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                       }
                       if (fieldName == "invi_click")
                       {
                           invi.Invi_click = (int)dr["invi_click"];
                       }

                   }
                   list.Add(invi);
               }
               dr.Close();
               return list;
           }
       }

       //查询部分的帖子
       public static IList<Invitation> GetInviPart()
       {
           string sql = "select top 6 * from invitation order by invi_time desc";
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand();
               cm.Connection = con;
               cm.CommandText = sql;
               SqlDataReader dr = cm.ExecuteReader();
               List<Invitation> list = new List<Invitation>();
               while (dr.Read())
               {
                   Invitation invi = new Invitation();
                   for (int i = 0; i < dr.FieldCount; i++)
                   {
                       string fieldName = dr.GetName(i);
                       if (fieldName == "invitationid")
                       {
                           invi.Invitationid = (int)dr["invitationid"];
                           invi.ReviNum = ReviewService.GetReviewNumber((int)dr["invitationid"]);
                       }
                       if (fieldName == "invi_title")
                       {
                           invi.Invi_title = (string)dr["invi_title"];
                       }
                       if (fieldName == "invi_contents")
                       {
                           invi.Invi_contents = (string)dr["invi_contents"];
                       }
                       if (fieldName == "invi_time")
                       {
                           invi.Invi_time = (DateTime)dr["invi_time"];
                       }
                       if (fieldName == "userid")
                       {
                           invi.Userid = (int)dr["userid"];
                           invi.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                       }
                       if (fieldName == "invi_click")
                       {
                           invi.Invi_click = (int)dr["invi_click"];
                       }

                   }
                   list.Add(invi);
               }
               dr.Close();
               return list;
           }
       }


       //查询点击最高的帖子
       public static IList<Invitation> GetInviClick()
       {
           string sql = "select top 10 * from invitation order by invi_click desc";
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand();
               cm.Connection = con;
               cm.CommandText = sql;
               SqlDataReader dr = cm.ExecuteReader();
               List<Invitation> list = new List<Invitation>();
               while (dr.Read())
               {
                   Invitation invi = new Invitation();
                   for (int i = 0; i < dr.FieldCount; i++)
                   {
                       string fieldName = dr.GetName(i);
                       if (fieldName == "invitationid")
                       {
                           invi.Invitationid = (int)dr["invitationid"];
                           invi.ReviNum = ReviewService.GetReviewNumber((int)dr["invitationid"]);
                       }
                       if (fieldName == "invi_title")
                       {
                           invi.Invi_title = (string)dr["invi_title"];
                       }
                       if (fieldName == "invi_contents")
                       {
                           invi.Invi_contents = (string)dr["invi_contents"];
                       }
                       if (fieldName == "invi_time")
                       {
                           invi.Invi_time = (DateTime)dr["invi_time"];
                       }
                       if (fieldName == "userid")
                       {
                           invi.Userid = (int)dr["userid"];
                           invi.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                       }
                       if (fieldName == "invi_click")
                       {
                           invi.Invi_click = (int)dr["invi_click"];
                       }

                   }
                   list.Add(invi);
               }
               dr.Close();
               return list;
           }
       }
       //通过帖子Id查询帖子,返回list
       public static IList<Invitation> GetInviById(int id)
       {
           string sql = "select * from invitation where invitationid=" + id;

           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand(sql, con);
               SqlDataReader dr = cm.ExecuteReader();
               List<Invitation> list = new List<Invitation>();
               while (dr.Read())
               {
                   Invitation invi = new Invitation();
                   for (int i = 0; i < dr.FieldCount; i++)
                   {
                       string fieldName = dr.GetName(i);
                       if (fieldName == "invitationid")
                       {
                           invi.Invitationid = (int)dr["invitationid"];

                       }
                       if (fieldName == "invi_title")
                       {
                           invi.Invi_title = (string)dr["invi_title"];
                       }
                       if (fieldName == "invi_contents")
                       {
                           invi.Invi_contents = (string)dr["invi_contents"];
                       }
                       if (fieldName == "invi_time")
                       {
                          invi.Invi_time= (DateTime)dr["invi_time"];
                       }
                       if (fieldName == "userid")
                       {
                           invi.Userid = (int)dr["userid"];
                           invi.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                           invi.Userimage = UserService.GetUserByUserId((int)dr["userid"]).Userimage;
                       }
                       if (fieldName == "invi_click")
                       {
                           invi.Invi_click = (int)dr["invi_click"];
                       }
                   }
                   list.Add(invi);
               }
               dr.Close();
               return list;
           }
       }


       //通过用户Id查询帖子,返回list
       public static IList<Invitation> GetInviByUserId(int id)
       {
           string sql = "select * from invitation where userid=" + id;

           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand(sql, con);
               SqlDataReader dr = cm.ExecuteReader();
               List<Invitation> list = new List<Invitation>();
               while (dr.Read())
               {
                   Invitation invi = new Invitation();
                   for (int i = 0; i < dr.FieldCount; i++)
                   {
                       string fieldName = dr.GetName(i);
                       if (fieldName == "invitationid")
                       {
                           invi.Invitationid = (int)dr["invitationid"];
                           invi.ReviNum = ReviewService.GetReviewNumber((int)dr["invitationid"]);

                       }
                       if (fieldName == "invi_title")
                       {
                           invi.Invi_title = (string)dr["invi_title"];
                       }
                       if (fieldName == "invi_contents")
                       {
                           invi.Invi_contents = (string)dr["invi_contents"];
                       }
                       if (fieldName == "invi_time")
                       {
                           invi.Invi_time = (DateTime)dr["invi_time"];
                       }
                       if (fieldName == "userid")
                       {
                           invi.Userid = (int)dr["userid"];
                           invi.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
        
                       }
                       if (fieldName == "invi_click")
                       {
                           invi.Invi_click = (int)dr["invi_click"];
                           
                       }
                   }
                   list.Add(invi);
               }
               dr.Close();
               return list;
           }
       }
       //通过帖子编号查帖子，返回实体类
       public static Invitation GetInvitationById(int invitationid)
       {
           string sql = " select * from invitation where invitationid=" + invitationid;
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand(sql, con);
               SqlDataReader dr = cm.ExecuteReader();

               if (dr.Read())
               {
                   Invitation invi = new Invitation();
                   invi.Invitationid = (int)dr["invitationid"];
                   invi.Invi_title = (string)dr["invi_title"];
                   invi.Invi_click = (int)dr["invi_click"];
                   dr.Close();
                   return invi;

               }
               else
               {
                   dr.Close();
                   return null;
               }
           }
       }
       //通过帖子ID查询帖子回复总数
       public static int GetReviewByInviNum(int invi_id)
       {
           string sql = "select count(*) as reviNum from review where invitationid=@id";
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand(sql, con);
               cm.Parameters.AddWithValue("@id", invi_id);
               int review_num = Convert.ToInt32(cm.ExecuteScalar());
               return review_num;
           }
       }

       //获取帖子总数
       public static int GetInviNum()
       {
           string sql = "select count(*) from invitation ";
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand(sql, con);
               int review_num = Convert.ToInt32(cm.ExecuteScalar());
               return review_num;
           }
       }
       //增加点击数

       public static void UpInvi_click(Invitation invi)
       {
           string sql = "update invitation set invi_click=@invi_click where invitationid=@id ";
           using (SqlConnection con = new SqlConnection(strcon))
           {
               con.Open();
               SqlCommand cm = new SqlCommand(sql, con);
               cm.Parameters.AddWithValue("@invi_click", invi.Invi_click);
               cm.Parameters.AddWithValue("@id", invi.Invitationid);
               cm.ExecuteNonQuery();

           }
       }

       //截取字段
       public static string GetPartString(string invi_contents, int n)
       {
           if (invi_contents.ToString().Length > n - 2)
           {
               return invi_contents.ToString().Substring(0, n - 2) + "...";

           }
           else
           {
               return invi_contents.ToString();

           }
       }
       //public static void PagedList(IList<Invitation> invi,int pageIndex,int pageSize)
       // {
       //     invi = GetInviAll();

       // }

    }
}
