﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Models;
using System.Configuration;
using System.Data.SqlClient;
namespace LoveDAL
{
    public static class NewsService
    {
        
        private static string strcon =System.Configuration.ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
        //删除新闻
        public static void DeleteNews(News news)
        {
            using (SqlConnection cn = new SqlConnection(strcon))
            {
                cn.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = cn;
                string sql = "delete from news where newsid=@Id";
                cm.CommandText = sql;
                cm.Parameters.AddWithValue("@Id", news.Newsid);
                cm.ExecuteNonQuery();
            }
        }
        //添加新闻
        public static Boolean AddNews(News news)
        {
            bool checkAdd = false;
            using (SqlConnection cn = new SqlConnection(strcon))
            {
                cn.Open();
                string sql = "insert into news(title,news_contents,news_author,newstime,news_coteid) values(@title,@contents,@author,@newstime,@coteid)";
                SqlCommand cm = new SqlCommand(sql,cn);
                cm.Parameters.AddWithValue("@title", news.Title);
                cm.Parameters.AddWithValue("@contents", news.News_contents);
                cm.Parameters.AddWithValue("@author", news.News_author);
                cm.Parameters.AddWithValue("@newstime", System.DateTime.Now);
                cm.Parameters.AddWithValue("@coteid", news.News_codeid);
                int check=cm.ExecuteNonQuery();
                if (check == 1)
                {
                    checkAdd = true;
                }
            }
            return checkAdd;
        }
        //修改新闻
        public static void Update(News news)
        {
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                string sql="update news set title=@title,news_contents=@contents,newstime=@newstime where newsid=@newsid";
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@title", news.Title);
                cm.Parameters.AddWithValue("@contents", news.News_contents);
                //cm.Parameters.AddWithValue("@author", news.News_author);
                cm.Parameters.AddWithValue("@newstime", news.Newstime);
                //cm.Parameters.AddWithValue("@coteid", news.News_codeid);
                cm.Parameters.AddWithValue("@newsid", news.Newsid);
                cm.ExecuteNonQuery();
            }
        }
        //查询所有新闻
        public static IList<News> GetNewsAll()
        {
            string sql = "select * from news order by newstime desc";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<News> list = new List<News>();
                while (dr.Read())
                {
                    News news = new News();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "newsid")
                        {
                            news.Newsid = (int)dr["newsid"];

                        }
                        if (fieldName == "title")
                        {
                            news.Title = (string)dr["title"];
                        }
                        if (fieldName == "news_contents")
                        {
                            news.News_contents = (string)dr["news_contents"];
                        }
                        if (fieldName == "news_author")
                        {
                            news.News_author = (string)dr["news_author"];
                        }
                        if (fieldName == "newstime")
                        {
                            news.Newstime = (DateTime)dr["newstime"];
                        }
                        if (fieldName == "news_coteid")
                        {
                            news.News_codeid = (int)dr["news_coteid"];
                            news.News_cotename = NewsCoteService.GetNewsCategoryById((int)dr["news_coteid"]).News_cotename;
                        }

             

                    }
                    list.Add(news);
                }
                dr.Close();
                return list;
            }
        }


        //查询部分新闻
        public static IList<News> GetNewsPartAll()
        {
            string sql = "select top 5 * from news order by newstime desc";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand();
                cm.Connection = con;
                cm.CommandText = sql;
                SqlDataReader dr = cm.ExecuteReader();
                List<News> list = new List<News>();
                while (dr.Read())
                {
                    News news = new News();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "newsid")
                        {
                            news.Newsid = (int)dr["newsid"];

                        }
                        if (fieldName == "title")
                        {
                            news.Title = (string)dr["title"];
                        }
                        if (fieldName == "news_contents")
                        {
                            news.News_contents = (string)dr["news_contents"];
                        }
                        if (fieldName == "news_author")
                        {
                            news.News_author = (string)dr["news_author"];
                        }
                        if (fieldName == "newstime")
                        {
                            news.Newstime = (DateTime)dr["newstime"];
                        }
                        if (fieldName == "news_coteid")
                        {
                            news.News_codeid = (int)dr["news_coteid"];
                            news.News_cotename = NewsCoteService.GetNewsCategoryById((int)dr["news_coteid"]).News_cotename;
                        }



                    }
                    list.Add(news);
                }
                dr.Close();
                return list;
            }
        }
        public static IList<News> GetNewsById(int id)
        {
            string sql = "select * from news where newsid=" + id;

            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql,con);
                SqlDataReader dr = cm.ExecuteReader();
                List<News> list = new List<News>();
                while (dr.Read())
                {
                    News news = new News();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "newsid")
                        {
                            news.Newsid = (int)dr["newsid"];

                        }
                        if (fieldName == "title")
                        {
                            news.Title = (string)dr["title"];
                        }
                        if (fieldName == "news_contents")
                        {
                            news.News_contents = (string)dr["news_contents"];
                        }
                        if (fieldName == "news_author")
                        {
                            news.News_author = (string)dr["news_author"];
                        }
                        if (fieldName == "newstime")
                        {
                            news.Newstime = (DateTime)dr["newstime"];
                        }
                        if (fieldName == "news_coteid")
                        {
                            news.News_codeid = (int)dr["news_coteid"];
                            news.News_cotename = NewsCoteService.GetNewsCategoryById((int)dr["news_coteid"]).News_cotename;
                        }

                    }
                    list.Add(news);
                }
                dr.Close();
                return list;
            }
        }

        public static IList<News> GetNewsByCoteId(int id)
        {
            string sql = "select * from news where news_coteid=" + id + " order by newstime desc";

            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                SqlDataReader dr = cm.ExecuteReader();
                List<News> list = new List<News>();
                while (dr.Read())
                {
                    News news = new News();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "newsid")
                        {
                            news.Newsid = (int)dr["newsid"];

                        }
                        if (fieldName == "title")
                        {
                            news.Title = (string)dr["title"];
                        }
                        if (fieldName == "news_contents")
                        {
                            news.News_contents = (string)dr["news_contents"];
                        }
                        if (fieldName == "news_author")
                        {
                            news.News_author = (string)dr["news_author"];
                        }
                        if (fieldName == "newstime")
                        {
                            news.Newstime = (DateTime)dr["newstime"];
                        }
                        if (fieldName == "news_coteid")
                        {
                            news.News_codeid = (int)dr["news_coteid"];
                            news.News_cotename = NewsCoteService.GetNewsCategoryById((int)dr["news_coteid"]).News_cotename;
                        }

                    }
                    list.Add(news);
                }
                dr.Close();
                return list;
            }
        }

        //统计所有新闻
        public static int GetNewNum()
        {
            string sql = "select count(*) from news ";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                int news_num = Convert.ToInt32(cm.ExecuteScalar());
                return news_num;
            }
        }
        //统计搜索到的新闻
        public static int GetSouNewNum(string str)
        {
            string sql = "select count(*) from news where title like '%" + str + "%'";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                int Sounews_num = Convert.ToInt32(cm.ExecuteScalar());
                return Sounews_num;
            }
        }
        //搜索新闻
        public static IList<News> SouNew(string str)
        {
            string sql = "select * from news where title like '%"+str+"%'";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
               SqlDataReader dr = cm.ExecuteReader();
                List<News> list = new List<News>();
                while (dr.Read())
                {
                    News news = new News();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "newsid")
                        {
                            news.Newsid = (int)dr["newsid"];

                        }
                        if (fieldName == "title")
                        {
                            news.Title = (string)dr["title"];
                        }
                        if (fieldName == "news_contents")
                        {
                            news.News_contents = (string)dr["news_contents"];
                        }
                        if (fieldName == "news_author")
                        {
                            news.News_author = (string)dr["news_author"];
                        }
                        if (fieldName == "newstime")
                        {
                            news.Newstime = (DateTime)dr["newstime"];
                        }
                        if (fieldName == "news_coteid")
                        {
                            news.News_codeid = (int)dr["news_coteid"];
                            news.News_cotename = NewsCoteService.GetNewsCategoryById((int)dr["news_coteid"]).News_cotename;
                        }

                    }
                    list.Add(news);
                }
                dr.Close();
                return list;

            }
        }
        //截取字段
        public static string GetPartString(string news_contents, int n)
        {
            if (news_contents.ToString().Length > n - 2)
            {
                return news_contents.ToString().Substring(0, n - 2) + "...";

            }
            else
            {
                return news_contents.ToString();

            }
        }

    }
}
