﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using Models;

namespace LoveDAL
{
   public static  class ReviewService
    {
        private static string strcon = System.Configuration.ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
       //添加回复
       public static int AddReview(Reviews review, int invitationid)
        {
            string sql = "insert review(invitationid,userid,revi_contents,submit_date) values(@invitationid,@userid,@revi_contents,@submit_date)";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@invitationid", invitationid);
                cm.Parameters.AddWithValue("@userid",review.Userid);
                cm.Parameters.AddWithValue("@revi_contents", review.Revi_contents);
                cm.Parameters.AddWithValue("@submit_date", System.DateTime.Now);
                return cm.ExecuteNonQuery();
            }
        }
       //通过帖子编号查回复
        public static IList<Reviews> GetReviewByInviId(int Invitationid)
        {
            string sql = "select * from review where invitationid=@Invitationid";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@Invitationid", Invitationid);
                SqlDataReader dr = cm.ExecuteReader();
                List<Reviews> list = new List<Reviews>();
                while (dr.Read())
                {
                    Reviews review = new Reviews();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "revi_id")
                        {
                            review.Revi_id = (int)dr["revi_id"];

                        }
                        if (fieldName == "invitationid")
                        {
                            review.Invitationid = (int)dr["invitationid"];
                            review.Invi_title = InvitationService.GetInvitationById((int)dr["invitationid"]).Invi_title;
                            review.Invi_click = InvitationService.GetInvitationById((int)dr["invitationid"]).Invi_click;
                        } 
                        if (fieldName == "userid")
                        {
                            review.Userid = (int)dr["userid"];
                            review.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                            review.Userimage = UserService.GetUserByUserId((int)dr["userid"]).Userimage;
                        }
                        if (fieldName == "revi_contents")
                        {
                            review.Revi_contents = (string)dr["revi_contents"];
                        }
                        if (fieldName == "submit_date")
                        {
                            review.Submit_date = (DateTime)dr["submit_date"];
                        }
                       


                    }
                    list.Add(review);
                }
                dr.Close();
                return list;
            }
        }
       // 通过帖子编号查回复次数
        public static int GetReviewNumber(int invitationid)
        {
            string sql = "select count(*) from review where invitationid=@invitationid";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@invitationid", invitationid);
                int review_num = Convert.ToInt32(cm.ExecuteScalar());
                return review_num;

            }
        }
       //最新回复
        public static IList<Reviews> GetReviewNew()
        {
            string sql = "select top4 * from review order by submit_date desc";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                SqlDataReader dr = cm.ExecuteReader();
                List<Reviews> list = new List<Reviews>();
                while (dr.Read())
                {
                    Reviews review = new Reviews();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "revi_id")
                        {
                            review.Revi_id = (int)dr["revi_id"];
                        }
                        if (fieldName == "userid")
                        {
                            review.Userid = (int)dr["userid"];
                            review.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;

                        }
                        if (fieldName == "revi_contents")
                        {
                            review.Revi_contents = (string)dr["revi_contents"];
                        }
                        if (fieldName == "submit_date")
                        {
                            review.Submit_date = (DateTime)dr["submit_date"];

                        }

                    }
                    list.Add(review);

                }
                dr.Close();
                return list;
            }
        }
       //全部回复
        public static IList<Reviews> GetReviewAll()
        {
            string sql = "select * from review order by submit_date desc";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                SqlDataReader dr = cm.ExecuteReader();
                List<Reviews> list = new List<Reviews>();
                while (dr.Read())
                {
                    Reviews review = new Reviews();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "revi_id")
                        {
                            review.Revi_id = (int)dr["revi_id"];
                        }
                        if (fieldName == "userid")
                        {
                            review.Userid = (int)dr["userid"];
                            review.Username = UserService.GetUserByUserId((int)dr["userid"]).Username;
                        }
                        if (fieldName == "revi_contents")
                        {
                            review.Revi_contents = (string)dr["revi_contents"];
                        }
                        if (fieldName == "submit_date")
                        {
                            review.Submit_date = (DateTime)dr["submit_date"];
                        }
                    }
                    list.Add(review);
                }
                dr.Close();
                return list;
            }
        }
        //删除回复
        public static void DelRevi(Reviews revi)
        {
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                string sql = "delete from review where revi_id=@invi_id";
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@invi_id", revi.Revi_id);
                cm.ExecuteNonQuery();
            }
        }
    }
}
