﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Models;
using System.Configuration;
using System.Data.SqlClient;
namespace LoveDAL
{
    public static class UserService
    {
        private static string strcon = System.Configuration.ConfigurationManager.ConnectionStrings["strCon"].ConnectionString;
        
        public static SqlDataReader sdr(string sql)
        {


            string s = "select * from [user] " + sql;
            SqlConnection con = new SqlConnection(strcon);

            con.Open();
            SqlCommand cm = new SqlCommand(s, con);
            SqlDataReader dr = cm.ExecuteReader();
            return dr;


        }
        //查询用户名和密码
        public static User QueryUser(User user)
        {
            string sql = "where username='" + user.Username + "' and pwd ='" + user.Pwd + "'";
            SqlDataReader dr = sdr(sql);
            if (dr.Read())
            {
                User vuser = new User();
                vuser.Userid = (int)dr["userid"];
                vuser.Username = (string)dr["username"];
                vuser.Pwd = (string)dr["pwd"];
                vuser.Lim = (int)dr["lim"];
                dr.Close();
                return vuser;

            }
            else
            {
                dr.Close();
                return null;
            }
        }
        //是否存在用户名
        public static bool QueryUserName(User user)
        {
            string sql = " where username ='" + user.Username + "'";
            SqlDataReader dr = sdr(sql);
            if (dr.Read())
            {
                dr.Close();
                return true;
            }
            else
            {
                dr.Close();
                return false;
            }
        }
        //通过用户编号查找用户名
        public static User GetUserByUserId(int userid)
        {
            string sql = " where userid=" + userid;
            SqlDataReader dr = sdr(sql);
            if (dr.Read())
            {
                User user = new User();
                user.Userid = (int)dr["userid"];
                user.Username = (string)dr["username"];
                user.Userimage = (string)dr["userimage"];
                dr.Close();
                return user;

            }
            else
            {
                dr.Close();
                return null;
            }
        }
        //获取所有的用户
        public static IList<User> GetUserAll()
        {
            string sql = "select * from [user] ";//order by username desc
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                SqlDataReader dr = cm.ExecuteReader();
                List<User> list = new List<User>();
                while (dr.Read())
                {
                    User user = new User();
                    for (int i = 0; i < dr.FieldCount; i++)
                    {
                        string fieldName = dr.GetName(i);
                        if (fieldName == "userid")
                        {
                            user.Userid = (int)dr["userid"];
                        }
                        if (fieldName == "username")
                        {
                            user.Username = (string)dr["username"];
                        }
                        if (fieldName == "pwd")
                        {
                            user.Pwd = (string)dr["pwd"];
                        }
                        if (fieldName == "lim")
                        {
                            user.Lim = (int)dr["lim"];
                        }
                       
                    }
                    list.Add(user);
                }
                dr.Close();
                return list;
            }
        }
        public static void AddUser(User inUser)
        {
            string sql = @"insert [user](username,pwd,lim,userimage) values(@username,@pwd,@lim,@userimage)";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@username", inUser.Username);
                cm.Parameters.AddWithValue("@pwd", inUser.Pwd);
                cm.Parameters.AddWithValue("@lim",inUser.Lim);
                cm.Parameters.AddWithValue("@userimage", inUser.Userimage);
                //cm.Parameters.AddWithValue("@login_date", System.DateTime.Now);
                cm.ExecuteNonQuery();

            }
        }
        public static User GetIdByUsername(string username)
        {
            string sql = " where username='" + username+"'";
            SqlDataReader dr = sdr(sql);
            if (dr.Read())
            {
                User user = new User();
                user.Userid = (int)dr["userid"];
                user.Username = (string)dr["username"];
                user.Userimage = (string)dr["userimage"];
                dr.Close();
                return user;

            }
            else
            {
                dr.Close();
                return null;
            }
        }
        //删除用户
        public static void Del(User user)
        {
            string sql = "delete from [user] where userid=@id";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@id", user.Userid);
                cm.ExecuteNonQuery();
            }
        }
        //修改用户
        public static void UpUser(User user)
        {
            string sql = "update [user] set username=@username,pwd=@pwd,lim=@lim where userid=@userid";
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@username", user.Username);
                cm.Parameters.AddWithValue("@pwd", user.Pwd);
                cm.Parameters.AddWithValue("@lim", user.Lim);
                cm.Parameters.AddWithValue("@userid", user.Userid);
                cm.ExecuteNonQuery();
            }
        }
        //修改密码
        public static bool UpPwd(User user)
        {
            string sql = "update [user] set pwd=@pwd where userid=@userid";
            bool c=false;
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
                cm.Parameters.AddWithValue("@pwd", user.Pwd);
                cm.Parameters.AddWithValue("@userid", user.Userid);
               int check=cm.ExecuteNonQuery();
               if (check == 1)
               {
                   c = true;
               }
               return c;
                
            }
        }

        //修改头像
        public static bool UpUserImage(User user)
        {
            string sql = "update [user] set userimage=@userimage where userid=@userid";
            bool c = false;
            using (SqlConnection con = new SqlConnection(strcon))
            {
                con.Open();
                SqlCommand cm = new SqlCommand(sql, con);
               //cm.Parameters.AddWithValue("@pwd", user.Pwd);
               cm.Parameters.AddWithValue("@userimage", user.Userimage);
                cm.Parameters.AddWithValue("@userid", user.Userid);
                int check = cm.ExecuteNonQuery();
                if (check == 1)
                {
                    c = true;
                }
                return c;

            }
        }
    }
}
