﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LoveBLL;
using Models;

namespace LoveWeb.Admin
{
    public partial class newsManager : System.Web.UI.Page
    {
        public static string GetPartString(string news_contents, int num)
        {
            return NewsManager.GetPartString(news_contents, num);
        }

        public void PageBind()
        {
            PagedDataSource pds = new PagedDataSource();
            pds.DataSource = NewsManager.GetAllNews();
            pds.AllowPaging = true;//设置PagedDataSource允许分页
            pds.PageSize = AspNetPager1.PageSize;//将PagedDataSource分页设置成ASPNetPaging的分页
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            AspNetPager1.RecordCount = NewsManager.GetNewsNum();//获取所有的新闻记录条数
            DataList1.DataSource = pds;
            DataList1.DataBind();

        }
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                PageBind();
            }
           
        }

        protected void AspNetPager1_PageChanged(object sender, EventArgs e)
        {
            PageBind();
        }
    }
}
