﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LoveBLL;
using Models;

namespace LoveWeb.Login
{
    public partial class Login : System.Web.UI.Page
    {
        

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                Create();
                if (Request.Cookies["userName"] != null)
                {
                    string loginName = Request.Cookies["userName"].Value;
                    txtLogName.Text = loginName;
                }
                else
                {
                    txtLogName.Text = "";
                }
            }
        }
        

        protected void btn2Register_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Login/Register.aspx");
        }

        protected void btnLogin_Click(object sender, EventArgs e)
        {
            //!CheckCode()
            if (!CheckCode())
            {
                Response.Write("<script>alert('验证码错误，请重新输入');this.location.href='login.aspx'</script>");
            }
            else
            {
                string loginName = txtLogName.Text.Trim();
                string loginPwd = txtLogPwd.Text.Trim();
                User user = new User();
                user.Username = loginName;
                user.Pwd = loginPwd;
                if (UserManager.UserLogin(user, out user))
                {

                    if (user.Lim == 2)//判断是否为普通用户
                    {
                        Session["username"] = txtLogName.Text;
                        if (Session["sort"] != null)
                        {
                            if (Session["sort"].Equals("Forum_Add"))
                            {

                                Response.Redirect("~/Forum_Add.aspx");
                            }
                            else if (Session["sort"].Equals("ForumView"))
                            {
                                Response.Redirect("~/ForumView.aspx");
                            }
                            else if (Session["sort"].Equals("Soul"))
                            {
                                Response.Redirect("~/SoulAdd.aspx");
                            }
                            else
                            {
                                Response.Redirect("index.aspx");
                            }
                        }
                        else
                        {
                            Session["username"] = txtLogName.Text;
                            //Response.Write("<script>alert('登录成功！欢迎您！" + txtLogName.Text + "')</script>");
                            Response.Redirect("UserPage.aspx");
                            //Response.Redirect("~/index.aspx");
                        }
                       
                    }
                    else
                    {
                        System.Web.Security.FormsAuthentication.SetAuthCookie(user.Lim.ToString(), false);
                        FormsAuthenticationTicket ticket = new FormsAuthenticationTicket(user.Lim.ToString(), true, 30);
                        string hashtiket = FormsAuthentication.Encrypt(ticket);
                        HttpCookie cookie = new HttpCookie(FormsAuthentication.FormsCookieName, hashtiket);
                        Response.Cookies.Add(cookie);
                        Response.Redirect("~/Admin/AdminIndex.aspx");
                    }
                }
            }  
        }

        protected void chkBox_CheckedChanged(object sender, EventArgs e)
        {
            HttpCookie NameCookie = new HttpCookie("userName", txtLogName.Text.Trim());
            Response.Cookies.Add(NameCookie);
        }

        protected void LinkButton1_Click(object sender, EventArgs e)
        {
            //SerialNumber1.Create();//生成新的验证码
            Create();
        }

        public void Create()
        {
            do
            {
                SerialNumber1.Create();
            }
            while (SerialNumber1.SN.ToString().Length != 4);
            
        }
        

        private bool CheckCode()
        {
            if (SerialNumber1.CheckSN(txtVerify.Text.Trim()))//判断输入的验证码是否正确
            {
                return true;
            }

            else
            {
                SerialNumber1.Create();
                return false;
            }
        }
    }
}
