﻿(function($){
	$.scrollBtn = function(options) {
		var opts = $.extend({}, $.scrollBtn.defaults, options);

		var $scrollBtn = $('<div></div>').css({
							bottom: opts.bottom + 'px',
							right: opts.right + 'px'
						}).addClass('scroll-up')
						.attr('title', opts.title)
						.click(function() {
							$('html, body').animate({scrollTop: 0}, opts.duration);
						}).appendTo('body');
																			
		$(window).bind('scroll', function() {
			var scrollTop = $(document).scrollTop(),
				viewHeight = $(window).height();

			if(scrollTop <= opts.showScale) {
				if($scrollBtn.is(':visible'))
					$scrollBtn.fadeOut(500);
			} else {
				if($scrollBtn.is(':hidden')) 
					$scrollBtn.fadeIn(500);
			}

			if(isIE6()) {
				var top = viewHeight + scrollTop - $scrollBtn.outerHeight() - opts.bottom;
				$scrollBtn.css('top', top + 'px');
			}
		});

		function isIE6() {
			if($.browser.msie) {
				if($.browser.version == '6.0') return true;
			}
		}
	};			
	$.scrollBtn.defaults = {
		showScale: 100,  
		right:20,
		bottom:20,
		duration:100,
		title:'返回页顶'
	}
})(jQuery);
$(document).ready(function(){
    $.scrollBtn({
	    showScale: 200,
	    bottom:20,
	    right:20
    });
});