﻿(function($)
{
	$.fn.marquee = function (opt, callback, endCallback)
	{
		var _this	= $(this);  //滚动对象
		var defa	= {  //默认值
			direction	: 'up',
			next		: 'next',
			prev		: 'prev',
			play		: 'play',
			pause		: 'pause',
			autoPlay	: false,
			perPage		: 22,
			step		: 1,
			waitTime	: 2000,
			delayTime	: 500,
			length		: 0,
			conType		: 'ul > li',
			controller	: '',
			cType		: 'click',
			loop		: true
		}
		var opts	= $.fn.extend(defa, opt);
		var dArray	= {  //方向JSON
			'top'		: 0,
			'up'		: 0,
			'bottom'	: 1,
			'down'		: 1,
			'left'		: 2,
			'right'		: 3
		};
		var marqId	= [null, null];  //时间ID
		var marqInd	= 0;  //当前序号
		if (opts.length > 0)
		{
			var marqLen	= opts.length;
		}
		else
		{
			var marqLen	= _this.find('>' + opts.conType).length;
		}
		var hasCallBack		= arguments[1] ? true : false;
		var hasEndCallBack	= arguments[2] ? true : false;
		if (typeof opts.direction == 'string')
		{
			opts.direction = dArray[opts.direction.toString().toLowerCase()];
		}
		if (opts.direction < 0 || opts.direction > 3)
		{
			opts.direction = 0;
		}

		if (opts.loop)
		{
			//生成HTML
			if (opts.direction <= 1)
			{
				_this.html('<div>' + _this.html() + '</div><div>' + _this.html() + '</div>');
			}
			else
			{
				_this.html('<div style="width:8000px;"><div style="float:left;">' + _this.html() + '</div><div style="float:left;">' + _this.html() + '</div></div>');
			}
		}
		else
		{
			if (opts.direction > 1)
			{
				_this.html('<div style="width:' + (marqLen * opts.perPage) + 'px;">' + _this.html() + '</div>');
			}
		}

		//初始化
		function initialize ()
		{
			clsTimeId();
			var isWait	= arguments[0] == null ? true : false;

			if (isWait)
			{
				marqId[1]	= setInterval(function(){
					scroll();
				}, opts.waitTime);
			}
			else
			{
				scroll();
				if (arguments[1] != null) opts.direction = parseInt(arguments[1]);
				if (opts.autoPlay)
				{
					initialize();
				}
			}
		}

		//控制器
		if (opts.controller != '')
		{
			var cs = $(opts.controller);
			cs.each(function(i){
				$(this).bind(opts.cType, function(){
					if (opts.cType == 'mouseover')
					{
						var cid = setTimeout(function(){
							marqInd = i - 1;
							pause();
							initialize(false);
						}, 100);
						$(this).bind('mouseout', function(){
							if (cid) clearTimeout(cid);
						});
					}
					else
					{
						marqInd = i - 1;
						pause();
						initialize(false);
					}
					return false;
				});
			});
		}

		//滚动核心函数
		function scroll ()
		{
			switch (opts.direction)
			{
				case 0:  //向上
					_this.animate({
						'scrollTop' : (marqInd + opts.step) * opts.perPage
					}, opts.delayTime, 'swing', function(){
						marqInd	= marqInd + opts.step;
						if (opts.loop)
						{
							if (marqInd >= marqLen)
							{
								marqInd = 0;
								_this.scrollTop(0);
							}
						}
						else
						{
							if (marqInd >= marqLen - 1)
							{
								pause();
								marqInd = marqLen - 1;
								if (hasEndCallBack) endCallback('end');
							}
							else {
								if (hasEndCallBack) endCallback('');
							}
						}
						if (hasCallBack) callback(marqInd, marqLen);
					});
				break;

				case 1:  //向下
					_this.animate({
						'scrollTop' : (marqInd - opts.step) * opts.perPage
					}, opts.delayTime, 'swing', function(){
						marqInd	= marqInd - opts.step;
						if (opts.loop)
						{
							if (marqInd <= 0)
							{
								marqInd	= marqLen;
								_this.scrollTop(marqLen * opts.perPage);
							}
						}
						else
						{
							if (marqInd <= 0)
							{
								pause();
								marqInd = 0;
								if (hasEndCallBack) endCallback('begin');
							}
							else {
								if (hasEndCallBack) endCallback('');
							}
						}
						if (hasCallBack) callback(marqInd, marqLen);
					});
				break;

				case 2:  //向左
					_this.animate({
						'scrollLeft' : (marqInd + opts.step) * opts.perPage
					}, opts.delayTime, 'swing', function(){
						marqInd	= marqInd + opts.step;
						if (opts.loop)
						{
							if (marqInd >= marqLen)
							{
								marqInd	= 0;
								_this.scrollLeft(0);
							}
						}
						else
						{
							if (_this.scrollLeft() + _this.width() == marqLen * opts.perPage)
							{
								pause();
								if (marqInd >= marqLen)
								{
									marqInd	= marqLen - 1;
								}
								if (hasEndCallBack) endCallback('end');
							}
							else {
								if (hasEndCallBack) endCallback('');
							}
						}
						if (hasCallBack) callback(marqInd, marqLen);
					});
				break;

				case 3:  //向右
					_this.animate({
						'scrollLeft' : (marqInd - opts.step) * opts.perPage
					}, opts.delayTime, 'swing', function(){
						marqInd	= marqInd - opts.step;
						if (opts.loop)
						{
							if (marqInd <= 0)
							{
								marqInd	= marqLen;
								_this.scrollLeft(marqLen * opts.perPage);
							}
						}
						else
						{
							if (_this.scrollLeft() == 0)
							{
								pause();
								if (marqInd <= 0)
								{
									marqInd = 0;
								}
								if (hasEndCallBack) endCallback('begin');
							}
							else {
								if (hasEndCallBack) endCallback('');
							}
						}
						if (hasCallBack) callback(marqInd, marqLen);
					});
				break;
			}
		}

		//暂停
		function pause ()
		{
			_this.stop();
			clsTimeId();
		}
		//继续
		function cont ()
		{
			if (opts.autoPlay)
			{
				initialize();
			}
		}

		//如果自动播放，则开启滚动
		if (opts.autoPlay)
		{
			initialize();
		}

		//添加控制按钮：向左，向右，暂停/播放
		if ($('#' + opts.next).length == 0)
		{
			$('body').append('<div id="'+ opts.next +'" style="display:none;"></div>');
		}
		$('#' + opts.next).click(function(){
			pause();
			initialize(false);
			return false;
		});

		if ($('#' + opts.prev).length == 0)
		{
			$('body').append('<div id="'+ opts.prev +'" style="display:none;"></div>');
		}
		$('#' + opts.prev).click(function(){
			pause();
			switch (opts.direction)
			{
				case 0:
					opts.direction = 1;
					initialize(false, 0);
				break;

				case 1:
					opts.direction = 0;
					initialize(false, 1);
				break;

				case 2:
					opts.direction = 3;
					initialize(false, 2);
				break;

				case 3:
					opts.direction = 2;
					initialize(false, 3);
				break;
			}
			return false;
		});

		if ($('#' + opts.pause).length == 0)
		{
			$('body').append('<div id="'+ opts.pause +'" style="display:none;"></div>');
		}
		$('#' + opts.pause).click(function(){
			pause();
			return false;
		});

		if ($('#' + opts.play).length == 0)
		{
			$('body').append('<div id="'+ opts.play +'" style="display:none;"></div>');
		}
		$('#' + opts.play).click(function(){
			initialize();
			return false;
		});
		//===============

		//添加鼠标移入/移出 事件
		_this.hover(function(){
			pause();
		}, function(){
			cont();
		});

		//清除时钟
		function clsTimeId ()
		{
			var id = arguments[0] == null ? 1 : arguments[0];
			if (marqId[id] != null)
			{
				clearInterval(marqId[id]);
			}
		}
	}
})(jQuery);