﻿using System;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Runtime.Serialization.Json;
using System.Data;
using System.IO;
using System.Text;
using xabaraCOM;
using DS.Web.UCenter.Client;
using DS.Web.UCenter;

public class webPublic
{
    user u = new user();
    sqlServer sql = new sqlServer();
    ipAddress ip = new ipAddress();
    javasrcipt js = new javasrcipt();
    email e = new email();
    fileDocument f = new fileDocument();
    classify c = new classify();

    #region 新会员注册
    /// <summary>
    /// 新会员注册
    /// </summary>
    /// <param name="uID">user_card_qq_alipay</param>
    /// <param name="email">邮箱</param>
    /// <param name="mobile">手机号码</param>
    /// <param name="pw">密码</param>
    /// <param name="name">姓名</param>    
    public void regUser(string uID, string email, string mobile, string pw, string name)
    {
        string checkStr = string.Empty;
        string userCardID = xabara.md5(xabara.rnd("name", 5)).ToUpper();
        //传递api接口已登录信息
        HttpContext.Current.Session.Add("bbsApi", userCardID + "|" + email);

        string[] id = uID.Split(new char[] { '^' });
        string[] strValue = new string[30];
        strValue[0] = id[1].ToLower();
        if (id[0].Equals("user"))
        {
            checkStr = u.txtCheck(id[1], "userID", "useridCN", 2, 20, "");    //用户名
            if (string.IsNullOrEmpty(checkStr as string))
            {
                checkStr = u.txtCheck(email, "userEmail", "email", 0, 0, "");    //邮箱

                if (string.IsNullOrEmpty(checkStr as string))
                {
                    checkStr = u.txtCheck(mobile, "userMobile", "mobile", 0, 0, ""); //手机号码
                }
            }
        }
        else
        {
            //一键登录捆绑帐号
            if (!string.IsNullOrEmpty(HttpContext.Current.Session["UserRndNums"] as string))
            {
                string ucID = HttpContext.Current.Request.Cookies["XabaraUser"]["userCardID"].ToString().Trim();
                string upStr = sql.update("xabaraUser", "@" + id[0] + "ID", strValue, " userCardID='" + ucID + "'");
                if (upStr.Equals("更新成功"))
                {
                    checkStr = "绑定帐号成功！";
                }
                else
                {
                    checkStr = "绑定帐号失败！";
                }
            }
        }

        if (string.IsNullOrEmpty(checkStr as string))
        {
            string dimStr = "@" + id[0] + "ID,@userLevel,@userLevelDate,@jiFen,@userPW,@userName,@userBirthday,@userEmail,@loginFlag,@loginNum,@LoginDate,@LoginIP,@SessionError,@PostDate,@userCardID,@userProvince,@userCity,@userArea,@userMobile";

            strValue[1] = "0";
            strValue[2] = "2010-06-06";
            strValue[3] = "0";
            strValue[4] = xabara.md5(pw);
            strValue[5] = name;
            strValue[6] = "1970-10-01";
            strValue[7] = email.ToLower();
            strValue[8] = "1";
            strValue[9] = "0";
            strValue[10] = datetime.format(true, "");
            strValue[11] = ip.address();
            strValue[12] = "www.xabara.com";
            strValue[13] = datetime.format(true, "");
            strValue[14] = userCardID;
            strValue[15] = "0";
            strValue[16] = "0";
            strValue[17] = "0";
            strValue[18] = mobile;

            string webTitle = xml.read("xabara.config", "webName", 180);
            if (sql.add("XabaraUser", dimStr, strValue).Equals("发布成功"))
            {
                double regMoney = Convert.ToDouble(xml.read("xabara.config", "regMoney", 180));    //判断用户初始注册送钱，体验功能
                if (regMoney > 0)
                {
                    //写入数据库
                    DateTime dTime = DateTime.Now;
                    string rndID = dTime.ToString("yyyyMMddHHmmss") + xabara.rnd("123", 5);
                    string strDim = "@uID,@rndID,@remitName,@remitBank,@remitMoney,@remitDate,@remitType,@remitInfo,@remitImg,@adminPass,@postDate,@postIP,@adminDate";
                    strValue[0] = userCardID;
                    strValue[1] = rndID;
                    strValue[2] = name;
                    strValue[3] = webTitle;
                    strValue[4] = regMoney.ToString();
                    strValue[5] = dTime.ToString("yyyy-MM-dd HH:mm:ss");
                    strValue[6] = "system";
                    strValue[7] = "注册新会员赠送";
                    strValue[8] = string.Empty;
                    strValue[9] = "12"; //支付宝付款审核状态
                    strValue[10] = dTime.ToString("yyyy-MM-dd HH:mm:ss");
                    strValue[11] = ip.address();
                    strValue[12] = dTime.ToString("yyyy-MM-dd HH:mm:ss");
                    sql.add("moneyBankRemit", strDim, strValue);

                    strDim = "@uID,@orderID,@addMoney,@subtractMoney,@nowMoney,@buyMoney,@moneyInfo,@adminID,@postDate,@postIP";   //增加帐户余额
                    strValue[0] = userCardID;
                    strValue[1] = rndID;
                    strValue[2] = regMoney.ToString();
                    strValue[3] = "0";
                    strValue[4] = regMoney.ToString();
                    strValue[5] = "0";
                    strValue[6] = "注册新会员赠送";
                    strValue[7] = "system";
                    strValue[8] = dTime.ToString("yyyy-MM-dd HH:mm:ss");
                    strValue[9] = ip.address();
                    sql.add("moneyDetail", strDim, strValue);
                }

                string bodyHtml = @"
<table width='100%' border='0' cellpadding='3' cellspacing='3'>
 <tr>
    <td>亲爱的 <strong>" + name + @"</strong> ：您好！</td>
  </tr>
  <tr>
    <td>　　恭喜您成为" + webTitle + @"的用户，同时感谢您对" + webTitle + @"的关注与支持并欢迎您使用" + webTitle + @"的产品与服务。请您妥善保管好帐号信息，以免给您带来不必要的损失！<br />　　用户名：<span class='redFont'>" + id[1] + @"</span><br />　　密　码：<span class='redFont'>" + pw + @"</span><br /><br />　　登陆&nbsp;" + webTitle + @"&nbsp;<a href='' target='_blank'></a> ，检验用户名及密码。并可在&nbsp;[&nbsp;<a href='http://" + url.domain + @"/member/' target='_blank'>会员中心</a>&nbsp;]&nbsp;中修改您的密码。<br />　　注意：一键登录用户，无法输入以上信息直接登陆，但切记初始密码！</td>
  </tr>  
</table>
";
                e.add(userCardID, "user", 0, email, "新会员注册", "您好，您已经成功注册为 " + webTitle + "的会员！", bodyHtml, true);


                HttpContext.Current.Session.Add("regIf", "ok");   //判断新注册用户不需要邮箱验证
                u.login(userCardID, email, "", "", true, false);
            }
            else
            {
                js.div(false, "注册提示", "text", "新会员注册失败！", 350, 0, "", "");
            }
        }
        else
        {
            js.div(false, "操作提示", "text", checkStr, 400, 0, "/member/user/my.aspx", "top");
        }
    }
    #endregion

    #region 检查会员资料
    /// <summary>
    /// 检查会员信息资料
    /// </summary>
    /// <returns></returns>
    public bool checkUserInfo()
    {
        bool login = false;
        string userID = string.Empty;

        if (HttpContext.Current.Request.Cookies["XabaraUser"] != null)
        {
            userID = HttpContext.Current.Request.Cookies["XabaraUser"]["userCardID"].ToString().Trim();
        }

        if (!string.IsNullOrEmpty(userID as string))
        {
            DataTable dt;
            string strSql = "select * from XabaraUser where userCardID='" + userID + "'";
            dt = sql.getDataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                if (dt.Rows[0]["userArea"].ToString().Trim().Equals("0") || dt.Rows[0]["userZip"].ToString().Trim().Equals("0") || dt.Rows[0]["userMobile"].ToString().Trim().Equals("0"))
                {
                    js.div(false, "", "text", "您的资料还不够完善，请完善后再发布！", 350, 0, "/member/user/edit.aspx", "top");
                }
                else
                {
                    if (xabara.isNum(xml.read("xabara.config", "emailCheck", 120)) > 0)
                    {
                        if (string.IsNullOrEmpty(dt.Rows[0]["userEmailDate"].ToString().Trim() as string))
                        {
                            if (string.IsNullOrEmpty(HttpContext.Current.Session["regIf"] as string))   //新注册用户不需要验证
                            {
                                js.div(false, "", "text", "您的邮箱还没认证，请及时认证！", 350, 0, "/member/user/email.aspx", "top");
                            }
                            else
                            {
                                login = true;
                            }
                        }
                        else
                        {
                            login = true;
                        }
                    }
                }
            }
            else
            {
                js.div(false, "", "text", "您的登录有异常，请重新登录！", 350, 0, "/member/user/exit.aspx", "top");
            }
            dt.Dispose();
        }
        else
        {
            HttpContext.Current.Response.Redirect("/member/", true);
        }

        return login;
    }
    #endregion

    #region 读取json
    /// <summary>
    /// 读取json数据
    /// </summary>
    /// <param name="jsonString">字符串</param>
    /// <returns></returns>
    public static T JsonToObject<T>(string jsonString)
    {
        DataContractJsonSerializer ser = new DataContractJsonSerializer(typeof(T));
        MemoryStream ms = new MemoryStream(Encoding.UTF8.GetBytes(jsonString));
        T jsonObject = (T)ser.ReadObject(ms);
        ms.Close();
        return jsonObject;
    }
    #endregion

    #region 组件checkBoxList
    /// <summary>
    /// 读取组件checkBoxList初始值
    /// </summary>
    /// <param name="box">checkboxlist 组件名</param>
    /// <param name="str">字符串值</param>
    /// <returns></returns>
    public bool checkBoxRead(CheckBoxList box, string str)
    {
        for (int i = 0; i < box.Items.Count; i++)
        {
            if (str.IndexOf(box.Items[i].Value) > -1)
            {
                box.Items[i].Selected = true;
            }
        }
        return true;
    }

    /// <summary>
    /// 获取checkBoxList值
    /// </summary>
    /// <param name="box">checkboxlist 组件名</param>
    /// <param name="selectNums">至少选择项数</param>
    /// <returns></returns>
    public string checkBoxValue(CheckBoxList box, int selectNums)
    {
        string str = string.Empty;
        int sNums = 0;
        for (int i = 0; i < box.Items.Count; i++)
        {
            if (box.Items[i].Selected == true)
            {
                str += box.Items[i].Value.Trim() + "|";
                sNums += 1;
            }
        }

        if (selectNums > sNums)
        {
            js.div(false, "", "text", "请检查一下多选框，必须要选中 " + selectNums.ToString() + " 项！", 350, 0, "", "");
        }
        else
        {
            str = "|" + str;
        }

        return str;
    }
    #endregion

    #region 支付接口
    /// <summary>
    /// 支付接口更新状态
    /// </summary>
    /// <param name="payName">支付平台商</param>
    /// <param name="trade_no">支付平台交易号</param>
    /// <param name="order_no">站内订单号</param>
    /// <param name="userCheckLogin">是否检查会员登录状态</param>
    public void payUpdate(string payName, string trade_no, string order_no, bool userCheckLogin)
    {
        if (userCheckLogin) //检查登录状态
        {
            u.check("", url.before);
        }

        DataTable dt;
        double myMoney = 0;
        double myBuyMoney = 0;
        string userID = string.Empty;

        //取单子状态
        string strSql = "select * from moneyBankRemit where rndID='" + order_no + "' and adminPass=11 and remitBank='" + payName + "在线支付'";
        //HttpContext.Current.Response.Write(strSql);
        //HttpContext.Current.Response.End();
        dt = sql.getDataTable(strSql);
        if (dt.Rows.Count > 0)
        {
            string total_fee = dt.Rows[0]["remitMoney"].ToString();

            userID = dt.Rows[0]["uID"].ToString().Trim();

            DataTable dtMoney = sql.getDataTable("select top 1 * from moneyDetail where uID='" + userID + "' order by dID DESC");  //取原余额及已消费额
            if (dtMoney.Rows.Count > 0)
            {
                myMoney = Convert.ToDouble(dtMoney.Rows[0]["nowMoney"]);
                myBuyMoney = Convert.ToDouble(dtMoney.Rows[0]["buyMoney"]);
            }
            dtMoney.Dispose();

            //更新moneyBankRemit状态为12 
            string strDim = "@adminPass,@adminID,@adminDate,@adminIP,@remitInfo";
            string[] strValue = new string[30];
            strValue[0] = "12"; //更新支付宝状态为12 表示有效
            strValue[1] = "alipay";
            strValue[2] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            strValue[3] = ip.address();
            strValue[4] = "交易号：" + trade_no;
            sql.update("moneyBankRemit", strDim, strValue, "rndID='" + order_no + "' and adminPass=11 and remitBank='" + payName + "在线支付'");

            strDim = "@uID,@orderID,@addMoney,@subtractMoney,@nowMoney,@buyMoney,@moneyInfo,@adminID,@postDate,@postIP";   //增加帐户余额
            strValue[0] = userID;
            strValue[1] = order_no;
            strValue[2] = total_fee;
            strValue[3] = "0";
            strValue[4] = (myMoney + Convert.ToDouble(total_fee)).ToString();
            strValue[5] = myBuyMoney.ToString();
            strValue[6] = payName + "在线支付";
            strValue[7] = "alipay";
            strValue[8] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            strValue[9] = ip.address();
            sql.add("moneyDetail", strDim, strValue);
        }
        dt.Dispose();
    }
    #endregion

    #region uc论坛同步
    /// <summary>
    /// uc论坛同步
    /// </summary>
    /// <param name="uid">用户名</param>
    /// <param name="pw">密码</param>
    /// <param name="email">邮箱</param>
    public void ucLogin(string uid, string pw, string email)
    {
        //UC同步
        IUcClient client = new UcClient();
        var user = client.UserLogin(uid, pw, LoginMethod.UserName, false, 0, "");
        if (user.Success)
        {
            HttpContext.Current.Session.Add("ucid", user.Uid.ToString());
        }
        else
        {
            //本站会员老用户实行新注册
            var uc = client.UserRegister(uid, pw, email, 0, "");
            if (uc.Uid > 0)
            {
                HttpContext.Current.Session.Add("ucid", uc.Uid.ToString());
                user = client.UserLogin(uid, pw, LoginMethod.UserName, false, 0, "");
                if (user.Success)
                {
                    HttpContext.Current.Session.Add("ucid", user.Uid.ToString());
                }
            }
        }
    }
    #endregion

    public string checkUserCer(string userID)  //检查会员认证信息情况
    {
        string htm = string.Empty;
        string txt = string.Empty;

        DataTable dt = sql.getDataTable("select * from cerPic where flagID>0 and toDate>getdate() and postID='" + userID + "' order by id DESC");
        int c = dt.Rows.Count;
        if (c > 0)
        {
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                switch (dt.Rows[i]["cerName"].ToString().Trim())
                {
                    case "cardNo":
                        txt += "身份证已认证&nbsp;";
                        break;
                    case "teachCard":
                        txt += "教师证或学生证已认证&nbsp;";
                        break;
                    default:
                        if (xabara.isNum(dt.Rows[i]["viewID"].ToString().Trim()) > 0)
                        {
                            string img = f.picDisplay(dt.Rows[i]["picName"].ToString().Trim());
                            htm += "<a href=\"" + img + "\" target=\"_blank\" title=\"点击查看大图\"><img src=\"" + img + "\" style=\"height:26px;\" align=\"middle\" class=\"imgLine\" /></a>&nbsp;";
                        }
                        break;
                }
            }
        }
        else
        {
            htm = "还没有任何认证资料 <a href=\"/member/cer/\" target=\"_blank\" style=\"color:red;\">[我要认证]</a>";
        }
        dt.Dispose();

        return txt + htm;
    }

    public string getCheckBox(CheckBoxList box, int selectNums)    //获取checkBoxList值   
    {
        string str = string.Empty;
        int sNums = 0;
        for (int i = 0; i < box.Items.Count; i++)
        {
            if (box.Items[i].Selected == true)
            {
                str += box.Items[i].Value.Trim() + "|";
                sNums += 1;
            }
        }

        if (selectNums > sNums)
        {
            js.div(false, "", "text", "请检查一下多选框，必须要选中 " + selectNums.ToString() + " 项！", 350, 150, "", "");
        }
        else
        {
            str = "|" + str;
        }

        return str;
    }

    public bool checkBoxValue(string boxValue)    //checkBoxList值是否有空值
    {
        string[] box = boxValue.Split(new char[] { ',' });
        for (int i = 0; i < box.GetUpperBound(0); i++)
        {
            if (string.IsNullOrEmpty(box[i] as string))
            {
                return false;
            }
        }
        return true;
    }

    public bool readCheckBox(CheckBoxList box, string str)    //读取checkBoxList值   
    {
        for (int i = 0; i < box.Items.Count; i++)
        {
            if (str.IndexOf(box.Items[i].Value) > -1)
            {
                box.Items[i].Selected = true;
            }
        }
        return true;
    }

    public string createNums(string tORs, string id) //生成学生及老师编码
    {
        string str = id;
        if (id.Length < 7)
        {
            str = "0000000".Substring(0, 7 - id.Length) + id;
        }
        return tORs + str;
    }

    public string returnNums(string tORs, string id) //还原成ID号
    {
        string str = id;
        if (!string.IsNullOrEmpty(id as string))
        {
            str = xabara.isNum(id.Replace(tORs, "")).ToString();
        }
        return str;
    }

    public string IDsTreeName(string str, string strBR) //多选框ids读取
    {
        string returnStr = string.Empty;
        if (str.Length > 2)
        {
            string IDs = str.Substring(1, str.Length - 2);
            //HttpContext.Current.Response.Write(IDs + "<br />");
            string[] id = IDs.Split(new char[] { '|' });
            string classOne = string.Empty;
            for (int i = 0; i <= id.GetUpperBound(0); i++)
            {
                string idsStr = c.readClassName_Link(xabara.isNum(id[i]), string.Empty, string.Empty);
                /*string[] s = idsStr.Split(new char[] { '-' });
                returnStr += s[s.GetUpperBound(0)].Trim() + strBR;
                if (s.GetUpperBound(0) > 0)
                {
                    classOne = s[0] + "-";
                }*/
                returnStr += idsStr + strBR;
            }
            returnStr = classOne + returnStr.Substring(0, returnStr.Length - strBR.Length);
        }
        return returnStr;
    }

    public string payRead(string money, string moneyBit) //读取报酬方式
    {
        string returnStr = string.Empty;
        int mBit = Convert.ToInt16(moneyBit);

        returnStr = "<font color=\"red\">" + rmb.format(money) + "</font> 元人民币　每 <font color=\"red\">" + moneyBit + "</font> 小时";

        if (mBit < 1)
        {
            returnStr = "面议";
        }
        if (mBit > 7)
        {
            returnStr = rmb.format(money) + " 元人民币　包月";
        }

        return returnStr;
    }

    public string studyIDSWeek(string str)  //星期上课表拆解
    {
        string returnStr = string.Empty;

        for (int j = 1; j < 4; j++)
        {

            string jStr = string.Empty;
            switch (j)
            {
                case 1:
                    jStr = "上";
                    break;
                case 2:
                    jStr = "下";
                    break;
                case 3:
                    jStr = "晚";
                    break;
            }

            for (int i = 1; i < 8; i++)
            {
                string iStr = string.Empty;
                switch (i)
                {
                    case 1:
                        iStr = "周一";
                        break;
                    case 2:
                        iStr = "周二";
                        break;
                    case 3:
                        iStr = "周三";
                        break;
                    case 4:
                        iStr = "周四";
                        break;
                    case 5:
                        iStr = "周五";
                        break;
                    case 6:
                        iStr = "周六";
                        break;
                    case 7:
                        iStr = "周日";
                        break;
                }

                string ij = "|" + i.ToString() + j.ToString() + "|";
                if (str.IndexOf(ij) > -1)
                {
                    returnStr += iStr + jStr + " ";
                }
            }
        }

        return returnStr.Trim();
    }

    public string infoStudentFlag(string str)   //学生信息状态
    {
        string returnStr = string.Empty;

        switch (str)
        {
            case "-1":
                returnStr = "<font color='red'>不通过</font>";
                break;

            case "0":
                returnStr = "<font color='deeppink'>待审核</font>";
                break;

            case "1":
                returnStr = "<font color='red'>急找家教</font>";
                break;

            case "2":
                returnStr = "<font color='green'>正在试讲</font>";
                break;

            case "3":
                returnStr = "<font color='blue'>已预约</font>";
                break;
        }

        return returnStr;
    }

    public string infoTeachFlag(string str)   //老师信息状态
    {
        string returnStr = string.Empty;

        switch (str)
        {
            case "-1":
                returnStr = "<font color='red'>不通过</font>";
                break;

            case "0":
                returnStr = "<font color='deeppink'>待审核</font>";
                break;

            case "1":
                returnStr = "<font color='red'>等待预约</font>";
                break;

            case "2":
                returnStr = "<font color='green'>正在试讲</font>";
                break;

            case "3":
                returnStr = "<font color='blue'>已预约</font>";
                break;
        }

        return returnStr;
    }

    public string telDisplay(string productID, string tels, long id)
    {
        string telStr = xml.read("xabara.config", "freePhone", 180);
        string allTel = string.Empty;
        string idStr = string.Empty;
        string orderHtm = string.Empty;
        idStr = "?id=" + id.ToString() + "&ts=" + productID.Substring(0, 1);

        long orderFlag = xabara.isNum(xml.read("xabara.config", "orderFlag", 180));    //预约开关
        if (orderFlag > 0)
        {
            orderHtm = @"或 <a href='/onlineOrder/" + idStr + "' target='_blank' style='color:red; font-size:14px;'>在线预约</a>";
        }

        if (!string.IsNullOrEmpty(telStr as string))
        {
            allTel = telStr + "&nbsp;";
        }
        telStr = xml.read("xabara.config", "mobile", 180);
        if (!string.IsNullOrEmpty(telStr as string))
        {
            allTel += telStr + "&nbsp;";
        }
        telStr = xml.read("xabara.config", "webTel", 180);
        if (!string.IsNullOrEmpty(telStr as string))
        {
            allTel += telStr + "&nbsp;";
        }

        string webIM = "&nbsp;" + xabara.QQ(xml.read("xabara.config", "qq", 180), "4") + xabara.taobao(xml.read("xabara.config", "taobao", 180), "1");

        DataTable dt;
        string strHtm = @"<ul><li><img src='/images/notice.png' style='border-width:0px; vertical-align:middle;' /> 您当前处于末登录状态！不能进行相关操作　[ <a href='/member/?errorUrl=" + url.before + "' target='_top' style='color:red;font-size:14px;'>登录</a> - <a href='/member/reg.aspx' target='_blank' style='color:red; font-size:14px;'>免费注册</a> ]</li><li style=\"padding-left:32px;\">咨询电话： <span style='color:red;'>" + allTel + "</span>" + orderHtm + webIM + "</li></ul>";

        double moneyTel = Convert.ToDouble(xml.read("xabara.config", "viewTelMoney", 180));
        if (moneyTel < 0)
        {
            strHtm = "<span style='color:red;'>" + tels.Trim() + "&nbsp;</span>" + orderHtm + webIM;
        }
        else
        {
            if (u.loginFlag())
            {
                string userID = string.Empty;
                if (HttpContext.Current.Request.Cookies["XabaraUser"] != null)  //cookies检查
                {
                    if (HttpContext.Current.Request.Cookies["XabaraUser"]["userCardID"] != null)
                    {
                        userID = HttpContext.Current.Request.Cookies["XabaraUser"]["userCardID"].ToString().Trim();
                    }
                }
                if (moneyTel > 0)
                {
                    dt = sql.getDataTable("select * from moneydetail where uID='" + userID + "' and orderID='" + productID + "'");
                    if (dt.Rows.Count > 0)
                    {
                        strHtm = "<span style='color:red;'>" + tels.Trim() + "&nbsp;</span>" + orderHtm + webIM;
                    }
                    else
                    {
                        strHtm = "温馨提示：购买将扣除您 <span style='color:red;'>" + rmb.format(moneyTel.ToString()) + "</span> 元并获取联系方式！ <a href='/member/buyViewTel.aspx?id=" + productID + "&errorUrl=" + url.before + "' target='_top' style='font-weight:bold;font-size:14px; color:red;'>[我要购买]</a><br />咨询电话： <span style='color:red;'>" + allTel + "</span>" + orderHtm + webIM;
                    }
                    dt.Dispose();
                }
                else
                {
                    strHtm = "温馨提示：请直接咨询客服 <span style='color:red;'>" + allTel + "</span>" + orderHtm + webIM;
                }
            }
        }

        return strHtm;
    }

    public string cnName(string txt, string sex, string teacherORStudent) //名字简写
    {
        string sexStr = "先生";
        if (teacherORStudent.Equals("s"))
        {
            if (sex.Equals("女"))
            {
                sexStr = "女士";
            }
        }
        else
        {
            sexStr = "教员";
        }

        if (!string.IsNullOrEmpty(txt as string))
        {
            if (txt.Length > 3)
            {
                sexStr = txt.Substring(0, 2) + sexStr;
            }
            else
            {
                sexStr = txt.Substring(0, 1) + sexStr;
            }
        }

        return sexStr;
    }

    public double readMoney(string userID)  //读取余额
    {
        double m = 0;

        DataTable dt = sql.getDataTable("select top 1 * from moneyDetail where uID='" + userID + "' order by dID DESC");
        if (dt.Rows.Count > 0)
        {
            m = Convert.ToDouble(dt.Rows[0]["nowMoney"].ToString().Trim());
        }
        dt.Dispose();

        return m;
    }

    public bool payMoney(string userID, double num, string payTxt, string adminID) //减少余额
    {
        bool pay = false;
        double myMoney = 0;
        double myBuyMoney = 0;

        DataTable dt = sql.getDataTable("select top 1 * from moneyDetail where uID='" + userID + "' order by dID DESC");  //取原余额及已消费额
        if (dt.Rows.Count > 0)
        {
            myMoney = Convert.ToDouble(dt.Rows[0]["nowMoney"]);
            myBuyMoney = Convert.ToDouble(dt.Rows[0]["buyMoney"]);
        }
        dt.Dispose();

        if (myMoney >= num)    //判断余额
        {
            string strDim = "@uID,@orderID,@addMoney,@subtractMoney,@nowMoney,@buyMoney,@moneyInfo,@adminID,@postDate,@postIP";   //增加帐户余额
            string[] strValue = new string[10];
            strValue[0] = userID;
            strValue[1] = DateTime.Now.ToString("yyyyMMddHHmmss") + xabara.rnd("123", 5);
            strValue[2] = "0";
            strValue[3] = num.ToString();
            strValue[4] = (myMoney - num).ToString();
            strValue[5] = (myBuyMoney + num).ToString();
            strValue[6] = payTxt;
            strValue[7] = adminID;
            strValue[8] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            strValue[9] = ip.address();
            string returnStr = sql.add("moneyDetail", strDim, strValue);
            if (returnStr.Equals("发布成功"))
            {
                pay = true;
            }
        }

        return pay;
    }

    public string cerFlag(string num)   //读取证件审核状态
    {
        string str = string.Empty;
        switch (num)
        {
            case "0":
                str = "等待审核";
                break;
            case "1":
                str = "审核通过";
                break;
        }
        return str;
    }

    /// <summary>
    /// 页面缓存
    /// </summary>
    /// <param name="n">输入时间（分）</param>
    /// <returns>true</returns>
    public bool cacheTime(int n)
    {
        HttpContext.Current.Response.Cache.SetExpires(DateTime.Now.AddSeconds(15 * 60));
        HttpContext.Current.Response.Cache.SetCacheability(HttpCacheability.Public);
        HttpContext.Current.Response.Cache.SetVaryByCustom("browser");
        HttpContext.Current.Response.Cache.VaryByParams["City"] = true;

        return true;
    }

    /// <summary>
    /// 通知邮箱发送
    /// </summary>
    /// <param name="title">标题</param>
    /// <param name="content">内容</param>
    public void tzMail(string uID, string title, string content)
    {
        if (string.IsNullOrEmpty(uID as string))
        {
            uID = "sys";
        }

        string mail = xml.read("xabara.config", "tzMail", 180);
        if (!string.IsNullOrEmpty(mail as string))
        {
            e.add(uID, "admin", 1, mail, "信息通知", title, content, false);
        }
    }
}