﻿<%@ Application Language="C#" %>

<script RunAt="server">

    void Application_Start(object sender, EventArgs e)
    {        
        RegisterRoutes(RouteTable.Routes);
    }

    void RegisterRoutes(RouteCollection routes)
    {
        routes.Ignore("{resource}.axd/{*pathInfo}");

        routes.MapPageRoute("teacherShow", "teacher/view/{sID}/{*extrainfo}", "~/teacher/show.aspx", true);
        routes.MapPageRoute("studentShow", "student/view/{sID}/{*extrainfo}", "~/student/show.aspx", true);
        routes.MapPageRoute("helpShow", "help/view/{sID}/{*extrainfo}", "~/help/show.aspx", true);
        routes.MapPageRoute("articleShow", "article/view/{sID}/{*extrainfo}", "~/article/show.aspx", true);

        routes.MapPageRoute("teahcer", "teacher/{tID}/{*extrainfo}", "~/teacher/list.aspx", true);
        routes.MapPageRoute("student", "student/{sID}/{*extrainfo}", "~/student/list.aspx", true);
        routes.MapPageRoute("helpList", "help/{cID}/{*extrainfo}", "~/help/list.aspx", true);
        routes.MapPageRoute("articleList", "article/{cID}/{*extrainfo}", "~/article/list.aspx", true);

        //城市导航
        routes.MapPageRoute("cityNav", "city/{IDs}/{*extrainfo}", "~/inClude/cityNav.aspx", true);      

        routes.MapPageRoute("error", "{dir}/{*extrainfo}", "~/include/error.aspx", true);
    }
</script>