﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="map.aspx.cs" Inherits="inClude_map" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link rel="Shortcut Icon" href="/Images/favicon.ico" />
    <link href="../inClude/style.css" rel="stylesheet" type="text/css" />
    <script src="http://api.map.baidu.com/api?v=1.3" type="text/javascript"></script>
    <script type="text/javascript">
        function xabaraJsMap(keyword) {
            var map = new BMap.Map("xabaraMap");                    // 创建地图实例
            map.centerAndZoom("台州", 16);                           // 初始化地图，设置中心点坐标和地图级别
            map.addControl(new BMap.NavigationControl());           // 添加平移缩放控件
            map.addControl(new BMap.ScaleControl());                // 添加比例尺控件
            map.addControl(new BMap.OverviewMapControl());          //添加缩略地图控件
            map.enableScrollWheelZoom();                            //启用滚轮放大缩小
            //map.addControl(new BMap.MapTypeControl());              //添加地图类型控件

            var menu = new BMap.ContextMenu();
            var txtMenuItem = [
              {
                  text: '放大',
                  callback: function () { map.zoomIn() }
              },
              {
                  text: '缩小',
                  callback: function () { map.zoomOut() }
              },
              {
                  text: '放置到最大级',
                  callback: function () { map.setZoom(18) }
              }
            ];

            for (var i = 0; i < txtMenuItem.length; i++) {
                menu.addItem(new BMap.MenuItem(txtMenuItem[i].text, txtMenuItem[i].callback, 30));
            }
            //控件
            map.addControl(new BMap.ScaleControl());    // 添加比例尺控件
            map.addContextMenu(menu);

            //搜索
            var local = new BMap.LocalSearch(map, { renderOptions: { map: map } });
            local.search(keyword);

            setTimeout(function () {
                map.setZoom(16);   //放大级别
            }, 1500);
        }
    </script>
</head>
<body onload="xabaraJsMap('<%=mapAdd%>');">
    <form id="form1" runat="server">
        <div style="width:<%=w%>px;height:<%=h%>px; text-align:center;" id="xabaraMap"></div>
    </form>
</body>
</html>