﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.IO;
using xabaraCOM;

public partial class member_cer_Default : System.Web.UI.Page
{
    user u = new user();
    sqlServer sql = new sqlServer();
    classify c = new classify();
    webPublic wp = new webPublic();
    fileDocument f = new fileDocument();
    javasrcipt js = new javasrcipt();
    ipAddress ip = new ipAddress();

    protected void Page_Load(object sender, EventArgs e)
    {
        u.check("", url.currently);
        Page.Title = "身份认证　" + xml.read("xabara.config", "webName", 180);

        if (!IsPostBack)
        {
            c.bindingDropDownList("all", true, 0, "cer", imgType);

            DataTable dt = sql.getDataTable("select * from cerPic where postID='" + u.userCardID + "' order by toDate ASC");
            int cc = dt.Rows.Count;

            for (int i = 0; i < cc; i++)
            {
                string type = dt.Rows[i]["cerName"].ToString().Trim();
                if (type.Equals("cardNo") && xabara.isNum(dt.Rows[i]["flagID"].ToString().Trim()) == 1)  //身份证认证后无法再次上传
                {
                    this.imgType.Items.FindByValue(dt.Rows[i]["picType"].ToString().Trim()).Enabled = false;
                }

                if ((i + 1) % 3 == 1)
                {
                    pic.Text += "<tr>";
                }
                string img = dt.Rows[i]["picName"].ToString().Trim();
                string txt = string.Empty;
                DateTime d = Convert.ToDateTime(dt.Rows[i]["toDate"].ToString().Trim());
                if (d == Convert.ToDateTime("2011-01-01"))
                {
                    txt = "<span style=\"color:red;\">" + wp.cerFlag(dt.Rows[i]["flagID"].ToString().Trim()) + "</span>";
                }
                else
                {
                    if (d < DateTime.Now)
                    {
                        txt = "<span style=\"color:red;\">已过期</span>";
                    }
                    else
                    {
                        txt = "有效期至 " + d.ToString("yyyy-MM-dd HH:mm:ss");
                    }
                }
                string view = "不公开显示";
                if (xabara.isNum(dt.Rows[i]["viewID"].ToString()) > 0)
                {
                    view = "公开显示";
                }

                pic.Text += "<td valign=\"top\"><ul style=\"height-line:160%; text-align:left;\"><li><img src=\"" + f.picDisplay(img) + "\" style=\"width:180px;\" /></li><li>" + c.readClassName_Link(xabara.isNum(dt.Rows[i]["picType"].ToString().Trim()), string.Empty, string.Empty) + "</li><li>" + txt + "</li><li>" + view + "</li></ul></td>";
                if ((i + 1) % 3 == 0)
                {
                    pic.Text += "</tr>";
                }
            }
        }
    }

    protected void postButton_Click(object sender, EventArgs e)
    {
        string AllowFile = "jpg|jpeg|bmp|gif|png";
        int UploadSize = 512000;    //500KB
        string NewFileName = string.Empty;
        string UploadTemp = string.Empty;

        if (this.uploadImg.HasFile)    //本地上传
        {
            string dateFolader = DateTime.Now.ToString("yyyyMMdd");
            if (!Directory.Exists(HttpContext.Current.Server.MapPath(f.uploadFolder + dateFolader + "/"))) //判断上传目录日期型的是否存在
            {
                Directory.CreateDirectory(HttpContext.Current.Server.MapPath(f.uploadFolder + dateFolader + "/"));
            }

            string fileName = this.uploadImg.PostedFile.FileName.ToLower();
            if (string.IsNullOrEmpty(fileName as string))
            {
                js.div(false, "", "text", "请选择文件后再上传！", 0, 0, string.Empty, string.Empty);
            }
            else
            {
                string fileExe = fileName.Substring(fileName.LastIndexOf(".") + 1); //取后缀名
                if (AllowFile.IndexOf(fileExe) < 0) //判断该扩展名是否合法
                {
                    js.div(false, "", "text", "目前支持格式为" + AllowFile, 400, 150, string.Empty, string.Empty);
                }
                else
                {
                    if (this.uploadImg.PostedFile.ContentLength > UploadSize) // 判断上传文件大小是否超过最大值
                    {
                        js.div(false, "", "text", "目前支持大小最大为" + Convert.ToString(UploadSize / 1024) + "KB", 400, 150, string.Empty, string.Empty);
                    }
                    else
                    {
                        NewFileName = xabara.rnd("abc123", 5) + dateFolader + DateTime.Now.ToString("HHmmss") + "." + fileExe;
                        UploadTemp = Server.MapPath(f.uploadFolder + dateFolader + "/" + NewFileName);

                        this.uploadImg.PostedFile.SaveAs(UploadTemp); //保存临时图片

                        string strDim = "@picType,@picName,@fromDate,@toDate,@postID,@postDate,@postIP,@flagID,@viewID";
                        string[] strValue = new string[9];

                        DataTable dt = sql.getDataTable("select * from cerPic where postID='" + u.userCardID + "' and picType=" + imgType.Text + " order by fromDate");
                        if (dt.Rows.Count > 0)
                        {
                            string oldImg = dt.Rows[0]["picName"].ToString().Trim();
                            if (!string.IsNullOrEmpty(oldImg as string))
                            {
                                f.del(oldImg);   //删除旧头像
                            }

                            strDim = "@picName,@postID,@postDate,@postIP,@flagID,@viewID";
                            strValue[0] = NewFileName;
                            strValue[1] = u.userCardID;
                            strValue[2] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                            strValue[3] = ip.address();
                            strValue[4] = "0";
                            strValue[5] = view.Text;

                            sql.update("cerPic", strDim, strValue, "postID='" + u.userCardID + "' and picType=" + imgType.Text);
                        }
                        else
                        {
                            strValue[0] = imgType.Text;
                            strValue[1] = NewFileName;
                            strValue[2] = "2011-01-01";
                            strValue[3] = "2011-01-01";
                            strValue[4] = u.userCardID;
                            strValue[5] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                            strValue[6] = ip.address();
                            strValue[7] = "0";
                            strValue[8] = view.Text;

                            sql.add("cerPic", strDim, strValue);
                        }

                        sql.log(u.userCardID, "user", "身份认证");

                        js.div(false, "", "text", "您的头像已上传！<br /><br /><img src='" + f.picDisplay(NewFileName) + "' />", 800, 600, "default.aspx", "top");
                    }
                }
            }
        }
    }
}