﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;

public partial class member_pay_Default : System.Web.UI.Page
{
    user u = new user();
    sqlServer sql = new sqlServer();
    javasrcipt js = new javasrcipt();

    protected void Page_Load(object sender, EventArgs e)
    {
        u.check("", url.currently);
        Page.Title = "帐户充值　" + xml.read("xabara.config", "webName", 180);

        if (!IsPostBack)
        {
            regExpression reg = new regExpression();
            payRegularExpressionValidator.ValidationExpression = reg.Double;
            payRegularExpressionValidator.ErrorMessage = reg.DoubleError;

            if (!string.IsNullOrEmpty(xml.read("xabara.config", "tenPayKey", 180) as string))  //财富通付费方式
            {
                this.payType.Items.Add(new ListItem("<img src=\"../images/tenpay_logo.gif\" align=\"middle\" />", "tenpay"));
                this.payType.Items.FindByValue("tenpay").Selected = true;
            }

            if (!string.IsNullOrEmpty(xml.read("xabara.config", "aliPayKey", 180) as string))  //支付宝付费方式
            {
                this.payType.Items.Add(new ListItem("<img src=\"../images/alipay_logo.gif\" align=\"middle\" />", "alipay"));
            }

            if (this.payType.Items.Count < 1)
            {
                this.payType.Items.Add(new ListItem("<span style=\"color:red;\">管理员还没设置支付宝或财付通帐户</span>", ""));
            }

        }

        xabara.safeHistory();
    }

    protected void postButton_Click(object sender, EventArgs e)
    {
        string pay = payType.Text.Trim();

        if (string.IsNullOrEmpty(pay as string))
        {
            js.div(false, "", "text", "请联系管理员设置支付方式！", 300, 120, "/", "top");
        }
        else
        {
            Double inMoney = Math.Round(Math.Abs(Convert.ToDouble(payTxt.Text)), 2);
            if (inMoney > 0)
            {
                Session.Add("payMoneyStr", inMoney.ToString());

                if (pay.Equals("alipay"))
                {
                    long alipayType = xabara.isNum(xml.read("xabara.config", "alipayType", 180));
                    switch (alipayType)
                    { 
                        case 0:
                            Response.Redirect("alipay.aspx", true);
                            break;
                        case 1:
                            Response.Redirect("alipayescow.aspx", true);
                            break;
                        case 2:
                            Response.Redirect("alipaydualfun.aspx", true);
                            break;
                        default:
                            Response.Write("支付宝接口设置错误，请联系管理员！");
                            Response.End();
                            break;
                    }
                }
                else
                {
                    Response.Redirect(pay + ".aspx", true);
                }
            }
            else
            {
                Response.Write("支付接口设置错误，请联系管理员！");
                Response.End();
            }
        }
    }
}