﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;
using alipaydirect;

/// <summary>
/// 功能：即时到账交易接口接入页
/// 版本：3.3
/// 日期：2012-07-05
/// 说明：
/// 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。
/// 该代码仅供学习和研究支付宝接口使用，只是提供一个参考。
/// 
/// /////////////////注意///////////////////////////////////////////////////////////////
/// 如果您在接口集成过程中遇到问题，可以按照下面的途径来解决
/// 1、商户服务中心（https://b.alipay.com/support/helperApply.htm?action=consultationApply），提交申请集成协助，我们会有专业的技术工程师主动联系您协助解决
/// 2、商户帮助中心（http://help.alipay.com/support/232511-16307/0-16307.htm?sh=Y&info_type=9）
/// 3、支付宝论坛（http://club.alipay.com/read-htm-tid-8681712.html）
/// 
/// 如果不想使用扩展功能请把扩展功能参数赋空值。
/// </summary>
public partial class member_pay_alipay : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        user u = new user();
        ipAddress ip = new ipAddress();
        sqlServer sql = new sqlServer();
        javasrcipt js = new javasrcipt();

        u.check("", url.before);

        Page.Title = "在线支付宝支付预付款确认信息　" + xml.read("xabara.config", "webName", 180) + xml.read("xabara.config", "titleMeta", 180);
        xabara.safeHistory();

        string payMoney = Session["payMoneyStr"].ToString();
        payLab.Text = rmb.format(payMoney);

        ////////////////////////////////////////////请求参数////////////////////////////////////////////

        //支付类型
        string payment_type = "1";
        //必填，不能修改
        //服务器异步通知页面路径
        string notify_url = "http://" + HttpContext.Current.Request.Url.Host + "/member/pay/alipayNotifyUrl.aspx";
        //需http://格式的完整路径，不能加?id=123这类自定义参数

        //页面跳转同步通知页面路径
        string return_url = "http://" + HttpContext.Current.Request.Url.Host + "/member/pay/alipayReturnUrl.aspx";
        //需http://格式的完整路径，不能加?id=123这类自定义参数，不能写成http://localhost/

        //卖家支付宝帐户
        string seller_email = xml.read("xabara.config", "aliPayEmail", 180);
        //必填

        //商户订单号
        string out_trade_no = DateTime.Now.ToString("yyyyMMddHHmmss") + xabara.rnd("123", 5);
        //商户网站订单系统中唯一订单号，必填

        //订单名称
        string subject = xml.read("xabara.config", "webName", 180) + "---会员帐户余额充值";
        //必填

        //付款金额
        string total_fee = payMoney;
        //必填

        //订单描述

        string body = "充值网站：" + Request.Url.Host;
        //商品展示地址
        string show_url = "http://" + HttpContext.Current.Request.Url.Host;
        //需以http://开头的完整路径，例如：http://www.xxx.com/myorder.html

        //防钓鱼时间戳
        string anti_phishing_key = "";
        //若要使用请调用类文件submit中的query_timestamp函数

        //客户端的IP地址
        string exter_invoke_ip = "";
        //非局域网的外网IP地址，如：221.0.0.1


        ////////////////////////////////////////////////////////////////////////////////////////////////

        //写入数据库
        DateTime dTime = DateTime.Now;
        string strDim = "@uID,@rndID,@remitName,@remitBank,@remitMoney,@remitDate,@remitType,@remitInfo,@remitImg,@adminPass,@postDate,@postIP,@adminDate";
        string[] strValue = new string[13];
        strValue[0] = u.userCardID;
        strValue[1] = out_trade_no;
        strValue[2] = HttpUtility.UrlDecode(Request.Cookies["XabaraUser"]["userName"].ToString().Trim());
        strValue[3] = "支付宝在线支付";
        strValue[4] = payMoney;
        strValue[5] = dTime.ToString("yyyy-MM-dd HH:mm:ss");
        strValue[6] = "追加预付款";
        strValue[7] = string.Empty;
        strValue[8] = string.Empty;
        strValue[9] = "11"; //支付宝付款审核状态
        strValue[10] = dTime.ToString("yyyy-MM-dd HH:mm:ss");
        strValue[11] = ip.address();
        strValue[12] = "2009-01-01";

        sql.add("moneyBankRemit", strDim, strValue);

        //把请求参数打包成数组
        SortedDictionary<string, string> sParaTemp = new SortedDictionary<string, string>();
        sParaTemp.Add("partner", Config.Partner);
        sParaTemp.Add("_input_charset", Config.Input_charset.ToLower());
        sParaTemp.Add("service", "create_direct_pay_by_user");
        sParaTemp.Add("payment_type", payment_type);
        sParaTemp.Add("notify_url", notify_url);
        sParaTemp.Add("return_url", return_url);
        sParaTemp.Add("seller_email", seller_email);
        sParaTemp.Add("out_trade_no", out_trade_no);
        sParaTemp.Add("subject", subject);
        sParaTemp.Add("total_fee", total_fee);
        sParaTemp.Add("body", body);
        sParaTemp.Add("show_url", show_url);
        sParaTemp.Add("anti_phishing_key", anti_phishing_key);
        sParaTemp.Add("exter_invoke_ip", exter_invoke_ip);

        //建立请求
        string sHtmlText = Submit.BuildRequest(sParaTemp, "get", "确认");
        Response.Write(sHtmlText);
    }
}