﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;

public partial class member_pay_onlineMoney : System.Web.UI.Page
{
    sqlServer sql = new sqlServer();
    user u = new user();
    fileDocument f = new fileDocument();
    javasrcipt js = new javasrcipt();
    ipAddress ip = new ipAddress();

    protected void Page_Load(object sender, EventArgs e)
    {
        u.check("", url.currently);
        Page.Title = "汇款确认　" + xml.read("xabara.config", "webName", 180);

        if (!IsPostBack)
        {
            regExpression reg = new regExpression();
            textNameRegularExpressionValidator.ValidationExpression = reg.chinese;
            textNameRegularExpressionValidator.ErrorMessage = reg.chineseError;
            dateRegExpree.ValidationExpression = reg.ymd;
            dateRegExpree.ErrorMessage = reg.ymdError;
            payRegularExpressionValidator.ValidationExpression = reg.Double;
            payRegularExpressionValidator.ErrorMessage = reg.DoubleError;

            txtName.Text = HttpUtility.UrlDecode(Request.Cookies["XabaraUser"]["userName"].ToString().Trim());

            bankType.DataSource = sql.getDataTable("select * from payBank order by id DESC");
            bankType.DataTextField = "bankName";
            bankType.DataValueField = "bankName";
            bankType.DataBind();
            bankType.Dispose();
            if (bankType.Items.Count < 1)
            {
                bankType.Items.Add(new ListItem("目前无任何银行设置，请联系管理员", ""));
            }
        }

        xabara.safeHistory();
    }

    protected void postButton_Click(object sender, EventArgs e)
    {
        string upImgName = string.Empty;
        bool upFile = true;

        if (moneyImgUpload.HasFile)
        {
            string UpFileReturnStr = f.upload(moneyImgUpload, "Img", false);

            if (!UpFileReturnStr.Equals("上传成功"))
            {
                fileError.Text = UpFileReturnStr;
                js.div(false, "", "text", UpFileReturnStr + "！", 0, 0, string.Empty, string.Empty);
                upFile = false;
            }
            else
            {
                upImgName = Session["NewFile"].ToString();
            }
        }

        if (upFile)
        {
            string strDim = "@uID,@remitName,@remitBank,@remitMoney,@remitDate,@remitType,@remitInfo,@remitImg,@adminPass,@postDate,@postIP,@rndID,@adminDate";
            string[] strValue = new string[13];
            strValue[0] = u.userCardID;
            strValue[1] = txtName.Text;
            strValue[2] = bankType.Text;
            strValue[3] = payTxt.Text;
            strValue[4] = Convert.ToDateTime(bDate.Text).AddHours(Convert.ToInt16(moneyPayHour.Text)).ToString("yyyy-MM-dd HH:mm:ss");
            strValue[5] = moneyType.Text;
            strValue[6] = CHAR.htmSafe(bankInfo.Text);
            strValue[7] = upImgName;
            strValue[8] = "0";
            strValue[9] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            strValue[10] = ip.address();
            strValue[11] = DateTime.Now.ToString("yyyyMMddHHmmss") + xabara.rnd("123", 5);
            strValue[12] = "2010-10-10";

            string strSql = "select * from moneyBankRemit where adminPass=0 and uID='" + u.userCardID + "' and remitBank='" + bankType.Text + "' and remitMoney=" + payTxt.Text.Trim();
            //Response.Write(strSql);
            //Response.End();

            DataTable dt = sql.getDataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                f.del(upImgName);

                js.div(false, "", "text", "请不要重复提交，管理员正审核中，请耐心等待！", 0, 0, "onlineMoney.aspx", "top");
            }
            else
            {
                string returnStr = sql.add("moneyBankRemit", strDim, strValue);

                if (returnStr.Equals("发布成功"))
                {
                    js.div(false, "", "text", "提交成功，请耐心等待审核或QQ直接联系！", 0, 0, "onlineMoney.aspx", "top");
                }
                else
                {
                    f.del(upImgName);

                    js.div(false, "", "text", "提交失败！", 0, 0, string.Empty, string.Empty);
                }
            }
            dt.Dispose();
        }
    }
}