﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;

public partial class member_teacher_edit : System.Web.UI.Page
{
    sqlServer sql = new sqlServer();
    webPublic wp = new webPublic();
    user u = new user();
    javasrcipt js = new javasrcipt();
    ipAddress ip = new ipAddress();
    classify c = new classify();

    protected void Page_Load(object sender, EventArgs e)
    {
        u.check("", url.before);
        wp.checkUserInfo();
        Page.Title = "修改教员信息　" + xml.read("xabara.config", "webName", 180);

        if (!IsPostBack)
        {
            this.teachAge.Items.Clear();
            this.teachAge.Items.Add(new ListItem("== 请选择 ==", ""));
            for (int t = 0; t < 51; t++)
            {
                this.teachAge.Items.Add(new ListItem(t.ToString() + "年", t.ToString()));
            }
            this.teachAge.DataBind();

            string strSQL = "select * from NewsTree where TreeType='study' and treeID=0 order by ListID ASC,Tid ASC";
            DataTable dt = sql.getDataTable(strSQL);
            this.gradeList.Items.Add(new ListItem("== 请选择 ==", ""));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                this.gradeList.Items.Add(new ListItem(dt.Rows[i]["TreeName"].ToString().Trim(), dt.Rows[i]["Tid"].ToString().Trim()));
            }
            this.gradeList.DataBind();

            dt = sql.getDataTable("select * from selectProvince order by id");
            this.ProvinceList.Items.Clear();
            this.ProvinceList.Items.Add(new ListItem("== 省份 ==", string.Empty));
            for (int p = 0; p < dt.Rows.Count; p++)
            {
                this.ProvinceList.Items.Add(new ListItem(dt.Rows[p]["provinceTxt"].ToString().Trim(), dt.Rows[p]["provinceID"].ToString().Trim()));
            }
            this.ProvinceList.DataBind();

            strSQL = "select * from NewsTree where TreeType='edu' order by ListID ASC,Tid ASC";
            dt = sql.getDataTable(strSQL);
            this.eduType.Items.Clear();
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                this.eduType.Items.Add(new ListItem(dt.Rows[i]["TreeName"].ToString().Trim(), dt.Rows[i]["Tid"].ToString().Trim()));
            }
            this.eduType.DataBind();

            strSQL = "select * from NewsTree where TreeType='teachertype' order by ListID ASC,Tid ASC";
            dt = sql.getDataTable(strSQL);
            this.teacherType.Items.Clear();
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                this.teacherType.Items.Add(new ListItem(dt.Rows[i]["TreeName"].ToString().Trim(), dt.Rows[i]["Tid"].ToString().Trim()));
            }
            this.teacherType.DataBind();

            strSQL = "select * from NewsTree where TreeType='teacherstudy' order by ListID ASC,Tid ASC";
            dt = sql.getDataTable(strSQL);
            this.teachStudy.Items.Clear();
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                this.teachStudy.Items.Add(new ListItem(dt.Rows[i]["TreeName"].ToString().Trim(), dt.Rows[i]["Tid"].ToString().Trim()));
            }
            this.teachStudy.DataBind();

            this.studyTime.Items.Clear();
            for (int j = 1; j < 4; j++)
            {
                string jStr = string.Empty;
                switch (j)
                {
                    case 1:
                        jStr = "上";
                        break;
                    case 2:
                        jStr = "下";
                        break;
                    case 3:
                        jStr = "晚";
                        break;
                }

                for (int i = 1; i < 8; i++)
                {
                    string iStr = string.Empty;
                    switch (i)
                    {
                        case 1:
                            iStr = "周一";
                            break;
                        case 2:
                            iStr = "周二";
                            break;
                        case 3:
                            iStr = "周三";
                            break;
                        case 4:
                            iStr = "周四";
                            break;
                        case 5:
                            iStr = "周五";
                            break;
                        case 6:
                            iStr = "周六";
                            break;
                        case 7:
                            iStr = "周日";
                            break;
                    }
                    this.studyTime.Items.Add(new ListItem(iStr + jStr, i.ToString() + j.ToString()));
                }
            }
            this.studyTime.DataBind();

            this.payBit.Items.Clear();
            this.payBit.Items.Add(new ListItem("面议", "0"));
            for (int i = 1; i < 9; i++)
            {
                this.payBit.Items.Add(new ListItem("每" + i.ToString() + "小时", i.ToString()));
            }
            this.payBit.Items.Add(new ListItem("包月", "9"));
            this.payBit.DataBind();

            regExpression reg = new regExpression();
            payRegularExpressionValidator.ValidationExpression = reg.Double;
            payRegularExpressionValidator.ErrorMessage = reg.DoubleError;

            dt = sql.getDataTable("select * from teacherInfo where uID='" + u.userCardID + "' and tID=" + xabara.isNum(Request["id"]).ToString());    //已存在的信息
            if (dt.Rows.Count > 0)
            {
                if (xabara.isNum(dt.Rows[0]["workFlag"].ToString()) > 2)
                {
                    js.div(false, "", "text", "对不起，已安排的信息不能再次修改！", 350, 150, "add.aspx", "top");
                }
                try
                {
                    this.eduType.Items.FindByValue(dt.Rows[0]["nowEdu"].ToString().Trim()).Selected = true;
                }
                catch { }
                try
                {
                    this.teacherType.Items.FindByValue(dt.Rows[0]["nowWork"].ToString().Trim()).Selected = true;
                }
                catch { }
                try
                {
                    this.ProvinceList.Items.FindByValue(dt.Rows[0]["provinceID"].ToString().Trim()).Selected = true;
                }
                catch { }

                DataTable dtCity = sql.getDataTable("select * from selectCity where cFather=" + ProvinceList.Text.Trim() + " order by id");
                this.CityList.Items.Clear();
                for (int p = 0; p < dtCity.Rows.Count; p++)
                {
                    this.CityList.Items.Add(new ListItem(dtCity.Rows[p]["cityTxt"].ToString().Trim(), dtCity.Rows[p]["cityID"].ToString().Trim()));
                }
                this.CityList.DataBind();
                dtCity.Dispose();
                try
                {
                    this.CityList.Items.FindByValue(dt.Rows[0]["cityID"].ToString().Trim()).Selected = true;
                }
                catch { }

                string areaStr = dt.Rows[0]["areaID"].ToString().Trim();
                DataTable dtArea = sql.getDataTable("select * from selectArea where aFather='" + dt.Rows[0]["cityID"].ToString().Trim() + "' order by id");
                this.areaList.Items.Clear();
                if (dtArea.Rows.Count > 0)
                {
                    for (int p = 0; p < dtArea.Rows.Count; p++)
                    {
                        this.areaList.Items.Add(new ListItem(dtArea.Rows[p]["areaTxt"].ToString().Trim(), dtArea.Rows[p]["areaID"].ToString().Trim()));
                    }
                }
                else
                {
                    this.areaList.Items.Add(new ListItem("== 暂无 ==", ""));
                }
                this.areaList.DataBind();
                if (!string.IsNullOrEmpty(areaStr as string))
                {
                    try
                    {
                        this.areaList.Items.FindByValue(areaStr).Selected = true;
                    }
                    catch { }
                }
                dtArea.Dispose();

                school.Text = CHAR.htmReturn(dt.Rows[0]["studySchool"].ToString().Trim());
                studyProfession.Text = CHAR.htmReturn(dt.Rows[0]["studyProfession"].ToString().Trim());
                try
                {
                    this.teachAge.Items.FindByValue(dt.Rows[0]["teachAge"].ToString().Trim()).Selected = true;
                }
                catch { }
                try
                {
                    this.gradeList.Items.FindByValue(dt.Rows[0]["gradeID"].ToString().Trim()).Selected = true;
                }
                catch { }
                DataTable dtGrade = sql.getDataTable("select * from NewsTree where TreeType='study' and TreeID=" + gradeList.Text.Trim() + " order by ListID ASC,Tid ASC");
                this.gradeCheck.Items.Clear();
                for (int p = 0; p < dtGrade.Rows.Count; p++)
                {
                    this.gradeCheck.Items.Add(new ListItem(dtGrade.Rows[p]["TreeName"].ToString().Trim(), dtGrade.Rows[p]["Tid"].ToString().Trim()));
                }
                this.gradeCheck.DataBind();
                gradeCheck.Dispose();

                this.classBool.Items.FindByValue(dt.Rows[0]["openClass"].ToString().Trim()).Selected = true;
                wp.readCheckBox(classSize, dt.Rows[0]["classNums"].ToString().Trim());
                myStudy.Text = CHAR.htmReturn(dt.Rows[0]["aboutME"].ToString());
                teachArea.Text = CHAR.htmReturn(dt.Rows[0]["teachRoad"].ToString());
                wp.readCheckBox(teachStudy, dt.Rows[0]["teachStudyIDs"].ToString().Trim());
                wp.readCheckBox(studyTime, dt.Rows[0]["studyTimeIDs"].ToString().Trim());
                studyAbout.Text = CHAR.htmReturn(dt.Rows[0]["studyTimeInfo"].ToString());
                payMoney.Text = dt.Rows[0]["payMoney"].ToString();
                this.payBit.Items.FindByValue(dt.Rows[0]["payBit"].ToString().Trim()).Selected = true;

                countHid.Value = dt.Rows[0]["readNums"].ToString().Trim();

                string checkIDs = dt.Rows[0]["teachTypeID"].ToString().Trim();
                string[] checkID = checkIDs.Split(new char[] { '|' });
                for (int cc = 1; cc < checkID.GetUpperBound(0); cc++)
                {
                    this.gradeCheckValue.Items.Add(new ListItem(c.readClassName_Link(xabara.isNum(checkID[cc]), string.Empty, string.Empty).Replace("&nbsp;", ""), checkID[cc]));
                }

                strSQL = "select * from NewsTree where TreeType='study' and TreeID=" + dt.Rows[0]["gradeID"].ToString().Trim() + " order by ListID ASC,Tid ASC";
                dt = sql.getDataTable(strSQL);
                this.gradeCheck.Items.Clear();
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    this.gradeCheck.Items.Add(new ListItem(dt.Rows[i]["TreeName"].ToString().Trim(), dt.Rows[i]["Tid"].ToString().Trim()));
                }
                this.gradeCheck.DataBind();

            }
            else
            {
                js.div(false, "", "text", "您的操作有误！", 350, 150, "default.aspx", "top");
            }

            dt.Dispose();
        }

        xabara.safeHistory();
    }

    protected void gradeList_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(gradeList.Text.Trim() as string))
        {
            string strSQL = "select * from NewsTree where TreeType='study' and TreeID=" + gradeList.Text.Trim() + " order by ListID ASC,Tid ASC";
            DataTable dt = sql.getDataTable(strSQL);
            this.gradeCheck.Items.Clear();
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                this.gradeCheck.Items.Add(new ListItem(dt.Rows[i]["TreeName"].ToString().Trim(), dt.Rows[i]["Tid"].ToString().Trim()));
            }
            this.gradeCheck.DataBind();
        }
        else
        {
            this.gradeCheck.Items.Clear();
        }
    }

    protected void ProvinceList_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.CityList.Items.Clear();
        this.CityList.Items.Add(new ListItem("== 地级市 ==", ""));
        if (!string.IsNullOrEmpty(ProvinceList.Text as string))
        {
            DataTable dt;
            dt = sql.getDataTable("select * from selectCity where cFather=" + ProvinceList.Text.Trim() + " order by id");
            for (int p = 0; p < dt.Rows.Count; p++)
            {
                this.CityList.Items.Add(new ListItem(dt.Rows[p]["cityTxt"].ToString().Trim(), dt.Rows[p]["cityID"].ToString().Trim()));
            }
            this.CityList.DataBind();
            dt.Dispose();
        }
        this.areaList.Items.Clear();
        this.areaList.Items.Add(new ListItem("== 县级市 ==", ""));
    }

    protected void cityList_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.areaList.Items.Clear();
        if (!string.IsNullOrEmpty(CityList.Text as string))
        {
            DataTable dt;
            dt = sql.getDataTable("select * from selectArea where aFather=" + CityList.Text.Trim() + " order by id");
            if (dt.Rows.Count > 0)
            {
                for (int p = 0; p < dt.Rows.Count; p++)
                {
                    this.areaList.Items.Add(new ListItem(dt.Rows[p]["areaTxt"].ToString().Trim(), dt.Rows[p]["areaID"].ToString().Trim()));
                }
            }
            else
            {
                this.areaList.Items.Add(new ListItem("== 暂无 ==", ""));
            }
            this.areaList.DataBind();
            dt.Dispose();
        }
    }

    protected void postButton_Click(object sender, EventArgs e)
    {
        string strDim = "@uID,@nowEdu,@nowWork,@provinceID,@cityID,@areaID,@studySchool,@studyProfession,@teachAge,@gradeID,@teachTypeID,@openClass,@classNums,@aboutME,@teachRoad,@teachStudyIDs,@studyTimeIDs,@studyTimeInfo,@payMoney,@payBit,@adBeginDate,@adEndDate,@workFlag,@workDate,@readNums,@postDate,@postIP";
        string[] strValue = new string[27];
        strValue[0] = u.userCardID;
        strValue[1] = eduType.Text.Trim();
        strValue[2] = teacherType.Text.Trim();
        strValue[3] = ProvinceList.Text.Trim();
        strValue[4] = CityList.Text.Trim();
        strValue[5] = areaList.Text.Trim();
        strValue[6] = CHAR.htmSafe(school.Text).Trim();
        strValue[7] = CHAR.htmSafe(studyProfession.Text).Trim();
        strValue[8] = teachAge.Text.Trim();
        strValue[9] = gradeList.Text;
        string gradeIDStr = "|";
        for (int i = 0; i < this.gradeCheckValue.Items.Count; i++)
        {
            gradeIDStr += this.gradeCheckValue.Items[i].Value + "|";
        }
        strValue[10] = gradeIDStr;
        strValue[11] = classBool.Text.Trim();
        strValue[12] = wp.getCheckBox(classSize, 1);
        strValue[13] = CHAR.htmSafe(myStudy.Text);
        strValue[14] = CHAR.htmSafe(teachArea.Text);
        strValue[15] = wp.getCheckBox(teachStudy, 1);
        strValue[16] = wp.getCheckBox(studyTime, 1);
        strValue[17] = CHAR.htmSafe(studyAbout.Text);
        strValue[18] = payMoney.Text.Trim();
        strValue[19] = payBit.Text.Trim();
        strValue[20] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
        strValue[21] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
        strValue[22] = "0";//信息条默认不通过，需审核
        strValue[23] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
        strValue[24] = countHid.Value;
        strValue[25] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
        strValue[26] = ip.address();

        if (wp.checkBoxValue(strValue[12] + "," + strValue[15] + "," + strValue[16]))
        {
            if (gradeIDStr.Length < 3)
            {
                js.div(false, "", "text", "请选择相关授权课程后再发布！", 0, 0, "", "");
            }
            else
            {
                sql.log(u.userCardID, "user", "修改教员");

                wp.tzMail(u.userCardID, "教员修改信息啦", "快去审核了喽");

                long idTemp = xabara.isNum(Request["id"]);
                string str = sql.update("teacherInfo", strDim, strValue, "uID='" + u.userCardID + "' and tID=" + idTemp.ToString());
                js.div(false, "", "text", str + "，待审核通过后即可正常显示！", 400, 150, "default.aspx", "goto");
            }
        }
    }

    protected void gradeCheck_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.gradeCheckValue.Visible = true;
        bool check = true;
        for (int i = 0; i < this.gradeCheckValue.Items.Count; i++)
        {
            if (this.gradeCheckValue.Items[i].Value.Equals(gradeCheck.Text))
            {
                check = false;
            }
        }

        if (check)
        {
            this.gradeCheckValue.Items.Add(new ListItem(c.readClassName_Link(xabara.isNum(gradeCheck.Text), string.Empty, string.Empty).Replace("&nbsp;", ""), this.gradeCheck.Text));
        }
    }

    protected void gradeCheckValue_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.gradeCheckValue.Items.Remove(new ListItem(c.readClassName_Link(xabara.isNum(gradeCheckValue.Text), string.Empty, string.Empty).Replace("&nbsp;", ""), this.gradeCheckValue.Text));
    }
}