﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;

public partial class onlineOrder_Default : System.Web.UI.Page
{
    xabara x = new xabara();
    webPublic wp = new webPublic();
    sqlServer sql = new sqlServer();
    classify c = new classify();
    user u = new user();
    javasrcipt js = new javasrcipt();

    long idTemp = 0;
    string userID = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        url.safeDomain();
        DataTable dt;

        idTemp = xabara.isNum(Request["id"]);
        string ts = Request.QueryString["ts"];

        if (!IsPostBack)
        {
            advertisement ad = new advertisement();
            ad200.Text = ad.read("20130427191139263", 200, 0, 2, true, true, "ad200H");

            long pidTemp = 0;   //省份
            long cityIDTemp = 0;   //市级
            long aIDTemp = 0;   //县区级            

            pidTemp = xabara.isNum(xml.read("xabara.config", "province", 180));
            cityIDTemp = xabara.isNum(xml.read("xabara.config", "city", 180));
            aIDTemp = xabara.isNum(xml.read("xabara.config", "area", 180));

            if (pidTemp < 1)  //省市县cookies检查
            {
                if (Request.Cookies["xabaraWhere"] != null)
                {
                    pidTemp = xabara.isNum(Request.Cookies["xabaraWhere"]["p"].ToString().Trim());
                    cityIDTemp = xabara.isNum(Request.Cookies["xabaraWhere"]["c"].ToString().Trim());
                    aIDTemp = xabara.isNum(Request.Cookies["xabaraWhere"]["a"].ToString().Trim());
                }
            }
            else
            {
                if (pidTemp > 0)
                {
                    this.ProvinceList.Visible = false;
                }

                if (cityIDTemp > 0)
                {
                    this.CityList.Visible = false;
                }
            }
            dt = sql.getDataTable("select * from selectProvince order by id");
            this.ProvinceList.Items.Clear();
            this.ProvinceList.Items.Add(new ListItem("== 省份 ==", ""));
            for (int p = 0; p < dt.Rows.Count; p++)
            {
                this.ProvinceList.Items.Add(new ListItem(dt.Rows[p]["provinceTxt"].ToString().Trim(), dt.Rows[p]["provinceID"].ToString().Trim()));
            }
            this.ProvinceList.DataBind();
            if (pidTemp > 0)
            {
                this.ProvinceList.Items.FindByValue(pidTemp.ToString()).Selected = true;
            }
            dt.Dispose();

            DataTable dtCity = sql.getDataTable("select * from selectCity where cFather=" + pidTemp.ToString() + " order by id");
            this.CityList.Items.Clear();
            this.CityList.Items.Add(new ListItem("== 地级市 ==", ""));
            if (dtCity.Rows.Count > 0)
            {
                for (int p = 0; p < dtCity.Rows.Count; p++)
                {
                    this.CityList.Items.Add(new ListItem(dtCity.Rows[p]["cityTxt"].ToString().Trim(), dtCity.Rows[p]["cityID"].ToString().Trim()));
                }
            }
            this.CityList.DataBind();
            dtCity.Dispose();
            if (cityIDTemp > 0)
            {
                this.CityList.Items.FindByValue(cityIDTemp.ToString()).Selected = true;
            }

            DataTable dtArea = sql.getDataTable("select * from selectArea where aFather='" + cityIDTemp.ToString() + "' order by id");
            this.areaList.Items.Clear();
            this.areaList.Items.Add(new ListItem("== 县级市 ==", ""));
            if (dtArea.Rows.Count > 0)
            {
                for (int p = 0; p < dtArea.Rows.Count; p++)
                {
                    this.areaList.Items.Add(new ListItem(dtArea.Rows[p]["areaTxt"].ToString().Trim(), dtArea.Rows[p]["areaID"].ToString().Trim()));
                }
            }
            this.areaList.DataBind();
            if (aIDTemp > 0)
            {
                this.areaList.Items.FindByValue(aIDTemp.ToString()).Selected = true;
            }
            dtArea.Dispose();

            string strSQL = "select * from NewsTree where TreeType='study' and TreeID=0 order by ListID ASC,Tid ASC";
            dt = sql.getDataTable(strSQL);
            this.gradeList.Items.Add(new ListItem("== 请选择 ==", ""));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                this.gradeList.Items.Add(new ListItem(dt.Rows[i]["TreeName"].ToString().Trim(), dt.Rows[i]["Tid"].ToString().Trim()));
            }
            this.gradeList.DataBind();
            this.gradeCheck.Visible = false;
            this.gradeCheckValue.Visible = false;

            string telStr = xml.read("xabara.config", "freePhone", 180);
            if (!string.IsNullOrEmpty(telStr as string))
            {
                telInfo.Text = telStr + "&nbsp;";
            }
            telStr = xml.read("xabara.config", "mobile", 180);
            if (!string.IsNullOrEmpty(telStr as string))
            {
                telInfo.Text += telStr + "&nbsp;";
            }
            telStr = xml.read("xabara.config", "webTel", 180);
            if (!string.IsNullOrEmpty(telStr as string))
            {
                telInfo.Text += telStr + "&nbsp;";
            }

            string qqID = xml.read("xabara.config", "qq", 180);
            qqBottom.Text = xabara.QQ(qqID, "46");

            if (idTemp < 1)
            {
                teachID.Text = "预约";
            }

            c.bindingRepeaterClass(true, 0, "help", navList);
            navClass.Text = "当前位置：<a href='/' target='_top'>首页</a> - 快速预约";

            if (idTemp > 0)
            {
                string strSql = string.Empty;
                string strName = string.Empty;
                if (ts.Equals("t"))
                {
                    strSql = "select xabaraUser.uid,xabaraUser.userName from teacherinfo left join xabaraUser on teacherinfo.uID=XabaraUser.userCardID where teacherinfo.tID=" + idTemp.ToString();
                    strName = "教员";

                    this.doAdd.Items.FindByValue("s").Selected = true;
                }
                else
                {
                    strSql = "select xabaraUser.uid,xabaraUser.userName from studentinfo left join xabaraUser on studentinfo.uID=XabaraUser.userCardID where studentinfo.sID=" + idTemp.ToString();
                    strName = "学员";

                    this.doAdd.Items.FindByValue("t").Selected = true;
                }
                //直接预约客户
                if (string.IsNullOrEmpty(ts as string))
                {
                    this.doAdd.ClearSelection();
                }

                dt = sql.getDataTable(strSql);   //验证教员或学员请求合法性
                if (dt.Rows.Count > 0)
                {
                    teachName.Text = dt.Rows[0]["userName"].ToString().Trim().Substring(0, 1) + strName;
                    teachID.Text = wp.createNums(ts, dt.Rows[0]["uID"].ToString().Trim());
                }
            }

            //已登录会员资料自动填充
            if (u.loginFlag())
            {
                userID = Request.Cookies["XabaraUser"]["userCardID"].ToString().Trim();

                dt = sql.getDataTable("select * from xabarauser where userCardID='" + userID + "'");
                if (dt.Rows.Count > 0)
                {
                    txtName.Text = dt.Rows[0]["userName"].ToString().Trim();
                    email.Text = dt.Rows[0]["userEmail"].ToString().Trim();
                    mobile.Text = dt.Rows[0]["userMobile"].ToString().Trim();
                    tel.Text = dt.Rows[0]["userTel"].ToString().Trim();
                    uAdd.Text = dt.Rows[0]["userAdd"].ToString().Trim();
                }
            }

            dt.Dispose();

            regExpression reg = new regExpression();
            textNameRegularExpressionValidator.ValidationExpression = reg.chinese;
            textNameRegularExpressionValidator.ErrorMessage = reg.chineseError;
            emailRegularExpressionValidator.ValidationExpression = reg.email;
            emailRegularExpressionValidator.ErrorMessage = reg.emailError;
            telRegularExpressionValidator.ValidationExpression = reg.phone;
            telRegularExpressionValidator.ErrorMessage = reg.phoneError;
            mobileRegularExpressionValidator.ValidationExpression = reg.mobile;
            mobileRegularExpressionValidator.ErrorMessage = reg.mobileError;
            rndNumRegularExpressionValidator.ValidationExpression = reg.rndNums(6, 8);
            rndNumRegularExpressionValidator.ErrorMessage = reg.rndNumsError(6, 8);
        }

        Page.Title = "在线预约　" + xml.read("xabara.config", "webName", 180) + xml.read("xabara.config", "titleMeta", 180);
        xabara.safeHistory();
    }

    protected void gradeList_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.gradeCheck.Visible = true;
        if (!string.IsNullOrEmpty(gradeList.Text.Trim() as string))
        {
            string strSQL = "select * from NewsTree where TreeType='study' and TreeID=" + gradeList.Text.Trim() + " order by ListID ASC,Tid ASC";
            DataTable dt = sql.getDataTable(strSQL);
            this.gradeCheck.Items.Clear();
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                this.gradeCheck.Items.Add(new ListItem(dt.Rows[i]["TreeName"].ToString().Trim(), dt.Rows[i]["Tid"].ToString().Trim()));
            }
            this.gradeCheck.DataBind();
        }
        else
        {
            this.gradeCheck.Items.Clear();
        }
    }

    protected void gradeCheck_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.gradeCheckValue.Visible = true;
        bool check = true;
        for (int i = 0; i < this.gradeCheckValue.Items.Count; i++)
        {
            if (this.gradeCheckValue.Items[i].Value.Equals(gradeCheck.Text))
            {
                check = false;
            }
        }

        if (check)
        {
            this.gradeCheckValue.Items.Add(new ListItem(c.readClassName_Link(xabara.isNum(gradeCheck.Text), string.Empty, string.Empty).Replace("&nbsp;", ""), this.gradeCheck.Text));
        }
    }

    protected void gradeCheckValue_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.gradeCheckValue.Items.Remove(new ListItem(c.readClassName_Link(xabara.isNum(gradeCheckValue.Text), string.Empty, string.Empty).Replace("&nbsp;", ""), this.gradeCheckValue.Text));
    }

    protected void ProvinceList_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.CityList.Items.Clear();
        this.CityList.Items.Add(new ListItem("== 地级市 ==", ""));
        if (!string.IsNullOrEmpty(ProvinceList.Text as string))
        {
            DataTable dt;
            dt = sql.getDataTable("select * from selectCity where cFather=" + ProvinceList.Text.Trim() + " order by id");
            for (int p = 0; p < dt.Rows.Count; p++)
            {
                this.CityList.Items.Add(new ListItem(dt.Rows[p]["cityTxt"].ToString().Trim(), dt.Rows[p]["cityID"].ToString().Trim()));
            }
            this.CityList.DataBind();
            dt.Dispose();
        }
        this.areaList.Items.Clear();
        this.areaList.Items.Add(new ListItem("== 县级市 ==", ""));
    }

    protected void cityList_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.areaList.Items.Clear();
        if (!string.IsNullOrEmpty(CityList.Text as string))
        {
            DataTable dt;
            dt = sql.getDataTable("select * from selectArea where aFather=" + CityList.Text.Trim() + " order by id");
            if (dt.Rows.Count > 0)
            {
                for (int p = 0; p < dt.Rows.Count; p++)
                {
                    this.areaList.Items.Add(new ListItem(dt.Rows[p]["areaTxt"].ToString().Trim(), dt.Rows[p]["areaID"].ToString().Trim()));
                }
            }
            else
            {
                this.areaList.Items.Add(new ListItem("== 暂无 ==", ""));
            }
            this.areaList.DataBind();
            dt.Dispose();
        }
    }

    protected void postButton_Click(object sender, EventArgs e)
    {
        if (x.checkValidateCode(true, RndNum.Text))
        {
            string returnStr = string.Empty;
            string strDim = "@relatingID,@yourName,@yourEmail,@yourTel,@yourMobile,@youAddress,@guestBook,@flagID,@postIP,@postDate,@userID,@ts,@pID,@cID,@aID,@teachIDs";
            string[] strValue = new string[16];
            strValue[0] = idTemp.ToString();
            strValue[1] = txtName.Text.Trim();
            strValue[2] = email.Text;
            strValue[3] = tel.Text;
            strValue[4] = mobile.Text;
            strValue[5] = CHAR.htmSafe(uAdd.Text);
            strValue[6] = CHAR.htmSafe(myAbout.Text);
            strValue[7] = "0";  //信息处理情况，默认为0待处理
            strValue[8] = new ipAddress().address();
            strValue[9] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
            if (u.loginFlag())
            {
                userID = Request.Cookies["XabaraUser"]["userCardID"].ToString().Trim();
            }
            strValue[10] = userID;
            strValue[11] = doAdd.Text;
            strValue[12] = ProvinceList.Text;
            strValue[13] = CityList.Text;
            strValue[14] = areaList.Text;
            string gradeIDStr = "|";
            for (int i = 0; i < this.gradeCheckValue.Items.Count; i++)
            {
                gradeIDStr += this.gradeCheckValue.Items[i].Value + "|";
            }
            strValue[15] = gradeIDStr;

            if (gradeIDStr.Length < 3)
            {
                js.div(false, "", "text", "请将授权课目至少选择一项！", 0, 0, "", "");
            }
            else
            {
                string strSql = "select * from onlineorder where yourMobile='" + mobile.Text + "' and flagID<1";
                DataTable dt = sql.getDataTable(strSql);
                if (dt.Rows.Count > 0)
                {
                    returnStr = "请不要重复提交，等待管理员回复或直接致电！";
                }
                else
                {
                    returnStr = sql.add("onlineorder", strDim, strValue) + "！";

                    wp.tzMail(userID, "有人预约了", "快去看看有没赚钱机会了喽");
                }
                dt.Dispose();

                string strUrl = "/";
                if (idTemp > 0)
                {
                    if (doAdd.Text.Trim().Equals("t"))
                    {
                        strUrl = "/student/view/" + idTemp.ToString() + ".htm";
                    }
                    else
                    {
                        strUrl = "/teacher/view/" + idTemp.ToString() + ".htm";
                    }
                }
                js.div(false, "", "text", returnStr, 0, 0, strUrl, "top");
            }
        }
    }
}