﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using xabaraCOM;

public partial class setup_step03 : System.Web.UI.Page
{
    sqlServer sql = new sqlServer();
    ipAddress ip = new ipAddress();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            regExpression reg = new regExpression();
            uIDRegularExpressionValidator.ValidationExpression = reg.userID(2, 20);
            uIDRegularExpressionValidator.ErrorMessage = reg.userIDError(2, 20);
            PWRegularExpressionValidator.ValidationExpression = reg.passWord(6, 20);
            PWRegularExpressionValidator.ErrorMessage = reg.passWordError(6, 20);
            ServerOS.Text = Environment.OSVersion.ToString();
            pcServer pc = new pcServer();
            ServerOSVer.Text = pc.os;
            ServerSoft.Text = Request.ServerVariables["SERVER_SOFTWARE"];
            netVer.Text = Environment.Version.ToString();
            sqlVer.Text = sql.ver(true);

            //写入robots.txt
            string txt = Server.MapPath("/robots.txt");
            ExistsFile(txt);
            StreamWriter sr = new StreamWriter(txt, false, System.Text.Encoding.Default);
            try
            {
                sr.WriteLine("#");
                sr.WriteLine("# robots.txt for zdianpu.com");
                sr.WriteLine("# Version 4.0.0");
                sr.WriteLine("#");
                sr.WriteLine();
                sr.WriteLine("User-agent: *");
                sr.WriteLine("Allow: /student/");
                sr.WriteLine("Allow: /teacher/");
                sr.WriteLine("Allow: /help/");
                sr.WriteLine("Allow: /article/");
                sr.WriteLine("Allow: /fee/");
                sr.WriteLine("Sitemap: http://" + Request.Url.Host + "/sitemap.xml");
                sr.Close();
            }
            catch
            {
                Response.Write("请开启根目录robots.txt写入权限！");
            }
        }

        cache.clear();
    }

    private void ExistsFile(string FilePath)
    {
        if (!File.Exists(FilePath))
        {
            FileStream fs = File.Create(FilePath);
            fs.Close();
        }
    }

    protected void step_Click(object sender, EventArgs e)
    {
        Response.Clear();
        Response.Write("<div class=\"inputTextIME\" style=\"padding:10px;\"><span style=\"font-weight:bold; font-size:14px;\">执行信息如下：</span><br />");

        //创建表
        bool flag = sql.executeSqlFile("/setup/sql/setup.sql");
        Response.Write("数据库框架安装包执行完成！状态：" + flag.ToString() + "<br />");
        Response.Flush();
        flag = sql.executeSqlFile("/setup/sql/data.sql");
        Response.Write("导入默认数据包执行完成！状态：" + flag.ToString() + "<br />");
        Response.Flush();
        flag = sql.executeSqlFile("/setup/sql/pca.sql");
        Response.Write("导入默认全国数据包执行完成！状态：" + flag.ToString() + "<br />");
        Response.Flush();
        flag = sql.executeSqlFile("/setup/sql/tree.sql");
        Response.Write("导入默认分类数据包执行完成！状态：" + flag.ToString() + "<br />");
        Response.Flush();

        //添加管理员
        string uid = uID.Text.Trim().ToLower();
        string dimStr = "@UserId,@UserName,@UserPW,@SessionError,@loginFlag,@LoginNum,@RegDate,@LoginDate,@LoginIP,@classID,@postIF,@cityID,@groupID,@newsIDs,@helpIDs,@UserAdmin";

        string[] strValue = new string[20];
        strValue[0] = uid;
        strValue[1] = "管理员";
        strValue[2] = xabara.md5(uPW.Text.Trim());
        strValue[3] = "xabara.com";
        strValue[4] = "2";
        strValue[5] = "0";
        strValue[6] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
        strValue[7] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
        strValue[8] = ip.address();
        strValue[9] = "0";
        strValue[10] = "1";
        strValue[11] = "0";
        strValue[12] = "0";
        strValue[13] = "all";
        strValue[14] = "all";
        strValue[15] = "xabaraCOM";

        string strSql = "select * from AdminUser where userID='" + uid + "'";
        if (sql.getDataTable(strSql).Rows.Count > 0)
        {
            sql.update("adminuser", dimStr, strValue, " userid='" + uid + "'");
        }
        else
        {
            sql.add("AdminUser", dimStr, strValue);
        }

        Response.Write("导入数据完成！<br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />");
        Response.Flush();

        Response.Write("<br />恭喜您安装成功，进入网站后台并设置您的网站参数！ <a href=\"/webXabara/\" style=\"font-weight:bold;\" target=\"_top\">点击进入管理平台</a></div><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />");

        Response.Write("<script type=\"text/javascript\">{setTimeout(\"top.window.location.href='clear.aspx'\",1000);}</script>");
    }
}