﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using xabaraCOM;

public partial class student_show : System.Web.UI.Page
{
    webPublic wp = new webPublic();
    sqlServer sql = new sqlServer();
    classify c = new classify();
    fileDocument f = new fileDocument();
    user u = new user();
    xabara x = new xabara();
    javasrcipt js = new javasrcipt();
    ipAddress ip = new ipAddress();

    long idTemp = 0;
    public string mapAdd = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        string webTitle = string.Empty;
        string strSql;
        DataTable dt;
        url.safeDomain();

        idTemp = xabara.isNum(Request["sid"]);
        if (idTemp < 1)    //route取值
        {
            idTemp = xabara.isNum(this.Page.RouteData.Values["sID"].ToString().Replace(".htm", ""));
        }

        string pID = "0";  //省
        string cID = "0";  //市
        string aID = "0";  //区
        string userID = string.Empty;

        if (!IsPostBack)
        {
            strSql = "select *,XabaraUser.uid as xID from studentInfo left join XabaraUser on XabaraUser.userCardID = studentInfo.uID where studentInfo.workFlag>0 and studentInfo.sID=" + idTemp.ToString();
            dt = sql.getDataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                userID = dt.Rows[0]["uID"].ToString().Trim();
                vipTxt.Text = u.level(dt.Rows[0]["userLevel"].ToString().Trim(), "img");
                webName.Text = wp.cnName(dt.Rows[0]["userName"].ToString().Trim(), dt.Rows[0]["userSex"].ToString().Trim(), "s");
                webFlag.Text = wp.infoStudentFlag(dt.Rows[0]["workFlag"].ToString().Trim());
                webSelf.Text = c.readClassName_Link(xabara.isNum(dt.Rows[0]["myGradeId"].ToString().Trim()), string.Empty, string.Empty);
                webHome.Text = c.cityName(dt.Rows[0]["userProvince"].ToString().Trim(), dt.Rows[0]["userCity"].ToString().Trim(), dt.Rows[0]["userArea"].ToString().Trim());
                webSchool.Text = dt.Rows[0]["schoolName"].ToString().Trim();
                webSex.Text = dt.Rows[0]["sexMy"].ToString().Trim();
                webTeachType.Text = c.readClassName_Link(xabara.isNum(dt.Rows[0]["studyTypeID"].ToString().Trim()), string.Empty, string.Empty);
                pID = dt.Rows[0]["provinceID"].ToString().Trim();
                cID = dt.Rows[0]["cityID"].ToString().Trim();
                aID = dt.Rows[0]["areaID"].ToString().Trim();
                webStudyCity.Text = c.cityName(pID, cID, aID);
                webTeach.Text = wp.IDsTreeName(dt.Rows[0]["GradeIDs"].ToString().Trim(), ",");
                webAboutMe.Text = dt.Rows[0]["myInfo"].ToString().Trim();
                webTeachSex.Text = dt.Rows[0]["sexTeacher"].ToString().Trim();
                webTeachSelf.Text = wp.IDsTreeName(dt.Rows[0]["teacherTypeIDs"].ToString().Trim(), " / ");
                webTeachArea.Text = wp.IDsTreeName(dt.Rows[0]["teachStudyIDs"].ToString().Trim(), " / ");
                int weeks = Convert.ToInt16(dt.Rows[0]["teachWeek"].ToString().Trim());
                webTeachWeeks.Text = weeks.ToString() + " 次";
                if (weeks < 1)
                {
                    webTeachWeeks.Text = "面议";
                }
                if (weeks > 7)
                {
                    webTeachWeeks.Text = "包月";
                }
                webTeachAbout.Text = dt.Rows[0]["teachInfo"].ToString();
                string weekStr = dt.Rows[0]["studyTimeIDs"].ToString().Trim();
                this.studyTime.Items.Clear();
                for (int j = 1; j < 4; j++)
                {
                    string jStr = string.Empty;
                    switch (j)
                    {
                        case 1:
                            jStr = "上";
                            break;
                        case 2:
                            jStr = "下";
                            break;
                        case 3:
                            jStr = "晚";
                            break;
                    }

                    for (int i = 1; i < 8; i++)
                    {
                        string iStr = string.Empty;
                        switch (i)
                        {
                            case 1:
                                iStr = "周一";
                                break;
                            case 2:
                                iStr = "周二";
                                break;
                            case 3:
                                iStr = "周三";
                                break;
                            case 4:
                                iStr = "周四";
                                break;
                            case 5:
                                iStr = "周五";
                                break;
                            case 6:
                                iStr = "周六";
                                break;
                            case 7:
                                iStr = "周日";
                                break;
                        }

                        this.studyTime.Items.Add(new ListItem(iStr + jStr, i.ToString() + j.ToString()));
                        if (weekStr.IndexOf(i.ToString() + j.ToString()) > -1)
                        {
                            //this.studyTime.Items.FindByValue(i.ToString() + j.ToString()).Attributes.Add("disabled", "true");
                            this.studyTime.Items.FindByValue(i.ToString() + j.ToString()).Selected = true;
                            this.studyTime.Items.FindByValue(i.ToString() + j.ToString()).Attributes.CssStyle["color"] = "red";
                            this.studyTime.Items.FindByValue(i.ToString() + j.ToString()).Attributes.CssStyle["cursor"] = "pointer";
                        }
                    }
                }
                this.studyTime.DataBind();
                otherTime.Text = dt.Rows[0]["studyInfo"].ToString().Trim();
                webTeachRoad.Text = dt.Rows[0]["carMoney"].ToString().Trim();
                webMoney.Text = wp.payRead(dt.Rows[0]["payMoney"].ToString().Trim(), dt.Rows[0]["payBit"].ToString().Trim());

                idNum.Text = wp.createNums("s", dt.Rows[0]["xID"].ToString().Trim());
                callMe.Text = wp.telDisplay(wp.createNums("s", dt.Rows[0]["xID"].ToString().Trim()), dt.Rows[0]["userMobile"].ToString().Trim() + " " + dt.Rows[0]["userTel"].ToString().Trim(), idTemp);
                userLoginTime.Text = Convert.ToDateTime(dt.Rows[0]["loginDate"].ToString().Trim()).ToString("yyyy-MM-dd HH:mm:ss");
                userLoginIP.Text = ip.addressCN(dt.Rows[0]["loginIP"].ToString().Trim());
                mapAdd = Server.UrlEncode(dt.Rows[0]["userAdd"].ToString().Trim());
                if (string.IsNullOrEmpty(mapAdd as string))
                {
                    mapAdd = userLoginIP.Text;
                }

                myImg.ImageUrl = f.picDisplay(dt.Rows[0]["userImg"].ToString().Trim());
                cer.Text = wp.checkUserCer(dt.Rows[0]["userCardID"].ToString().Trim());

                vistaCount.Text = (xabara.isNum(dt.Rows[0]["readNums"].ToString().Trim()) + 1).ToString();

                string[] strValue = new string[1];  //更新阅读量
                strValue[0] = (xabara.isNum(dt.Rows[0]["readNums"].ToString().Trim()) + 1).ToString();
                sql.update("studentInfo", "@readNums", strValue, "sID=" + idTemp.ToString());

                x.webMeta(this.Page, CHAR.NoHtm(webAboutMe.Text + webStudyCity.Text + ",找家教," + webTeach.Text + "," + webTeachAbout.Text) + xml.read("xabara.config", "KeyWord", 180), xml.read("xabara.config", "metaStr", 180));
            }
            else
            {
                js.div(false, "", "text", "您的操作有误或此条信息没通过！", 0, 0, "/", "close");
            }
            dt.Dispose();

            //推荐教员
            strSql = "select top 12 XabaraUser.Uid,XabaraUser.userCardID,XabaraUser.userName,XabaraUser.userSex,XabaraUser.userImg,teacherInfo.tID,teacherInfo.workFlag from teacherInfo left join XabaraUser on XabaraUser.userCardID=teacherInfo.uID where teacherInfo.workFlag>0 and teacherInfo.workFlag<3 and teacherInfo.provinceID=" + pID + " and teacherInfo.cityID=" + cID + " and teacherInfo.areaID=" + aID + " order by teacherInfo.adBeginDate DESC,teacherInfo.tID DESC";
            //Response.Write(strSql);
            //Response.End();
            teachList.DataSource = sql.getDataTable(strSql).DefaultView;
            teachList.DataBind();
            teachList.Dispose();

            if (this.teachList.Items.Count < 1)
            {
                noList.Text = "<div style='text-align:center; height:60px; line-height:60px;'>暂时还没教员推荐！</div>";
            }
        }

        xabara.safeHistory();

        webTitle = c.cityName("0", cID, aID).Replace("-", " ") + webName.Text + " 急需" + webTeach.Text.Replace("-", " ") + " 的家教信息";
        Page.Title = CHAR.NoHtm(webTitle).Replace(" ", "") + " " + xml.read("xabara.config", "webName", 180);

    }

    public string ipAdd(string ipstr)
    {
        return ip.addressCN(ipstr);
    }

    public string cNums(string id)
    {
        string idStr = "0";
        if (xabara.isNum(id) > 0)
        {
            idStr = wp.createNums("t", id);
        }
        return idStr;
    }

    public string img(string str)
    {
        return f.picDisplay(str);
    }

    public string name(string txt, string sex)
    {
        if (string.IsNullOrEmpty(sex as string))
        {
            return "直接预约客户";
        }
        else
        {
            return wp.cnName(txt, sex, "t");
        }
    }

    public string workFlag(string str)
    {
        return wp.infoStudentFlag(str);
    }

    public string workFlagS(string str)
    {
        return wp.infoTeachFlag(str);
    }

    public string ids(string id)
    {
        return wp.IDsTreeName(id, ",");
    }
}