﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;

public partial class teacher_list : System.Web.UI.Page
{
    webPublic wp = new webPublic();
    fileDocument f = new fileDocument();
    classify c = new classify();
    sqlServer sql = new sqlServer();

    public long cid = 0;
    string[] sexName = { "不限", "男", "女" };
    string selectTitle = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        string className = string.Empty;
        string strSql = string.Empty;

        long pid = xabara.isNum(Request.QueryString["pid"]);   //省份        
        long cityID = xabara.isNum(Request.QueryString["cityID"]);   //市级
        long aID = xabara.isNum(Request.QueryString["aID"]);   //县区级
        if (pid < 1)    //区域性限制设置
        {
            if (Request.Cookies["xabaraWhere"] != null)
            {
                pid = xabara.isNum(Request.Cookies["xabaraWhere"]["p"].ToString().Trim());
                cityID = xabara.isNum(Request.Cookies["xabaraWhere"]["c"].ToString().Trim());
                aID = xabara.isNum(Request.Cookies["xabaraWhere"]["a"].ToString().Trim());
            }
            else
            {
                string pathFlie = HttpContext.Current.Server.MapPath("/xabara.config");

                pid = xabara.isNum(xml.read("xabara.config", "province", 1));
                cityID = xabara.isNum(xml.read("xabara.config", "city", 1));
                aID = xabara.isNum(xml.read("xabara.config", "area", 1));
            }
        }

        if (pid > 0)
        {
            if (aID > 0)
            {
                cityReset.Text = "<span style=\"color:blue;\">[<a href=\"/city/" + pid.ToString() + "-" + cityID.ToString() + "-0.htm\" target=\"_top\" style=\"color:blue;\">全市</a>]</span>";
            }
            else
            {
                if (cityID > 0)
                {
                    cityReset.Text = "<span style=\"color:blue;\">[<a href=\"/city/" + pid.ToString() + "-0-0.htm\" target=\"_top\" style=\"color:blue;\">全省</a>]</span>";
                }
                else
                {
                    cityReset.Text = "<span style=\"color:blue;\">[<a href=\"/city/0-0-0.htm\" target=\"_top\" style=\"color:blue;\">全国</a>]</span>";
                }
            }
        }

        cid = xabara.isNum(Request.QueryString["cid"]);   //课程分类
        if (cid < 1)    //route取值
        {
            cid = xabara.isNum(this.Page.RouteData.Values["tID"].ToString().Replace(".htm", ""));
        }
        long sexID = xabara.isNum(Request.QueryString["sexID"]); //性别判断
        long teachTypeID = xabara.isNum(Request.QueryString["teachTypeID"]); //教员身份
        long teachStudyID = xabara.isNum(Request.QueryString["teachStudyID"]); //教员授课方式
        long listType = xabara.isNum(Request.QueryString["listType"]);    //列表方式
        string keyWord = xabara.safeSql(Server.UrlDecode(Request.QueryString["keyWord"])); //搜索关键字
        string ifStr = string.Empty;
        string otherIfStr = string.Empty;   //非同一张表判断
        string idALLStr = string.Empty;
        bool searchDo = false;
        string selectCss = string.Empty;
        int readLine = 0;
        DataTable dt;

        if (!IsPostBack)
        {
            advertisement ad = new advertisement();
            ad200.Text = ad.read("20130427191139558", 200, 0, 2, true, true, "ad200H");

            //===================判断开始
            if (cid > 0)
            {
                className = " - " + c.readClassName_Link(cid, "*.htm", string.Empty);
                string[] cName = CHAR.NoHtm(className).Split(new char[] { '-' });
                if (cName.GetUpperBound(0) == 1)
                {
                    navListName.Text = cName[cName.GetUpperBound(0)];
                }
                else
                {
                    navListName.Text = cName[cName.GetUpperBound(0) - 1];
                }
            }
            else
            {
                navListName.Text = "教员库";
            }

            //身份要求
            if (teachTypeID > 0)
            {
                ifStr += " and teacherInfo.nowWork='" + teachTypeID + "'";
                idALLStr += "&teachTypeID=" + teachTypeID.ToString();  //参数跟踪
            }

            //性别属性
            if (sexID > 0)
            {
                otherIfStr += " and xabaraUser.userSex='" + sexName[sexID] + "'";
                idALLStr += "&sexID=" + sexID.ToString();  //参数跟踪
            }

            //授课方式
            if (teachStudyID > 0)
            {
                ifStr += " and teacherInfo.teachStudyIDs like '%|" + teachStudyID + "|%'";
                idALLStr += "&teachStudyID=" + teachStudyID.ToString();  //参数跟踪
            }

            if (pid > 0)
            {
                ifStr += " and teacherInfo.provinceID=" + pid.ToString();
            }
            if (cityID > 0)
            {
                ifStr += " and teacherInfo.cityID=" + cityID.ToString();
            }
            if (aID > 0)
            {
                ifStr += " and teacherInfo.areaID=" + aID.ToString();
            }

            if (cid > 0)
            {
                string cidStr = c.ReadAllClassID("study", cid); //得到所有ID
                //Response.Write(cidStr);
                string[] ids = cidStr.Split(new char[] { ',' });
                for (int i = 0; i <= ids.GetUpperBound(0); i++)
                {
                    strSql += "select * from teacherInfo where workFlag>0 and teachTypeID like '%|" + ids[i].ToString().Trim() + "|%'" + ifStr + " union ";
                }
            }
            else
            {
                strSql = "select * from teacherInfo where workFlag>0" + ifStr + " union ";
            }

            if (!string.IsNullOrEmpty(keyWord as string))
            {
                strSql = "select * from teacherInfo where workFlag>0 and studySchool like '%" + keyWord + "%'" + ifStr + " union ";
                strSql += "select * from teacherInfo where workFlag>0 and studyProfession like '%" + keyWord + "%'" + ifStr + " union ";
                strSql += "select * from teacherInfo where workFlag>0 and aboutMe like '%" + keyWord + "%'" + ifStr + " union ";
                strSql += "select * from teacherInfo where workFlag>0 and teachRoad like '%" + keyWord + "%'" + ifStr + " union ";

                searchStr.Text = HttpUtility.HtmlEncode(keyWord);
                idALLStr += "&keyWord=" + Server.UrlDecode(keyWord);   //参数跟踪

                searchDo = true;
            }

            //================判断结束
            //区域
            readLine = 0;
            area.Text = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:100%;\">";
            if (cityID > 0)
            {
                dt = sql.getDataTable("select areaID,areaTxt from selectarea where aFather=" + cityID.ToString() + " order by areaPY ASC");
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    readLine += 1;
                    if (readLine % 5 == 1)
                    {
                        area.Text += "<tr>";
                    }

                    if (i == 0)
                    {
                        if (aID < 1)
                        {
                            selectCss = " class=\"listRed\"";
                        }

                        area.Text += "<td style=\"height:24px; line-height:24px; text-algin:left;\"><a href=\"/city/" + pid.ToString() + "-" + cityID.ToString() + "-0.htm\" " + selectCss + ">不限</a></td>";

                        readLine += 1;
                    }

                    long id = xabara.isNum(dt.Rows[i]["areaID"].ToString());
                    if (id == aID)
                    {
                        selectCss = " class=\"listRed\"";
                        selectTitle += dt.Rows[i]["areaTxt"].ToString().Trim() + "-";
                    }
                    else
                    {
                        selectCss = string.Empty;
                    }

                    area.Text += "<td style=\"height:24px; line-height:24px; text-algin:left;\"><a href=\"/city/" + pid.ToString() + "-" + cityID.ToString() + "-" + id.ToString() + ".htm\" " + selectCss + ">" + dt.Rows[i]["areaTxt"].ToString().Trim() + "</a></td>";
                    if (readLine % 5 == 0)
                    {
                        area.Text += "</tr>";
                    }
                }
                dt.Dispose();
            }
            else
            {
                if (pid > 0)
                {
                    dt = sql.getDataTable("select cityID,cityTxt from selectcity where cFather=" + pid.ToString() + " order by cityPY ASC");
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        readLine += 1;
                        if (readLine % 5 == 1)
                        {
                            area.Text += "<tr>";
                        }

                        if (i == 0)
                        {
                            if (cityID < 1)
                            {
                                selectCss = " class=\"listRed\"";
                            }

                            area.Text += "<td style=\"height:24px; line-height:24px; text-algin:left;\"><a href=\"/city/" + pid.ToString() + "-0-0.htm\" " + selectCss + ">不限</a></td>";

                            readLine += 1;
                        }

                        long id = xabara.isNum(dt.Rows[i]["cityID"].ToString());
                        if (id == cityID)
                        {
                            selectCss = " class=\"listRed\"";
                            selectTitle += dt.Rows[i]["cityTxt"].ToString().Trim() + "-";
                        }
                        else
                        {
                            selectCss = string.Empty;
                        }

                        area.Text += "<td style=\"height:24px; line-height:24px; text-algin:left;\"><a href=\"/city/" + pid.ToString() + "-" + id.ToString() + "-" + aID.ToString() + ".htm\" " + selectCss + ">" + dt.Rows[i]["cityTxt"].ToString().Trim() + "</a></td>";
                        if (readLine % 5 == 0)
                        {
                            area.Text += "</tr>";
                        }
                    }
                    dt.Dispose();
                }
                else
                {
                    dt = sql.getDataTable("select provinceID,provinceTxt from selectprovince order by provincePY ASC");
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        readLine += 1;
                        if (readLine % 5 == 1)
                        {
                            area.Text += "<tr>";
                        }

                        if (i == 0)
                        {
                            if (cityID < 1)
                            {
                                selectCss = " class=\"listRed\"";
                            }

                            area.Text += "<td style=\"height:24px; line-height:24px; text-algin:left;\"><a href=\"/city/0-0-0.htm\" " + selectCss + ">全国</a></td>";

                            readLine += 1;
                        }

                        long id = xabara.isNum(dt.Rows[i]["provinceID"].ToString());
                        if (id == cityID)
                        {
                            selectCss = " class=\"listRed\"";
                            selectTitle += dt.Rows[i]["provinceTxt"].ToString().Trim() + "-";
                        }
                        else
                        {
                            selectCss = string.Empty;
                        }

                        area.Text += "<td style=\"height:24px; line-height:24px; text-algin:left;\"><a href=\"/city/" + id.ToString() + "-0-0.htm\" " + selectCss + ">" + dt.Rows[i]["provinceTxt"].ToString().Trim() + "</a></td>";
                        if (readLine % 5 == 0)
                        {
                            area.Text += "</tr>";
                        }
                    }
                    dt.Dispose();
                }
            }
            area.Text += "</table>";

            //列表方式
            string orderBy = " order by newTeacherInfo.workFlag ASC,newTeacherInfo.tID DESC";
            listType0.NavigateUrl = this.urlIds(cid, sexID, teachTypeID, teachStudyID, 0, keyWord);
            listType1.NavigateUrl = this.urlIds(cid, sexID, teachTypeID, teachStudyID, 1, keyWord);
            listType2.NavigateUrl = this.urlIds(cid, sexID, teachTypeID, teachStudyID, 2, keyWord);
            listType3.NavigateUrl = this.urlIds(cid, sexID, teachTypeID, teachStudyID, 3, keyWord);
            switch (listType)
            {
                case 1:
                    orderBy = " order by newTeacherInfo.readNums DESC";
                    listType1.CssClass = "listRed";
                    break;
                case 2:
                    orderBy = " order by newTeacherInfo.adBeginDate DESC";
                    listType2.CssClass = "listRed";
                    break;
                case 3:
                    orderBy = " order by xabaraUser.loginDate DESC";
                    listType3.CssClass = "listRed";
                    break;
                default:
                    listType0.CssClass = "listRed";
                    break;
            }
            idALLStr += "&listType=" + listType.ToString();  //参数跟踪

            //身份要求
            readLine = 0;
            dt = sql.getDataTable("select Tid,TreeName from NewsTree where TreeType='teachertype' order by ListID ASC,Tid ASC");
            teacherType.Text = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:100%;\">";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                readLine += 1;
                if (readLine % 5 == 1)
                {
                    teacherType.Text += "<tr>";
                }

                if (i == 0)
                {
                    if (teachTypeID < 1)
                    {
                        selectCss = " class=\"listRed\"";
                    }

                    teacherType.Text += "<td style=\"height:24px; line-height:24px; text-algin:left;\"><a href=\"" + this.urlIds(cid, sexID, 0, teachStudyID, listType, keyWord) + "\" " + selectCss + ">不限</a></td>";

                    readLine += 1;
                }

                long id = xabara.isNum(dt.Rows[i]["Tid"].ToString());
                if (id == teachTypeID)
                {
                    selectCss = " class=\"listRed\"";
                    selectTitle += dt.Rows[i]["TreeName"].ToString().Trim() + "-";
                }
                else
                {
                    selectCss = string.Empty;
                }

                teacherType.Text += "<td style=\"height:24px; line-height:24px; text-algin:left;\"><a href=\"" + this.urlIds(cid, sexID, id, teachStudyID, listType, keyWord) + "\" " + selectCss + ">" + dt.Rows[i]["TreeName"].ToString().Trim() + "</a></td>";

                if (readLine % 5 == 0)
                {
                    teacherType.Text += "</tr>";
                }
            }
            teacherType.Text += "</table>";
            dt.Dispose();

            //性别
            for (int i = 0; i < 3; i++)
            {
                if (i == sexID)
                {
                    selectCss = " class=\"listRed\"";
                }
                else
                {
                    selectCss = string.Empty;
                }

                sex.Text += "<a href=\"" + this.urlIds(cid, i, teachTypeID, teachStudyID, listType, keyWord) + "\" " + selectCss + ">" + sexName[i] + "</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            }

            //授课方式
            dt = sql.getDataTable("select Tid,TreeName from NewsTree where TreeType='teacherstudy' order by ListID ASC,Tid ASC");
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                if (i == 0)
                {
                    if (teachStudyID < 1)
                    {
                        selectCss = " class=\"listRed\"";
                    }

                    teachStudy.Text += "<a href=\"" + this.urlIds(cid, sexID, teachTypeID, 0, listType, keyWord) + "\" " + selectCss + ">不限</a>";
                }

                long id = xabara.isNum(dt.Rows[i]["Tid"].ToString());
                if (id == teachStudyID)
                {
                    selectCss = " class=\"listRed\"";
                    selectTitle += dt.Rows[i]["TreeName"].ToString().Trim() + "-";
                }
                else
                {
                    selectCss = string.Empty;
                }

                teachStudy.Text += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"" + this.urlIds(cid, sexID, teachTypeID, id, listType, keyWord) + "\" " + selectCss + ">" + dt.Rows[i]["TreeName"].ToString().Trim() + "</a>";
            }
            dt.Dispose();

            //sql执行
            strSql = "(" + strSql.Substring(0, strSql.Length - 6) + ") as newTeacherInfo";

            strSql = "select XabaraUser.Uid,XabaraUser.userName,XabaraUser.userImg,XabaraUser.userSex,newTeacherInfo.tID,newTeacherInfo.nowWork,newTeacherInfo.provinceID,newTeacherInfo.cityID,newTeacherInfo.areaID,newTeacherInfo.teachTypeID,newTeacherInfo.teachStudyIDs,newTeacherInfo.aboutME,newTeacherInfo.teachRoad,newTeacherInfo.payMoney,newTeacherInfo.payBit,newTeacherInfo.workFlag,newTeacherInfo.readNums from " + strSql + " left join XabaraUser on XabaraUser.userCardID = newTeacherInfo.uID where 1=1 " + otherIfStr + orderBy;
            //Response.Write(strSql);
            //Response.End();

            lblCurrentPage.Text = sql.RepeaterDB(sList, strSql, idALLStr, 10, "page", "center", true);
            if (this.sList.Items.Count < 1)
            {
                string cityName = string.Empty;
                if (Request.Cookies["xabaraWhere"] != null)  //cookies检查
                {
                    cityName = HttpUtility.UrlDecode(Request.Cookies["xabaraWhere"]["city"].ToString().Trim());
                }

                errInfo.Text = "目前暂没有" + cityName + "教员信息！如需发布请 <a href=\"/member/teacher/add.aspx\" target=\"_blank\" style=\"font-weight:bold;\">点击进入</a>";
                errDiv.Visible = true;
            }
            else
            {
                errDiv.Visible = false;
            }

            if (searchDo)
            {
                navClass.Text = "您的当前位置：<a href='/' target='_top'>首页</a> - <a href='/teacher/default.htm' target='_top'>教员库</a>" + className + " - 搜索结果";
            }
            else
            {
                navClass.Text = "您的当前位置：<a href='/' target='_top'>首页</a> - <a href='/teacher/default.htm' target='_top'>教员库</a>" + className;
            }
            c.bindingRepeaterClass(true, cid, "study", navList);

            string helpcidStr = c.ReadAllClassID("help", 164); //得到帮助所有ID
            ifStr = string.Empty;
            if (helpcidStr.Length > 1)
            {
                string[] ids = helpcidStr.Split(new char[] { ',' });
                for (int i = 0; i <= ids.GetUpperBound(0); i++)
                {
                    ifStr += " select * from (select top 10 Nid,NewTitle,titleFontB,titleFontC,TopDate,PostDate from NewsXabara where adminPass=1 and  treeTid=" + ids[i].ToString().Trim() + " Order By TopDate desc,PostDate desc) as t" + i.ToString() + " union ";
                }
                ifStr = "(" + ifStr.Substring(0, ifStr.Length - 6) + ") as news";
            }
            strSql = "select top 10 * from " + ifStr + " Order By TopDate desc,PostDate desc";
            //Response.Write(strSql);
            //Response.End();
            memberRepeater.DataSource = sql.getDataTable(strSql).DefaultView;  //帮助中心
            memberRepeater.DataBind();
            memberRepeater.Dispose();
        }

        this.Page.Title = selectTitle + "教员库" + CHAR.NoHtm(className) + " " + xml.read("xabara.config", "webName", 180) + xml.read("xabara.config", "titleMeta", 180);
    }

    protected void searchButton_Click(object sender, ImageClickEventArgs e)
    {
        Response.Redirect(this.urlIds(cid, xabara.isNum(Request.QueryString["sexID"]), xabara.isNum(Request.QueryString["teachTypeID"]), xabara.isNum(Request.QueryString["teachStudyID"]), xabara.isNum(Request.QueryString["listType"]), searchStr.Text), true);
    }

    public string getTreeName(string str)
    {
        return c.readClassName_Link(xabara.isNum(str), string.Empty, string.Empty);
    }

    public string name(string txt, string sex)
    {
        return wp.cnName(txt, sex, "t");
    }

    public string getPCA(string p, string cc, string a)  //得到省市区镇
    {
        string city = c.cityName("0", cc, a);
        if (city.Length > 3)
        {
            city = city.Substring(3);
        }
        return city;
    }

    public string cutWords(string str, int len)
    {
        return CHAR.left(str, len);
    }

    public string getTitleColor(string title, string b, string c)
    {
        string titleBC = title;
        if (!string.IsNullOrEmpty(title as string))
        {
            if (b.Equals("1"))
            {
                titleBC = "<b>" + title + "</b>";
            }

            if (!string.IsNullOrEmpty(c as string))
            {
                titleBC = "<font color='" + c.Trim() + "'>" + titleBC + "</font>";
            }
        }

        return titleBC;
    }

    public string cNums(string sOrt, string id)  //编号
    {
        return wp.createNums(sOrt, id);
    }

    public string getStudentInfo(string id)
    {
        return wp.infoTeachFlag(id);
    }

    public string idsName(string str)
    {
        return wp.IDsTreeName(str, ", ");
    }

    public string pay(string m, string bit)
    {
        return wp.payRead(m, bit);
    }

    public string img(string str)
    {
        return f.picDisplay(str);
    }

    private string urlIds(long cid, long sexID, long teachTypeID, long teachStudyID, long listType, string keyWord)
    {
        string url = string.Empty;

        if (teachTypeID > 0)
        {
            url += "&teachTypeID=" + teachTypeID.ToString();
        }
        if (teachStudyID > 0)
        {
            url += "&teachStudyID=" + teachStudyID.ToString();
        }
        if (listType > 0)
        {
            url += "&listType=" + listType.ToString();
        }
        if (sexID > 0)
        {
            url += "&sexID=" + sexID.ToString();
        }
        if (!string.IsNullOrEmpty(keyWord as string))
        {
            url += "&keyWord=" + Server.UrlEncode(keyWord);
        }

        if (!string.IsNullOrEmpty(url as string))
        {
            url = "?" + url.Substring(1);
        }

        if (cid > 0)
        {
            url = cid.ToString() + ".htm" + url;
        }
        else
        {
            url = "default.htm" + url;
        }

        return url;
    }
}