﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using xabaraCOM;

public partial class teacher_show : System.Web.UI.Page
{
    webPublic wp = new webPublic();
    sqlServer sql = new sqlServer();
    classify c = new classify();
    fileDocument f = new fileDocument();
    user u = new user();
    xabara x = new xabara();
    javasrcipt js = new javasrcipt();
    ipAddress ip = new ipAddress();

    long idTemp;
    public string mapAdd = string.Empty;

    protected void Page_Load(object sender, EventArgs e)
    {
        idTemp = xabara.isNum(Request["id"]);
        if (idTemp < 1)
        {
            string urlID = Page.RouteData.Values["sID"].ToString();
            urlID = urlID.Replace(".htm", "");
            idTemp = xabara.isNum(urlID);
        }

        string webTitle = string.Empty;
        string strSql = string.Empty;
        DataTable dt;
        url.safeDomain();

        string pID = "0";  //省
        string cID = "0";  //市
        string aID = "0";  //区
        string userID = string.Empty;

        if (!IsPostBack)
        {
            strSql = "select *,XabaraUser.uid as xID from teacherInfo left join XabaraUser on XabaraUser.userCardID = teacherInfo.uID where teacherInfo.workFlag>0 and teacherInfo.tID=" + idTemp.ToString();
            dt = sql.getDataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                userID = dt.Rows[0]["uID"].ToString().Trim();
                vipTxt.Text = u.level(dt.Rows[0]["userLevel"].ToString().Trim(), "img");
                webName.Text = wp.cnName(dt.Rows[0]["userName"].ToString().Trim(), dt.Rows[0]["userSex"].ToString().Trim(), "t");
                webFlag.Text = wp.infoTeachFlag(dt.Rows[0]["workFlag"].ToString().Trim());
                webSelf.Text = c.readClassName_Link(Convert.ToInt16(dt.Rows[0]["nowWork"].ToString().Trim()), string.Empty, string.Empty);
                webProfession.Text = dt.Rows[0]["studyProfession"].ToString().Trim();
                webSchool.Text = dt.Rows[0]["studySchool"].ToString().Trim() + "　<strong>[学历]</strong> " + c.readClassName_Link(Convert.ToInt16(dt.Rows[0]["nowEdu"].ToString().Trim()), string.Empty, string.Empty);
                webSex.Text = dt.Rows[0]["userSex"].ToString().Trim();
                webHomeCity.Text = c.cityName(dt.Rows[0]["userProvince"].ToString().Trim(), dt.Rows[0]["userCity"].ToString().Trim(), dt.Rows[0]["userArea"].ToString().Trim());
                pID = dt.Rows[0]["provinceID"].ToString().Trim();
                cID = dt.Rows[0]["cityID"].ToString().Trim();
                aID = dt.Rows[0]["areaID"].ToString().Trim();
                webWorkCity.Text = c.cityName(pID, cID, aID);
                webTeach.Text = wp.IDsTreeName(dt.Rows[0]["teachTypeID"].ToString().Trim(), ",");
                webAge.Text = dt.Rows[0]["teachAge"].ToString().Trim() + "年";
                webClass.Text = dt.Rows[0]["openClass"].ToString().Trim();
                string strClass = dt.Rows[0]["classNums"].ToString().Trim();
                strClass = strClass.Substring(1, strClass.Length - 2);
                webClassNums.Text = strClass.Replace("|", " / ");
                webAbout.Text = dt.Rows[0]["aboutME"].ToString();
                webTeachArea.Text = dt.Rows[0]["teachRoad"].ToString();
                string weekStr = dt.Rows[0]["studyTimeIDs"].ToString().Trim();
                this.studyTime.Items.Clear();
                for (int j = 1; j < 4; j++)
                {
                    string jStr = string.Empty;
                    switch (j)
                    {
                        case 1:
                            jStr = "上";
                            break;
                        case 2:
                            jStr = "下";
                            break;
                        case 3:
                            jStr = "晚";
                            break;
                    }

                    for (int i = 1; i < 8; i++)
                    {
                        string iStr = string.Empty;
                        switch (i)
                        {
                            case 1:
                                iStr = "周一";
                                break;
                            case 2:
                                iStr = "周二";
                                break;
                            case 3:
                                iStr = "周三";
                                break;
                            case 4:
                                iStr = "周四";
                                break;
                            case 5:
                                iStr = "周五";
                                break;
                            case 6:
                                iStr = "周六";
                                break;
                            case 7:
                                iStr = "周日";
                                break;
                        }

                        this.studyTime.Items.Add(new ListItem(iStr + jStr, i.ToString() + j.ToString()));
                        if (weekStr.IndexOf(i.ToString() + j.ToString()) > -1)
                        {
                            //this.studyTime.Items.FindByValue(i.ToString() + j.ToString()).Attributes.Add("disabled", "true");
                            this.studyTime.Items.FindByValue(i.ToString() + j.ToString()).Selected = true;
                            this.studyTime.Items.FindByValue(i.ToString() + j.ToString()).Attributes.CssStyle["color"] = "red";
                        }
                    }
                }
                this.studyTime.DataBind();
                otherTime.Text = dt.Rows[0]["studyTimeInfo"].ToString().Trim();
                webTeachRoad.Text = wp.IDsTreeName(dt.Rows[0]["teachStudyIDs"].ToString().Trim(), " / ");
                webMoney.Text = wp.payRead(dt.Rows[0]["payMoney"].ToString().Trim(), dt.Rows[0]["payBit"].ToString().Trim());
                idNum.Text = wp.createNums("t", dt.Rows[0]["xID"].ToString().Trim());
                callMe.Text = wp.telDisplay(wp.createNums("t", dt.Rows[0]["xID"].ToString().Trim()), dt.Rows[0]["userMobile"].ToString().Trim() + " " + dt.Rows[0]["userTel"].ToString().Trim(), idTemp);
                userLoginTime.Text = datetime.format(true, dt.Rows[0]["loginDate"].ToString());
                userLoginIP.Text = ip.addressCN(dt.Rows[0]["loginIP"].ToString().Trim());
                mapAdd = Server.UrlEncode(dt.Rows[0]["userAdd"].ToString().Trim());
                if (string.IsNullOrEmpty(mapAdd as string))
                {
                    mapAdd = userLoginIP.Text;
                }

                myImg.ImageUrl = f.picDisplay(dt.Rows[0]["userImg"].ToString().Trim());
                cer.Text = wp.checkUserCer(dt.Rows[0]["userCardID"].ToString().Trim());

                vistaCount.Text = (xabara.isNum(dt.Rows[0]["readNums"].ToString().Trim()) + 1).ToString();

                string[] strValue = new string[1];  //更新阅读量
                strValue[0] = (xabara.isNum(dt.Rows[0]["readNums"].ToString().Trim()) + 1).ToString();
                sql.update("teacherInfo", "@readNums", strValue, "tID=" + idTemp.ToString());

                x.webMeta(this.Page, CHAR.NoHtm(webWorkCity.Text + webAbout.Text + webTeachArea.Text) + xml.read("xabara.config", "KeyWord", 180), xml.read("xabara.config", "metaStr", 180));
            }
            else
            {
                js.div(false, "", "text", "您的操作有误或此条信息没通过！", 0, 0, "/", "close");
            }
            dt.Dispose();

            //推荐学员
            strSql = "select top 12 XabaraUser.Uid,XabaraUser.userCardID,XabaraUser.userName,XabaraUser.userSex,XabaraUser.userImg,studentInfo.sID,studentInfo.workFlag from studentInfo left join XabaraUser on XabaraUser.userCardID=studentInfo.uID where studentInfo.workFlag>0 and studentInfo.workFlag<3 and studentInfo.provinceID=" + pID + " and studentInfo.cityID=" + cID + " and studentInfo.areaID=" + aID + " order by studentInfo.adBeginDate DESC,studentInfo.uID DESC";
            //Response.Write(strSql);
            //Response.End();
            studentList.DataSource = sql.getDataTable(strSql).DefaultView;
            studentList.DataBind();
            studentList.Dispose();

            if (this.studentList.Items.Count < 1)
            {
                noList.Text = "<div style='text-align:center; height:60px; line-height:60px;'>暂时还没家长推荐！</div>";
            }
        }
        webTitle = c.cityName("0", cID, aID).Replace("-", " ") + "辅导" + webTeach.Text.Replace("-", " ") + webName.Text + " 的个人简历";
        Page.Title = CHAR.NoHtm(webTitle).Replace(" ", "") + " " + xml.read("xabara.config", "webName", 180);
        xabara.safeHistory();
    }

    public string ipAdd(string ipstr)
    {
        return ip.addressCN(ipstr);
    }

    public string cNums(string id)
    {
        string idStr = "0";
        if (xabara.isNum(id) > 0)
        {
            idStr = wp.createNums("s", id);
        }
        return idStr;
    }

    public string img(string str)
    {
        return f.picDisplay(str);
    }

    public string name(string name, string sex)
    {
        if (string.IsNullOrEmpty(sex as string))
        {
            return "直接预约客户";
        }
        else
        {
            return wp.cnName(name, sex, "s");
        }
    }

    public string workFlag(string str)
    {
        return wp.infoStudentFlag(str);
    }

    public string ids(string id)
    {
        return wp.IDsTreeName(id, ",");
    }
}