﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using xabaraCOM;

public partial class WebXabara_userList : System.Web.UI.Page
{
    admin a = new admin();
    classify c = new classify();
    sqlServer sql = new sqlServer();

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check("|admins|");
        
        long classID = xabara.isNum(Request.QueryString["cid"]);
        string strSql = string.Empty;
        string ifStr = string.Empty;
        string pageIDs = string.Empty;
        string idsStr = string.Empty;
        string keyWordStr = xabara.safeSql(Server.UrlDecode(Request.QueryString["keyWords"])); 
        
        if (!IsPostBack)
        {
            c.bindingSingleClass(classList, 0, true, "city");

            if (classID > 0) //分类读取
            {
                string pids = c.ReadAllClassID("city", classID);

                if (!pids.Equals(classID.ToString()))
                {
                    idsStr = string.Empty;
                    string[] ids = pids.Split(new char[] { ',' });
                    for (int i = 0; i <= ids.GetUpperBound(0); i++)
                    {
                        idsStr += "classID=" + ids[i].ToString().Trim() + " or ";
                    }
                    ifStr += " and (" + idsStr.Substring(0, idsStr.Length - 3) + ")";
                }
                else
                {
                    ifStr += " and classID=" + classID.ToString().Trim();
                }
                this.classList.Items.FindByValue(classID.ToString()).Selected = true;

                pageIDs += "&cid=" + classID.ToString();
            }

            if (!string.IsNullOrEmpty(keyWordStr as string))
            {
                ifStr += " and (UserName like '%" + keyWordStr + "%' or UserId like '%" + keyWordStr + "%') ";
                keyWord.Text = keyWordStr;

                pageIDs += "&keyWords=" + Server.UrlEncode(keyWordStr);
            }

            strSql = "select * from AdminUser where classID>0 " + ifStr + " Order By LoginDate desc";
            //Response.Write(strSql);
            //Response.End();

            lblCurrentPage.Text = sql.RepeaterDB(RepeaterList, strSql, pageIDs, 20, "page", "center", true);
        }
    }

    public string getClass(string cid)
    {
        string str = c.readClassName_Link(xabara.isNum(cid), string.Empty, string.Empty);
        if (string.IsNullOrEmpty(str as string))
        {
            str = "管理员";
        }
        return str;
    }

    public string getQQ(string str)
    {
        return xabara.QQ(str, "5");
    }

    protected void classList_SelectedIndexChanged(object sender, EventArgs e)
    {
        Response.Redirect("userList.aspx?cid=" + classList.Text + "&keyWords=" + Server.UrlEncode(keyWord.Text.Trim()), true);
    }

    protected void searchButton_Click(object sender, EventArgs e)
    {
        Response.Redirect("userList.aspx?cid=" + classList.Text + "&keyWords=" + Server.UrlEncode(keyWord.Text.Trim()), true);
    }
}
