﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using xabaraCOM;

public partial class WebXabara_ads_edit : System.Web.UI.Page
{
    admin a = new admin();
    javasrcipt js = new javasrcipt();
    sqlServer sql = new sqlServer();
    classify c = new classify();
    fileDocument f = new fileDocument();

    protected void Page_Load(object sender, EventArgs e)
    {
        a.check("|ads|");

        if (!IsPostBack)
        {
            regExpression reg = new regExpression();
            pdateRegExpree.ValidationExpression = reg.dateTime;
            pdateRegExpree.ErrorMessage = reg.dateTimeError;
            eDateRegExpree.ValidationExpression = reg.dateTime;
            eDateRegExpree.ErrorMessage = reg.dateTimeError;
            httpRegExpree.ValidationExpression = reg.urlHttp;
            httpRegExpree.ErrorMessage = reg.urlHttpError;

            c.bindingDropDownList("all", true, 0, "ads", adClass);

            string img = xml.read("xabara.config", "UploadImgType", 180);
            this.adImg.Items.Add(new ListItem(img, "Img"));
            string flash = xml.read("xabara.config", "UploadFlashType", 180);
            this.adImg.Items.Add(new ListItem(flash, "Flash"));
            this.adImg.Items.Add(new ListItem("广告代码", "Code"));

            DataTable dt = sql.getDataTable("select * from ads where aID=" + xabara.isNum(Request.QueryString["id"]).ToString());
            if (dt.Rows.Count > 0)
            {
                this.adClass.Items.FindByValue(dt.Rows[0]["classID"].ToString().Trim()).Selected = true;
                string fileName = dt.Rows[0]["adImg"].ToString().Trim();
                upImg.Value = fileName;
                if (!string.IsNullOrEmpty(fileName as string))
                {
                    string fileExe = fileName.Substring(fileName.Length - 3);
                    if (img.IndexOf(fileExe) > -1)
                    {
                        this.adImg.Items.FindByValue("Img").Selected = true;
                    }
                    else
                    {
                        this.adImg.Items.FindByValue("Flash").Selected = true;
                    }
                }
                else
                {
                    this.adImg.Items.FindByValue("Code").Selected = true;
                }

                adW.Text = dt.Rows[0]["adW"].ToString().Trim();
                adH.Text = dt.Rows[0]["adH"].ToString().Trim();
                adHttp.Text = dt.Rows[0]["adHttp"].ToString().Trim();
                adCode.Text = dt.Rows[0]["adCode"].ToString().Trim();
                pDate.Text = datetime.format(true,dt.Rows[0]["starDate"].ToString().Trim());
                eDate.Text = datetime.format(true,dt.Rows[0]["stopDate"].ToString().Trim());
                adCodeImg.Text = dt.Rows[0]["adCode"].ToString().Trim();
            }
            else
            {
                js.div(false, "", "text", "您的操作有误！", 350, 150, "default.aspx", "goto");
            }
            dt.Dispose();
        }
    }

    protected void editMoney_Click(object sender, EventArgs e)
    {
        string imgFile = adImg.Text.Trim();
        string uploadFileStr = string.Empty;
        if (!imgFile.Equals("Code"))
        {
            uploadFileStr = f.upload(imgUpload, imgFile, false);
        }
        string url = adHttp.Text;

        string newFile = upImg.Value;
        if (uploadFileStr.Equals("上传成功"))
        {
            if (!string.IsNullOrEmpty(newFile as string))
            {
                f.del(newFile);
            }
            newFile = Session["NewFile"].ToString().Trim();
        }

        string strDim = "@classID,@adW,@adH,@adImg,@adHttp,@adCode,@starDate,@stopDate,@postDate,@postIP,@adminID";
        string[] strValue = new string[11];
        strValue[0] = adClass.Text;
        strValue[1] = adW.Text;
        strValue[2] = adH.Text;
        strValue[3] = newFile;
        strValue[4] = url;
        switch (imgFile)
        {
            case "Img":
                if (!string.IsNullOrEmpty(url as string))
                {
                    strValue[5] = "<a href=\"" + url + "\" target=\"_blank\"><img src=\"http://" + xml.read("xabara.config", "webDomains", 18) + f.uploadFolder + newFile.Substring(5, 8) + "/" + newFile + "\" style=\"boder:0px;width:" + adW.Text + "px;height:" + adH.Text + "px\" /></a>";
                }
                else
                {
                    strValue[5] = "<img src=\"" + f.uploadFolder + newFile.Substring(5, 8) + "/" + newFile + "\"  style=\"boder:0px;width:" + adW.Text + "px;height:" + adH.Text + "px\" />";
                }
                break;
            case "Flash":
                strValue[5] = "<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0\" height=\"" + adH.Text + "\" width=\"" + adW.Text + "\"><param name=\"quality\" value=\"high\" /><param name=\"movie\" value=\"" + f.uploadFolder + newFile.Substring(5, 8) + "/" + newFile + "\" /><embed height=\"" + adH.Text + "\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" quality=\"high\" src=\"" + f.uploadFolder + newFile.Substring(5, 8) + "/" + newFile + "\" type=\"application/x-shockwave-flash\" width=\"" + adW.Text + "\"></embed></object>";
                break;
            default:
                strValue[5] = adCode.Text;
                break;
        }
        strValue[6] = pDate.Text;
        strValue[7] = eDate.Text;
        strValue[8] = datetime.format(true,"");
        strValue[9] = new ipAddress().address();
        strValue[10] = a.uid;

        sql.log(a.uid, "admin", "修改广告");

        js.div(false, "", "text", sql.update("ads", strDim, strValue, "aID=" + xabara.isNum(Request["id"]).ToString()), 350, 150, "default.aspx?cid=" + Request.QueryString["cid"] + "&page=" + Request.QueryString["page"], "goto");
    }

    protected void adClass_SelectedIndexChanged(object sender, EventArgs e)
    {
        long cid = xabara.isNum(adClass.Text);

        if (cid > 0)
        {
            DataTable dt = sql.getDataTable("select * from NewsTree where Tid=" + adClass.Text);
            if (dt.Rows.Count > 0)
            {
                try
                {
                    string[] className = dt.Rows[0]["TreeName"].ToString().Trim().Split(new char[] { '_' });
                    string[] adSize = className[1].Split(new char[] { 'X' });
                    adW.Text = adSize[0];
                    adH.Text = adSize[1];
                    adSelect.Text = "";
                }
                catch
                {
                    adSelect.Text = "提醒：分类是否选择正确，广告分类命名统一采用 广告位置名称_960X90 格式，便于尺寸框自动填入！";
                    adW.Text = "0";
                    adH.Text = "0";
                }
            }
            else
            {
                adSelect.Text = "提醒：分类是否选择正确，广告分类命名统一采用 广告位置名称_960X90 格式，便于尺寸框自动填入！";
                adW.Text = "0";
                adH.Text = "0";
            }
            dt.Dispose();
        }
        else
        {
            adSelect.Text = "提醒：分类是否选择正确，广告分类命名统一采用 广告位置名称_960X90 格式，便于尺寸框自动填入！";
            adW.Text = "0";
            adH.Text = "0";
        }
    }
}